/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.os.Parcel;

public final class CdmaInformationRecords {
    public static final int RIL_CDMA_CALLED_PARTY_NUMBER_INFO_REC = 1;
    public static final int RIL_CDMA_CALLING_PARTY_NUMBER_INFO_REC = 2;
    public static final int RIL_CDMA_CONNECTED_NUMBER_INFO_REC = 3;
    public static final int RIL_CDMA_DISPLAY_INFO_REC = 0;
    public static final int RIL_CDMA_EXTENDED_DISPLAY_INFO_REC = 7;
    public static final int RIL_CDMA_LINE_CONTROL_INFO_REC = 6;
    public static final int RIL_CDMA_REDIRECTING_NUMBER_INFO_REC = 5;
    public static final int RIL_CDMA_SIGNAL_INFO_REC = 4;
    public static final int RIL_CDMA_T53_AUDIO_CONTROL_INFO_REC = 10;
    public static final int RIL_CDMA_T53_CLIR_INFO_REC = 8;
    public static final int RIL_CDMA_T53_RELEASE_INFO_REC = 9;
    public Object record;

    public CdmaInformationRecords(Parcel parcel) {
        int n = parcel.readInt();
        switch (n) {
            default: {
                throw new RuntimeException("RIL_UNSOL_CDMA_INFO_REC: unsupported record. Got " + CdmaInformationRecords.idToString(n) + " ");
            }
            case 0: 
            case 7: {
                this.record = new CdmaDisplayInfoRec(n, parcel.readString());
                return;
            }
            case 1: 
            case 2: 
            case 3: {
                this.record = new CdmaNumberInfoRec(n, parcel.readString(), parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readInt());
                return;
            }
            case 4: {
                this.record = new CdmaSignalInfoRec(parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readInt());
                return;
            }
            case 5: {
                this.record = new CdmaRedirectingNumberInfoRec(parcel.readString(), parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readInt());
                return;
            }
            case 6: {
                this.record = new CdmaLineControlInfoRec(parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readInt());
                return;
            }
            case 8: {
                this.record = new CdmaT53ClirInfoRec(parcel.readInt());
                return;
            }
            case 10: 
        }
        this.record = new CdmaT53AudioControlInfoRec(parcel.readInt(), parcel.readInt());
    }

    public static String idToString(int n) {
        switch (n) {
            default: {
                return "<unknown record>";
            }
            case 0: {
                return "RIL_CDMA_DISPLAY_INFO_REC";
            }
            case 1: {
                return "RIL_CDMA_CALLED_PARTY_NUMBER_INFO_REC";
            }
            case 2: {
                return "RIL_CDMA_CALLING_PARTY_NUMBER_INFO_REC";
            }
            case 3: {
                return "RIL_CDMA_CONNECTED_NUMBER_INFO_REC";
            }
            case 4: {
                return "RIL_CDMA_SIGNAL_INFO_REC";
            }
            case 5: {
                return "RIL_CDMA_REDIRECTING_NUMBER_INFO_REC";
            }
            case 6: {
                return "RIL_CDMA_LINE_CONTROL_INFO_REC";
            }
            case 7: {
                return "RIL_CDMA_EXTENDED_DISPLAY_INFO_REC";
            }
            case 8: {
                return "RIL_CDMA_T53_CLIR_INFO_REC";
            }
            case 9: {
                return "RIL_CDMA_T53_RELEASE_INFO_REC";
            }
            case 10: 
        }
        return "RIL_CDMA_T53_AUDIO_CONTROL_INFO_REC";
    }

    public static class CdmaDisplayInfoRec {
        public String alpha;
        public int id;

        public CdmaDisplayInfoRec(int n, String string2) {
            this.id = n;
            this.alpha = string2;
        }

        public String toString() {
            return "CdmaDisplayInfoRec: { id: " + CdmaInformationRecords.idToString(this.id) + ", alpha: " + this.alpha + " }";
        }
    }

    public static class CdmaLineControlInfoRec {
        public byte lineCtrlPolarityIncluded;
        public byte lineCtrlPowerDenial;
        public byte lineCtrlReverse;
        public byte lineCtrlToggle;

        public CdmaLineControlInfoRec(int n, int n2, int n3, int n4) {
            this.lineCtrlPolarityIncluded = (byte)n;
            this.lineCtrlToggle = (byte)n2;
            this.lineCtrlReverse = (byte)n3;
            this.lineCtrlPowerDenial = (byte)n4;
        }

        public String toString() {
            return "CdmaLineControlInfoRec: { lineCtrlPolarityIncluded: " + this.lineCtrlPolarityIncluded + " lineCtrlToggle: " + this.lineCtrlToggle + " lineCtrlReverse: " + this.lineCtrlReverse + " lineCtrlPowerDenial: " + this.lineCtrlPowerDenial + " }";
        }
    }

    public static class CdmaNumberInfoRec {
        public int id;
        public String number;
        public byte numberPlan;
        public byte numberType;
        public byte pi;
        public byte si;

        public CdmaNumberInfoRec(int n, String string2, int n2, int n3, int n4, int n5) {
            this.number = string2;
            this.numberType = (byte)n2;
            this.numberPlan = (byte)n3;
            this.pi = (byte)n4;
            this.si = (byte)n5;
        }

        public String toString() {
            return "CdmaNumberInfoRec: { id: " + CdmaInformationRecords.idToString(this.id) + ", number: " + this.number + ", numberType: " + this.numberType + ", numberPlan: " + this.numberPlan + ", pi: " + this.pi + ", si: " + this.si + " }";
        }
    }

    public static class CdmaRedirectingNumberInfoRec {
        public static final int REASON_CALLED_DTE_OUT_OF_ORDER = 9;
        public static final int REASON_CALL_FORWARDING_BUSY = 1;
        public static final int REASON_CALL_FORWARDING_BY_THE_CALLED_DTE = 10;
        public static final int REASON_CALL_FORWARDING_NO_REPLY = 2;
        public static final int REASON_CALL_FORWARDING_UNCONDITIONAL = 15;
        public static final int REASON_UNKNOWN;
        public CdmaNumberInfoRec numberInfoRec;
        public int redirectingReason;

        public CdmaRedirectingNumberInfoRec(String string2, int n, int n2, int n3, int n4, int n5) {
            this.numberInfoRec = new CdmaNumberInfoRec(5, string2, n, n2, n3, n4);
            this.redirectingReason = n5;
        }

        public String toString() {
            return "CdmaNumberInfoRec: { numberInfoRec: " + this.numberInfoRec + ", redirectingReason: " + this.redirectingReason + " }";
        }
    }

    public static class CdmaSignalInfoRec {
        public int alertPitch;
        public boolean isPresent;
        public int signal;
        public int signalType;

        public CdmaSignalInfoRec() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public CdmaSignalInfoRec(int n, int n2, int n3, int n4) {
            boolean bl = n != 0;
            this.isPresent = bl;
            this.signalType = n2;
            this.alertPitch = n3;
            this.signal = n4;
        }

        public String toString() {
            return "CdmaSignalInfo: { isPresent: " + this.isPresent + ", signalType: " + this.signalType + ", alertPitch: " + this.alertPitch + ", signal: " + this.signal + " }";
        }
    }

    public static class CdmaT53AudioControlInfoRec {
        public byte downlink;
        public byte uplink;

        public CdmaT53AudioControlInfoRec(int n, int n2) {
            this.uplink = (byte)n;
            this.downlink = (byte)n2;
        }

        public String toString() {
            return "CdmaT53AudioControlInfoRec: { uplink: " + this.uplink + " downlink: " + this.downlink + " }";
        }
    }

    public static class CdmaT53ClirInfoRec {
        public byte cause;

        public CdmaT53ClirInfoRec(int n) {
            this.cause = (byte)n;
        }

        public String toString() {
            return "CdmaT53ClirInfoRec: { cause: " + this.cause + " }";
        }
    }
}

