/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.MmiCode;
import com.android.internal.telephony.cdma.CDMAPhone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CdmaMmiCode
extends Handler
implements MmiCode {
    static final String ACTION_REGISTER = "**";
    static final int EVENT_SET_COMPLETE = 1;
    static final String LOG_TAG = "CDMA_MMI";
    static final int MATCH_GROUP_ACTION = 2;
    static final int MATCH_GROUP_DIALING_NUMBER = 12;
    static final int MATCH_GROUP_POUND_STRING = 1;
    static final int MATCH_GROUP_PWD_CONFIRM = 11;
    static final int MATCH_GROUP_SERVICE_CODE = 3;
    static final int MATCH_GROUP_SIA = 5;
    static final int MATCH_GROUP_SIB = 7;
    static final int MATCH_GROUP_SIC = 9;
    static final String SC_PUK = "05";
    static Pattern sPatternSuppService = Pattern.compile("((\\*|#|\\*#|\\*\\*|##)(\\d{2,3})(\\*([^*#]*)(\\*([^*#]*)(\\*([^*#]*)(\\*([^*#]*))?)?)?)?#)(.*)");
    String action;
    Context context;
    String dialingNumber;
    CharSequence message;
    CDMAPhone phone;
    String poundString;
    String pwd;
    String sc;
    String sia;
    String sib;
    String sic;
    MmiCode.State state = MmiCode.State.PENDING;

    CdmaMmiCode(CDMAPhone cDMAPhone) {
        super(cDMAPhone.getHandler().getLooper());
        this.phone = cDMAPhone;
        this.context = cDMAPhone.getContext();
    }

    private CharSequence getScString() {
        if (this.sc != null && this.isPukCommand()) {
            return this.context.getText(17039559);
        }
        return "";
    }

    private void handlePasswordError(int n) {
        this.state = MmiCode.State.FAILED;
        StringBuilder stringBuilder = new StringBuilder(this.getScString());
        stringBuilder.append("\n");
        stringBuilder.append(this.context.getText(n));
        this.message = stringBuilder;
        this.phone.onMMIDone(this);
    }

    private static String makeEmptyNull(String string2) {
        if (string2 != null && string2.length() == 0) {
            return null;
        }
        return string2;
    }

    public static CdmaMmiCode newFromDialString(String string2, CDMAPhone cDMAPhone) {
        Matcher matcher = sPatternSuppService.matcher(string2);
        boolean bl = matcher.matches();
        CdmaMmiCode cdmaMmiCode = null;
        if (bl) {
            cdmaMmiCode = new CdmaMmiCode(cDMAPhone);
            cdmaMmiCode.poundString = CdmaMmiCode.makeEmptyNull(matcher.group(1));
            cdmaMmiCode.action = CdmaMmiCode.makeEmptyNull(matcher.group(2));
            cdmaMmiCode.sc = CdmaMmiCode.makeEmptyNull(matcher.group(3));
            cdmaMmiCode.sia = CdmaMmiCode.makeEmptyNull(matcher.group(5));
            cdmaMmiCode.sib = CdmaMmiCode.makeEmptyNull(matcher.group(7));
            cdmaMmiCode.sic = CdmaMmiCode.makeEmptyNull(matcher.group(9));
            cdmaMmiCode.pwd = CdmaMmiCode.makeEmptyNull(matcher.group(11));
            cdmaMmiCode.dialingNumber = CdmaMmiCode.makeEmptyNull(matcher.group(12));
        }
        return cdmaMmiCode;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onSetComplete(AsyncResult asyncResult) {
        StringBuilder stringBuilder;
        block6: {
            block7: {
                block8: {
                    stringBuilder = new StringBuilder(this.getScString());
                    stringBuilder.append("\n");
                    if (asyncResult.exception == null) break block7;
                    this.state = MmiCode.State.FAILED;
                    if (!(asyncResult.exception instanceof CommandException)) break block8;
                    if (((CommandException)asyncResult.exception).getCommandError() == CommandException.Error.PASSWORD_INCORRECT) {
                        if (this.isPukCommand()) {
                            stringBuilder.append(this.context.getText(17039548));
                            break block6;
                        } else {
                            stringBuilder.append(this.context.getText(17039545));
                        }
                        break block6;
                    } else {
                        stringBuilder.append(this.context.getText(17039538));
                    }
                    break block6;
                }
                stringBuilder.append(this.context.getText(17039538));
                break block6;
            }
            if (this.isRegister()) {
                this.state = MmiCode.State.COMPLETE;
                stringBuilder.append(this.context.getText(17039543));
            } else {
                this.state = MmiCode.State.FAILED;
                stringBuilder.append(this.context.getText(17039538));
            }
        }
        this.message = stringBuilder;
        this.phone.onMMIDone(this);
    }

    @Override
    public void cancel() {
        if (this.state == MmiCode.State.COMPLETE || this.state == MmiCode.State.FAILED) {
            return;
        }
        this.state = MmiCode.State.CANCELLED;
        this.phone.onMMIDone(this);
    }

    @Override
    public CharSequence getMessage() {
        return this.message;
    }

    @Override
    public MmiCode.State getState() {
        return this.state;
    }

    @Override
    public void handleMessage(Message message) {
        if (message.what == 1) {
            this.onSetComplete((AsyncResult)message.obj);
            return;
        }
        Log.e(LOG_TAG, "Unexpected reply");
    }

    @Override
    public boolean isCancelable() {
        return false;
    }

    boolean isPukCommand() {
        return this.sc != null && this.sc.equals(SC_PUK);
    }

    boolean isRegister() {
        return this.action != null && this.action.equals(ACTION_REGISTER);
    }

    @Override
    public boolean isUssdRequest() {
        Log.w(LOG_TAG, "isUssdRequest is not implemented in CdmaMmiCode");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void processCode() {
        try {
            int n;
            String string2;
            String string3;
            block8: {
                if (this.isPukCommand()) {
                    string3 = this.sia;
                    string2 = this.sib;
                    n = string2.length();
                    if (this.isRegister()) {
                        if (!string2.equals(this.sic)) {
                            this.handlePasswordError(17039549);
                            return;
                        }
                        break block8;
                    } else {
                        throw new RuntimeException("Invalid or Unsupported MMI Code");
                    }
                }
                throw new RuntimeException("Invalid or Unsupported MMI Code");
            }
            if (n >= 4 && n <= 8) {
                this.phone.mCM.supplyIccPuk(string3, string2, this.obtainMessage(1, this));
                return;
            }
        }
        catch (RuntimeException runtimeException) {
            this.state = MmiCode.State.FAILED;
            this.message = this.context.getText(17039538);
            this.phone.onMMIDone(this);
            return;
        }
        this.handlePasswordError(17039550);
    }
}

