/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.app.PendingIntent;
import android.content.ContentValues;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.SQLException;
import android.os.AsyncResult;
import android.os.Message;
import android.os.SystemProperties;
import android.preference.PreferenceManager;
import android.telephony.SmsMessage;
import android.util.Log;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.SMSDispatcher;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.cdma.CDMAPhone;
import com.android.internal.telephony.cdma.SmsMessage;
import com.android.internal.telephony.cdma.sms.UserData;
import com.android.internal.util.HexDump;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;

final class CdmaSMSDispatcher
extends SMSDispatcher {
    private static final String TAG = "CDMA";
    private byte[] mLastAcknowledgedSmsFingerprint;
    private byte[] mLastDispatchedSmsFingerprint;

    CdmaSMSDispatcher(CDMAPhone cDMAPhone) {
        super(cDMAPhone);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleCdmaStatusReport(SmsMessage smsMessage) {
        int n2 = this.deliveryPendingList.size();
        for (int n = 0; n < n2; ++n) {
            SMSDispatcher.SmsTracker smsTracker = (SMSDispatcher.SmsTracker)this.deliveryPendingList.get(n);
            if (smsTracker.mMessageRef != smsMessage.messageRef) continue;
            this.deliveryPendingList.remove(n);
            PendingIntent pendingIntent = smsTracker.mDeliveryIntent;
            Intent intent = new Intent();
            intent.putExtra("pdu", smsMessage.getPdu());
            try {
                pendingIntent.send(this.mContext, -1, intent);
                return;
            }
            catch (PendingIntent.CanceledException canceledException) {
                return;
            }
        }
    }

    private int resultToCause(int n) {
        switch (n) {
            default: {
                return 96;
            }
            case -1: 
            case 1: {
                return 0;
            }
            case 3: {
                return 35;
            }
            case 4: 
        }
        return 4;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void acknowledgeLastIncomingSms(boolean bl, int n, Message message) {
        if (SystemProperties.get("ril.cdma.inecmmode", "false").equals("true") || this.mCm == null) {
            return;
        }
        int n2 = this.resultToCause(n);
        this.mCm.acknowledgeLastIncomingCdmaSms(bl, n2, message);
        if (n2 == 0) {
            this.mLastAcknowledgedSmsFingerprint = this.mLastDispatchedSmsFingerprint;
        }
        this.mLastDispatchedSmsFingerprint = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void activateCellBroadcastSms(int n, Message message) {
        CommandsInterface commandsInterface = this.mCm;
        boolean bl = n == 0;
        commandsInterface.setCdmaBroadcastActivation(bl, message);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected int dispatchMessage(SmsMessageBase smsMessageBase) {
        if (smsMessageBase == null) {
            Log.e(TAG, "dispatchMessage: message is null");
            return 2;
        }
        if (SystemProperties.get("ril.cdma.inecmmode", "false").equals("true")) {
            return -1;
        }
        SmsMessage smsMessage = (SmsMessage)smsMessageBase;
        this.mLastDispatchedSmsFingerprint = smsMessage.getIncomingSmsFingerprint();
        if (this.mLastAcknowledgedSmsFingerprint != null && Arrays.equals(this.mLastDispatchedSmsFingerprint, this.mLastAcknowledgedSmsFingerprint)) {
            return 1;
        }
        smsMessage.parseSms();
        int n = smsMessage.getTeleService();
        if (4099 == n || 262144 == n) {
            int n2 = smsMessage.getNumOfVoicemails();
            Log.d(TAG, "Voicemail count=" + n2);
            SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences(this.mPhone.getContext()).edit();
            editor.putInt("vm_count_key_cdma", n2);
            editor.apply();
            ((CDMAPhone)this.mPhone).updateMessageWaitingIndicator(n2);
            return 1;
        }
        if ((4098 == n || 4101 == n) && smsMessage.isStatusReportMessage()) {
            this.handleCdmaStatusReport(smsMessage);
            return 1;
        }
        byte[] byArray = smsMessage.getUserData();
        boolean bl = false;
        if (byArray == null) {
            Log.d(TAG, "Received SMS without user data");
            return 1;
        }
        if (bl) {
            return 1;
        }
        if (!this.mStorageAvailable && smsMessage.getMessageClass() != SmsMessage.MessageClass.CLASS_0) {
            return 3;
        }
        if (4100 == n) {
            return this.processCdmaWapPdu(smsMessage.getUserData(), smsMessage.messageRef, smsMessage.getOriginatingAddress());
        }
        if (4098 != n && 4101 != n && 1 != smsMessage.getMessageType()) {
            return 4;
        }
        SmsHeader smsHeader = smsMessage.getUserDataHeader();
        if (smsHeader != null) {
            if (smsHeader.concatRef != null) return this.processMessagePart(smsMessage, smsHeader.concatRef, smsHeader.portAddrs);
        }
        byte[][] byArrayArray = new byte[][]{smsMessage.getPdu()};
        if (smsHeader != null && smsHeader.portAddrs != null) {
            if (smsHeader.portAddrs.destPort == 2948) {
                return this.mWapPush.dispatchWapPdu(smsMessage.getUserData());
            }
            this.dispatchPortAddressedPdus(byArrayArray, smsHeader.portAddrs.destPort);
            return -1;
        }
        this.dispatchPdus(byArrayArray);
        return -1;
    }

    @Override
    protected void getCellBroadcastSmsConfig(Message message) {
        this.mCm.getCdmaBroadcastConfig(message);
    }

    @Override
    protected void handleStatusReport(AsyncResult asyncResult) {
        Log.d(TAG, "handleStatusReport is a special GSM function, should never be called in CDMA!");
    }

    /*
     * Unable to fully structure code
     */
    protected int processCdmaWapPdu(byte[] var1_1, int var2_2, String var3_3) {
        block24: {
            var4_4 = 0 + 1;
            var5_5 = var1_1[0];
            if (var5_5 != 0) {
                Log.w("CDMA", "Received a WAP SMS which is not WDP. Discard.");
                var23_6 = 1;
lbl7:
                // 3 sources

                return var23_6;
            }
            var6_7 = var4_4 + 1;
            var7_8 = var1_1[var4_4];
            var8_9 = var6_7 + 1;
            var9_10 = var1_1[var6_7];
            if (var9_10 != 0) break block24;
            var39_11 = var8_9 + 1;
            var40_12 = (255 & var1_1[var8_9]) << 8;
            var41_13 = var39_11 + 1;
            var12_14 = var40_12 | 255 & var1_1[var39_11];
            var42_15 = var41_13 + 1;
            var43_16 = (255 & var1_1[var41_13]) << 8;
            var44_17 = var42_15 + 1;
            var11_18 = var43_16 | 255 & var1_1[var42_15];
            var10_19 = var44_17;
lbl23:
            // 2 sources

            while (true) {
                block25: {
                    block23: {
                        block22: {
                            block21: {
                                var13_20 = new StringBuilder("reference_number =");
                                var13_20.append(var2_2);
                                var13_20.append(" AND address = ?");
                                var16_21 = new String[]{var3_3};
                                Log.i("CDMA", "Received WAP PDU. Type = " + var5_5 + ", originator = " + var3_3 + ", src-port = " + var12_14 + ", dst-port = " + var11_18 + ", ID = " + var2_2 + ", segment# = " + var9_10 + "/" + var7_8);
                                (byte[][])null;
                                var19_22 = null;
                                var19_22 = this.mResolver.query(this.mRawUri, CdmaSMSDispatcher.RAW_PROJECTION, var13_20.toString(), var16_21, null);
                                var24_23 = var19_22.getCount();
                                if (var24_23 == var7_8 - 1) break block21;
                                var25_24 = new ContentValues();
                                var25_24.put("date", new Long(0L));
                                var26_25 = var1_1.length - var10_19;
                                var25_24.put("pdu", HexDump.toHexString(var1_1, var10_19, var26_25));
                                var25_24.put("address", var3_3);
                                var25_24.put("reference_number", var2_2);
                                var25_24.put("count", var7_8);
                                var25_24.put("sequence", Integer.valueOf(var9_10));
                                var25_24.put("destination_port", var11_18);
                                this.mResolver.insert(this.mRawUri, var25_24);
                                var23_6 = 1;
                                if (var19_22 == null) ** GOTO lbl7
lbl53:
                                // 2 sources

                                while (true) {
                                    var19_22.close();
                                    return var23_6;
                                }
                            }
                            var28_26 = var19_22.getColumnIndex("pdu");
                            var29_27 = var19_22.getColumnIndex("sequence");
                            var30_28 = new byte[var7_8][];
                            for (var31_29 = 0; var31_29 < var24_23; ++var31_29) {
                                var19_22.moveToNext();
                                var33_30 = (int)var19_22.getLong(var29_27);
                                if (var33_30 != 0) ** GOTO lbl69
                                var11_18 = (int)var19_22.getLong(var19_22.getColumnIndex("destination_port"));
lbl69:
                                // 2 sources

                                var30_28[var33_30] = HexDump.hexStringToByteArray(var19_22.getString(var28_26));
                                continue;
                            }
                            try {
                                this.mResolver.delete(this.mRawUri, var13_20.toString(), var16_21);
                                if (var19_22 == null) break block22;
                            }
                            catch (SQLException var21_34) {
                                try {
                                    Log.e("CDMA", "Can't access multipart SMS database", var21_34);
                                    var23_6 = 2;
                                    if (var19_22 == null) ** continue;
                                    ** continue;
                                }
                                catch (Throwable var20_35) {
                                    if (var19_22 != null) {
                                        var19_22.close();
                                    }
                                    throw var20_35;
                                }
                            }
                            var19_22.close();
                        }
                        var35_31 = new ByteArrayOutputStream();
                        block16: for (var36_32 = 0; var36_32 < var7_8; ++var36_32) {
                            if (var36_32 == var9_10) {
                                var38_33 = var1_1.length - var10_19;
                                var35_31.write(var1_1, var10_19, var38_33);
lbl82:
                                // 2 sources

                                continue block16;
                            }
                            break block23;
                        }
                        break block25;
                    }
                    var35_31.write(var30_28[var36_32], 0, var30_28[var36_32].length);
                    ** continue;
                }
                var37_36 = var35_31.toByteArray();
                switch (var11_18) {
                    default: {
                        this.dispatchPortAddressedPdus(new byte[][]{var37_36}, var11_18);
                        return -1;
                    }
                    case 2948: 
                }
                return this.mWapPush.dispatchWapPdu(var37_36);
            }
        }
        var10_19 = var8_9;
        var11_18 = 0;
        var12_14 = 0;
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void sendData(String string2, String string3, int n, byte[] byArray, PendingIntent pendingIntent, PendingIntent pendingIntent2) {
        boolean bl = pendingIntent2 != null;
        this.sendSubmitPdu(SmsMessage.getSubmitPdu(string3, string2, n, byArray, bl), pendingIntent, pendingIntent2);
    }

    @Override
    protected void sendMultipartSms(SMSDispatcher.SmsTracker smsTracker) {
        Log.d(TAG, "TODO: CdmaSMSDispatcher.sendMultipartSms not implemented");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void sendMultipartText(String string2, String string3, ArrayList<String> arrayList, ArrayList<PendingIntent> arrayList2, ArrayList<PendingIntent> arrayList3) {
        int n = 0xFF & CdmaSMSDispatcher.getNextConcatenatedRef();
        int n2 = arrayList.size();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            SmsMessageBase.TextEncodingDetails textEncodingDetails = SmsMessage.calculateLength(arrayList.get(i), false);
            if (n3 == textEncodingDetails.codeUnitSize || n3 != 0 && n3 != 1) continue;
            n3 = textEncodingDetails.codeUnitSize;
        }
        int n4 = 0;
        while (n4 < n2) {
            SmsHeader.ConcatRef concatRef = new SmsHeader.ConcatRef();
            concatRef.refNumber = n;
            concatRef.seqNumber = n4 + 1;
            concatRef.msgCount = n2;
            concatRef.isEightBits = true;
            SmsHeader smsHeader = new SmsHeader();
            smsHeader.concatRef = concatRef;
            PendingIntent pendingIntent = null;
            if (arrayList2 != null) {
                int n5 = arrayList2.size();
                pendingIntent = null;
                if (n5 > n4) {
                    pendingIntent = arrayList2.get(n4);
                }
            }
            PendingIntent pendingIntent2 = null;
            if (arrayList3 != null) {
                int n6 = arrayList3.size();
                pendingIntent2 = null;
                if (n6 > n4) {
                    pendingIntent2 = arrayList3.get(n4);
                }
            }
            UserData userData = new UserData();
            userData.payloadStr = arrayList.get(n4);
            userData.userDataHeader = smsHeader;
            userData.msgEncoding = n3 == 1 ? 9 : 4;
            userData.msgEncodingSet = true;
            boolean bl = pendingIntent2 != null && n4 == n2 - 1;
            this.sendSubmitPdu(SmsMessage.getSubmitPdu(string2, userData, bl), pendingIntent, pendingIntent2);
            ++n4;
        }
        return;
    }

    @Override
    protected void sendSms(SMSDispatcher.SmsTracker smsTracker) {
        byte[] byArray = (byte[])smsTracker.mData.get("pdu");
        Message message = this.obtainMessage(2, smsTracker);
        this.mCm.sendCdmaSms(byArray, message);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void sendSubmitPdu(SmsMessage.SubmitPdu submitPdu, PendingIntent pendingIntent, PendingIntent pendingIntent2) {
        if (!SystemProperties.getBoolean("ril.cdma.inecmmode", false)) {
            this.sendRawPdu(submitPdu.encodedScAddress, submitPdu.encodedMessage, pendingIntent, pendingIntent2);
            return;
        }
        if (pendingIntent != null) {
            try {
                pendingIntent.send(4);
            }
            catch (PendingIntent.CanceledException canceledException) {}
        }
        Log.d(TAG, "Block SMS in Emergency Callback mode");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void sendText(String string2, String string3, String string4, PendingIntent pendingIntent, PendingIntent pendingIntent2) {
        boolean bl = pendingIntent2 != null;
        this.sendSubmitPdu(SmsMessage.getSubmitPdu(string3, string2, string4, bl, null), pendingIntent, pendingIntent2);
    }

    @Override
    protected void setCellBroadcastConfig(int[] nArray, Message message) {
        this.mCm.setCdmaBroadcastConfig(nArray, message);
    }
}

