/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.app.AlarmManager;
import android.content.ContentResolver;
import android.content.Intent;
import android.database.ContentObserver;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.provider.Settings;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.telephony.cdma.CdmaCellLocation;
import android.text.TextUtils;
import android.util.EventLog;
import android.util.Log;
import android.util.TimeUtils;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.DataConnectionTracker;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.ServiceStateTracker;
import com.android.internal.telephony.cdma.CDMAPhone;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

final class CdmaServiceStateTracker
extends ServiceStateTracker {
    static final String LOG_TAG = "CDMA";
    private static final int NITZ_UPDATE_DIFF_DEFAULT = 2000;
    private static final int NITZ_UPDATE_SPACING_DEFAULT = 600000;
    private static final String WAKELOCK_TAG = "ServiceStateTracker";
    private RegistrantList cdmaDataConnectionAttachedRegistrants;
    private RegistrantList cdmaDataConnectionDetachedRegistrants;
    private int cdmaDataConnectionState = 1;
    private RegistrantList cdmaForSubscriptionInfoReadyRegistrants;
    CdmaCellLocation cellLoc;
    private ContentResolver cr;
    private String curPlmn = null;
    private String curSpn = null;
    private int curSpnRule = 0;
    private String currentCarrier = null;
    private boolean isEriTextLoaded = false;
    private boolean isSubscriptionFromRuim = false;
    private ContentObserver mAutoTimeObserver;
    private boolean mCdmaRoaming = false;
    private int mDefaultRoamingIndicator;
    private boolean mGotCountryCode = false;
    private int[] mHomeNetworkId = null;
    private int[] mHomeSystemId = null;
    private boolean mIsInPrl;
    private boolean mIsMinInfoReady = false;
    private String mMdn;
    private String mMin;
    private boolean mNeedFixZone = false;
    private boolean mNeedToRegForRuimLoaded = false;
    private int mNitzUpdateDiff;
    private int mNitzUpdateSpacing = SystemProperties.getInt("ro.nitz_update_spacing", 600000);
    private boolean mPendingRadioPowerOffAfterDataOff = false;
    private String mPrlVersion;
    private String mRegistrationDeniedReason;
    private int mRegistrationState = -1;
    private int mRoamingIndicator;
    long mSavedAtTime;
    long mSavedTime;
    String mSavedTimeZone;
    private PowerManager.WakeLock mWakeLock;
    private boolean mZoneDst;
    private int mZoneOffset;
    private long mZoneTime;
    private int networkType = 0;
    private int newCdmaDataConnectionState = 1;
    CdmaCellLocation newCellLoc;
    private int newNetworkType = 0;
    CDMAPhone phone;

    /*
     * Enabled aggressive block sorting
     */
    public CdmaServiceStateTracker(CDMAPhone cDMAPhone) {
        this.mNitzUpdateDiff = SystemProperties.getInt("ro.nitz_update_diff", 2000);
        this.cdmaDataConnectionAttachedRegistrants = new RegistrantList();
        this.cdmaDataConnectionDetachedRegistrants = new RegistrantList();
        this.cdmaForSubscriptionInfoReadyRegistrants = new RegistrantList();
        this.mAutoTimeObserver = new ContentObserver(new Handler()){

            @Override
            public void onChange(boolean bl) {
                Log.i("CdmaServiceStateTracker", "Auto time state called ...");
                CdmaServiceStateTracker.this.revertToNitz();
            }
        };
        this.phone = cDMAPhone;
        this.cr = cDMAPhone.getContext().getContentResolver();
        this.cm = cDMAPhone.mCM;
        this.ss = new ServiceState();
        this.newSS = new ServiceState();
        this.cellLoc = new CdmaCellLocation();
        this.newCellLoc = new CdmaCellLocation();
        this.mSignalStrength = new SignalStrength();
        this.mWakeLock = ((PowerManager)cDMAPhone.getContext().getSystemService("power")).newWakeLock(1, WAKELOCK_TAG);
        this.cm.registerForAvailable(this, 13, null);
        this.cm.registerForRadioStateChanged(this, 1, null);
        this.cm.registerForNetworkStateChanged(this, 30, null);
        this.cm.setOnNITZTime(this, 11, null);
        this.cm.setOnSignalStrengthUpdate(this, 12, null);
        this.cm.registerForRUIMReady(this, 26, null);
        this.cm.registerForNVReady(this, 35, null);
        cDMAPhone.registerForEriFileLoaded(this, 36, null);
        this.cm.registerForCdmaOtaProvision(this, 37, null);
        boolean bl = Settings.System.getInt(this.cr, "airplane_mode_on", 0) <= 0;
        this.mDesiredPowerState = bl;
        this.cr.registerContentObserver(Settings.System.getUriFor("auto_time"), true, this.mAutoTimeObserver);
        this.setSignalStrengthDefaultValues();
        this.mNeedToRegForRuimLoaded = true;
    }

    private TimeZone findTimeZone(int n, boolean bl, long l) {
        int n2 = n;
        if (bl) {
            n2 -= 3600000;
        }
        String[] stringArray = TimeZone.getAvailableIDs(n2);
        Date date = new Date(l);
        int n3 = stringArray.length;
        int n4 = 0;
        while (true) {
            block6: {
                TimeZone timeZone;
                block5: {
                    timeZone = null;
                    if (n4 >= n3) break block5;
                    TimeZone timeZone2 = TimeZone.getTimeZone(stringArray[n4]);
                    if (timeZone2.getOffset(l) != n || timeZone2.inDaylightTime(date) != bl) break block6;
                    timeZone = timeZone2;
                }
                return timeZone;
            }
            ++n4;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void fixTimeZone(String string2) {
        TimeZone timeZone;
        String string3 = SystemProperties.get("persist.sys.timezone");
        if (this.mZoneOffset == 0 && !this.mZoneDst && string3 != null && string3.length() > 0 && Arrays.binarySearch(GMT_COUNTRY_CODES, string2) < 0) {
            timeZone = TimeZone.getDefault();
            long l = timeZone.getOffset(System.currentTimeMillis());
            if (this.getAutoTime()) {
                this.setAndBroadcastNetworkSetTime(System.currentTimeMillis() - l);
            } else {
                this.mSavedTime -= l;
            }
        } else {
            timeZone = string2.equals("") ? this.getNitzTimeZone(this.mZoneOffset, this.mZoneDst, this.mZoneTime) : TimeUtils.getTimeZone(this.mZoneOffset, this.mZoneDst, this.mZoneTime, string2);
        }
        this.mNeedFixZone = false;
        if (timeZone != null) {
            if (this.getAutoTime()) {
                this.setAndBroadcastNetworkSetTimeZone(timeZone.getID());
            }
            this.saveNitzTimeZone(timeZone.getID());
        }
    }

    private boolean getAutoTime() {
        try {
            int n = Settings.System.getInt(this.cr, "auto_time");
            return n > 0;
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private TimeZone getNitzTimeZone(int n, boolean bl, long l) {
        TimeZone timeZone = this.findTimeZone(n, bl, l);
        if (timeZone == null) {
            boolean bl2 = !bl;
            timeZone = this.findTimeZone(n, bl2, l);
        }
        StringBuilder stringBuilder = new StringBuilder().append("getNitzTimeZone returning ");
        Object object = timeZone == null ? timeZone : timeZone.getID();
        this.log(stringBuilder.append(object).toString());
        return timeZone;
    }

    private void hangupAndPowerOff() {
        this.phone.mCT.ringingCall.hangupIfAlive();
        this.phone.mCT.backgroundCall.hangupIfAlive();
        this.phone.mCT.foregroundCall.hangupIfAlive();
        this.cm.setRadioPower(false, null);
    }

    private boolean isHomeSid(int n) {
        if (this.mHomeSystemId != null) {
            for (int i = 0; i < this.mHomeSystemId.length; ++i) {
                if (n != this.mHomeSystemId[i]) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isRoamIndForHomeSystem(String string2) {
        String string3 = SystemProperties.get("ro.cdma.homesystem");
        if (!TextUtils.isEmpty(string3)) {
            String[] stringArray = string3.split(",");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (!stringArray[i].equals(string2)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isRoamingBetweenOperators(boolean bl, ServiceState serviceState) {
        String string2 = SystemProperties.get("gsm.sim.operator.alpha", "empty");
        String string3 = serviceState.getOperatorAlphaLong();
        String string4 = serviceState.getOperatorAlphaShort();
        boolean bl2 = string3 != null && string2.equals(string3);
        boolean bl3 = string4 != null && string2.equals(string4);
        return bl && !bl2 && !bl3;
    }

    private boolean isSidsAllZeros() {
        if (this.mHomeSystemId != null) {
            for (int i = 0; i < this.mHomeSystemId.length; ++i) {
                if (this.mHomeSystemId[i] == 0) continue;
                return false;
            }
        }
        return true;
    }

    private static String networkTypeToString(int n) {
        switch (n) {
            default: {
                Log.e(LOG_TAG, "Wrong network. Can not return a string.");
                return "unknown";
            }
            case 4: 
            case 5: {
                return LOG_TAG;
            }
            case 6: {
                return "CDMA - 1xRTT";
            }
            case 7: {
                return "CDMA - EvDo rev. 0";
            }
            case 8: {
                return "CDMA - EvDo rev. A";
            }
            case 12: 
        }
        return "CDMA - EvDo rev. B";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onSignalStrengthResult(AsyncResult asyncResult) {
        if (asyncResult.exception != null) {
            this.setSignalStrengthDefaultValues();
        } else {
            int[] nArray = (int[])asyncResult.result;
            int n = nArray[2] > 0 ? -nArray[2] : -120;
            int n2 = nArray[2 + 1] > 0 ? -nArray[2 + 1] : -160;
            int n3 = nArray[2 + 2] > 0 ? -nArray[2 + 2] : -120;
            int n4 = nArray[2 + 3] > 0 ? -nArray[2 + 3] : -1;
            int n5 = nArray[2 + 4] > 0 && nArray[2 + 4] <= 8 ? nArray[2 + 4] : -1;
            this.mSignalStrength = new SignalStrength(99, -1, n, n2, n3, n4, n5, false);
        }
        try {
            this.phone.notifySignalStrength();
            return;
        }
        catch (NullPointerException nullPointerException) {
            this.log("onSignalStrengthResult() Phone already destroyed: " + nullPointerException + "SignalStrength not notified");
            return;
        }
    }

    private void pollState() {
        this.pollingContext = new int[1];
        this.pollingContext[0] = 0;
        switch (2.$SwitchMap$com$android$internal$telephony$CommandsInterface$RadioState[this.cm.getRadioState().ordinal()]) {
            default: {
                int[] nArray = this.pollingContext;
                nArray[0] = 1 + nArray[0];
                this.cm.getOperator(this.obtainMessage(25, this.pollingContext));
                int[] nArray2 = this.pollingContext;
                nArray2[0] = 1 + nArray2[0];
                this.cm.getRegistrationState(this.obtainMessage(24, this.pollingContext));
                return;
            }
            case 1: {
                this.newSS.setStateOutOfService();
                this.newCellLoc.setStateInvalid();
                this.setSignalStrengthDefaultValues();
                this.mGotCountryCode = false;
                this.pollStateDone();
                return;
            }
            case 2: {
                this.newSS.setStateOff();
                this.newCellLoc.setStateInvalid();
                this.setSignalStrengthDefaultValues();
                this.mGotCountryCode = false;
                this.pollStateDone();
                return;
            }
            case 3: 
            case 4: 
            case 5: 
        }
        this.log("Radio Technology Change ongoing, setting SS to off");
        this.newSS.setStateOff();
        this.newCellLoc.setStateInvalid();
        this.setSignalStrengthDefaultValues();
        this.mGotCountryCode = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void pollStateDone() {
        this.log("Poll ServiceState done: oldSS=[" + this.ss + "] newSS=[" + this.newSS + "]");
        boolean bl = this.ss.getState() != 0 && this.newSS.getState() == 0;
        if (this.ss.getState() != 0 || this.newSS.getState() != 0) {
            // empty if block
        }
        boolean bl2 = this.cdmaDataConnectionState != 0 && this.newCdmaDataConnectionState == 0;
        boolean bl3 = this.cdmaDataConnectionState == 0 && this.newCdmaDataConnectionState != 0;
        boolean bl4 = this.cdmaDataConnectionState != this.newCdmaDataConnectionState;
        boolean bl5 = this.networkType != this.newNetworkType;
        boolean bl6 = !this.newSS.equals(this.ss);
        boolean bl7 = !this.ss.getRoaming() && this.newSS.getRoaming();
        boolean bl8 = this.ss.getRoaming() && !this.newSS.getRoaming();
        boolean bl9 = !this.newCellLoc.equals(this.cellLoc);
        if (this.ss.getState() != this.newSS.getState() || this.cdmaDataConnectionState != this.newCdmaDataConnectionState) {
            Object[] objectArray = new Object[]{this.ss.getState(), this.cdmaDataConnectionState, this.newSS.getState(), this.newCdmaDataConnectionState};
            EventLog.writeEvent(50116, objectArray);
        }
        ServiceState serviceState = this.ss;
        this.ss = this.newSS;
        this.newSS = serviceState;
        this.newSS.setStateOutOfService();
        CdmaCellLocation cdmaCellLocation = this.cellLoc;
        this.cellLoc = this.newCellLoc;
        this.newCellLoc = cdmaCellLocation;
        this.cdmaDataConnectionState = this.newCdmaDataConnectionState;
        this.networkType = this.newNetworkType;
        this.newSS.setStateOutOfService();
        if (bl5) {
            this.phone.setSystemProperty("gsm.network.type", CdmaServiceStateTracker.networkTypeToString(this.networkType));
        }
        if (bl) {
            this.networkAttachedRegistrants.notifyRegistrants();
        }
        if (bl6) {
            if (this.cm.getRadioState().isNVReady()) {
                String string2 = this.ss.getState() == 0 ? this.phone.getCdmaEriText() : ((Object)this.phone.getContext().getText(17039602)).toString();
                this.ss.setCdmaEriText(string2);
            }
            this.phone.setSystemProperty("gsm.operator.alpha", this.ss.getOperatorAlphaLong());
            String string3 = this.ss.getOperatorNumeric();
            this.phone.setSystemProperty("gsm.operator.numeric", string3);
            if (string3 == null) {
                this.phone.setSystemProperty("gsm.operator.iso-country", "");
            } else {
                String string4 = "";
                try {
                    String string5;
                    string4 = string5 = MccTable.countryCodeForMcc(Integer.parseInt(string3.substring(0, 3)));
                }
                catch (NumberFormatException numberFormatException) {
                    Log.w(LOG_TAG, "countryCodeForMcc error" + numberFormatException);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    Log.w(LOG_TAG, "countryCodeForMcc error" + stringIndexOutOfBoundsException);
                }
                this.phone.setSystemProperty("gsm.operator.iso-country", string4);
                this.mGotCountryCode = true;
                if (this.mNeedFixZone) {
                    this.fixTimeZone(string4);
                }
            }
            CDMAPhone cDMAPhone = this.phone;
            String string6 = this.ss.getRoaming() ? "true" : "false";
            cDMAPhone.setSystemProperty("gsm.operator.isroaming", string6);
            this.updateSpnDisplay();
            this.phone.notifyServiceStateChanged(this.ss);
        }
        if (bl2) {
            this.cdmaDataConnectionAttachedRegistrants.notifyRegistrants();
        }
        if (bl3) {
            this.cdmaDataConnectionDetachedRegistrants.notifyRegistrants();
        }
        if (bl4 || bl5) {
            this.phone.notifyDataConnection(null);
        }
        if (bl7) {
            this.roamingOnRegistrants.notifyRegistrants();
        }
        if (bl8) {
            this.roamingOffRegistrants.notifyRegistrants();
        }
        if (bl9) {
            this.phone.notifyLocationChanged();
        }
    }

    private void queueNextSignalStrengthPoll() {
        if (this.dontPollSignalStrength || this.cm.getRadioState().isGsm()) {
            return;
        }
        Message message = this.obtainMessage();
        message.what = 10;
        this.sendMessageDelayed(message, 20000L);
    }

    private int radioTechnologyToDataServiceState(int n) {
        switch (n) {
            default: {
                Log.e(LOG_TAG, "Wrong radioTechnology code.");
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return 1;
            }
            case 6: 
            case 7: 
            case 8: 
            case 12: 
        }
        return 0;
    }

    private boolean regCodeIsRoaming(int n) {
        return 5 == n;
    }

    private int regCodeToServiceState(int n) {
        int n2 = 0;
        switch (n) {
            default: {
                Log.w(LOG_TAG, "unexpected service state " + n);
                n2 = 1;
            }
            case 1: 
            case 5: {
                return n2;
            }
            case 0: {
                return 1;
            }
            case 2: 
            case 3: 
            case 4: 
        }
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void revertToNitz() {
        block3: {
            block2: {
                if (Settings.System.getInt(this.cr, "auto_time", 0) == 0) break block2;
                Log.d(LOG_TAG, "Reverting to NITZ: tz='" + this.mSavedTimeZone + "' mSavedTime=" + this.mSavedTime + " mSavedAtTime=" + this.mSavedAtTime);
                if (this.mSavedTimeZone != null && this.mSavedTime != 0L && this.mSavedAtTime != 0L) break block3;
            }
            return;
        }
        this.setAndBroadcastNetworkSetTimeZone(this.mSavedTimeZone);
        this.setAndBroadcastNetworkSetTime(this.mSavedTime + (SystemClock.elapsedRealtime() - this.mSavedAtTime));
    }

    private void saveNitzTimeZone(String string2) {
        this.mSavedTimeZone = string2;
    }

    private void setAndBroadcastNetworkSetTime(long l) {
        SystemClock.setCurrentTimeMillis(l);
        Intent intent = new Intent("android.intent.action.NETWORK_SET_TIME");
        intent.addFlags(0x20000000);
        intent.putExtra("time", l);
        this.phone.getContext().sendStickyBroadcast(intent);
    }

    private void setAndBroadcastNetworkSetTimeZone(String string2) {
        ((AlarmManager)this.phone.getContext().getSystemService("alarm")).setTimeZone(string2);
        Intent intent = new Intent("android.intent.action.NETWORK_SET_TIMEZONE");
        intent.addFlags(0x20000000);
        intent.putExtra("time-zone", string2);
        this.phone.getContext().sendStickyBroadcast(intent);
    }

    private void setSignalStrengthDefaultValues() {
        this.mSignalStrength = new SignalStrength(99, -1, -1, -1, -1, -1, -1, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setTimeFromNITZString(String var1_1, long var2_2) {
        block25: {
            block24: {
                block26: {
                    var4_3 = SystemClock.elapsedRealtime();
                    Log.i("CDMA", "NITZ: " + var1_1 + "," + var2_2 + " start=" + var4_3 + " delay=" + (var4_3 - var2_2));
                    var9_4 = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                    var9_4.clear();
                    var9_4.set(16, 0);
                    var10_5 = var1_1.split("[/:,+-]");
                    var9_4.set(1, 2000 + Integer.parseInt(var10_5[0]));
                    var9_4.set(2, Integer.parseInt(var10_5[1]) - 1);
                    var9_4.set(5, Integer.parseInt(var10_5[2]));
                    var9_4.set(10, Integer.parseInt(var10_5[3]));
                    var9_4.set(12, Integer.parseInt(var10_5[4]));
                    var9_4.set(13, Integer.parseInt(var10_5[5]));
                    var11_6 = var1_1.indexOf(45) == -1;
                    var12_7 = Integer.parseInt(var10_5[6]);
                    var13_8 = var10_5.length >= 8 ? Integer.parseInt(var10_5[7]) : 0;
lbl18:
                    // 2 sources

                    while (true) {
                        block23: {
                            var15_10 = 1000 * (60 * (15 * (var14_9 * var12_7)));
                            try {
                                block22: {
                                    var16_11 = var10_5.length;
                                    var17_12 = null;
                                    if (var16_11 >= 9) {
                                        var17_12 = TimeZone.getTimeZone(var10_5[8].replace('!', '/'));
                                    }
                                    var18_13 = SystemProperties.get("gsm.operator.iso-country");
                                    if (var17_12 == null && this.mGotCountryCode) {
                                        if (var18_13 != null && var18_13.length() > 0) {
                                            var19_14 = var13_8 != 0;
                                        }
                                        var55_18 = var13_8 != 0;
                                        var56_19 = var9_4.getTimeInMillis();
                                        var17_12 = var58_20 = this.getNitzTimeZone(var15_10, var55_18, var56_19);
                                        break block22;
                                        var20_15 = var9_4.getTimeInMillis();
                                        var17_12 = TimeUtils.getTimeZone(var15_10, var19_14, var20_15, var18_13);
                                    }
                                }
                                if (var17_12 == null) {
                                    this.mNeedFixZone = true;
                                    this.mZoneOffset = var15_10;
                                    var22_16 = var13_8 != 0;
                                    this.mZoneDst = var22_16;
                                    this.mZoneTime = var9_4.getTimeInMillis();
                                }
                                if (var17_12 != null) {
                                    if (this.getAutoTime()) {
                                        this.setAndBroadcastNetworkSetTimeZone(var17_12.getID());
                                    }
                                    this.saveNitzTimeZone(var17_12.getID());
                                }
                                if ((var23_17 = SystemProperties.get("gsm.ignore-nitz")) == null || !var23_17.equals("yes")) break block23;
                                Log.i("CDMA", "NITZ: Not setting clock because gsm.ignore-nitz is set");
                                return;
                            }
                            catch (RuntimeException var7_23) {
                                Log.e("CDMA", "NITZ: Parsing NITZ time " + var1_1, var7_23);
                                return;
                            }
                        }
                        this.mWakeLock.acquire();
                        var28_21 = SystemClock.elapsedRealtime() - var2_2;
                        if (var28_21 >= 0L) break block24;
                        Log.i("CDMA", "NITZ: not setting time, clock has rolled backwards since NITZ time was received, " + var1_1);
                        var31_22 = SystemClock.elapsedRealtime();
                        Log.i("CDMA", "NITZ: end=" + var31_22 + " dur=" + (var31_22 - var4_3));
                        this.mWakeLock.release();
                        return;
                        break;
                    }
                    if (!var11_6) break block26;
                    var14_9 = 1;
                    ** GOTO lbl18
                }
                var14_9 = -1;
                ** while (true)
            }
            if (var28_21 > 0x7FFFFFFFL) {
                Log.i("CDMA", "NITZ: not setting time, processing has taken " + var28_21 / 86400000L + " days");
                return;
            }
            var34_25 = (int)var28_21;
            var9_4.add(14, var34_25);
            if (this.getAutoTime()) {
                var39_26 = var9_4.getTimeInMillis() - System.currentTimeMillis();
                var41_27 = SystemClock.elapsedRealtime() - this.mSavedAtTime;
                var43_28 = Settings.Secure.getInt(this.cr, "nitz_update_spacing", this.mNitzUpdateSpacing);
                var44_29 = Settings.Secure.getInt(this.cr, "nitz_update_diff", this.mNitzUpdateDiff);
                if (this.mSavedAtTime != 0L && var41_27 <= (long)var43_28 && Math.abs(var39_26) <= (long)var44_29) break block25;
                Log.i("CDMA", "NITZ: Auto updating time of day to " + var9_4.getTime() + " NITZ receive delay=" + var28_21 + "ms gained=" + var39_26 + "ms from " + var1_1);
                this.setAndBroadcastNetworkSetTime(var9_4.getTimeInMillis());
            }
            Log.i("CDMA", "NITZ: update nitz time property");
            SystemProperties.set("gsm.nitz.time", String.valueOf(var9_4.getTimeInMillis()));
            this.mSavedTime = var9_4.getTimeInMillis();
            this.mSavedAtTime = SystemClock.elapsedRealtime();
            {
                catch (Throwable var24_32) {
                    throw var24_32;
                }
            }
            {
                var36_30 = SystemClock.elapsedRealtime();
                Log.i("CDMA", "NITZ: end=" + var36_30 + " dur=" + (var36_30 - var4_3));
                this.mWakeLock.release();
                return;
            }
        }
        try {
            Log.i("CDMA", "NITZ: ignore, a previous update was " + var41_27 + "ms ago and gained=" + var39_26 + "ms");
        }
        finally {
            var51_24 = SystemClock.elapsedRealtime();
            Log.i("CDMA", "NITZ: end=" + var51_24 + " dur=" + (var51_24 - var4_3));
            this.mWakeLock.release();
        }
        {
            var47_31 = SystemClock.elapsedRealtime();
            Log.i("CDMA", "NITZ: end=" + var47_31 + " dur=" + (var47_31 - var4_3));
            this.mWakeLock.release();
            return;
        }
    }

    public void dispose() {
        this.cm.unregisterForAvailable(this);
        this.cm.unregisterForRadioStateChanged(this);
        this.cm.unregisterForNetworkStateChanged(this);
        this.cm.unregisterForRUIMReady(this);
        this.cm.unregisterForNVReady(this);
        this.cm.unregisterForCdmaOtaProvision(this);
        this.phone.unregisterForEriFileLoaded(this);
        this.phone.mRuimRecords.unregisterForRecordsLoaded(this);
        this.cm.unSetOnSignalStrengthUpdate(this);
        this.cm.unSetOnNITZTime(this);
        this.cr.unregisterContentObserver(this.mAutoTimeObserver);
    }

    protected void finalize() {
        this.log("CdmaServiceStateTracker finalized");
    }

    public String getCdmaMin() {
        return this.mMin;
    }

    int getCurrentCdmaDataConnectionState() {
        return this.cdmaDataConnectionState;
    }

    String getImsi() {
        String string2 = SystemProperties.get("gsm.sim.operator.numeric", "");
        if (!TextUtils.isEmpty(string2) && this.getCdmaMin() != null) {
            return string2 + this.getCdmaMin();
        }
        return null;
    }

    public String getMdnNumber() {
        return this.mMdn;
    }

    public String getPrlVersion() {
        return this.mPrlVersion;
    }

    /*
     * Handled duff style switch with additional control
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleMessage(Message var1_1) {
        block49: {
            block50: {
                block47: {
                    block48: {
                        cfr_temp_0 = 0;
                        block27: do {
                            switch (cfr_temp_0 == 0 ? var1_1.what : cfr_temp_0) {
                                default: {
                                    Log.e("CDMA", "Unhandled message with number: " + var1_1.what);
                                    cfr_temp_0 = 13;
                                    continue block27;
                                }
                                case 26: {
                                    this.isSubscriptionFromRuim = true;
                                    if (this.mNeedToRegForRuimLoaded) {
                                        this.phone.mRuimRecords.registerForRecordsLoaded(this, 27, null);
                                        this.mNeedToRegForRuimLoaded = false;
                                    }
                                    this.cm.getCDMASubscription(this.obtainMessage(34));
                                    this.log("Receive EVENT_RUIM_READY and Send Request getCDMASubscription.");
                                    this.pollState();
                                    this.queueNextSignalStrengthPoll();
                                    return;
                                }
                                case 35: {
                                    this.isSubscriptionFromRuim = false;
                                    this.cm.getCDMASubscription(this.obtainMessage(34));
                                    this.pollState();
                                    this.queueNextSignalStrengthPoll();
                                    return;
                                }
                                case 1: {
                                    this.setPowerStateToDesired();
                                    this.pollState();
                                    return;
                                }
                                case 30: {
                                    this.pollState();
                                    return;
                                }
                                case 3: {
                                    cfr_temp_0 = 13;
                                    if (!this.cm.getRadioState().isOn()) continue block27;
                                    cfr_temp_0 = 13;
                                    if (this.cm.getRadioState().isGsm()) continue block27;
                                    this.onSignalStrengthResult((AsyncResult)var1_1.obj);
                                    this.queueNextSignalStrengthPoll();
                                    return;
                                }
                                case 31: {
                                    var25_2 = (AsyncResult)var1_1.obj;
                                    if (var25_2.exception != null) break block47;
                                    var26_3 = (String[])var25_2.result;
                                    var27_4 = -1;
                                    var28_5 = 0x7FFFFFFF;
                                    var29_6 = 0x7FFFFFFF;
                                    var30_7 = -1;
                                    var31_8 = -1;
                                    if (var26_3.length > 9) {
                                        try {
                                            if (var26_3[4] != null) {
                                                var27_4 = Integer.parseInt(var26_3[4]);
                                            }
                                            if (var26_3[5] != null) {
                                                var28_5 = Integer.parseInt(var26_3[5]);
                                            }
                                            if (var26_3[6] == null) break;
                                            var29_6 = Integer.parseInt(var26_3[6]);
                                            break;
                                        }
                                        catch (NumberFormatException var32_10) {
                                            Log.w("CDMA", "error parsing cell location data: " + var32_10);
                                        }
                                    }
                                    break block48;
                                }
                                case 24: 
                                case 25: {
                                    var24_11 = (AsyncResult)var1_1.obj;
                                    this.handlePollStateResult(var1_1.what, var24_11);
                                    return;
                                }
                                case 34: {
                                    var10_12 = (AsyncResult)var1_1.obj;
                                    cfr_temp_0 = 13;
                                    if (var10_12.exception != null) continue block27;
                                    var11_13 = (String[])var10_12.result;
                                    if (var11_13 != null && var11_13.length >= 5) {
                                        this.mMdn = var11_13[0];
                                        if (var11_13[1] == null) break block49;
                                        var20_14 = var11_13[1].split(",");
                                        this.mHomeSystemId = new int[var20_14.length];
                                        break block50;
                                    }
                                    Log.w("CDMA", "error parsing cdmaSubscription params num=" + var11_13.length);
                                    return;
                                }
                                case 10: {
                                    this.cm.getSignalStrength(this.obtainMessage(3));
                                    return;
                                }
                                case 11: {
                                    var9_20 = (AsyncResult)var1_1.obj;
                                    this.setTimeFromNITZString((String)((Object[])var9_20.result)[0], (Long)((Object[])var9_20.result)[1]);
                                    return;
                                }
                                case 12: {
                                    var8_21 = (AsyncResult)var1_1.obj;
                                    this.dontPollSignalStrength = true;
                                    this.onSignalStrengthResult(var8_21);
                                    return;
                                }
                                case 27: {
                                    this.updateSpnDisplay();
                                    return;
                                }
                                case 18: {
                                    cfr_temp_0 = 13;
                                    if (((AsyncResult)var1_1.obj).exception != null) continue block27;
                                    this.cm.getRegistrationState(this.obtainMessage(31, null));
                                    return;
                                }
                                case 36: {
                                    this.log("[CdmaServiceStateTracker] ERI file has been loaded, repolling.");
                                    this.pollState();
                                    return;
                                }
                                case 37: {
                                    var3_22 = (AsyncResult)var1_1.obj;
                                    if (var3_22.exception != null) ** GOTO lbl116
                                    var4_23 = ((int[])var3_22.result)[0];
                                    if (var4_23 == 8) ** GOTO lbl112
                                    if (var4_23 != 10) ** GOTO lbl116
lbl112:
                                    // 2 sources

                                    Log.d("CDMA", "Received OTA_PROGRAMMING Complete,Reload MDN ");
                                    this.cm.getCDMASubscription(this.obtainMessage(34));
                                    return;
                                }
lbl116:
                                // 3 sources

                                case 13: {
                                    return;
                                }
                                case 38: {
                                    synchronized (this) {
                                        if (this.mPendingRadioPowerOffAfterDataOff) {
                                            this.log("EVENT_SET_RADIO_OFF, turn radio off now.");
                                            this.hangupAndPowerOff();
                                            this.mPendingRadioPowerOffAfterDataOff = false;
                                        }
                                        return;
                                    }
                                }
                            }
                            break;
                        } while (true);
                        if (var28_5 == 0 && var29_6 == 0) {
                            var28_5 = 0x7FFFFFFF;
                            var29_6 = 0x7FFFFFFF;
                        }
                        if (var26_3[8] != null) {
                            var30_7 = Integer.parseInt(var26_3[8]);
                        }
                        if (var26_3[9] != null) {
                            var31_8 = var34_9 = Integer.parseInt(var26_3[9]);
                        }
                    }
                    this.cellLoc.setCellLocationData(var27_4, var28_5, var29_6, var30_7, var31_8);
                    this.phone.notifyLocationChanged();
                }
                this.disableSingleLocationUpdate();
                return;
            }
            for (var21_15 = 0; var21_15 < var20_14.length; ++var21_15) {
                try {
                    this.mHomeSystemId[var21_15] = Integer.parseInt(var20_14[var21_15]);
                    continue;
                }
                catch (NumberFormatException var22_16) {
                    Log.e("CDMA", "error parsing system id: ", var22_16);
                }
            }
        }
        Log.d("CDMA", "GET_CDMA_SUBSCRIPTION SID=" + var11_13[1]);
        if (var11_13[2] != null) {
            var16_17 = var11_13[2].split(",");
            this.mHomeNetworkId = new int[var16_17.length];
            for (var17_18 = 0; var17_18 < var16_17.length; ++var17_18) {
                try {
                    this.mHomeNetworkId[var17_18] = Integer.parseInt(var16_17[var17_18]);
                    continue;
                }
                catch (NumberFormatException var18_19) {
                    Log.e("CDMA", "error parsing network id: ", var18_19);
                }
            }
        }
        Log.d("CDMA", "GET_CDMA_SUBSCRIPTION NID=" + var11_13[2]);
        this.mMin = var11_13[3];
        this.mPrlVersion = var11_13[4];
        Log.d("CDMA", "GET_CDMA_SUBSCRIPTION MDN=" + this.mMdn);
        if (this.cdmaForSubscriptionInfoReadyRegistrants != null) {
            this.cdmaForSubscriptionInfoReadyRegistrants.notifyRegistrants();
        }
        if (!this.mIsMinInfoReady) {
            this.mIsMinInfoReady = true;
        }
        this.phone.getIccCard().broadcastIccStateChangedIntent("IMSI", null);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void handlePollStateResult(int var1_1, AsyncResult var2_2) {
        block51: {
            block48: {
                block50: {
                    block47: {
                        block49: {
                            if (var2_2.userObj != this.pollingContext) break block48;
                            if (var2_2.exception == null) break block49;
                            var39_3 = var2_2.exception instanceof CommandException;
                            var40_4 = null;
                            if (var39_3) {
                                var40_4 = ((CommandException)var2_2.exception).getCommandError();
                            }
                            if (var40_4 == CommandException.Error.RADIO_NOT_AVAILABLE) {
                                this.cancelPollState();
                                return;
                            }
                            if (!this.cm.getRadioState().isOn()) {
                                this.cancelPollState();
                                return;
                            }
                            if (var40_4 == CommandException.Error.OP_NOT_ALLOWED_BEFORE_REG_NW || var40_4 == CommandException.Error.OP_NOT_ALLOWED_BEFORE_REG_NW) break block50;
                            Log.e("CDMA", "RIL implementation has returned an error where it must succeed", var2_2.exception);
                            break block50;
                        }
                        switch (var1_1) {
                            default: {
                                Log.e("CDMA", "RIL response handle in wrong phone! Expected CDMA RIL request and get GSM RIL request.");
                            }
                            case 24: {
                                try {
                                    var13_12 = (String[])var2_2.result;
                                    var14_13 = 4;
                                    var15_14 = -1;
                                    var16_15 = -1;
                                    var17_16 = 0x7FFFFFFF;
                                    var18_17 = 0x7FFFFFFF;
                                    var19_18 = 0;
                                    var20_19 = 0;
                                    var21_20 = 0;
                                    var22_21 = -1;
                                    var23_22 = 0;
                                    var24_23 = 0;
                                    var25_24 = var13_12.length;
                                    if (var25_24 != 14) ** GOTO lbl62
                                    ** try [egrp 2[TRYBLOCK] [3 : 529->782)] { 
lbl41:
                                    // 1 sources

                                    ** GOTO lbl-1000
                                }
                                catch (RuntimeException var11_11) {
                                    Log.e("CDMA", "Exception while polling service state. Probably malformed RIL response.", var11_11);
                                }
                                break block50;
lbl-1000:
                                // 1 sources

                                {
                                    if (var13_12[0] != null) {
                                        var14_13 = Integer.parseInt(var13_12[0]);
                                    }
                                    if (var13_12[3] != null) {
                                        var15_14 = Integer.parseInt(var13_12[3]);
                                    }
                                    if (var13_12[4] != null) {
                                        var16_15 = Integer.parseInt(var13_12[4]);
                                    }
                                    if (var13_12[5] != null) {
                                        var17_16 = Integer.parseInt(var13_12[5]);
                                    }
                                    if (var13_12[6] == null) break;
                                    var18_17 = Integer.parseInt(var13_12[6]);
                                    break;
                                }
lbl57:
                                // 1 sources

                                catch (NumberFormatException var26_35) {
                                    Log.w("CDMA", "error parsing RegistrationState: " + var26_35);
                                    var28_31 = 0;
                                    break block47;
                                }
lbl62:
                                // 1 sources

                                throw new RuntimeException("Warning! Wrong number of parameters returned from RIL_REQUEST_REGISTRATION_STATE: expected 14 got " + var13_12.length);
                            }
                            case 25: {
                                var3_36 = (String[])var2_2.result;
                                if (var3_36 != null && var3_36.length >= 3) {
                                    if (this.cm.getRadioState().isNVReady()) {
                                        this.newSS.setOperatorName(null, var3_36[1], var3_36[2]);
                                        ** break;
                                    }
                                    this.newSS.setOperatorName(var3_36[0], var3_36[1], var3_36[2]);
                                    ** break;
                                }
                                Log.w("CDMA", "error parsing opNames");
                                ** break;
                            }
                        }
                        if (var17_16 == 0 && var18_17 == 0) {
                            var17_16 = 0x7FFFFFFF;
                            var18_17 = 0x7FFFFFFF;
                        }
                        var31_25 = var13_12[7];
                        var19_18 = 0;
                        if (var31_25 != null) {
                            var19_18 = Integer.parseInt(var13_12[7]);
                        }
                        var32_26 = var13_12[8];
                        var20_19 = 0;
                        if (var32_26 != null) {
                            var20_19 = Integer.parseInt(var13_12[8]);
                        }
                        var33_27 = var13_12[9];
                        var21_20 = 0;
                        if (var33_27 != null) {
                            var21_20 = Integer.parseInt(var13_12[9]);
                        }
                        if (var13_12[10] != null) {
                            var22_21 = Integer.parseInt(var13_12[10]);
                        }
                        var34_28 = var13_12[11];
                        var23_22 = 0;
                        if (var34_28 != null) {
                            var23_22 = Integer.parseInt(var13_12[11]);
                        }
                        var35_29 = var13_12[12];
                        var24_23 = 0;
                        if (var35_29 != null) {
                            var24_23 = Integer.parseInt(var13_12[12]);
                        }
                        var36_30 = var13_12[13];
                        var28_31 = 0;
                        if (var36_30 != null) {
                            var28_31 = var37_32 = Integer.parseInt(var13_12[13]);
                        }
                    }
                    this.mRegistrationState = var14_13;
                    var29_33 = this.regCodeIsRoaming(var14_13) != false && this.isRoamIndForHomeSystem(var13_12[10]) == false;
                    this.mCdmaRoaming = var29_33;
                    this.newSS.setState(this.regCodeToServiceState(var14_13));
                    this.newCdmaDataConnectionState = this.radioTechnologyToDataServiceState(var15_14);
                    this.newSS.setRadioTechnology(var15_14);
                    this.newNetworkType = var15_14;
                    this.newSS.setCssIndicator(var19_18);
                    this.newSS.setSystemAndNetworkId(var20_19, var21_20);
                    this.mRoamingIndicator = var22_21;
                    var30_34 = var23_22 != 0;
                    this.mIsInPrl = var30_34;
                    this.mDefaultRoamingIndicator = var24_23;
                    this.newCellLoc.setCellLocationData(var16_15, var17_16, var18_17, var20_19, var21_20);
                    this.mRegistrationDeniedReason = var28_31 == 0 ? "General" : (var28_31 == 1 ? "Authentication Failure" : "");
                    if (this.mRegistrationState == 3) {
                        this.log("Registration denied, " + this.mRegistrationDeniedReason);
                        ** break;
                    }
                }
                var5_5 = this.pollingContext;
                var5_5[0] = var5_5[0] - 1;
                if (this.pollingContext[0] == 0) break block51;
            }
            return;
        }
        var6_6 = this.isSidsAllZeros();
        var7_7 = false;
        if (!var6_6) {
            var10_8 = this.isHomeSid(this.newSS.getSystemId());
            var7_7 = false;
            if (var10_8) {
                var7_7 = true;
            }
        }
        if (this.isSubscriptionFromRuim) {
            this.newSS.setRoaming(this.isRoamingBetweenOperators(this.mCdmaRoaming, this.newSS));
        } else {
            this.newSS.setRoaming(this.mCdmaRoaming);
        }
        this.newSS.setCdmaDefaultRoamingIndicator(this.mDefaultRoamingIndicator);
        this.newSS.setCdmaRoamingIndicator(this.mRoamingIndicator);
        var8_9 = true;
        if (TextUtils.isEmpty(this.mPrlVersion)) {
            var8_9 = false;
        }
        if (!var8_9) {
            this.newSS.setCdmaRoamingIndicator(2);
        } else if (!this.isSidsAllZeros()) {
            if (!var7_7 && !this.mIsInPrl) {
                this.newSS.setCdmaRoamingIndicator(this.mDefaultRoamingIndicator);
            } else if (var7_7 && !this.mIsInPrl) {
                this.newSS.setCdmaRoamingIndicator(2);
            } else if (!var7_7 && this.mIsInPrl) {
                this.newSS.setCdmaRoamingIndicator(this.mRoamingIndicator);
            } else if (this.mRoamingIndicator <= 2) {
                this.newSS.setCdmaRoamingIndicator(1);
            } else {
                this.newSS.setCdmaRoamingIndicator(this.mRoamingIndicator);
            }
        }
        var9_10 = this.newSS.getCdmaRoamingIndicator();
        this.newSS.setCdmaEriIconIndex(this.phone.mEriManager.getCdmaEriIconIndex(var9_10, this.mDefaultRoamingIndicator));
        this.newSS.setCdmaEriIconMode(this.phone.mEriManager.getCdmaEriIconMode(var9_10, this.mDefaultRoamingIndicator));
        this.log("Set CDMA Roaming Indicator to: " + this.newSS.getCdmaRoamingIndicator() + ". mCdmaRoaming = " + this.mCdmaRoaming + ", isPrlLoaded = " + var8_9 + ". namMatch = " + var7_7 + " , mIsInPrl = " + this.mIsInPrl + ", mRoamingIndicator = " + this.mRoamingIndicator + ", mDefaultRoamingIndicator= " + this.mDefaultRoamingIndicator);
        this.pollStateDone();
    }

    boolean isConcurrentVoiceAndData() {
        return false;
    }

    public boolean isMinInfoReady() {
        return this.mIsMinInfoReady;
    }

    protected void log(String string2) {
        Log.d(LOG_TAG, "[CdmaServiceStateTracker] " + string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void powerOffRadioSafely() {
        DataConnectionTracker dataConnectionTracker = this.phone.mDataConnection;
        Message message = dataConnectionTracker.obtainMessage(34);
        message.arg1 = 1;
        message.obj = "radioTurnedOff";
        dataConnectionTracker.sendMessage(message);
        synchronized (this) {
            if (!this.mPendingRadioPowerOffAfterDataOff) {
                DataConnectionTracker.State state = dataConnectionTracker.getState();
                if (state != DataConnectionTracker.State.CONNECTED && state != DataConnectionTracker.State.DISCONNECTING && state != DataConnectionTracker.State.INITING) {
                    this.log("Data disconnected, turn off radio right away.");
                    this.hangupAndPowerOff();
                } else if (this.sendEmptyMessageDelayed(38, 30000L)) {
                    this.log("Wait up to 30 sec for data to disconnect, then turn off radio.");
                    this.mPendingRadioPowerOffAfterDataOff = true;
                } else {
                    Log.w(LOG_TAG, "Cannot send delayed Msg, turn off radio right away.");
                    this.hangupAndPowerOff();
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean processPendingRadioPowerOffAfterDataOff() {
        synchronized (this) {
            if (this.mPendingRadioPowerOffAfterDataOff) {
                this.log("Process pending request to turn radio off.");
                this.removeMessages(38);
                this.hangupAndPowerOff();
                this.mPendingRadioPowerOffAfterDataOff = false;
                return true;
            }
            return false;
        }
    }

    void registerForCdmaDataConnectionAttached(Handler handler, int n, Object object) {
        Registrant registrant = new Registrant(handler, n, object);
        this.cdmaDataConnectionAttachedRegistrants.add(registrant);
        if (this.cdmaDataConnectionState == 0) {
            registrant.notifyRegistrant();
        }
    }

    void registerForCdmaDataConnectionDetached(Handler handler, int n, Object object) {
        Registrant registrant = new Registrant(handler, n, object);
        this.cdmaDataConnectionDetachedRegistrants.add(registrant);
        if (this.cdmaDataConnectionState != 0) {
            registrant.notifyRegistrant();
        }
    }

    void registerForNetworkAttach(Handler handler, int n, Object object) {
        Registrant registrant = new Registrant(handler, n, object);
        this.networkAttachedRegistrants.add(registrant);
        if (this.ss.getState() == 0) {
            registrant.notifyRegistrant();
        }
    }

    public void registerForSubscriptionInfoReady(Handler handler, int n, Object object) {
        Registrant registrant = new Registrant(handler, n, object);
        this.cdmaForSubscriptionInfoReadyRegistrants.add(registrant);
        if (this.isMinInfoReady()) {
            registrant.notifyRegistrant();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    @Override
    protected void setPowerStateToDesired() {
        if (this.mDesiredPowerState && this.cm.getRadioState() == CommandsInterface.RadioState.RADIO_OFF) {
            this.cm.setRadioPower(true, null);
            return;
        }
        if (this.mDesiredPowerState) return;
        if (!this.cm.getRadioState().isOn()) return;
        DataConnectionTracker dataConnectionTracker = this.phone.mDataConnection;
        if (!dataConnectionTracker.isDataConnectionAsDesired()) {
            Object[] objectArray = new Object[2];
            objectArray[0] = dataConnectionTracker.getStateInString();
            int n = dataConnectionTracker.getAnyDataEnabled() ? 1 : 0;
            objectArray[1] = n;
            EventLog.writeEvent(50108, objectArray);
        }
        this.powerOffRadioSafely();
    }

    void unregisterForCdmaDataConnectionAttached(Handler handler) {
        this.cdmaDataConnectionAttachedRegistrants.remove(handler);
    }

    void unregisterForCdmaDataConnectionDetached(Handler handler) {
        this.cdmaDataConnectionDetachedRegistrants.remove(handler);
    }

    void unregisterForNetworkAttach(Handler handler) {
        this.networkAttachedRegistrants.remove(handler);
    }

    public void unregisterForSubscriptionInfoReady(Handler handler) {
        this.cdmaForSubscriptionInfoReadyRegistrants.remove(handler);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void updateSpnDisplay() {
        boolean bl;
        String string2;
        if (this.cm.getRadioState().isRUIMReady()) {
            string2 = this.ss.getOperatorAlphaLong();
            bl = true;
        } else {
            string2 = this.ss.getOperatorAlphaLong();
            bl = true;
        }
        if (this.curSpnRule != 0 || !TextUtils.equals("", this.curSpn) || !TextUtils.equals(string2, this.curPlmn)) {
            Intent intent = new Intent("android.provider.Telephony.SPN_STRINGS_UPDATED");
            intent.addFlags(0x20000000);
            intent.putExtra("showSpn", false);
            intent.putExtra("spn", "");
            intent.putExtra("showPlmn", bl);
            intent.putExtra("plmn", string2);
            this.phone.getContext().sendStickyBroadcast(intent);
        }
        this.curSpnRule = 0;
        this.curSpn = "";
        this.curPlmn = string2;
    }
}

