/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.os.AsyncResult;
import android.os.Message;
import android.util.Log;
import com.android.internal.telephony.AdnRecordCache;
import com.android.internal.telephony.IccException;
import com.android.internal.telephony.IccRecords;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.cdma.CDMAPhone;

public final class RuimRecords
extends IccRecords {
    private static final boolean DBG = true;
    private static final int EVENT_GET_ALL_SMS_DONE = 18;
    private static final int EVENT_GET_CDMA_SUBSCRIPTION_DONE = 10;
    private static final int EVENT_GET_DEVICE_IDENTITY_DONE = 4;
    private static final int EVENT_GET_ICCID_DONE = 5;
    private static final int EVENT_GET_SMS_DONE = 22;
    private static final int EVENT_GET_SST_DONE = 17;
    private static final int EVENT_MARK_SMS_READ_DONE = 19;
    private static final int EVENT_RADIO_OFF_OR_NOT_AVAILABLE = 2;
    private static final int EVENT_RUIM_READY = 1;
    private static final int EVENT_RUIM_REFRESH = 31;
    private static final int EVENT_SMS_ON_RUIM = 21;
    private static final int EVENT_UPDATE_DONE = 14;
    static final String LOG_TAG = "CDMA";
    private String mImsi;
    private String mMin2Min1;
    private String mMyMobileNumber;
    private String mPrlVersion;
    private boolean m_ota_commited = false;

    RuimRecords(CDMAPhone cDMAPhone) {
        super(cDMAPhone);
        this.adnCache = new AdnRecordCache(this.phone);
        this.recordsRequested = false;
        this.recordsToLoad = 0;
        cDMAPhone.mCM.registerForRUIMReady(this, 1, null);
        cDMAPhone.mCM.registerForOffOrNotAvailable(this, 2, null);
        cDMAPhone.mCM.setOnIccRefresh(this, 31, null);
        this.onRadioOffOrNotAvailable();
    }

    private void fetchRuimRecords() {
        this.recordsRequested = true;
        Log.v(LOG_TAG, "RuimRecords:fetchRuimRecords " + this.recordsToLoad);
        this.phone.getIccFileHandler().loadEFTransparent(12258, this.obtainMessage(5));
        this.recordsToLoad = 1 + this.recordsToLoad;
    }

    private void handleRuimRefresh(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            this.log("handleRuimRefresh without input");
            return;
        }
        switch (nArray[0]) {
            default: {
                this.log("handleRuimRefresh with unknown operation");
                return;
            }
            case 0: {
                this.log("handleRuimRefresh with SIM_REFRESH_FILE_UPDATED");
                this.adnCache.reset();
                this.fetchRuimRecords();
                return;
            }
            case 1: {
                this.log("handleRuimRefresh with SIM_REFRESH_INIT");
                this.fetchRuimRecords();
                return;
            }
            case 2: 
        }
        this.log("handleRuimRefresh with SIM_REFRESH_RESET");
        this.phone.mCM.setRadioPower(false, null);
    }

    private void onRuimReady() {
        ((CDMAPhone)this.phone).mRuimCard.broadcastIccStateChangedIntent("READY", null);
        this.fetchRuimRecords();
        this.phone.mCM.getCDMASubscription(this.obtainMessage(10));
    }

    public void dispose() {
        this.phone.mCM.unregisterForRUIMReady(this);
        this.phone.mCM.unregisterForOffOrNotAvailable(this);
        this.phone.mCM.unSetOnIccRefresh(this);
    }

    protected void finalize() {
        Log.d(LOG_TAG, "RuimRecords finalized");
    }

    public String getCdmaMin() {
        return this.mMin2Min1;
    }

    @Override
    protected int getDisplayRule(String string2) {
        return 0;
    }

    public String getMdnNumber() {
        return this.mMyMobileNumber;
    }

    public String getPrlVersion() {
        return this.mPrlVersion;
    }

    public String getRUIMOperatorNumeric() {
        if (this.mImsi == null) {
            return null;
        }
        if (this.mncLength != -1 && this.mncLength != 0) {
            return this.mImsi.substring(0, 3 + this.mncLength);
        }
        int n = Integer.parseInt(this.mImsi.substring(0, 3));
        return this.mImsi.substring(0, 3 + MccTable.smallestDigitsMccForMnc(n));
    }

    /*
     * Exception decompiling
     */
    @Override
    public void handleMessage(Message var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [5, 6 : 157->161)] java.lang.RuntimeException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected void log(String string2) {
        Log.d(LOG_TAG, "[RuimRecords] " + string2);
    }

    @Override
    protected void onAllRecordsLoaded() {
        Log.d(LOG_TAG, "RuimRecords: record load complete");
        this.recordsLoadedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        ((CDMAPhone)this.phone).mRuimCard.broadcastIccStateChangedIntent("LOADED", null);
    }

    @Override
    protected void onRadioOffOrNotAvailable() {
        this.countVoiceMessages = 0;
        this.mncLength = -1;
        this.iccid = null;
        this.adnCache.reset();
        this.recordsRequested = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onRecordLoaded() {
        --this.recordsToLoad;
        if (this.recordsToLoad == 0 && this.recordsRequested) {
            this.onAllRecordsLoaded();
            return;
        } else {
            if (this.recordsToLoad >= 0) return;
            Log.e(LOG_TAG, "RuimRecords: recordsToLoad <0, programmer error suspected");
            this.recordsToLoad = 0;
            return;
        }
    }

    @Override
    public void onRefresh(boolean bl, int[] nArray) {
        if (bl) {
            this.fetchRuimRecords();
        }
    }

    @Override
    public void setVoiceMailNumber(String string2, String string3, Message message) {
        AsyncResult.forMessage((Message)message).exception = new IccException("setVoiceMailNumber not implemented");
        message.sendToTarget();
        Log.e(LOG_TAG, "method setVoiceMailNumber is not implemented");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setVoiceMessageWaiting(int n, int n2) {
        if (n != 1) {
            return;
        }
        if (n2 < 0) {
            n2 = -1;
        } else if (n2 > 255) {
            n2 = 255;
        }
        this.countVoiceMessages = n2;
        ((CDMAPhone)this.phone).notifyMessageWaitingIndicator();
    }
}

