/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.android.internal.telephony.IccSmsInterfaceManager;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.SMSDispatcher;
import com.android.internal.telephony.SmsRawData;
import com.android.internal.telephony.cdma.CDMAPhone;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RuimSmsInterfaceManager
extends IccSmsInterfaceManager {
    static final boolean DBG = true;
    private static final int EVENT_LOAD_DONE = 1;
    private static final int EVENT_UPDATE_DONE = 2;
    static final String LOG_TAG = "CDMA";
    Handler mHandler;
    private final Object mLock = new Object();
    private List<SmsRawData> mSms;
    private boolean mSuccess;

    public RuimSmsInterfaceManager(CDMAPhone cDMAPhone, SMSDispatcher sMSDispatcher) {
        super(cDMAPhone);
        this.mHandler = new Handler(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        return;
                    }
                    case 2: {
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        Object object = RuimSmsInterfaceManager.this.mLock;
                        synchronized (object) {
                            RuimSmsInterfaceManager ruimSmsInterfaceManager = RuimSmsInterfaceManager.this;
                            boolean bl = asyncResult.exception == null;
                            RuimSmsInterfaceManager.access$102(ruimSmsInterfaceManager, bl);
                            RuimSmsInterfaceManager.this.mLock.notifyAll();
                            return;
                        }
                    }
                    case 1: 
                }
                AsyncResult asyncResult = (AsyncResult)message.obj;
                Object object = RuimSmsInterfaceManager.this.mLock;
                synchronized (object) {
                    if (asyncResult.exception == null) {
                        RuimSmsInterfaceManager.access$202(RuimSmsInterfaceManager.this, RuimSmsInterfaceManager.this.buildValidRawData((ArrayList)asyncResult.result));
                    } else {
                        RuimSmsInterfaceManager.this.log("Cannot load Sms records");
                        if (RuimSmsInterfaceManager.this.mSms != null) {
                            RuimSmsInterfaceManager.this.mSms.clear();
                        }
                    }
                    RuimSmsInterfaceManager.this.mLock.notifyAll();
                    return;
                }
            }
        };
        this.mDispatcher = sMSDispatcher;
    }

    static /* synthetic */ boolean access$102(RuimSmsInterfaceManager ruimSmsInterfaceManager, boolean bl) {
        ruimSmsInterfaceManager.mSuccess = bl;
        return bl;
    }

    static /* synthetic */ List access$202(RuimSmsInterfaceManager ruimSmsInterfaceManager, List list) {
        ruimSmsInterfaceManager.mSms = list;
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean copyMessageToIccEf(int n, byte[] byArray, byte[] byArray2) {
        this.log("copyMessageToIccEf: status=" + n + " ==> " + "pdu=(" + Arrays.toString(byArray) + ")");
        this.enforceReceiveAndSend("Copying message to RUIM");
        Object object = this.mLock;
        synchronized (object) {
            this.mSuccess = false;
            Message message = this.mHandler.obtainMessage(2);
            this.mPhone.mCM.writeSmsToRuim(n, IccUtils.bytesToHexString(byArray), message);
            try {
                this.mLock.wait();
            }
            catch (InterruptedException interruptedException) {
                this.log("interrupted while trying to update by index");
            }
            return this.mSuccess;
        }
    }

    public void dispose() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            Log.e(LOG_TAG, "Error while finalizing:", throwable);
        }
        Log.d(LOG_TAG, "RuimSmsInterfaceManager finalized");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<SmsRawData> getAllMessagesFromIccEf() {
        this.log("getAllMessagesFromEF");
        this.mPhone.getContext().enforceCallingPermission("android.permission.RECEIVE_SMS", "Reading messages from RUIM");
        Object object = this.mLock;
        synchronized (object) {
            Message message = this.mHandler.obtainMessage(1);
            this.mPhone.getIccFileHandler().loadEFLinearFixedAll(28476, message);
            try {
                this.mLock.wait();
            }
            catch (InterruptedException interruptedException) {
                this.log("interrupted while trying to load from the RUIM");
            }
            return this.mSms;
        }
    }

    @Override
    protected void log(String string2) {
        Log.d(LOG_TAG, "[RuimSmsInterfaceManager] " + string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean updateMessageOnIccEf(int n, int n2, byte[] byArray) {
        this.log("updateMessageOnIccEf: index=" + n + " status=" + n2 + " ==> " + "(" + byArray + ")");
        this.enforceReceiveAndSend("Updating message on RUIM");
        Object object = this.mLock;
        synchronized (object) {
            this.mSuccess = false;
            Message message = this.mHandler.obtainMessage(2);
            if (n2 == 0) {
                this.mPhone.mCM.deleteSmsOnRuim(n, message);
            } else {
                byte[] byArray2 = this.makeSmsRecordData(n2, byArray);
                this.mPhone.getIccFileHandler().updateEFLinearFixed(28476, n, byArray2, null, message);
            }
            try {
                this.mLock.wait();
            }
            catch (InterruptedException interruptedException) {
                this.log("interrupted while trying to update by index");
            }
            return this.mSuccess;
        }
    }
}

