/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.os.Parcel;
import android.os.SystemProperties;
import android.telephony.SmsMessage;
import android.util.Log;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.cdma.sms.BearerData;
import com.android.internal.telephony.cdma.sms.CdmaSmsAddress;
import com.android.internal.telephony.cdma.sms.SmsEnvelope;
import com.android.internal.telephony.cdma.sms.UserData;
import com.android.internal.util.HexDump;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SmsMessage
extends SmsMessageBase {
    private static final String LOGGABLE_TAG = "CDMA:SMS";
    static final String LOG_TAG = "CDMA";
    private static final int RETURN_ACK = 1;
    private static final int RETURN_NO_ACK;
    private BearerData mBearerData;
    private SmsEnvelope mEnvelope;
    private int status;

    public static SmsMessageBase.TextEncodingDetails calculateLength(CharSequence charSequence, boolean bl) {
        return BearerData.calcTextEncodingDetails(charSequence, bl);
    }

    private byte convertDtmfToAscii(byte by) {
        switch (by) {
            default: {
                return 32;
            }
            case 0: {
                return 68;
            }
            case 1: {
                return 49;
            }
            case 2: {
                return 50;
            }
            case 3: {
                return 51;
            }
            case 4: {
                return 52;
            }
            case 5: {
                return 53;
            }
            case 6: {
                return 54;
            }
            case 7: {
                return 55;
            }
            case 8: {
                return 56;
            }
            case 9: {
                return 57;
            }
            case 10: {
                return 48;
            }
            case 11: {
                return 42;
            }
            case 12: {
                return 35;
            }
            case 13: {
                return 65;
            }
            case 14: {
                return 66;
            }
            case 15: 
        }
        return 67;
    }

    public static SmsMessage createFromEfRecord(int n, byte[] byArray) {
        SmsMessage smsMessage;
        block3: {
            try {
                smsMessage = new SmsMessage();
                smsMessage.indexOnIcc = n;
                if ((1 & byArray[0]) != 0) break block3;
                Log.w(LOG_TAG, "SMS parsing failed: Trying to parse a free record");
                return null;
            }
            catch (RuntimeException runtimeException) {
                Log.e(LOG_TAG, "SMS PDU parsing failed: ", runtimeException);
                return null;
            }
        }
        smsMessage.statusOnIcc = 7 & byArray[0];
        byte by = byArray[1];
        System.arraycopy(byArray, 2, new byte[by], 0, by);
        return smsMessage;
    }

    public static SmsMessage createFromPdu(byte[] byArray) {
        SmsMessage smsMessage = new SmsMessage();
        try {
            smsMessage.parsePdu(byArray);
            return smsMessage;
        }
        catch (RuntimeException runtimeException) {
            Log.e(LOG_TAG, "SMS PDU parsing failed: ", runtimeException);
            return null;
        }
    }

    private void createPdu() {
        SmsEnvelope smsEnvelope = this.mEnvelope;
        CdmaSmsAddress cdmaSmsAddress = smsEnvelope.origAddress;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(100);
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(byteArrayOutputStream));
        try {
            dataOutputStream.writeInt(smsEnvelope.messageType);
            dataOutputStream.writeInt(smsEnvelope.teleService);
            dataOutputStream.writeInt(smsEnvelope.serviceCategory);
            dataOutputStream.writeByte(cdmaSmsAddress.digitMode);
            dataOutputStream.writeByte(cdmaSmsAddress.numberMode);
            dataOutputStream.writeByte(cdmaSmsAddress.ton);
            dataOutputStream.writeByte(cdmaSmsAddress.numberPlan);
            dataOutputStream.writeByte(cdmaSmsAddress.numberOfDigits);
            dataOutputStream.write(cdmaSmsAddress.origBytes, 0, cdmaSmsAddress.origBytes.length);
            dataOutputStream.writeInt(smsEnvelope.bearerReply);
            dataOutputStream.writeByte(smsEnvelope.replySeqNo);
            dataOutputStream.writeByte(smsEnvelope.errorClass);
            dataOutputStream.writeByte(smsEnvelope.causeCode);
            dataOutputStream.writeInt(smsEnvelope.bearerData.length);
            dataOutputStream.write(smsEnvelope.bearerData, 0, smsEnvelope.bearerData.length);
            dataOutputStream.close();
            this.mPdu = byteArrayOutputStream.toByteArray();
            return;
        }
        catch (IOException iOException) {
            Log.e(LOG_TAG, "createPdu: conversion from object to byte array failed: " + iOException);
            return;
        }
    }

    private static int getNextMessageId() {
        synchronized (SmsMessage.class) {
            int n = SystemProperties.getInt("persist.radio.cdma.msgid", 1);
            String string2 = Integer.toString(1 + n % 65535);
            SystemProperties.set("persist.radio.cdma.msgid", string2);
            if (Log.isLoggable(LOGGABLE_TAG, 2)) {
                Log.d(LOG_TAG, "next persist.radio.cdma.msgid = " + string2);
                Log.d(LOG_TAG, "readback gets " + SystemProperties.get("persist.radio.cdma.msgid"));
            }
            return n;
        }
    }

    public static SubmitPdu getSubmitPdu(String string2, UserData userData, boolean bl) {
        return SmsMessage.privateGetSubmitPdu(string2, bl, userData);
    }

    public static SubmitPdu getSubmitPdu(String string2, String string3, int n, byte[] byArray, boolean bl) {
        SmsHeader.PortAddrs portAddrs = new SmsHeader.PortAddrs();
        portAddrs.destPort = n;
        portAddrs.origPort = 0;
        portAddrs.areEightBits = false;
        SmsHeader smsHeader = new SmsHeader();
        smsHeader.portAddrs = portAddrs;
        UserData userData = new UserData();
        userData.userDataHeader = smsHeader;
        userData.msgEncoding = 0;
        userData.msgEncodingSet = true;
        userData.payload = byArray;
        return SmsMessage.privateGetSubmitPdu(string3, bl, userData);
    }

    public static SubmitPdu getSubmitPdu(String string2, String string3, String string4, boolean bl, SmsHeader smsHeader) {
        if (string4 == null || string3 == null) {
            return null;
        }
        UserData userData = new UserData();
        userData.payloadStr = string4;
        userData.userDataHeader = smsHeader;
        return SmsMessage.privateGetSubmitPdu(string3, bl, userData);
    }

    public static int getTPLayerLengthForPDU(String string2) {
        Log.w(LOG_TAG, "getTPLayerLengthForPDU: is not supported in CDMA mode.");
        return 0;
    }

    public static SmsMessage newFromCDS(String string2) {
        Log.w(LOG_TAG, "newFromCDS: is not supported in CDMA mode.");
        return null;
    }

    public static SmsMessage newFromCMT(String[] stringArray) {
        Log.w(LOG_TAG, "newFromCMT: is not supported in CDMA mode.");
        return null;
    }

    public static SmsMessage newFromCMTI(String string2) {
        Log.w(LOG_TAG, "newFromCMTI: is not supported in CDMA mode.");
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static SmsMessage newFromParcel(Parcel parcel) {
        SmsMessage smsMessage = new SmsMessage();
        SmsEnvelope smsEnvelope = new SmsEnvelope();
        CdmaSmsAddress cdmaSmsAddress = new CdmaSmsAddress();
        smsEnvelope.teleService = parcel.readInt();
        smsEnvelope.messageType = parcel.readByte() != 0 ? 1 : (smsEnvelope.teleService == 0 ? 2 : 0);
        smsEnvelope.serviceCategory = parcel.readInt();
        int n = parcel.readInt();
        cdmaSmsAddress.digitMode = (byte)(n & 0xFF);
        cdmaSmsAddress.numberMode = (byte)(0xFF & parcel.readInt());
        cdmaSmsAddress.ton = parcel.readInt();
        cdmaSmsAddress.numberPlan = (byte)(0xFF & parcel.readInt());
        int n2 = parcel.readByte();
        cdmaSmsAddress.numberOfDigits = n2;
        byte[] byArray = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byArray[i] = parcel.readByte();
            if (n != 0) continue;
            byArray[i] = smsMessage.convertDtmfToAscii(byArray[i]);
        }
        cdmaSmsAddress.origBytes = byArray;
        parcel.readInt();
        parcel.readInt();
        int n3 = parcel.readByte();
        for (int i = 0; i < n3; ++i) {
            parcel.readByte();
        }
        int n4 = parcel.readInt();
        if (n4 > 0) {
            byte[] byArray2 = new byte[n4];
            for (int i = 0; i < n4; ++i) {
                byArray2[i] = parcel.readByte();
            }
            smsEnvelope.bearerData = byArray2;
        }
        smsEnvelope.origAddress = cdmaSmsAddress;
        smsMessage.originatingAddress = cdmaSmsAddress;
        smsMessage.mEnvelope = smsEnvelope;
        smsMessage.createPdu();
        return smsMessage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parsePdu(byte[] byArray) {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        SmsEnvelope smsEnvelope = new SmsEnvelope();
        CdmaSmsAddress cdmaSmsAddress = new CdmaSmsAddress();
        try {
            smsEnvelope.messageType = dataInputStream.readInt();
            smsEnvelope.teleService = dataInputStream.readInt();
            smsEnvelope.serviceCategory = dataInputStream.readInt();
            cdmaSmsAddress.digitMode = dataInputStream.readByte();
            cdmaSmsAddress.numberMode = dataInputStream.readByte();
            cdmaSmsAddress.ton = dataInputStream.readByte();
            cdmaSmsAddress.numberPlan = dataInputStream.readByte();
            byte by = dataInputStream.readByte();
            cdmaSmsAddress.numberOfDigits = by;
            cdmaSmsAddress.origBytes = new byte[by];
            dataInputStream.read(cdmaSmsAddress.origBytes, 0, by);
            smsEnvelope.bearerReply = dataInputStream.readInt();
            smsEnvelope.replySeqNo = dataInputStream.readByte();
            smsEnvelope.errorClass = dataInputStream.readByte();
            smsEnvelope.causeCode = dataInputStream.readByte();
            int n = dataInputStream.readInt();
            smsEnvelope.bearerData = new byte[n];
            dataInputStream.read(smsEnvelope.bearerData, 0, n);
            dataInputStream.close();
        }
        catch (Exception exception) {
            Log.e(LOG_TAG, "createFromPdu: conversion from byte array to object failed: " + exception);
        }
        this.originatingAddress = cdmaSmsAddress;
        smsEnvelope.origAddress = cdmaSmsAddress;
        this.mEnvelope = smsEnvelope;
        this.mPdu = byArray;
        this.parseSms();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SubmitPdu privateGetSubmitPdu(String string2, boolean bl, UserData userData) {
        CdmaSmsAddress cdmaSmsAddress = CdmaSmsAddress.parse(string2);
        if (cdmaSmsAddress == null) {
            return null;
        }
        BearerData bearerData = new BearerData();
        bearerData.messageType = 2;
        bearerData.messageId = SmsMessage.getNextMessageId();
        bearerData.deliveryAckReq = bl;
        bearerData.userAckReq = false;
        bearerData.readAckReq = false;
        bearerData.reportReq = false;
        bearerData.userData = userData;
        byte[] byArray = BearerData.encode(bearerData);
        if (Log.isLoggable(LOGGABLE_TAG, 2)) {
            Log.d(LOG_TAG, "MO (encoded) BearerData = " + bearerData);
            Log.d(LOG_TAG, "MO raw BearerData = '" + HexDump.toHexString(byArray) + "'");
        }
        if (byArray == null) {
            return null;
        }
        int n = bearerData.hasUserDataHeader ? 4101 : 4098;
        SmsEnvelope smsEnvelope = new SmsEnvelope();
        smsEnvelope.messageType = 0;
        smsEnvelope.teleService = n;
        smsEnvelope.destAddress = cdmaSmsAddress;
        smsEnvelope.bearerReply = 1;
        smsEnvelope.bearerData = byArray;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(100);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(smsEnvelope.teleService);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
            dataOutputStream.write(cdmaSmsAddress.digitMode);
            dataOutputStream.write(cdmaSmsAddress.numberMode);
            dataOutputStream.write(cdmaSmsAddress.ton);
            dataOutputStream.write(cdmaSmsAddress.numberPlan);
            dataOutputStream.write(cdmaSmsAddress.numberOfDigits);
            dataOutputStream.write(cdmaSmsAddress.origBytes, 0, cdmaSmsAddress.origBytes.length);
            dataOutputStream.write(0);
            dataOutputStream.write(0);
            dataOutputStream.write(0);
            dataOutputStream.write(byArray.length);
            dataOutputStream.write(byArray, 0, byArray.length);
            dataOutputStream.close();
            SubmitPdu submitPdu = new SubmitPdu();
            submitPdu.encodedMessage = byteArrayOutputStream.toByteArray();
            submitPdu.encodedScAddress = null;
            return submitPdu;
        }
        catch (IOException iOException) {
            Log.e(LOG_TAG, "creating SubmitPdu failed: " + iOException);
            return null;
        }
    }

    byte[] getIncomingSmsFingerprint() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(this.mEnvelope.teleService);
        byteArrayOutputStream.write(this.mEnvelope.origAddress.origBytes, 0, this.mEnvelope.origAddress.origBytes.length);
        byteArrayOutputStream.write(this.mEnvelope.bearerData, 0, this.mEnvelope.bearerData.length);
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public SmsMessage.MessageClass getMessageClass() {
        if (this.mBearerData.displayMode == 0) {
            return SmsMessage.MessageClass.CLASS_0;
        }
        return SmsMessage.MessageClass.UNKNOWN;
    }

    int getMessageType() {
        return this.mEnvelope.messageType;
    }

    int getNumOfVoicemails() {
        return this.mBearerData.numberOfMessages;
    }

    @Override
    public int getProtocolIdentifier() {
        Log.w(LOG_TAG, "getProtocolIdentifier: is not supported in CDMA mode.");
        return 0;
    }

    @Override
    public int getStatus() {
        return this.status << 16;
    }

    int getTeleService() {
        return this.mEnvelope.teleService;
    }

    @Override
    public boolean isCphsMwiMessage() {
        Log.w(LOG_TAG, "isCphsMwiMessage: is not supported in CDMA mode.");
        return false;
    }

    @Override
    public boolean isMWIClearMessage() {
        return this.mBearerData != null && this.mBearerData.numberOfMessages == 0;
    }

    @Override
    public boolean isMWISetMessage() {
        return this.mBearerData != null && this.mBearerData.numberOfMessages > 0;
    }

    @Override
    public boolean isMwiDontStore() {
        return this.mBearerData != null && this.mBearerData.numberOfMessages > 0 && this.mBearerData.userData == null;
    }

    @Override
    public boolean isReplace() {
        Log.w(LOG_TAG, "isReplace: is not supported in CDMA mode.");
        return false;
    }

    @Override
    public boolean isReplyPathPresent() {
        Log.w(LOG_TAG, "isReplyPathPresent: is not supported in CDMA mode.");
        return false;
    }

    @Override
    public boolean isStatusReportMessage() {
        return this.mBearerData.messageType == 4;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void parseSms() {
        if (this.mEnvelope.teleService == 262144) {
            this.mBearerData = new BearerData();
            if (this.mEnvelope.bearerData == null) return;
            this.mBearerData.numberOfMessages = 0xFF & this.mEnvelope.bearerData[0];
            return;
        }
        this.mBearerData = BearerData.decode(this.mEnvelope.bearerData);
        if (Log.isLoggable(LOGGABLE_TAG, 2)) {
            Log.d(LOG_TAG, "MT raw BearerData = '" + HexDump.toHexString(this.mEnvelope.bearerData) + "'");
            Log.d(LOG_TAG, "MT (decoded) BearerData = " + this.mBearerData);
        }
        this.messageRef = this.mBearerData.messageId;
        if (this.mBearerData.userData != null) {
            this.userData = this.mBearerData.userData.payload;
            this.userDataHeader = this.mBearerData.userData.userDataHeader;
            this.messageBody = this.mBearerData.userData.payloadStr;
        }
        if (this.originatingAddress != null) {
            this.originatingAddress.address = new String(this.originatingAddress.origBytes);
        }
        if (this.mBearerData.msgCenterTimeStamp != null) {
            this.scTimeMillis = this.mBearerData.msgCenterTimeStamp.toMillis(true);
        }
        Log.d(LOG_TAG, "SMS SC timestamp: " + this.scTimeMillis);
        if (this.mBearerData.messageType == 4) {
            if (!this.mBearerData.messageStatusSet) {
                StringBuilder stringBuilder = new StringBuilder().append("DELIVERY_ACK message without msgStatus (");
                String string2 = this.userData == null ? "also missing" : "does have";
                Log.d(LOG_TAG, stringBuilder.append(string2).append(" userData).").toString());
                this.status = 0;
            } else {
                this.status = this.mBearerData.errorClass << 8;
                this.status |= this.mBearerData.messageStatus;
            }
        } else if (this.mBearerData.messageType != 1) {
            throw new RuntimeException("Unsupported message type: " + this.mBearerData.messageType);
        }
        if (this.messageBody != null) {
            this.parseMessageBody();
            return;
        }
        if (this.userData == null) return;
    }

    public static class SubmitPdu
    extends SmsMessageBase.SubmitPduBase {
    }
}

