/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma.sms;

import android.text.format.Time;
import android.util.Log;
import com.android.internal.telephony.EncodeException;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.cdma.sms.CdmaSmsAddress;
import com.android.internal.telephony.cdma.sms.UserData;
import com.android.internal.telephony.gsm.SmsMessage;
import com.android.internal.util.BitwiseInputStream;
import com.android.internal.util.BitwiseOutputStream;
import java.io.UnsupportedEncodingException;

public final class BearerData {
    public static final int ALERT_DEFAULT = 0;
    public static final int ALERT_HIGH_PRIO = 3;
    public static final int ALERT_LOW_PRIO = 1;
    public static final int ALERT_MEDIUM_PRIO = 2;
    public static final int DISPLAY_MODE_DEFAULT = 1;
    public static final int DISPLAY_MODE_IMMEDIATE = 0;
    public static final int DISPLAY_MODE_USER = 2;
    public static final int ERROR_NONE = 0;
    public static final int ERROR_PERMANENT = 3;
    public static final int ERROR_TEMPORARY = 2;
    public static final int ERROR_UNDEFINED = 255;
    public static final int LANGUAGE_CHINESE = 6;
    public static final int LANGUAGE_ENGLISH = 1;
    public static final int LANGUAGE_FRENCH = 2;
    public static final int LANGUAGE_HEBREW = 7;
    public static final int LANGUAGE_JAPANESE = 4;
    public static final int LANGUAGE_KOREAN = 5;
    public static final int LANGUAGE_SPANISH = 3;
    public static final int LANGUAGE_UNKNOWN = 0;
    private static final String LOG_TAG = "SMS";
    public static final int MESSAGE_TYPE_CANCELLATION = 3;
    public static final int MESSAGE_TYPE_DELIVER = 1;
    public static final int MESSAGE_TYPE_DELIVERY_ACK = 4;
    public static final int MESSAGE_TYPE_DELIVER_REPORT = 7;
    public static final int MESSAGE_TYPE_READ_ACK = 6;
    public static final int MESSAGE_TYPE_SUBMIT = 2;
    public static final int MESSAGE_TYPE_SUBMIT_REPORT = 8;
    public static final int MESSAGE_TYPE_USER_ACK = 5;
    public static final int PRIORITY_EMERGENCY = 3;
    public static final int PRIORITY_INTERACTIVE = 1;
    public static final int PRIORITY_NORMAL = 0;
    public static final int PRIORITY_URGENT = 2;
    public static final int PRIVACY_CONFIDENTIAL = 2;
    public static final int PRIVACY_NOT_RESTRICTED = 0;
    public static final int PRIVACY_RESTRICTED = 1;
    public static final int PRIVACY_SECRET = 3;
    public static final int RELATIVE_TIME_DAYS_LIMIT = 196;
    public static final int RELATIVE_TIME_HOURS_LIMIT = 167;
    public static final int RELATIVE_TIME_INDEFINITE = 245;
    public static final int RELATIVE_TIME_MINS_LIMIT = 143;
    public static final int RELATIVE_TIME_MOBILE_INACTIVE = 247;
    public static final int RELATIVE_TIME_NOW = 246;
    public static final int RELATIVE_TIME_RESERVED = 248;
    public static final int RELATIVE_TIME_WEEKS_LIMIT = 244;
    public static final int STATUS_ACCEPTED = 0;
    public static final int STATUS_BLOCKED_DESTINATION = 7;
    public static final int STATUS_CANCELLED = 3;
    public static final int STATUS_CANCEL_FAILED = 6;
    public static final int STATUS_DELIVERED = 2;
    public static final int STATUS_DEPOSITED_TO_INTERNET = 1;
    public static final int STATUS_DUPLICATE_MESSAGE = 9;
    public static final int STATUS_INVALID_DESTINATION = 10;
    public static final int STATUS_MESSAGE_EXPIRED = 13;
    public static final int STATUS_NETWORK_CONGESTION = 4;
    public static final int STATUS_NETWORK_ERROR = 5;
    public static final int STATUS_TEXT_TOO_LONG = 8;
    public static final int STATUS_UNDEFINED = 255;
    public static final int STATUS_UNKNOWN_ERROR = 31;
    private static final byte SUBPARAM_ALERT_ON_MESSAGE_DELIVERY = 12;
    private static final byte SUBPARAM_CALLBACK_NUMBER = 14;
    private static final byte SUBPARAM_DEFERRED_DELIVERY_TIME_ABSOLUTE = 6;
    private static final byte SUBPARAM_DEFERRED_DELIVERY_TIME_RELATIVE = 7;
    private static final byte SUBPARAM_LANGUAGE_INDICATOR = 13;
    private static final byte SUBPARAM_MESSAGE_CENTER_TIME_STAMP = 3;
    private static final byte SUBPARAM_MESSAGE_DEPOSIT_INDEX = 17;
    private static final byte SUBPARAM_MESSAGE_DISPLAY_MODE = 15;
    private static final byte SUBPARAM_MESSAGE_IDENTIFIER = 0;
    private static final byte SUBPARAM_MESSAGE_STATUS = 20;
    private static final byte SUBPARAM_NUMBER_OF_MESSAGES = 11;
    private static final byte SUBPARAM_PRIORITY_INDICATOR = 8;
    private static final byte SUBPARAM_PRIVACY_INDICATOR = 9;
    private static final byte SUBPARAM_REPLY_OPTION = 10;
    private static final byte SUBPARAM_USER_DATA = 1;
    private static final byte SUBPARAM_USER_REPONSE_CODE = 2;
    private static final byte SUBPARAM_VALIDITY_PERIOD_ABSOLUTE = 4;
    private static final byte SUBPARAM_VALIDITY_PERIOD_RELATIVE = 5;
    public int alert = 0;
    public boolean alertIndicatorSet = false;
    public CdmaSmsAddress callbackNumber;
    public TimeStamp deferredDeliveryTimeAbsolute;
    public int deferredDeliveryTimeRelative;
    public boolean deferredDeliveryTimeRelativeSet;
    public boolean deliveryAckReq;
    public int depositIndex;
    public int displayMode = 1;
    public boolean displayModeSet = false;
    public int errorClass = 255;
    public boolean hasUserDataHeader;
    public int language = 0;
    public boolean languageIndicatorSet = false;
    public int messageId;
    public int messageStatus = 255;
    public boolean messageStatusSet = false;
    public int messageType;
    public TimeStamp msgCenterTimeStamp;
    public int numberOfMessages;
    public int priority = 0;
    public boolean priorityIndicatorSet = false;
    public int privacy = 0;
    public boolean privacyIndicatorSet = false;
    public boolean readAckReq;
    public boolean reportReq;
    public boolean userAckReq;
    public UserData userData;
    public int userResponseCode;
    public boolean userResponseCodeSet = false;
    public TimeStamp validityPeriodAbsolute;
    public int validityPeriodRelative;
    public boolean validityPeriodRelativeSet;

    /*
     * Enabled aggressive block sorting
     */
    public static SmsMessageBase.TextEncodingDetails calcTextEncodingDetails(CharSequence charSequence, boolean bl) {
        SmsMessageBase.TextEncodingDetails textEncodingDetails;
        int n = BearerData.countAsciiSeptets(charSequence, bl);
        if (n != -1 && n <= 160) {
            textEncodingDetails = new SmsMessageBase.TextEncodingDetails();
            textEncodingDetails.msgCount = 1;
            textEncodingDetails.codeUnitCount = n;
            textEncodingDetails.codeUnitsRemaining = 160 - n;
            textEncodingDetails.codeUnitSize = 1;
            return textEncodingDetails;
        }
        textEncodingDetails = SmsMessage.calculateLength(charSequence, bl);
        if (textEncodingDetails.msgCount != 1 || textEncodingDetails.codeUnitSize != 1) return textEncodingDetails;
        textEncodingDetails.codeUnitCount = charSequence.length();
        int n2 = 2 * textEncodingDetails.codeUnitCount;
        if (n2 > 140) {
            textEncodingDetails.msgCount = (n2 + 133) / 134;
            textEncodingDetails.codeUnitsRemaining = (134 * textEncodingDetails.msgCount - n2) / 2;
        } else {
            textEncodingDetails.msgCount = 1;
            textEncodingDetails.codeUnitsRemaining = (140 - n2) / 2;
        }
        textEncodingDetails.codeUnitSize = 3;
        return textEncodingDetails;
    }

    private static int countAsciiSeptets(CharSequence charSequence, boolean bl) {
        int n = charSequence.length();
        if (bl) {
            return n;
        }
        for (int i = 0; i < n; ++i) {
            if (UserData.charToAscii.get(charSequence.charAt(i), -1) != -1) continue;
            return -1;
        }
        return n;
    }

    /*
     * Exception decompiling
     */
    public static BearerData decode(byte[] var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [6, 7 : 212->247)] com.android.internal.util.BitwiseInputStream$AccessException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String decode7bitAscii(byte[] byArray, int n, int n2) throws CodingException {
        int n3;
        BitwiseInputStream bitwiseInputStream;
        StringBuffer stringBuffer;
        int n4 = n * 8;
        try {
            stringBuffer = new StringBuffer(n2);
            bitwiseInputStream = new BitwiseInputStream(byArray);
            int n5 = n4 * 8 + n2 * 7;
            if (bitwiseInputStream.available() < n5) {
                throw new CodingException("insufficient data (wanted " + n5 + " bits, but only have " + bitwiseInputStream.available() + ")");
            }
            bitwiseInputStream.skip(n4);
            n3 = 0;
        }
        catch (BitwiseInputStream.AccessException accessException) {
            throw new CodingException("7bit ASCII decode failed: " + accessException);
        }
        while (n3 < n2) {
            int n6 = bitwiseInputStream.read(7);
            if (n6 >= 32 && n6 <= UserData.ASCII_MAP_MAX_INDEX) {
                stringBuffer.append(UserData.ASCII_MAP[n6 - 32]);
            } else if (n6 == 10) {
                stringBuffer.append('\n');
            } else if (n6 == 13) {
                stringBuffer.append('\r');
            } else {
                stringBuffer.append(' ');
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    private static String decode7bitGsm(byte[] byArray, int n, int n2) throws CodingException {
        int n3 = n * 8;
        int n4 = (n3 + 6) / 7;
        String string2 = GsmAlphabet.gsm7BitPackedToString(byArray, n, n2 - n4, n4 * 7 - n3);
        if (string2 == null) {
            throw new CodingException("7bit GSM decoding failed");
        }
        return string2;
    }

    private static boolean decodeCallbackNumber(BearerData bearerData, BitwiseInputStream bitwiseInputStream) throws BitwiseInputStream.AccessException, CodingException {
        int n = 8 * bitwiseInputStream.read(8);
        CdmaSmsAddress cdmaSmsAddress = new CdmaSmsAddress();
        cdmaSmsAddress.digitMode = bitwiseInputStream.read(1);
        int n2 = 4;
        int n3 = 1;
        if (cdmaSmsAddress.digitMode == 1) {
            cdmaSmsAddress.ton = bitwiseInputStream.read(3);
            cdmaSmsAddress.numberPlan = bitwiseInputStream.read(4);
            n2 = 8;
            n3 = (byte)(n3 + 7);
        }
        cdmaSmsAddress.numberOfDigits = bitwiseInputStream.read(8);
        int n4 = n - (byte)(n3 + 8);
        int n5 = n2 * cdmaSmsAddress.numberOfDigits;
        int n6 = n4 - n5;
        if (n4 < n5) {
            throw new CodingException("CALLBACK_NUMBER subparam encoding size error (remainingBits + " + n4 + ", dataBits + " + n5 + ", paddingBits + " + n6 + ")");
        }
        cdmaSmsAddress.origBytes = bitwiseInputStream.readByteArray(n5);
        bitwiseInputStream.skip(n6);
        BearerData.decodeSmsAddress(cdmaSmsAddress);
        bearerData.callbackNumber = cdmaSmsAddress;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean decodeDeferredDeliveryAbs(BearerData bearerData, BitwiseInputStream bitwiseInputStream) throws BitwiseInputStream.AccessException, CodingException {
        int n = 8 * bitwiseInputStream.read(8);
        boolean bl = false;
        if (n >= 48) {
            n -= 48;
            bl = true;
            bearerData.deferredDeliveryTimeAbsolute = TimeStamp.fromByteArray(bitwiseInputStream.readByteArray(48));
        }
        if (!bl || n > 0) {
            StringBuilder stringBuilder = new StringBuilder().append("DEFERRED_DELIVERY_TIME_ABSOLUTE decode ");
            String string2 = bl ? "succeeded" : "failed";
            Log.d(LOG_TAG, stringBuilder.append(string2).append(" (extra bits = ").append(n).append(")").toString());
        }
        bitwiseInputStream.skip(n);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean decodeDeferredDeliveryRel(BearerData bearerData, BitwiseInputStream bitwiseInputStream) throws BitwiseInputStream.AccessException, CodingException {
        int n = 8 * bitwiseInputStream.read(8);
        boolean bl = false;
        if (n >= 8) {
            n -= 8;
            bl = true;
            bearerData.validityPeriodRelative = bitwiseInputStream.read(8);
        }
        if (!bl || n > 0) {
            StringBuilder stringBuilder = new StringBuilder().append("DEFERRED_DELIVERY_TIME_RELATIVE decode ");
            String string2 = bl ? "succeeded" : "failed";
            Log.d(LOG_TAG, stringBuilder.append(string2).append(" (extra bits = ").append(n).append(")").toString());
        }
        bitwiseInputStream.skip(n);
        bearerData.validityPeriodRelativeSet = bl;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean decodeDepositIndex(BearerData bearerData, BitwiseInputStream bitwiseInputStream) throws BitwiseInputStream.AccessException, CodingException {
        int n = 8 * bitwiseInputStream.read(8);
        boolean bl = false;
        if (n >= 16) {
            n -= 16;
            bl = true;
            bearerData.depositIndex = bitwiseInputStream.read(8) << 8 | bitwiseInputStream.read(8);
        }
        if (!bl || n > 0) {
            StringBuilder stringBuilder = new StringBuilder().append("MESSAGE_DEPOSIT_INDEX decode ");
            String string2 = bl ? "succeeded" : "failed";
            Log.d(LOG_TAG, stringBuilder.append(string2).append(" (extra bits = ").append(n).append(")").toString());
        }
        bitwiseInputStream.skip(n);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean decodeDisplayMode(BearerData bearerData, BitwiseInputStream bitwiseInputStream) throws BitwiseInputStream.AccessException, CodingException {
        int n = 8 * bitwiseInputStream.read(8);
        boolean bl = false;
        if (n >= 8) {
            n -= 8;
            bl = true;
            bearerData.displayMode = bitwiseInputStream.read(2);
            bitwiseInputStream.skip(6);
        }
        if (!bl || n > 0) {
            StringBuilder stringBuilder = new StringBuilder().append("DISPLAY_MODE decode ");
            String string2 = bl ? "succeeded" : "failed";
            Log.d(LOG_TAG, stringBuilder.append(string2).append(" (extra bits = ").append(n).append(")").toString());
        }
        bitwiseInputStream.skip(n);
        bearerData.displayModeSet = bl;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String decodeDtmfSmsAddress(byte[] byArray, int n) throws CodingException {
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0xF & byArray[n2 / 2] >>> 4 - 4 * (n2 % 2);
            if (n3 >= 1 && n3 <= 9) {
                stringBuffer.append(Integer.toString(n3, 10));
            } else if (n3 == 10) {
                stringBuffer.append('0');
            } else if (n3 == 11) {
                stringBuffer.append('*');
            } else {
                if (n3 != 12) {
                    throw new CodingException("invalid SMS address DTMF code (" + n3 + ")");
                }
                stringBuffer.append('#');
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static void decodeIs91(BearerData bearerData) throws BitwiseInputStream.AccessException, CodingException {
        switch (bearerData.userData.msgType) {
            default: {
                throw new CodingException("unsupported IS-91 message type (" + bearerData.userData.msgType + ")");
            }
            case 130: {
                BearerData.decodeIs91VoicemailStatus(bearerData);
                return;
            }
            case 132: {
                BearerData.decodeIs91Cli(bearerData);
                return;
            }
            case 131: 
            case 133: 
        }
        BearerData.decodeIs91ShortMessage(bearerData);
    }

    private static void decodeIs91Cli(BearerData bearerData) throws CodingException {
        int n = new BitwiseInputStream(bearerData.userData.payload).available() / 4;
        int n2 = bearerData.userData.numFields;
        if (n > 14 || n < 3 || n < n2) {
            throw new CodingException("IS-91 voicemail status decoding failed");
        }
        CdmaSmsAddress cdmaSmsAddress = new CdmaSmsAddress();
        cdmaSmsAddress.digitMode = 0;
        cdmaSmsAddress.origBytes = bearerData.userData.payload;
        cdmaSmsAddress.numberOfDigits = (byte)n2;
        BearerData.decodeSmsAddress(cdmaSmsAddress);
        bearerData.callbackNumber = cdmaSmsAddress;
    }

    private static void decodeIs91ShortMessage(BearerData bearerData) throws BitwiseInputStream.AccessException, CodingException {
        BitwiseInputStream bitwiseInputStream = new BitwiseInputStream(bearerData.userData.payload);
        int n = bitwiseInputStream.available() / 6;
        int n2 = bearerData.userData.numFields;
        if (n > 14 || n < n2) {
            throw new CodingException("IS-91 voicemail status decoding failed");
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(UserData.ASCII_MAP[bitwiseInputStream.read(6)]);
        }
        bearerData.userData.payloadStr = stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void decodeIs91VoicemailStatus(BearerData bearerData) throws BitwiseInputStream.AccessException, CodingException {
        BitwiseInputStream bitwiseInputStream = new BitwiseInputStream(bearerData.userData.payload);
        int n = bitwiseInputStream.available() / 6;
        int n2 = bearerData.userData.numFields;
        if (n > 14 || n < 3 || n < n2) {
            throw new CodingException("IS-91 voicemail status decoding failed");
        }
        try {
            char c;
            block12: {
                String string2;
                block11: {
                    block10: {
                        StringBuffer stringBuffer = new StringBuffer(n);
                        while (bitwiseInputStream.available() >= 6) {
                            stringBuffer.append(UserData.ASCII_MAP[bitwiseInputStream.read(6)]);
                        }
                        string2 = stringBuffer.toString();
                        bearerData.numberOfMessages = Integer.parseInt(string2.substring(0, 2));
                        c = string2.charAt(2);
                        if (c != ' ') break block10;
                        bearerData.priority = 0;
                        break block11;
                    }
                    if (c != '!') break block12;
                    bearerData.priority = 2;
                }
                bearerData.priorityIndicatorSet = true;
                bearerData.userData.payloadStr = string2.substring(3, n2 - 3);
                return;
            }
            throw new CodingException("IS-91 voicemail status decoding failed: illegal priority setting (" + c + ")");
        }
        catch (NumberFormatException numberFormatException) {
            throw new CodingException("IS-91 voicemail status decoding failed: " + numberFormatException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new CodingException("IS-91 voicemail status decoding failed: " + indexOutOfBoundsException);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean decodeLanguageIndicator(BearerData bearerData, BitwiseInputStream bitwiseInputStream) throws BitwiseInputStream.AccessException, CodingException {
        int n = 8 * bitwiseInputStream.read(8);
        boolean bl = false;
        if (n >= 8) {
            n -= 8;
            bl = true;
            bearerData.language = bitwiseInputStream.read(8);
        }
        if (!bl || n > 0) {
            StringBuilder stringBuilder = new StringBuilder().append("LANGUAGE_INDICATOR decode ");
            String string2 = bl ? "succeeded" : "failed";
            Log.d(LOG_TAG, stringBuilder.append(string2).append(" (extra bits = ").append(n).append(")").toString());
        }
        bitwiseInputStream.skip(n);
        bearerData.languageIndicatorSet = bl;
        return bl;
    }

    private static String decodeLatin(byte[] byArray, int n, int n2) throws CodingException {
        try {
            String string2 = new String(byArray, n, n2 - n, "ISO-8859-1");
            return string2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CodingException("ISO-8859-1 decode failed: " + unsupportedEncodingException);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean decodeMessageId(BearerData bearerData, BitwiseInputStream bitwiseInputStream) throws BitwiseInputStream.AccessException, CodingException {
        int n = 8 * bitwiseInputStream.read(8);
        boolean bl = false;
        if (n >= 24) {
            n -= 24;
            bl = true;
            bearerData.messageType = bitwiseInputStream.read(4);
            bearerData.messageId = bitwiseInputStream.read(8) << 8;
            bearerData.messageId |= bitwiseInputStream.read(8);
            boolean bl2 = bitwiseInputStream.read(1) == 1;
            bearerData.hasUserDataHeader = bl2;
            bitwiseInputStream.skip(3);
        }
        if (!bl || n > 0) {
            StringBuilder stringBuilder = new StringBuilder().append("MESSAGE_IDENTIFIER decode ");
            String string2 = bl ? "succeeded" : "failed";
            Log.d(LOG_TAG, stringBuilder.append(string2).append(" (extra bits = ").append(n).append(")").toString());
        }
        bitwiseInputStream.skip(n);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean decodeMsgCenterTimeStamp(BearerData bearerData, BitwiseInputStream bitwiseInputStream) throws BitwiseInputStream.AccessException, CodingException {
        int n = 8 * bitwiseInputStream.read(8);
        boolean bl = false;
        if (n >= 48) {
            n -= 48;
            bl = true;
            bearerData.msgCenterTimeStamp = TimeStamp.fromByteArray(bitwiseInputStream.readByteArray(48));
        }
        if (!bl || n > 0) {
            StringBuilder stringBuilder = new StringBuilder().append("MESSAGE_CENTER_TIME_STAMP decode ");
            String string2 = bl ? "succeeded" : "failed";
            Log.d(LOG_TAG, stringBuilder.append(string2).append(" (extra bits = ").append(n).append(")").toString());
        }
        bitwiseInputStream.skip(n);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean decodeMsgCount(BearerData bearerData, BitwiseInputStream bitwiseInputStream) throws BitwiseInputStream.AccessException, CodingException {
        int n = 8 * bitwiseInputStream.read(8);
        boolean bl = false;
        if (n >= 8) {
            n -= 8;
            bl = true;
            bearerData.numberOfMessages = IccUtils.cdmaBcdByteToInt((byte)bitwiseInputStream.read(8));
        }
        if (!bl || n > 0) {
            StringBuilder stringBuilder = new StringBuilder().append("NUMBER_OF_MESSAGES decode ");
            String string2 = bl ? "succeeded" : "failed";
            Log.d(LOG_TAG, stringBuilder.append(string2).append(" (extra bits = ").append(n).append(")").toString());
        }
        bitwiseInputStream.skip(n);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean decodeMsgDeliveryAlert(BearerData bearerData, BitwiseInputStream bitwiseInputStream) throws BitwiseInputStream.AccessException, CodingException {
        int n = 8 * bitwiseInputStream.read(8);
        boolean bl = false;
        if (n >= 8) {
            n -= 8;
            bl = true;
            bearerData.alert = bitwiseInputStream.read(2);
            bitwiseInputStream.skip(6);
        }
        if (!bl || n > 0) {
            StringBuilder stringBuilder = new StringBuilder().append("ALERT_ON_MESSAGE_DELIVERY decode ");
            String string2 = bl ? "succeeded" : "failed";
            Log.d(LOG_TAG, stringBuilder.append(string2).append(" (extra bits = ").append(n).append(")").toString());
        }
        bitwiseInputStream.skip(n);
        bearerData.alertIndicatorSet = bl;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean decodeMsgStatus(BearerData bearerData, BitwiseInputStream bitwiseInputStream) throws BitwiseInputStream.AccessException, CodingException {
        int n = 8 * bitwiseInputStream.read(8);
        boolean bl = false;
        if (n >= 8) {
            n -= 8;
            bl = true;
            bearerData.errorClass = bitwiseInputStream.read(2);
            bearerData.messageStatus = bitwiseInputStream.read(6);
        }
        if (!bl || n > 0) {
            StringBuilder stringBuilder = new StringBuilder().append("MESSAGE_STATUS decode ");
            String string2 = bl ? "succeeded" : "failed";
            Log.d(LOG_TAG, stringBuilder.append(string2).append(" (extra bits = ").append(n).append(")").toString());
        }
        bitwiseInputStream.skip(n);
        bearerData.messageStatusSet = bl;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean decodePriorityIndicator(BearerData bearerData, BitwiseInputStream bitwiseInputStream) throws BitwiseInputStream.AccessException, CodingException {
        int n = 8 * bitwiseInputStream.read(8);
        boolean bl = false;
        if (n >= 8) {
            n -= 8;
            bl = true;
            bearerData.priority = bitwiseInputStream.read(2);
            bitwiseInputStream.skip(6);
        }
        if (!bl || n > 0) {
            StringBuilder stringBuilder = new StringBuilder().append("PRIORITY_INDICATOR decode ");
            String string2 = bl ? "succeeded" : "failed";
            Log.d(LOG_TAG, stringBuilder.append(string2).append(" (extra bits = ").append(n).append(")").toString());
        }
        bitwiseInputStream.skip(n);
        bearerData.priorityIndicatorSet = bl;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean decodePrivacyIndicator(BearerData bearerData, BitwiseInputStream bitwiseInputStream) throws BitwiseInputStream.AccessException, CodingException {
        int n = 8 * bitwiseInputStream.read(8);
        boolean bl = false;
        if (n >= 8) {
            n -= 8;
            bl = true;
            bearerData.privacy = bitwiseInputStream.read(2);
            bitwiseInputStream.skip(6);
        }
        if (!bl || n > 0) {
            StringBuilder stringBuilder = new StringBuilder().append("PRIVACY_INDICATOR decode ");
            String string2 = bl ? "succeeded" : "failed";
            Log.d(LOG_TAG, stringBuilder.append(string2).append(" (extra bits = ").append(n).append(")").toString());
        }
        bitwiseInputStream.skip(n);
        bearerData.privacyIndicatorSet = bl;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean decodeReplyOption(BearerData bearerData, BitwiseInputStream bitwiseInputStream) throws BitwiseInputStream.AccessException, CodingException {
        int n = 8 * bitwiseInputStream.read(8);
        boolean bl = false;
        if (n >= 8) {
            n -= 8;
            bl = true;
            boolean bl2 = bitwiseInputStream.read(1) == 1;
            bearerData.userAckReq = bl2;
            boolean bl3 = bitwiseInputStream.read(1) == 1;
            bearerData.deliveryAckReq = bl3;
            boolean bl4 = bitwiseInputStream.read(1) == 1;
            bearerData.readAckReq = bl4;
            boolean bl5 = bitwiseInputStream.read(1) == 1;
            bearerData.reportReq = bl5;
            bitwiseInputStream.skip(4);
        }
        if (!bl || n > 0) {
            StringBuilder stringBuilder = new StringBuilder().append("REPLY_OPTION decode ");
            String string2 = bl ? "succeeded" : "failed";
            Log.d(LOG_TAG, stringBuilder.append(string2).append(" (extra bits = ").append(n).append(")").toString());
        }
        bitwiseInputStream.skip(n);
        return bl;
    }

    private static void decodeSmsAddress(CdmaSmsAddress cdmaSmsAddress) throws CodingException {
        if (cdmaSmsAddress.digitMode == 1) {
            try {
                cdmaSmsAddress.address = new String(cdmaSmsAddress.origBytes, 0, cdmaSmsAddress.origBytes.length, "US-ASCII");
                return;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new CodingException("invalid SMS address ASCII code");
            }
        }
        cdmaSmsAddress.address = BearerData.decodeDtmfSmsAddress(cdmaSmsAddress.origBytes, cdmaSmsAddress.numberOfDigits);
    }

    private static boolean decodeUserData(BearerData bearerData, BitwiseInputStream bitwiseInputStream) throws BitwiseInputStream.AccessException {
        int n = 8 * bitwiseInputStream.read(8);
        bearerData.userData = new UserData();
        bearerData.userData.msgEncoding = bitwiseInputStream.read(5);
        bearerData.userData.msgEncodingSet = true;
        bearerData.userData.msgType = 0;
        int n2 = 5;
        if (bearerData.userData.msgEncoding == 1 || bearerData.userData.msgEncoding == 10) {
            bearerData.userData.msgType = bitwiseInputStream.read(8);
            n2 += 8;
        }
        bearerData.userData.numFields = bitwiseInputStream.read(8);
        int n3 = n - (n2 + 8);
        bearerData.userData.payload = bitwiseInputStream.readByteArray(n3);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void decodeUserDataPayload(UserData userData, boolean bl) throws CodingException {
        int n = 0;
        if (bl) {
            int n2 = 0xFF & userData.payload[0];
            n = 0 + (n2 + 1);
            byte[] byArray = new byte[n2];
            System.arraycopy(userData.payload, 1, byArray, 0, n2);
            userData.userDataHeader = SmsHeader.fromByteArray(byArray);
        }
        switch (userData.msgEncoding) {
            default: {
                throw new CodingException("unsupported user data encoding (" + userData.msgEncoding + ")");
            }
            case 0: {
                byte[] byArray = new byte[userData.numFields];
                int n3 = userData.numFields < userData.payload.length ? userData.numFields : userData.payload.length;
                System.arraycopy(userData.payload, 0, byArray, 0, n3);
                userData.payload = byArray;
                userData.payloadStr = BearerData.decodeLatin(userData.payload, n, userData.numFields);
                return;
            }
            case 2: 
            case 3: {
                userData.payloadStr = BearerData.decode7bitAscii(userData.payload, n, userData.numFields);
                return;
            }
            case 4: {
                userData.payloadStr = BearerData.decodeUtf16(userData.payload, n, userData.numFields);
                return;
            }
            case 9: {
                userData.payloadStr = BearerData.decode7bitGsm(userData.payload, n, userData.numFields);
                return;
            }
            case 8: 
        }
        userData.payloadStr = BearerData.decodeLatin(userData.payload, n, userData.numFields);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean decodeUserResponseCode(BearerData bearerData, BitwiseInputStream bitwiseInputStream) throws BitwiseInputStream.AccessException, CodingException {
        int n = 8 * bitwiseInputStream.read(8);
        boolean bl = false;
        if (n >= 8) {
            n -= 8;
            bl = true;
            bearerData.userResponseCode = bitwiseInputStream.read(8);
        }
        if (!bl || n > 0) {
            StringBuilder stringBuilder = new StringBuilder().append("USER_REPONSE_CODE decode ");
            String string2 = bl ? "succeeded" : "failed";
            Log.d(LOG_TAG, stringBuilder.append(string2).append(" (extra bits = ").append(n).append(")").toString());
        }
        bitwiseInputStream.skip(n);
        bearerData.userResponseCodeSet = bl;
        return bl;
    }

    private static String decodeUtf16(byte[] byArray, int n, int n2) throws CodingException {
        int n3 = n2 - (n + n % 2) / 2;
        try {
            String string2 = new String(byArray, n, n3 * 2, "utf-16be");
            return string2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CodingException("UTF-16 decode failed: " + unsupportedEncodingException);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean decodeValidityAbs(BearerData bearerData, BitwiseInputStream bitwiseInputStream) throws BitwiseInputStream.AccessException, CodingException {
        int n = 8 * bitwiseInputStream.read(8);
        boolean bl = false;
        if (n >= 48) {
            n -= 48;
            bl = true;
            bearerData.validityPeriodAbsolute = TimeStamp.fromByteArray(bitwiseInputStream.readByteArray(48));
        }
        if (!bl || n > 0) {
            StringBuilder stringBuilder = new StringBuilder().append("VALIDITY_PERIOD_ABSOLUTE decode ");
            String string2 = bl ? "succeeded" : "failed";
            Log.d(LOG_TAG, stringBuilder.append(string2).append(" (extra bits = ").append(n).append(")").toString());
        }
        bitwiseInputStream.skip(n);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean decodeValidityRel(BearerData bearerData, BitwiseInputStream bitwiseInputStream) throws BitwiseInputStream.AccessException, CodingException {
        int n = 8 * bitwiseInputStream.read(8);
        boolean bl = false;
        if (n >= 8) {
            n -= 8;
            bl = true;
            bearerData.deferredDeliveryTimeRelative = bitwiseInputStream.read(8);
        }
        if (!bl || n > 0) {
            StringBuilder stringBuilder = new StringBuilder().append("VALIDITY_PERIOD_RELATIVE decode ");
            String string2 = bl ? "succeeded" : "failed";
            Log.d(LOG_TAG, stringBuilder.append(string2).append(" (extra bits = ").append(n).append(")").toString());
        }
        bitwiseInputStream.skip(n);
        bearerData.deferredDeliveryTimeRelativeSet = bl;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] encode(BearerData bearerData) {
        boolean bl = bearerData.userData != null && bearerData.userData.userDataHeader != null;
        bearerData.hasUserDataHeader = bl;
        try {
            BitwiseOutputStream bitwiseOutputStream = new BitwiseOutputStream(200);
            bitwiseOutputStream.write(8, 0);
            BearerData.encodeMessageId(bearerData, bitwiseOutputStream);
            if (bearerData.userData != null) {
                bitwiseOutputStream.write(8, 1);
                BearerData.encodeUserData(bearerData, bitwiseOutputStream);
            }
            if (bearerData.callbackNumber != null) {
                bitwiseOutputStream.write(8, 14);
                BearerData.encodeCallbackNumber(bearerData, bitwiseOutputStream);
            }
            if (bearerData.userAckReq || bearerData.deliveryAckReq || bearerData.readAckReq || bearerData.reportReq) {
                bitwiseOutputStream.write(8, 10);
                BearerData.encodeReplyOption(bearerData, bitwiseOutputStream);
            }
            if (bearerData.numberOfMessages != 0) {
                bitwiseOutputStream.write(8, 11);
                BearerData.encodeMsgCount(bearerData, bitwiseOutputStream);
            }
            if (bearerData.validityPeriodRelativeSet) {
                bitwiseOutputStream.write(8, 5);
                BearerData.encodeValidityPeriodRel(bearerData, bitwiseOutputStream);
            }
            if (bearerData.privacyIndicatorSet) {
                bitwiseOutputStream.write(8, 9);
                BearerData.encodePrivacyIndicator(bearerData, bitwiseOutputStream);
            }
            if (bearerData.languageIndicatorSet) {
                bitwiseOutputStream.write(8, 13);
                BearerData.encodeLanguageIndicator(bearerData, bitwiseOutputStream);
            }
            if (bearerData.displayModeSet) {
                bitwiseOutputStream.write(8, 15);
                BearerData.encodeDisplayMode(bearerData, bitwiseOutputStream);
            }
            if (bearerData.priorityIndicatorSet) {
                bitwiseOutputStream.write(8, 8);
                BearerData.encodePriorityIndicator(bearerData, bitwiseOutputStream);
            }
            if (bearerData.alertIndicatorSet) {
                bitwiseOutputStream.write(8, 12);
                BearerData.encodeMsgDeliveryAlert(bearerData, bitwiseOutputStream);
            }
            if (!bearerData.messageStatusSet) return bitwiseOutputStream.toByteArray();
            bitwiseOutputStream.write(8, 20);
            BearerData.encodeMsgStatus(bearerData, bitwiseOutputStream);
            return bitwiseOutputStream.toByteArray();
        }
        catch (BitwiseOutputStream.AccessException accessException) {
            Log.e(LOG_TAG, "BearerData encode failed: " + accessException);
            return null;
        }
        catch (CodingException codingException) {
            Log.e(LOG_TAG, "BearerData encode failed: " + codingException);
            return null;
        }
    }

    private static void encode16bitEms(UserData userData, byte[] byArray) throws CodingException {
        byte[] byArray2 = BearerData.encodeUtf16(userData.payloadStr);
        int n = 1 + byArray.length;
        int n2 = (n + 1) / 2;
        int n3 = n % 2;
        int n4 = byArray2.length / 2;
        userData.msgEncoding = 4;
        userData.msgEncodingSet = true;
        userData.numFields = n2 + n4;
        userData.payload = new byte[2 * userData.numFields];
        userData.payload[0] = (byte)byArray.length;
        System.arraycopy(byArray, 0, userData.payload, 1, byArray.length);
        System.arraycopy(byArray2, 0, userData.payload, n + n3, byArray2.length);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] encode7bitAscii(String var0, boolean var1_1) throws CodingException {
        block6: {
            try {
                var2_2 = new BitwiseOutputStream(var0.length());
                var4_3 = var0.length();
                var5_4 = 0;
lbl5:
                // 2 sources

                while (true) {
                    if (var5_4 >= var4_3) return var2_2.toByteArray();
                    var6_5 = UserData.charToAscii.get(var0.charAt(var5_4), -1);
                    if (var6_5 == -1) {
                        if (!var1_1) {
                            throw new CodingException("cannot ASCII encode (" + var0.charAt(var5_4) + ")");
                        }
                        var2_2.write(7, 32);
                        break block6;
                    }
                    break;
                }
            }
            catch (BitwiseOutputStream.AccessException var3_6) {
                throw new CodingException("7bit ASCII encode failed: " + var3_6);
            }
            {
                var2_2.write(7, var6_5);
            }
        }
        ++var5_4;
        ** while (true)
    }

    private static void encode7bitEms(UserData userData, byte[] byArray, boolean bl) throws CodingException {
        int n = (6 + 8 * (1 + byArray.length)) / 7;
        Gsm7bitCodingResult gsm7bitCodingResult = BearerData.encode7bitGsm(userData.payloadStr, n, bl);
        userData.msgEncoding = 9;
        userData.msgEncodingSet = true;
        userData.numFields = gsm7bitCodingResult.septets;
        userData.payload = gsm7bitCodingResult.data;
        userData.payload[0] = (byte)byArray.length;
        System.arraycopy(byArray, 0, userData.payload, 1, byArray.length);
    }

    private static Gsm7bitCodingResult encode7bitGsm(String string2, int n, boolean bl) throws CodingException {
        boolean bl2 = false;
        if (!bl) {
            bl2 = true;
        }
        try {
            byte[] byArray = GsmAlphabet.stringToGsm7BitPacked(string2, n, bl2);
            Gsm7bitCodingResult gsm7bitCodingResult = new Gsm7bitCodingResult();
            gsm7bitCodingResult.data = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, gsm7bitCodingResult.data, 0, byArray.length - 1);
            gsm7bitCodingResult.septets = 0xFF & byArray[0];
            return gsm7bitCodingResult;
        }
        catch (EncodeException encodeException) {
            throw new CodingException("7bit GSM encode failed: " + encodeException);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void encodeCallbackNumber(BearerData bearerData, BitwiseOutputStream bitwiseOutputStream) throws BitwiseOutputStream.AccessException, CodingException {
        int n;
        CdmaSmsAddress cdmaSmsAddress = bearerData.callbackNumber;
        BearerData.encodeCdmaSmsAddress(cdmaSmsAddress);
        int n2 = 9;
        if (cdmaSmsAddress.digitMode == 1) {
            n2 += 7;
            n = 8 * cdmaSmsAddress.numberOfDigits;
        } else {
            n = 4 * cdmaSmsAddress.numberOfDigits;
        }
        int n3 = n2 + n;
        int n4 = n3 / 8;
        int n5 = n3 % 8 > 0 ? 1 : 0;
        int n6 = n4 + n5;
        int n7 = n6 * 8 - n3;
        bitwiseOutputStream.write(8, n6);
        bitwiseOutputStream.write(1, cdmaSmsAddress.digitMode);
        if (cdmaSmsAddress.digitMode == 1) {
            bitwiseOutputStream.write(3, cdmaSmsAddress.ton);
            bitwiseOutputStream.write(4, cdmaSmsAddress.numberPlan);
        }
        bitwiseOutputStream.write(8, cdmaSmsAddress.numberOfDigits);
        bitwiseOutputStream.writeByteArray(n, cdmaSmsAddress.origBytes);
        if (n7 > 0) {
            bitwiseOutputStream.write(n7, 0);
        }
    }

    private static void encodeCdmaSmsAddress(CdmaSmsAddress cdmaSmsAddress) throws CodingException {
        if (cdmaSmsAddress.digitMode == 1) {
            try {
                cdmaSmsAddress.origBytes = cdmaSmsAddress.address.getBytes("US-ASCII");
                return;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new CodingException("invalid SMS address, cannot convert to ASCII");
            }
        }
        cdmaSmsAddress.origBytes = BearerData.encodeDtmfSmsAddress(cdmaSmsAddress.address);
    }

    private static void encodeDisplayMode(BearerData bearerData, BitwiseOutputStream bitwiseOutputStream) throws BitwiseOutputStream.AccessException {
        bitwiseOutputStream.write(8, 1);
        bitwiseOutputStream.write(2, bearerData.displayMode);
        bitwiseOutputStream.skip(6);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static byte[] encodeDtmfSmsAddress(String string2) {
        int n = string2.length();
        int n2 = n * 4;
        int n3 = n2 / 8;
        int n4 = n2 % 8 > 0 ? 1 : 0;
        byte[] byArray = new byte[n3 + n4];
        int n5 = 0;
        while (n5 < n) {
            int n6;
            char c = string2.charAt(n5);
            if (c >= '1' && c <= '9') {
                n6 = c - 48;
            } else if (c == '0') {
                n6 = 10;
            } else if (c == '*') {
                n6 = 11;
            } else {
                if (c != '#') {
                    return null;
                }
                n6 = 12;
            }
            int n7 = n5 / 2;
            byArray[n7] = (byte)(byArray[n7] | n6 << 4 - 4 * (n5 % 2));
            ++n5;
        }
        return byArray;
    }

    private static void encodeEmsUserDataPayload(UserData userData) throws CodingException {
        byte[] byArray = SmsHeader.toByteArray(userData.userDataHeader);
        if (userData.msgEncodingSet) {
            if (userData.msgEncoding == 9) {
                BearerData.encode7bitEms(userData, byArray, true);
                return;
            }
            if (userData.msgEncoding == 4) {
                BearerData.encode16bitEms(userData, byArray);
                return;
            }
            throw new CodingException("unsupported EMS user data encoding (" + userData.msgEncoding + ")");
        }
        try {
            BearerData.encode7bitEms(userData, byArray, false);
            return;
        }
        catch (CodingException codingException) {
            BearerData.encode16bitEms(userData, byArray);
            return;
        }
    }

    private static void encodeLanguageIndicator(BearerData bearerData, BitwiseOutputStream bitwiseOutputStream) throws BitwiseOutputStream.AccessException {
        bitwiseOutputStream.write(8, 1);
        bitwiseOutputStream.write(8, bearerData.language);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void encodeMessageId(BearerData bearerData, BitwiseOutputStream bitwiseOutputStream) throws BitwiseOutputStream.AccessException {
        bitwiseOutputStream.write(8, 3);
        bitwiseOutputStream.write(4, bearerData.messageType);
        bitwiseOutputStream.write(8, bearerData.messageId >> 8);
        bitwiseOutputStream.write(8, bearerData.messageId);
        int n = bearerData.hasUserDataHeader ? 1 : 0;
        bitwiseOutputStream.write(1, n);
        bitwiseOutputStream.skip(3);
    }

    private static void encodeMsgCount(BearerData bearerData, BitwiseOutputStream bitwiseOutputStream) throws BitwiseOutputStream.AccessException {
        bitwiseOutputStream.write(8, 1);
        bitwiseOutputStream.write(8, bearerData.numberOfMessages);
    }

    private static void encodeMsgDeliveryAlert(BearerData bearerData, BitwiseOutputStream bitwiseOutputStream) throws BitwiseOutputStream.AccessException {
        bitwiseOutputStream.write(8, 1);
        bitwiseOutputStream.write(2, bearerData.alert);
        bitwiseOutputStream.skip(6);
    }

    private static void encodeMsgStatus(BearerData bearerData, BitwiseOutputStream bitwiseOutputStream) throws BitwiseOutputStream.AccessException {
        bitwiseOutputStream.write(8, 1);
        bitwiseOutputStream.write(2, bearerData.errorClass);
        bitwiseOutputStream.write(6, bearerData.messageStatus);
    }

    private static void encodePriorityIndicator(BearerData bearerData, BitwiseOutputStream bitwiseOutputStream) throws BitwiseOutputStream.AccessException {
        bitwiseOutputStream.write(8, 1);
        bitwiseOutputStream.write(2, bearerData.priority);
        bitwiseOutputStream.skip(6);
    }

    private static void encodePrivacyIndicator(BearerData bearerData, BitwiseOutputStream bitwiseOutputStream) throws BitwiseOutputStream.AccessException {
        bitwiseOutputStream.write(8, 1);
        bitwiseOutputStream.write(2, bearerData.privacy);
        bitwiseOutputStream.skip(6);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void encodeReplyOption(BearerData bearerData, BitwiseOutputStream bitwiseOutputStream) throws BitwiseOutputStream.AccessException {
        bitwiseOutputStream.write(8, 1);
        int n = bearerData.userAckReq ? 1 : 0;
        bitwiseOutputStream.write(1, n);
        int n2 = bearerData.deliveryAckReq ? 1 : 0;
        bitwiseOutputStream.write(1, n2);
        int n3 = bearerData.readAckReq ? 1 : 0;
        bitwiseOutputStream.write(1, n3);
        int n4 = bearerData.reportReq ? 1 : 0;
        bitwiseOutputStream.write(1, n4);
        bitwiseOutputStream.write(4, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void encodeUserData(BearerData bearerData, BitwiseOutputStream bitwiseOutputStream) throws BitwiseOutputStream.AccessException, CodingException {
        BearerData.encodeUserDataPayload(bearerData.userData);
        boolean bl = bearerData.userData.userDataHeader != null;
        bearerData.hasUserDataHeader = bl;
        if (bearerData.userData.payload.length > 140) {
            throw new CodingException("encoded user data too large (" + bearerData.userData.payload.length + " > " + 140 + " bytes)");
        }
        int n = 8 * bearerData.userData.payload.length - bearerData.userData.paddingBits;
        int n2 = n + 13;
        if (bearerData.userData.msgEncoding == 1 || bearerData.userData.msgEncoding == 10) {
            n2 += 8;
        }
        int n3 = n2 / 8;
        int n4 = n2 % 8 > 0 ? 1 : 0;
        int n5 = n3 + n4;
        int n6 = n5 * 8 - n2;
        bitwiseOutputStream.write(8, n5);
        bitwiseOutputStream.write(5, bearerData.userData.msgEncoding);
        if (bearerData.userData.msgEncoding == 1 || bearerData.userData.msgEncoding == 10) {
            bitwiseOutputStream.write(8, bearerData.userData.msgType);
        }
        bitwiseOutputStream.write(8, bearerData.userData.numFields);
        bitwiseOutputStream.writeByteArray(n, bearerData.userData.payload);
        if (n6 > 0) {
            bitwiseOutputStream.write(n6, 0);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void encodeUserDataPayload(UserData userData) throws CodingException {
        if (userData.payloadStr == null && userData.msgEncoding != 0) {
            Log.e(LOG_TAG, "user data with null payloadStr");
            userData.payloadStr = "";
        }
        if (userData.userDataHeader != null) {
            BearerData.encodeEmsUserDataPayload(userData);
            return;
        }
        if (userData.msgEncodingSet) {
            if (userData.msgEncoding == 0) {
                if (userData.payload == null) {
                    Log.e(LOG_TAG, "user data with octet encoding but null payload");
                    userData.payload = new byte[0];
                    userData.numFields = 0;
                    return;
                }
                userData.payload = userData.payload;
                userData.numFields = userData.payload.length;
                return;
            }
            if (userData.payloadStr == null) {
                Log.e(LOG_TAG, "non-octet user data with null payloadStr");
                userData.payloadStr = "";
            }
            if (userData.msgEncoding == 9) {
                Gsm7bitCodingResult gsm7bitCodingResult = BearerData.encode7bitGsm(userData.payloadStr, 0, true);
                userData.payload = gsm7bitCodingResult.data;
                userData.numFields = gsm7bitCodingResult.septets;
                return;
            }
            if (userData.msgEncoding == 2) {
                userData.payload = BearerData.encode7bitAscii(userData.payloadStr, true);
                userData.numFields = userData.payloadStr.length();
                return;
            }
            if (userData.msgEncoding == 4) {
                userData.payload = BearerData.encodeUtf16(userData.payloadStr);
                userData.numFields = userData.payloadStr.length();
                return;
            }
            throw new CodingException("unsupported user data encoding (" + userData.msgEncoding + ")");
        }
        try {
            userData.payload = BearerData.encode7bitAscii(userData.payloadStr, false);
            userData.msgEncoding = 2;
        }
        catch (CodingException codingException) {
            userData.payload = BearerData.encodeUtf16(userData.payloadStr);
            userData.msgEncoding = 4;
        }
        userData.numFields = userData.payloadStr.length();
        userData.msgEncodingSet = true;
    }

    private static byte[] encodeUtf16(String string2) throws CodingException {
        try {
            byte[] byArray = string2.getBytes("utf-16be");
            return byArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CodingException("UTF-16 encode failed: " + unsupportedEncodingException);
        }
    }

    private static void encodeValidityPeriodRel(BearerData bearerData, BitwiseOutputStream bitwiseOutputStream) throws BitwiseOutputStream.AccessException {
        bitwiseOutputStream.write(8, 1);
        bitwiseOutputStream.write(8, bearerData.validityPeriodRelative);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("BearerData ");
        stringBuilder.append("{ messageType=" + this.messageType);
        stringBuilder.append(", messageId=" + this.messageId);
        StringBuilder stringBuilder2 = new StringBuilder().append(", priority=");
        Object object = this.priorityIndicatorSet ? Integer.valueOf(this.priority) : "unset";
        stringBuilder.append(stringBuilder2.append(object).toString());
        StringBuilder stringBuilder3 = new StringBuilder().append(", privacy=");
        Object object2 = this.privacyIndicatorSet ? Integer.valueOf(this.privacy) : "unset";
        stringBuilder.append(stringBuilder3.append(object2).toString());
        StringBuilder stringBuilder4 = new StringBuilder().append(", alert=");
        Object object3 = this.alertIndicatorSet ? Integer.valueOf(this.alert) : "unset";
        stringBuilder.append(stringBuilder4.append(object3).toString());
        StringBuilder stringBuilder5 = new StringBuilder().append(", displayMode=");
        Object object4 = this.displayModeSet ? Integer.valueOf(this.displayMode) : "unset";
        stringBuilder.append(stringBuilder5.append(object4).toString());
        StringBuilder stringBuilder6 = new StringBuilder().append(", language=");
        Object object5 = this.languageIndicatorSet ? Integer.valueOf(this.language) : "unset";
        stringBuilder.append(stringBuilder6.append(object5).toString());
        StringBuilder stringBuilder7 = new StringBuilder().append(", errorClass=");
        Object object6 = this.messageStatusSet ? Integer.valueOf(this.errorClass) : "unset";
        stringBuilder.append(stringBuilder7.append(object6).toString());
        StringBuilder stringBuilder8 = new StringBuilder().append(", msgStatus=");
        Object object7 = this.messageStatusSet ? Integer.valueOf(this.messageStatus) : "unset";
        stringBuilder.append(stringBuilder8.append(object7).toString());
        StringBuilder stringBuilder9 = new StringBuilder().append(", msgCenterTimeStamp=");
        Object object8 = this.msgCenterTimeStamp != null ? this.msgCenterTimeStamp : "unset";
        stringBuilder.append(stringBuilder9.append(object8).toString());
        StringBuilder stringBuilder10 = new StringBuilder().append(", validityPeriodAbsolute=");
        Object object9 = this.validityPeriodAbsolute != null ? this.validityPeriodAbsolute : "unset";
        stringBuilder.append(stringBuilder10.append(object9).toString());
        StringBuilder stringBuilder11 = new StringBuilder().append(", validityPeriodRelative=");
        Object object10 = this.validityPeriodRelativeSet ? Integer.valueOf(this.validityPeriodRelative) : "unset";
        stringBuilder.append(stringBuilder11.append(object10).toString());
        StringBuilder stringBuilder12 = new StringBuilder().append(", deferredDeliveryTimeAbsolute=");
        Object object11 = this.deferredDeliveryTimeAbsolute != null ? this.deferredDeliveryTimeAbsolute : "unset";
        stringBuilder.append(stringBuilder12.append(object11).toString());
        StringBuilder stringBuilder13 = new StringBuilder().append(", deferredDeliveryTimeRelative=");
        Object object12 = this.deferredDeliveryTimeRelativeSet ? Integer.valueOf(this.deferredDeliveryTimeRelative) : "unset";
        stringBuilder.append(stringBuilder13.append(object12).toString());
        stringBuilder.append(", userAckReq=" + this.userAckReq);
        stringBuilder.append(", deliveryAckReq=" + this.deliveryAckReq);
        stringBuilder.append(", readAckReq=" + this.readAckReq);
        stringBuilder.append(", reportReq=" + this.reportReq);
        stringBuilder.append(", numberOfMessages=" + this.numberOfMessages);
        stringBuilder.append(", callbackNumber=" + this.callbackNumber);
        stringBuilder.append(", depositIndex=" + this.depositIndex);
        stringBuilder.append(", hasUserDataHeader=" + this.hasUserDataHeader);
        stringBuilder.append(", userData=" + this.userData);
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }

    private static class CodingException
    extends Exception {
        public CodingException(String string2) {
            super(string2);
        }
    }

    private static class Gsm7bitCodingResult {
        byte[] data;
        int septets;

        private Gsm7bitCodingResult() {
        }
    }

    public static class TimeStamp
    extends Time {
        public TimeStamp() {
            super("UTC");
        }

        /*
         * Enabled aggressive block sorting
         */
        public static TimeStamp fromByteArray(byte[] byArray) {
            TimeStamp timeStamp = new TimeStamp();
            int n = IccUtils.cdmaBcdByteToInt(byArray[0]);
            if (n > 99 || n < 0) {
                return null;
            }
            int n2 = n >= 96 ? n + 1900 : n + 2000;
            timeStamp.year = n2;
            int n3 = IccUtils.cdmaBcdByteToInt(byArray[1]);
            if (n3 < 1 || n3 > 12) {
                return null;
            }
            timeStamp.month = n3 - 1;
            int n4 = IccUtils.cdmaBcdByteToInt(byArray[2]);
            if (n4 < 1 || n4 > 31) {
                return null;
            }
            timeStamp.monthDay = n4;
            int n5 = IccUtils.cdmaBcdByteToInt(byArray[3]);
            if (n5 < 0 || n5 > 23) {
                return null;
            }
            timeStamp.hour = n5;
            int n6 = IccUtils.cdmaBcdByteToInt(byArray[4]);
            if (n6 < 0 || n6 > 59) {
                return null;
            }
            timeStamp.minute = n6;
            int n7 = IccUtils.cdmaBcdByteToInt(byArray[5]);
            if (n7 >= 0 && n7 <= 59) {
                timeStamp.second = n7;
                return timeStamp;
            }
            return null;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("TimeStamp ");
            stringBuilder.append("{ year=" + this.year);
            stringBuilder.append(", month=" + this.month);
            stringBuilder.append(", day=" + this.monthDay);
            stringBuilder.append(", hour=" + this.hour);
            stringBuilder.append(", minute=" + this.minute);
            stringBuilder.append(", second=" + this.second);
            stringBuilder.append(" }");
            return stringBuilder.toString();
        }
    }
}

