/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma.sms;

import android.util.SparseBooleanArray;
import com.android.internal.telephony.SmsAddress;
import com.android.internal.telephony.cdma.sms.UserData;
import com.android.internal.util.HexDump;

public class CdmaSmsAddress
extends SmsAddress {
    public static final int DIGIT_MODE_4BIT_DTMF = 0;
    public static final int DIGIT_MODE_8BIT_CHAR = 1;
    public static final int NUMBERING_PLAN_ISDN_TELEPHONY = 1;
    public static final int NUMBERING_PLAN_UNKNOWN = 0;
    public static final int NUMBER_MODE_DATA_NETWORK = 1;
    public static final int NUMBER_MODE_NOT_DATA_NETWORK = 0;
    public static final int SMS_ADDRESS_MAX = 36;
    public static final int SMS_SUBADDRESS_MAX = 36;
    public static final int TON_ABBREVIATED = 6;
    public static final int TON_ALPHANUMERIC = 5;
    public static final int TON_INTERNATIONAL_OR_IP = 1;
    public static final int TON_NATIONAL_OR_EMAIL = 2;
    public static final int TON_NETWORK = 3;
    public static final int TON_RESERVED = 7;
    public static final int TON_SUBSCRIBER = 4;
    public static final int TON_UNKNOWN;
    private static final SparseBooleanArray numericCharDialableMap;
    private static final char[] numericCharsDialable;
    private static final char[] numericCharsSugar;
    public int digitMode;
    public int numberMode;
    public int numberOfDigits;
    public int numberPlan;

    static {
        numericCharsDialable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '*', '#'};
        numericCharsSugar = new char[]{'(', ')', ' ', '-', '+', '.', '/', '\\'};
        numericCharDialableMap = new SparseBooleanArray(numericCharsDialable.length + numericCharsSugar.length);
        for (int i = 0; i < numericCharsDialable.length; ++i) {
            numericCharDialableMap.put(numericCharsDialable[i], true);
        }
        for (int i = 0; i < numericCharsSugar.length; ++i) {
            numericCharDialableMap.put(numericCharsSugar[i], false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String filterNumericSugar(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string2.charAt(n2);
            int n3 = numericCharDialableMap.indexOfKey(c);
            if (n3 < 0) {
                return null;
            }
            if (numericCharDialableMap.valueAt(n3)) {
                stringBuilder.append(c);
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String filterWhitespace(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string2.charAt(n2);
            if (c != ' ' && c != '\r' && c != '\n' && c != '\t') {
                stringBuilder.append(c);
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static CdmaSmsAddress parse(String string2) {
        CdmaSmsAddress cdmaSmsAddress = new CdmaSmsAddress();
        cdmaSmsAddress.address = string2;
        cdmaSmsAddress.ton = 0;
        String string3 = CdmaSmsAddress.filterNumericSugar(string2);
        byte[] byArray = null;
        if (string3 != null) {
            byArray = CdmaSmsAddress.parseToDtmf(string3);
        }
        if (byArray != null) {
            cdmaSmsAddress.digitMode = 0;
            cdmaSmsAddress.numberMode = 0;
            if (string2.indexOf(43) != -1) {
                cdmaSmsAddress.ton = 1;
            }
        } else {
            byArray = UserData.stringToAscii(CdmaSmsAddress.filterWhitespace(string2));
            if (byArray == null) {
                return null;
            }
            cdmaSmsAddress.digitMode = 1;
            cdmaSmsAddress.numberMode = 1;
            if (string2.indexOf(64) != -1) {
                cdmaSmsAddress.ton = 2;
            }
        }
        cdmaSmsAddress.origBytes = byArray;
        cdmaSmsAddress.numberOfDigits = byArray.length;
        return cdmaSmsAddress;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static byte[] parseToDtmf(String string2) {
        int n = string2.length();
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            int n3;
            char c = string2.charAt(n2);
            if (c >= '1' && c <= '9') {
                n3 = c - 48;
            } else if (c == '0') {
                n3 = 10;
            } else if (c == '*') {
                n3 = 11;
            } else {
                if (c != '#') {
                    return null;
                }
                n3 = 12;
            }
            byArray[n2] = (byte)n3;
            ++n2;
        }
        return byArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CdmaSmsAddress ");
        stringBuilder.append("{ digitMode=" + this.digitMode);
        stringBuilder.append(", numberMode=" + this.numberMode);
        stringBuilder.append(", numberPlan=" + this.numberPlan);
        stringBuilder.append(", numberOfDigits=" + this.numberOfDigits);
        stringBuilder.append(", ton=" + this.ton);
        stringBuilder.append(", address=\"" + this.address + "\"");
        stringBuilder.append(", origBytes=" + HexDump.toHexString(this.origBytes));
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }
}

