/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.SQLException;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemProperties;
import android.preference.PreferenceManager;
import android.provider.Telephony;
import android.telephony.CellLocation;
import android.telephony.PhoneNumberUtils;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallForwardInfo;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DataConnection;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.IccFileHandler;
import com.android.internal.telephony.IccPhoneBookInterfaceManager;
import com.android.internal.telephony.IccSmsInterfaceManager;
import com.android.internal.telephony.IccVmNotSupportedException;
import com.android.internal.telephony.MmiCode;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.PhoneNotifier;
import com.android.internal.telephony.PhoneProxy;
import com.android.internal.telephony.PhoneSubInfo;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.gsm.GsmCall;
import com.android.internal.telephony.gsm.GsmCallTracker;
import com.android.internal.telephony.gsm.GsmConnection;
import com.android.internal.telephony.gsm.GsmDataConnectionTracker;
import com.android.internal.telephony.gsm.GsmMmiCode;
import com.android.internal.telephony.gsm.GsmSMSDispatcher;
import com.android.internal.telephony.gsm.GsmServiceStateTracker;
import com.android.internal.telephony.gsm.NetworkInfo;
import com.android.internal.telephony.gsm.SIMFileHandler;
import com.android.internal.telephony.gsm.SIMRecords;
import com.android.internal.telephony.gsm.SimCard;
import com.android.internal.telephony.gsm.SimPhoneBookInterfaceManager;
import com.android.internal.telephony.gsm.SimSmsInterfaceManager;
import com.android.internal.telephony.gsm.SuppServiceNotification;
import com.android.internal.telephony.gsm.stk.StkService;
import com.android.internal.telephony.test.SimulatedRadioControl;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;

public class GSMPhone
extends PhoneBase {
    public static final String CIPHERING_KEY = "ciphering_key";
    private static final boolean LOCAL_DEBUG = true;
    static final String LOG_TAG = "GSM";
    public static final String VM_NUMBER = "vm_number_key";
    public static final String VM_SIM_IMSI = "vm_sim_imsi_key";
    Thread debugPortThread;
    ServerSocket debugSocket;
    GsmCallTracker mCT;
    private String mImei;
    private String mImeiSv;
    ArrayList<GsmMmiCode> mPendingMMIs = new ArrayList();
    Registrant mPostDialHandler;
    SIMRecords mSIMRecords;
    GsmSMSDispatcher mSMS;
    GsmServiceStateTracker mSST;
    SimCard mSimCard;
    SimPhoneBookInterfaceManager mSimPhoneBookIntManager;
    SimSmsInterfaceManager mSimSmsIntManager;
    RegistrantList mSsnRegistrants = new RegistrantList();
    StkService mStkService;
    PhoneSubInfo mSubInfo;
    private String mVmNumber;

    public GSMPhone(Context context, CommandsInterface commandsInterface, PhoneNotifier phoneNotifier) {
        this(context, commandsInterface, phoneNotifier, false);
    }

    public GSMPhone(Context context, CommandsInterface commandsInterface, PhoneNotifier phoneNotifier, boolean bl) {
        super(phoneNotifier, context, commandsInterface, bl);
        if (commandsInterface instanceof SimulatedRadioControl) {
            this.mSimulatedRadioControl = (SimulatedRadioControl)((Object)commandsInterface);
        }
        this.mCM.setPhoneType(1);
        this.mCT = new GsmCallTracker(this);
        this.mSST = new GsmServiceStateTracker(this);
        this.mSMS = new GsmSMSDispatcher(this);
        this.mIccFileHandler = new SIMFileHandler(this);
        this.mSIMRecords = new SIMRecords(this);
        this.mDataConnection = new GsmDataConnectionTracker(this);
        this.mSimCard = new SimCard(this);
        if (!bl) {
            this.mSimPhoneBookIntManager = new SimPhoneBookInterfaceManager(this);
            this.mSimSmsIntManager = new SimSmsInterfaceManager(this, this.mSMS);
            this.mSubInfo = new PhoneSubInfo(this);
        }
        this.mStkService = StkService.getInstance(this.mCM, this.mSIMRecords, this.mContext, (SIMFileHandler)this.mIccFileHandler, this.mSimCard);
        this.mCM.registerForAvailable(this, 1, null);
        this.mSIMRecords.registerForRecordsLoaded(this, 3, null);
        this.mCM.registerForOffOrNotAvailable(this, 8, null);
        this.mCM.registerForOn(this, 5, null);
        this.mCM.setOnUSSD(this, 7, null);
        this.mCM.setOnSuppServiceNotification(this, 2, null);
        this.mSST.registerForNetworkAttach(this, 19, null);
        SystemProperties.set("gsm.current.phone-type", new Integer(1).toString());
    }

    private String getVmSimImsi() {
        return PreferenceManager.getDefaultSharedPreferences(this.getContext()).getString(VM_SIM_IMSI, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleCallDeflectionIncallSupplementaryService(String string2) throws CallStateException {
        if (string2.length() > 1) {
            return false;
        }
        if (this.getRingingCall().getState() == Call.State.IDLE) {
            if (this.getBackgroundCall().getState() == Call.State.IDLE) return true;
            Log.d(LOG_TAG, "MmiCode 0: hangupWaitingOrBackground");
            this.mCT.hangupWaitingOrBackground();
            return true;
        }
        Log.d(LOG_TAG, "MmiCode 0: rejectCall");
        try {
            this.mCT.rejectCall();
            return true;
        }
        catch (CallStateException callStateException) {
            Log.d(LOG_TAG, "reject failed", callStateException);
            this.notifySuppServiceFailed(Phone.SuppService.REJECT);
            return true;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleCallHoldIncallSupplementaryService(String string2) throws CallStateException {
        int n = string2.length();
        if (n > 2) {
            return false;
        }
        Call call = this.getForegroundCall();
        if (n > 1) {
            try {
                int n2 = string2.charAt(1) - 48;
                GsmConnection gsmConnection = this.mCT.getConnectionByIndex((GsmCall)call, n2);
                if (gsmConnection != null && n2 >= 1 && n2 <= 7) {
                    Log.d(LOG_TAG, "MmiCode 2: separate call " + n2);
                    this.mCT.separate(gsmConnection);
                    return true;
                }
                Log.d(LOG_TAG, "separate: invalid call index " + n2);
                this.notifySuppServiceFailed(Phone.SuppService.SEPARATE);
                return true;
            }
            catch (CallStateException callStateException) {
                Log.d(LOG_TAG, "separate failed", callStateException);
                this.notifySuppServiceFailed(Phone.SuppService.SEPARATE);
                return true;
            }
        }
        try {
            if (this.getRingingCall().getState() != Call.State.IDLE) {
                Log.d(LOG_TAG, "MmiCode 2: accept ringing call");
                this.mCT.acceptCall();
                return true;
            }
        }
        catch (CallStateException callStateException) {
            Log.d(LOG_TAG, "switch failed", callStateException);
            this.notifySuppServiceFailed(Phone.SuppService.SWITCH);
            return true;
        }
        {
            Log.d(LOG_TAG, "MmiCode 2: switchWaitingOrHoldingAndActive");
            this.mCT.switchWaitingOrHoldingAndActive();
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleCallWaitingIncallSupplementaryService(String var1_1) throws CallStateException {
        var2_2 = var1_1.length();
        if (var2_2 > 2) {
            return false;
        }
        var3_3 = this.getForegroundCall();
        if (var2_2 <= 1) ** GOTO lbl14
        try {
            var8_4 = var1_1.charAt(1) - 48;
            if (var8_4 < 1) return true;
            if (var8_4 > 7) return true;
            Log.d("GSM", "MmiCode 1: hangupConnectionByIndex " + var8_4);
            this.mCT.hangupConnectionByIndex((GsmCall)var3_3, var8_4);
            return true;
lbl14:
            // 1 sources

            if (var3_3.getState() != Call.State.IDLE) {
                Log.d("GSM", "MmiCode 1: hangup foreground");
                this.mCT.hangup((GsmCall)var3_3);
                return true;
            }
        }
        catch (CallStateException var4_5) {
            Log.d("GSM", "hangup failed", var4_5);
            this.notifySuppServiceFailed(Phone.SuppService.HANGUP);
            return true;
        }
        {
            Log.d("GSM", "MmiCode 1: switchWaitingOrHoldingAndActive");
            this.mCT.switchWaitingOrHoldingAndActive();
        }
        return true;
    }

    private boolean handleCcbsIncallSupplementaryService(String string2) throws CallStateException {
        if (string2.length() > 1) {
            return false;
        }
        Log.i(LOG_TAG, "MmiCode 5: CCBS not supported!");
        this.notifySuppServiceFailed(Phone.SuppService.UNKNOWN);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleCfuQueryResult(CallForwardInfo[] callForwardInfoArray) {
        if (callForwardInfoArray == null || callForwardInfoArray.length == 0) {
            this.mSIMRecords.setVoiceCallForwardingFlag(1, false);
            return;
        }
        int n = 0;
        int n2 = callForwardInfoArray.length;
        while (n < n2) {
            if ((1 & callForwardInfoArray[n].serviceClass) != 0) {
                SIMRecords sIMRecords = this.mSIMRecords;
                boolean bl = callForwardInfoArray[n].status == 1;
                sIMRecords.setVoiceCallForwardingFlag(1, bl);
                return;
            }
            ++n;
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean handleEctIncallSupplementaryService(String string2) throws CallStateException {
        if (string2.length() != 1) {
            return false;
        }
        Log.d(LOG_TAG, "MmiCode 4: explicit call transfer");
        try {
            this.explicitCallTransfer();
            return true;
        }
        catch (CallStateException callStateException) {
            Log.d(LOG_TAG, "transfer failed", callStateException);
            this.notifySuppServiceFailed(Phone.SuppService.TRANSFER);
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean handleMultipartyIncallSupplementaryService(String string2) throws CallStateException {
        if (string2.length() > 1) {
            return false;
        }
        Log.d(LOG_TAG, "MmiCode 3: merge calls");
        try {
            this.conference();
            return true;
        }
        catch (CallStateException callStateException) {
            Log.d(LOG_TAG, "conference failed", callStateException);
            this.notifySuppServiceFailed(Phone.SuppService.CONFERENCE);
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleSetSelectNetwork(AsyncResult asyncResult) {
        if (!(asyncResult.userObj instanceof NetworkSelectMessage)) {
            Log.d(LOG_TAG, "unexpected result from user object.");
            return;
        } else {
            NetworkSelectMessage networkSelectMessage = (NetworkSelectMessage)asyncResult.userObj;
            if (networkSelectMessage.message != null) {
                Log.d(LOG_TAG, "sending original message to recipient");
                AsyncResult.forMessage(networkSelectMessage.message, asyncResult.result, asyncResult.exception);
                networkSelectMessage.message.sendToTarget();
            }
            SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences(this.getContext()).edit();
            editor.putString("network_selection_key", networkSelectMessage.operatorNumeric);
            editor.putString("network_selection_name_key", networkSelectMessage.operatorAlphaLong);
            if (editor.commit()) return;
            Log.e(LOG_TAG, "failed to commit network selection preference");
            return;
        }
    }

    private boolean isValidCommandInterfaceCFAction(int n) {
        switch (n) {
            default: {
                return false;
            }
            case 0: 
            case 1: 
            case 3: 
            case 4: 
        }
        return true;
    }

    private boolean isValidCommandInterfaceCFReason(int n) {
        switch (n) {
            default: {
                return false;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onIncomingUSSD(int n, String string2) {
        boolean bl = n == 1;
        boolean bl2 = n != 0 && n != 1;
        int n2 = 0;
        int n3 = this.mPendingMMIs.size();
        while (true) {
            block5: {
                GsmMmiCode gsmMmiCode;
                block4: {
                    gsmMmiCode = null;
                    if (n2 >= n3) break block4;
                    if (!this.mPendingMMIs.get(n2).isPendingUSSD()) break block5;
                    gsmMmiCode = this.mPendingMMIs.get(n2);
                }
                if (gsmMmiCode == null) break;
                if (!bl2) {
                    gsmMmiCode.onUssdFinished(string2, bl);
                    return;
                }
                gsmMmiCode.onUssdFinishedError();
                return;
            }
            ++n2;
        }
        if (bl2 || string2 == null) return;
        this.onNetworkInitiatedUssd(GsmMmiCode.newNetworkInitiatedUssd(string2, bl, this));
    }

    private void onNetworkInitiatedUssd(GsmMmiCode gsmMmiCode) {
        this.mMmiCompleteRegistrants.notifyRegistrants(new AsyncResult(null, gsmMmiCode, null));
    }

    private void setVmSimImsi(String string2) {
        SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences(this.getContext()).edit();
        editor.putString(VM_SIM_IMSI, string2);
        editor.apply();
    }

    private void storeVoiceMailNumber(String string2) {
        SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences(this.getContext()).edit();
        editor.putString(VM_NUMBER, string2);
        editor.apply();
        this.setVmSimImsi(this.getSubscriberId());
    }

    @Override
    public void acceptCall() throws CallStateException {
        this.mCT.acceptCall();
    }

    @Override
    public void activateCellBroadcastSms(int n, Message message) {
        Log.e(LOG_TAG, "Error! This functionality is not implemented for GSM.");
    }

    @Override
    public boolean canConference() {
        return this.mCT.canConference();
    }

    public boolean canDial() {
        return this.mCT.canDial();
    }

    @Override
    public boolean canTransfer() {
        return this.mCT.canTransfer();
    }

    @Override
    public void clearDisconnected() {
        this.mCT.clearDisconnected();
    }

    @Override
    public void conference() throws CallStateException {
        this.mCT.conference();
    }

    @Override
    public Connection dial(String string2) throws CallStateException {
        return this.dial(string2, null);
    }

    @Override
    public Connection dial(String string2, UUSInfo uUSInfo) throws CallStateException {
        String string3 = PhoneNumberUtils.stripSeparators(string2);
        if (this.handleInCallMmiCommands(string3)) {
            return null;
        }
        GsmMmiCode gsmMmiCode = GsmMmiCode.newFromDialString(PhoneNumberUtils.extractNetworkPortionAlt((String)string3), this);
        Log.d(LOG_TAG, "dialing w/ mmi '" + gsmMmiCode + "'...");
        if (gsmMmiCode == null) {
            return this.mCT.dial(string3, uUSInfo);
        }
        if (gsmMmiCode.isTemporaryModeCLIR()) {
            return this.mCT.dial(gsmMmiCode.dialingNumber, gsmMmiCode.getCLIRMode(), uUSInfo);
        }
        this.mPendingMMIs.add(gsmMmiCode);
        this.mMmiRegistrants.notifyRegistrants(new AsyncResult(null, gsmMmiCode, null));
        gsmMmiCode.processCode();
        return null;
    }

    @Override
    public boolean disableDataConnectivity() {
        return this.mDataConnection.setDataEnabled(false);
    }

    @Override
    public void disableLocationUpdates() {
        this.mSST.disableLocationUpdates();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void dispose() {
        Object object = PhoneProxy.lockForRadioTechnologyChange;
        synchronized (object) {
            super.dispose();
            this.mCM.unregisterForAvailable(this);
            this.mSIMRecords.unregisterForRecordsLoaded(this);
            this.mCM.unregisterForOffOrNotAvailable(this);
            this.mCM.unregisterForOn(this);
            this.mSST.unregisterForNetworkAttach(this);
            this.mCM.unSetOnUSSD(this);
            this.mCM.unSetOnSuppServiceNotification(this);
            this.mPendingMMIs.clear();
            this.mStkService.dispose();
            this.mCT.dispose();
            this.mDataConnection.dispose();
            this.mSST.dispose();
            this.mIccFileHandler.dispose();
            this.mSIMRecords.dispose();
            this.mSimCard.dispose();
            this.mSimPhoneBookIntManager.dispose();
            this.mSimSmsIntManager.dispose();
            this.mSubInfo.dispose();
            return;
        }
    }

    @Override
    public boolean enableDataConnectivity() {
        return this.mDataConnection.setDataEnabled(true);
    }

    @Override
    public void enableLocationUpdates() {
        this.mSST.enableLocationUpdates();
    }

    @Override
    public void explicitCallTransfer() throws CallStateException {
        this.mCT.explicitCallTransfer();
    }

    protected void finalize() {
        Log.d(LOG_TAG, "GSMPhone finalized");
    }

    @Override
    public void getAvailableNetworks(Message message) {
        this.mCM.getAvailableNetworks(message);
    }

    @Override
    public GsmCall getBackgroundCall() {
        return this.mCT.backgroundCall;
    }

    @Override
    public boolean getCallForwardingIndicator() {
        return this.mSIMRecords.getVoiceCallForwardingFlag();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void getCallForwardingOption(int n, Message message) {
        if (this.isValidCommandInterfaceCFReason(n)) {
            Log.d(LOG_TAG, "requesting call forwarding query.");
            Message message2 = n == 0 ? this.obtainMessage(13, message) : message;
            this.mCM.queryCallForwardStatus(n, 0, null, message2);
        }
    }

    @Override
    public void getCallWaiting(Message message) {
        this.mCM.queryCallWaiting(1, message);
    }

    @Override
    public void getCellBroadcastSmsConfig(Message message) {
        Log.e(LOG_TAG, "Error! This functionality is not implemented for GSM.");
    }

    @Override
    public CellLocation getCellLocation() {
        return this.mSST.cellLoc;
    }

    @Override
    public List<DataConnection> getCurrentDataConnectionList() {
        return this.mDataConnection.getAllDataConnections();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Phone.DataActivityState getDataActivityState() {
        Phone.DataActivityState dataActivityState = Phone.DataActivityState.NONE;
        if (this.mSST.getCurrentGprsState() != 0) return dataActivityState;
        switch (this.mDataConnection.getActivity()) {
            default: {
                return dataActivityState;
            }
            case DATAIN: {
                return Phone.DataActivityState.DATAIN;
            }
            case DATAOUT: {
                return Phone.DataActivityState.DATAOUT;
            }
            case DATAINANDOUT: 
        }
        return Phone.DataActivityState.DATAINANDOUT;
    }

    @Override
    public void getDataCallList(Message message) {
        this.mCM.getDataCallList(message);
    }

    @Override
    public Phone.DataState getDataConnectionState() {
        Phone.DataState dataState = Phone.DataState.DISCONNECTED;
        if (this.mSST == null) {
            return Phone.DataState.DISCONNECTED;
        }
        if (this.mSST.getCurrentGprsState() != 0) {
            return Phone.DataState.DISCONNECTED;
        }
        switch (2.$SwitchMap$com$android$internal$telephony$DataConnectionTracker$State[this.mDataConnection.getState().ordinal()]) {
            default: {
                return dataState;
            }
            case 1: 
            case 2: {
                return Phone.DataState.DISCONNECTED;
            }
            case 3: 
            case 4: {
                if (this.mCT.state != Phone.State.IDLE && !this.mSST.isConcurrentVoiceAndData()) {
                    return Phone.DataState.SUSPENDED;
                }
                return Phone.DataState.CONNECTED;
            }
            case 5: 
            case 6: 
            case 7: 
        }
        return Phone.DataState.CONNECTING;
    }

    @Override
    public boolean getDataRoamingEnabled() {
        return this.mDataConnection.getDataOnRoamingEnabled();
    }

    @Override
    public String getDeviceId() {
        return this.mImei;
    }

    @Override
    public String getDeviceSvn() {
        return this.mImeiSv;
    }

    @Override
    public String getEsn() {
        Log.e(LOG_TAG, "[GSMPhone] getEsn() is a CDMA method");
        return "0";
    }

    @Override
    public GsmCall getForegroundCall() {
        return this.mCT.foregroundCall;
    }

    @Override
    public IccCard getIccCard() {
        return this.mSimCard;
    }

    @Override
    public IccFileHandler getIccFileHandler() {
        return this.mIccFileHandler;
    }

    @Override
    public IccPhoneBookInterfaceManager getIccPhoneBookInterfaceManager() {
        return this.mSimPhoneBookIntManager;
    }

    @Override
    public boolean getIccRecordsLoaded() {
        return this.mSIMRecords.getRecordsLoaded();
    }

    @Override
    public String getIccSerialNumber() {
        return this.mSIMRecords.iccid;
    }

    @Override
    public IccSmsInterfaceManager getIccSmsInterfaceManager() {
        return this.mSimSmsIntManager;
    }

    @Override
    public String getLine1AlphaTag() {
        return this.mSIMRecords.getMsisdnAlphaTag();
    }

    @Override
    public String getLine1Number() {
        return this.mSIMRecords.getMsisdnNumber();
    }

    @Override
    public String getMeid() {
        Log.e(LOG_TAG, "[GSMPhone] getMeid() is a CDMA method");
        return "0";
    }

    @Override
    public boolean getMessageWaitingIndicator() {
        return this.mSIMRecords.getVoiceMessageWaiting();
    }

    @Override
    public boolean getMute() {
        return this.mCT.getMute();
    }

    @Override
    public void getNeighboringCids(Message message) {
        this.mCM.getNeighboringCids(message);
    }

    @Override
    public void getOutgoingCallerIdDisplay(Message message) {
        this.mCM.getCLIR(message);
    }

    @Override
    public List<? extends MmiCode> getPendingMmiCodes() {
        return this.mPendingMMIs;
    }

    @Override
    public String getPhoneName() {
        return LOG_TAG;
    }

    @Override
    public PhoneSubInfo getPhoneSubInfo() {
        return this.mSubInfo;
    }

    @Override
    public int getPhoneType() {
        return 1;
    }

    @Override
    public GsmCall getRingingCall() {
        return this.mCT.ringingCall;
    }

    @Override
    public ServiceState getServiceState() {
        return this.mSST.ss;
    }

    @Override
    public SignalStrength getSignalStrength() {
        return this.mSST.mSignalStrength;
    }

    @Override
    public Phone.State getState() {
        return this.mCT.state;
    }

    @Override
    public String getSubscriberId() {
        return this.mSIMRecords.imsi;
    }

    @Override
    public String getVoiceMailAlphaTag() {
        String string2 = this.mSIMRecords.getVoiceMailAlphaTag();
        if (string2 == null || string2.length() == 0) {
            return ((Object)this.mContext.getText(0x1040004)).toString();
        }
        return string2;
    }

    @Override
    public String getVoiceMailNumber() {
        String string2 = this.mSIMRecords.getVoiceMailNumber();
        if (TextUtils.isEmpty(string2)) {
            string2 = PreferenceManager.getDefaultSharedPreferences(this.getContext()).getString(VM_NUMBER, null);
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean handleInCallMmiCommands(String string2) throws CallStateException {
        if (!this.isInCall()) {
            return false;
        }
        if (TextUtils.isEmpty(string2)) {
            return false;
        }
        char c = string2.charAt(0);
        boolean bl = false;
        switch (c) {
            case '0': {
                return this.handleCallDeflectionIncallSupplementaryService(string2);
            }
            case '1': {
                return this.handleCallWaitingIncallSupplementaryService(string2);
            }
            case '2': {
                return this.handleCallHoldIncallSupplementaryService(string2);
            }
            case '3': {
                return this.handleMultipartyIncallSupplementaryService(string2);
            }
            case '4': {
                return this.handleEctIncallSupplementaryService(string2);
            }
            case '5': {
                return this.handleCcbsIncallSupplementaryService(string2);
            }
        }
        return bl;
    }

    /*
     * Handled duff style switch with additional control
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleMessage(Message message) {
        int n = 0;
        block19: do {
            switch (n == 0 ? message.what : n) {
                default: {
                    super.handleMessage(message);
                    return;
                }
                case 1: {
                    this.mCM.getBasebandVersion(this.obtainMessage(6));
                    this.mCM.getIMEI(this.obtainMessage(9));
                    this.mCM.getIMEISV(this.obtainMessage(10));
                    return;
                }
                case 19: {
                    this.syncClirSetting();
                    return;
                }
                case 3: {
                    this.updateCurrentCarrierInProvider();
                    n = 5;
                    String string2 = this.getVmSimImsi();
                    if (string2 == null) continue block19;
                    n = 5;
                    if (this.getSubscriberId().equals(string2)) continue block19;
                    this.storeVoiceMailNumber(null);
                    this.setVmSimImsi(null);
                    return;
                }
                case 6: {
                    AsyncResult asyncResult = (AsyncResult)message.obj;
                    n = 5;
                    if (asyncResult.exception != null) continue block19;
                    Log.d(LOG_TAG, "Baseband version: " + asyncResult.result);
                    this.setSystemProperty("gsm.version.baseband", (String)asyncResult.result);
                    return;
                }
                case 9: {
                    AsyncResult asyncResult = (AsyncResult)message.obj;
                    n = 5;
                    if (asyncResult.exception != null) continue block19;
                    this.mImei = (String)asyncResult.result;
                    return;
                }
                case 10: {
                    AsyncResult asyncResult = (AsyncResult)message.obj;
                    n = 5;
                    if (asyncResult.exception != null) continue block19;
                    this.mImeiSv = (String)asyncResult.result;
                    return;
                }
                case 7: {
                    n = 5;
                    String[] stringArray = (String[])((AsyncResult)message.obj).result;
                    if (stringArray.length <= 1) continue block19;
                    try {
                        this.onIncomingUSSD(Integer.parseInt(stringArray[0]), stringArray[1]);
                        return;
                    }
                    catch (NumberFormatException numberFormatException) {
                        Log.w(LOG_TAG, "error parsing USSD");
                        return;
                    }
                }
                case 8: {
                    int n2 = 0;
                    int n3 = this.mPendingMMIs.size();
                    while (true) {
                        n = 5;
                        if (n2 >= n3) continue block19;
                        if (this.mPendingMMIs.get(n2).isPendingUSSD()) {
                            this.mPendingMMIs.get(n2).onUssdFinishedError();
                        }
                        ++n2;
                    }
                }
                case 2: {
                    AsyncResult asyncResult = (AsyncResult)message.obj;
                    SuppServiceNotification cfr_ignored_1 = (SuppServiceNotification)asyncResult.result;
                    this.mSsnRegistrants.notifyRegistrants(asyncResult);
                    return;
                }
                case 12: {
                    AsyncResult asyncResult = (AsyncResult)message.obj;
                    if (asyncResult.exception == null) {
                        SIMRecords sIMRecords = this.mSIMRecords;
                        boolean bl = message.arg1 == 1;
                        sIMRecords.setVoiceCallForwardingFlag(1, bl);
                    }
                    n = 5;
                    Message message2 = (Message)asyncResult.userObj;
                    if (message2 == null) continue block19;
                    AsyncResult.forMessage(message2, asyncResult.result, asyncResult.exception);
                    message2.sendToTarget();
                    return;
                }
                case 20: {
                    AsyncResult asyncResult = (AsyncResult)message.obj;
                    if (IccVmNotSupportedException.class.isInstance(asyncResult.exception)) {
                        this.storeVoiceMailNumber(this.mVmNumber);
                        asyncResult.exception = null;
                    }
                    n = 5;
                    Message message3 = (Message)asyncResult.userObj;
                    if (message3 == null) continue block19;
                    AsyncResult.forMessage(message3, asyncResult.result, asyncResult.exception);
                    message3.sendToTarget();
                    return;
                }
                case 13: {
                    Message message4;
                    AsyncResult asyncResult = (AsyncResult)message.obj;
                    if (asyncResult.exception == null) {
                        this.handleCfuQueryResult((CallForwardInfo[])asyncResult.result);
                    }
                    if ((message4 = (Message)asyncResult.userObj) == null) return;
                    AsyncResult.forMessage(message4, asyncResult.result, asyncResult.exception);
                    message4.sendToTarget();
                    return;
                }
                case 5: {
                    return;
                }
                case 16: 
                case 17: {
                    this.handleSetSelectNetwork((AsyncResult)message.obj);
                    return;
                }
                case 18: {
                    Message message5;
                    AsyncResult asyncResult = (AsyncResult)message.obj;
                    if (asyncResult.exception == null) {
                        this.saveClirSetting(message.arg1);
                    }
                    if ((message5 = (Message)asyncResult.userObj) == null) return;
                    AsyncResult.forMessage(message5, asyncResult.result, asyncResult.exception);
                    message5.sendToTarget();
                    return;
                }
            }
        } while (true);
    }

    @Override
    public boolean handlePinMmi(String string2) {
        GsmMmiCode gsmMmiCode = GsmMmiCode.newFromDialString(string2, this);
        if (gsmMmiCode != null && gsmMmiCode.isPinCommand()) {
            this.mPendingMMIs.add(gsmMmiCode);
            this.mMmiRegistrants.notifyRegistrants(new AsyncResult(null, gsmMmiCode, null));
            gsmMmiCode.processCode();
            return true;
        }
        return false;
    }

    protected boolean isCfEnable(int n) {
        return n == 1 || n == 3;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean isDataConnectivityPossible() {
        if (this.mDataConnection.getDataEnabled() && this.getDataConnectionState() == Phone.DataState.DISCONNECTED) {
            return false;
        }
        boolean bl = false;
        if (bl) return false;
        if (this.getIccCard().getState() != IccCard.State.READY) return false;
        if (this.getServiceState().getState() != 0) return false;
        if (this.mDataConnection.getDataOnRoamingEnabled()) return true;
        if (this.getServiceState().getRoaming()) return false;
        return true;
    }

    boolean isInCall() {
        Call.State state = this.getForegroundCall().getState();
        Call.State state2 = this.getBackgroundCall().getState();
        Call.State state3 = this.getRingingCall().getState();
        return state.isAlive() || state2.isAlive() || state3.isAlive();
    }

    public void notifyCallForwardingIndicator() {
        this.mNotifier.notifyCallForwardingChanged(this);
    }

    void notifyDataConnectionFailed(String string2) {
        this.mNotifier.notifyDataConnectionFailed(this, string2);
    }

    void notifyDisconnect(Connection connection) {
        this.mDisconnectRegistrants.notifyResult(connection);
    }

    void notifyLocationChanged() {
        this.mNotifier.notifyCellLocation(this);
    }

    void notifyNewRingingConnection(Connection connection) {
        super.notifyNewRingingConnectionP(connection);
    }

    void notifyPhoneStateChanged() {
        this.mNotifier.notifyPhoneState(this);
    }

    void notifyPreciseCallStateChanged() {
        super.notifyPreciseCallStateChangedP();
    }

    void notifyServiceStateChanged(ServiceState serviceState) {
        super.notifyServiceStateChangedP(serviceState);
    }

    void notifySignalStrength() {
        this.mNotifier.notifySignalStrength(this);
    }

    void notifySuppServiceFailed(Phone.SuppService suppService) {
        this.mSuppServiceFailedRegistrants.notifyResult((Object)suppService);
    }

    void notifyUnknownConnection() {
        this.mUnknownConnectionRegistrants.notifyResult(this);
    }

    void onMMIDone(GsmMmiCode gsmMmiCode) {
        if (this.mPendingMMIs.remove(gsmMmiCode) || gsmMmiCode.isUssdRequest()) {
            this.mMmiCompleteRegistrants.notifyRegistrants(new AsyncResult(null, gsmMmiCode, null));
        }
    }

    @Override
    public void registerForSuppServiceNotification(Handler handler, int n, Object object) {
        this.mSsnRegistrants.addUnique(handler, n, object);
        if (this.mSsnRegistrants.size() == 1) {
            this.mCM.setSuppServiceNotifications(true, null);
        }
    }

    @Override
    public void rejectCall() throws CallStateException {
        this.mCT.rejectCall();
    }

    public void removeReferences() {
        this.mSimulatedRadioControl = null;
        this.mStkService = null;
        this.mSimPhoneBookIntManager = null;
        this.mSimSmsIntManager = null;
        this.mSMS = null;
        this.mSubInfo = null;
        this.mSIMRecords = null;
        this.mIccFileHandler = null;
        this.mSimCard = null;
        this.mDataConnection = null;
        this.mCT = null;
        this.mSST = null;
    }

    public void saveClirSetting(int n) {
        SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences(this.getContext()).edit();
        editor.putInt("clir_key", n);
        if (!editor.commit()) {
            Log.e(LOG_TAG, "failed to commit CLIR preference");
        }
    }

    @Override
    public void selectNetworkManually(NetworkInfo networkInfo, Message message) {
        NetworkSelectMessage networkSelectMessage = new NetworkSelectMessage();
        networkSelectMessage.message = message;
        networkSelectMessage.operatorNumeric = networkInfo.operatorNumeric;
        networkSelectMessage.operatorAlphaLong = networkInfo.operatorAlphaLong;
        Message message2 = this.obtainMessage(16, networkSelectMessage);
        this.mCM.setNetworkSelectionModeManual(networkInfo.operatorNumeric, message2);
    }

    public void sendBurstDtmf(String string2) {
        Log.e(LOG_TAG, "[GSMPhone] sendBurstDtmf() is a CDMA method");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void sendDtmf(char c) {
        if (!PhoneNumberUtils.is12Key(c)) {
            Log.e(LOG_TAG, "sendDtmf called with invalid character '" + c + "'");
            return;
        } else {
            if (this.mCT.state != Phone.State.OFFHOOK) return;
            this.mCM.sendDtmf(c, null);
            return;
        }
    }

    @Override
    public void sendUssdResponse(String string2) {
        GsmMmiCode gsmMmiCode = GsmMmiCode.newFromUssdUserInput(string2, this);
        this.mPendingMMIs.add(gsmMmiCode);
        this.mMmiRegistrants.notifyRegistrants(new AsyncResult(null, gsmMmiCode, null));
        gsmMmiCode.sendUssd(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setCallForwardingOption(int n, int n2, String string2, int n3, Message message) {
        if (this.isValidCommandInterfaceCFAction(n) && this.isValidCommandInterfaceCFReason(n2)) {
            Message message2;
            if (n2 == 0) {
                int n4 = this.isCfEnable(n) ? 1 : 0;
                message2 = this.obtainMessage(12, n4, 0, message);
            } else {
                message2 = message;
            }
            this.mCM.setCallForward(n, n2, 1, string2, n3, message2);
        }
    }

    @Override
    public void setCallWaiting(boolean bl, Message message) {
        this.mCM.setCallWaiting(bl, 1, message);
    }

    @Override
    public void setCellBroadcastSmsConfig(int[] nArray, Message message) {
        Log.e(LOG_TAG, "Error! This functionality is not implemented for GSM.");
    }

    @Override
    public void setDataRoamingEnabled(boolean bl) {
        this.mDataConnection.setDataOnRoamingEnabled(bl);
    }

    @Override
    public void setLine1Number(String string2, String string3, Message message) {
        this.mSIMRecords.setMsisdnNumber(string2, string3, message);
    }

    @Override
    public void setMute(boolean bl) {
        this.mCT.setMute(bl);
    }

    @Override
    public void setNetworkSelectionModeAutomatic(Message message) {
        NetworkSelectMessage networkSelectMessage = new NetworkSelectMessage();
        networkSelectMessage.message = message;
        networkSelectMessage.operatorNumeric = "";
        networkSelectMessage.operatorAlphaLong = "";
        Message message2 = this.obtainMessage(17, networkSelectMessage);
        Log.d(LOG_TAG, "wrapping and sending message to connect automatically");
        this.mCM.setNetworkSelectionModeAutomatic(message2);
    }

    @Override
    public void setOnPostDialCharacter(Handler handler, int n, Object object) {
        this.mPostDialHandler = new Registrant(handler, n, object);
    }

    @Override
    public void setOutgoingCallerIdDisplay(int n, Message message) {
        this.mCM.setCLIR(n, this.obtainMessage(18, n, 0, message));
    }

    @Override
    public void setRadioPower(boolean bl) {
        this.mSST.setRadioPower(bl);
    }

    @Override
    public final void setSystemProperty(String string2, String string3) {
        super.setSystemProperty(string2, string3);
    }

    @Override
    public void setVoiceMailNumber(String string2, String string3, Message message) {
        this.mVmNumber = string3;
        Message message2 = this.obtainMessage(20, 0, 0, message);
        this.mSIMRecords.setVoiceMailNumber(string2, this.mVmNumber, message2);
    }

    @Override
    public void startDtmf(char c) {
        if (!PhoneNumberUtils.is12Key(c)) {
            Log.e(LOG_TAG, "startDtmf called with invalid character '" + c + "'");
            return;
        }
        this.mCM.startDtmf(c, null);
    }

    @Override
    public void stopDtmf() {
        this.mCM.stopDtmf(null);
    }

    @Override
    public void switchHoldingAndActive() throws CallStateException {
        this.mCT.switchWaitingOrHoldingAndActive();
    }

    protected void syncClirSetting() {
        int n = PreferenceManager.getDefaultSharedPreferences(this.getContext()).getInt("clir_key", -1);
        if (n >= 0) {
            this.mCM.setCLIR(n, null);
        }
    }

    @Override
    public void unregisterForSuppServiceNotification(Handler handler) {
        this.mSsnRegistrants.remove(handler);
        if (this.mSsnRegistrants.size() == 0) {
            this.mCM.setSuppServiceNotifications(false, null);
        }
    }

    boolean updateCurrentCarrierInProvider() {
        if (this.mSIMRecords != null) {
            try {
                Uri uri = Uri.withAppendedPath(Telephony.Carriers.CONTENT_URI, "current");
                ContentValues contentValues = new ContentValues();
                contentValues.put("numeric", this.mSIMRecords.getSIMOperatorNumeric());
                this.mContext.getContentResolver().insert(uri, contentValues);
                return true;
            }
            catch (SQLException sQLException) {
                Log.e(LOG_TAG, "Can't store current operator", sQLException);
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    void updateMessageWaitingIndicator(boolean bl) {
        SIMRecords sIMRecords = this.mSIMRecords;
        int n = bl ? -1 : 0;
        sIMRecords.setVoiceMessageWaiting(1, n);
    }

    @Override
    public void updateServiceLocation() {
        this.mSST.enableSingleLocationUpdate();
    }

    private static class NetworkSelectMessage {
        public Message message;
        public String operatorAlphaLong;
        public String operatorNumeric;

        private NetworkSelectMessage() {
        }
    }
}

