/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.gsm.GsmCallTracker;
import com.android.internal.telephony.gsm.GsmConnection;
import java.util.ArrayList;
import java.util.List;

class GsmCall
extends Call {
    ArrayList<Connection> connections = new ArrayList();
    GsmCallTracker owner;

    GsmCall(GsmCallTracker gsmCallTracker) {
        this.owner = gsmCallTracker;
    }

    static Call.State stateFromDCState(DriverCall.State state) {
        switch (1.$SwitchMap$com$android$internal$telephony$DriverCall$State[state.ordinal()]) {
            default: {
                throw new RuntimeException("illegal call state:" + (Object)((Object)state));
            }
            case 1: {
                return Call.State.ACTIVE;
            }
            case 2: {
                return Call.State.HOLDING;
            }
            case 3: {
                return Call.State.DIALING;
            }
            case 4: {
                return Call.State.ALERTING;
            }
            case 5: {
                return Call.State.INCOMING;
            }
            case 6: 
        }
        return Call.State.WAITING;
    }

    void attach(Connection connection, DriverCall driverCall) {
        this.connections.add(connection);
        this.state = GsmCall.stateFromDCState(driverCall.state);
    }

    void attachFake(Connection connection, Call.State state) {
        this.connections.add(connection);
        this.state = state;
    }

    void clearDisconnected() {
        for (int i = this.connections.size() - 1; i >= 0; --i) {
            if (((GsmConnection)this.connections.get(i)).getState() != Call.State.DISCONNECTED) continue;
            this.connections.remove(i);
        }
        if (this.connections.size() == 0) {
            this.state = Call.State.IDLE;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void connectionDisconnected(GsmConnection gsmConnection) {
        if (this.state == Call.State.DISCONNECTED) return;
        boolean bl = true;
        int n = 0;
        int n2 = this.connections.size();
        while (true) {
            if (n < n2) {
                if (this.connections.get(n).getState() != Call.State.DISCONNECTED) {
                    return;
                }
            } else {
                if (!bl) return;
                this.state = Call.State.DISCONNECTED;
                return;
            }
            ++n;
        }
    }

    void detach(GsmConnection gsmConnection) {
        this.connections.remove(gsmConnection);
        if (this.connections.size() == 0) {
            this.state = Call.State.IDLE;
        }
    }

    public void dispose() {
    }

    @Override
    public List<Connection> getConnections() {
        return this.connections;
    }

    @Override
    public Phone getPhone() {
        return this.owner.phone;
    }

    @Override
    public void hangup() throws CallStateException {
        this.owner.hangup(this);
    }

    boolean isFull() {
        return this.connections.size() == 5;
    }

    @Override
    public boolean isMultiparty() {
        return this.connections.size() > 1;
    }

    void onHangupLocal() {
        int n = this.connections.size();
        for (int i = 0; i < n; ++i) {
            ((GsmConnection)this.connections.get(i)).onHangupLocal();
        }
        this.state = Call.State.DISCONNECTING;
    }

    public String toString() {
        return this.state.toString();
    }

    boolean update(GsmConnection gsmConnection, DriverCall driverCall) {
        Call.State state = GsmCall.stateFromDCState(driverCall.state);
        Call.State state2 = this.state;
        boolean bl = false;
        if (state != state2) {
            this.state = state;
            bl = true;
        }
        return bl;
    }
}

