/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemProperties;
import android.telephony.TelephonyManager;
import android.telephony.gsm.GsmCellLocation;
import android.util.EventLog;
import android.util.Log;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CallTracker;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.gsm.GsmCall;
import com.android.internal.telephony.gsm.GsmConnection;
import java.util.ArrayList;
import java.util.List;

public final class GsmCallTracker
extends CallTracker {
    private static final boolean DBG_POLL = false;
    static final String LOG_TAG = "GSM";
    static final int MAX_CONNECTIONS = 7;
    static final int MAX_CONNECTIONS_PER_CALL = 5;
    private static final boolean REPEAT_POLLING;
    GsmCall backgroundCall;
    GsmConnection[] connections = new GsmConnection[7];
    boolean desiredMute = false;
    ArrayList<GsmConnection> droppedDuringPoll;
    GsmCall foregroundCall;
    boolean hangupPendingMO;
    GsmConnection pendingMO;
    GSMPhone phone;
    GsmCall ringingCall;
    Phone.State state;
    RegistrantList voiceCallEndedRegistrants = new RegistrantList();
    RegistrantList voiceCallStartedRegistrants = new RegistrantList();

    GsmCallTracker(GSMPhone gSMPhone) {
        this.droppedDuringPoll = new ArrayList(7);
        this.ringingCall = new GsmCall(this);
        this.foregroundCall = new GsmCall(this);
        this.backgroundCall = new GsmCall(this);
        this.state = Phone.State.IDLE;
        this.phone = gSMPhone;
        this.cm = gSMPhone.mCM;
        this.cm.registerForCallStateChanged(this, 2, null);
        this.cm.registerForOn(this, 9, null);
        this.cm.registerForNotAvailable(this, 10, null);
    }

    private void dumpState() {
        Log.i(LOG_TAG, "Phone State:" + (Object)((Object)this.state));
        Log.i(LOG_TAG, "Ringing call: " + this.ringingCall.toString());
        List<Connection> list = this.ringingCall.getConnections();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Log.i(LOG_TAG, ((Object)list.get(i)).toString());
        }
        Log.i(LOG_TAG, "Foreground call: " + this.foregroundCall.toString());
        List<Connection> list2 = this.foregroundCall.getConnections();
        int n2 = list2.size();
        for (int i = 0; i < n2; ++i) {
            Log.i(LOG_TAG, ((Object)list2.get(i)).toString());
        }
        Log.i(LOG_TAG, "Background call: " + this.backgroundCall.toString());
        List<Connection> list3 = this.backgroundCall.getConnections();
        int n3 = list3.size();
        for (int i = 0; i < n3; ++i) {
            Log.i(LOG_TAG, ((Object)list3.get(i)).toString());
        }
    }

    private void fakeHoldForegroundBeforeDial() {
        List list = (List)this.foregroundCall.connections.clone();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ((GsmConnection)list.get(i)).fakeHoldBeforeDial();
        }
    }

    private Phone.SuppService getFailedService(int n) {
        switch (n) {
            default: {
                return Phone.SuppService.UNKNOWN;
            }
            case 8: {
                return Phone.SuppService.SWITCH;
            }
            case 11: {
                return Phone.SuppService.CONFERENCE;
            }
            case 12: {
                return Phone.SuppService.SEPARATE;
            }
            case 13: 
        }
        return Phone.SuppService.TRANSFER;
    }

    private void handleRadioNotAvailable() {
        this.pollCallsWhenSafe();
    }

    private void internalClearDisconnected() {
        this.ringingCall.clearDisconnected();
        this.foregroundCall.clearDisconnected();
        this.backgroundCall.clearDisconnected();
    }

    private Message obtainCompleteMessage() {
        return this.obtainCompleteMessage(4);
    }

    private Message obtainCompleteMessage(int n) {
        this.pendingOperations = 1 + this.pendingOperations;
        this.lastRelevantPoll = null;
        this.needsPoll = true;
        return this.obtainMessage(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void operationComplete() {
        --this.pendingOperations;
        if (this.pendingOperations == 0 && this.needsPoll) {
            this.lastRelevantPoll = this.obtainMessage(1);
            this.cm.getCurrentCalls(this.lastRelevantPoll);
            return;
        } else {
            if (this.pendingOperations >= 0) return;
            Log.e(LOG_TAG, "GsmCallTracker.pendingOperations < 0");
            this.pendingOperations = 0;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updatePhoneState() {
        Phone.State state = this.state;
        this.state = this.ringingCall.isRinging() ? Phone.State.RINGING : (this.pendingMO != null || !this.foregroundCall.isIdle() || !this.backgroundCall.isIdle() ? Phone.State.OFFHOOK : Phone.State.IDLE);
        if (this.state == Phone.State.IDLE && state != this.state) {
            this.voiceCallEndedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        } else if (state == Phone.State.IDLE && state != this.state) {
            this.voiceCallStartedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        }
        if (this.state != state) {
            this.phone.notifyPhoneStateChanged();
        }
    }

    void acceptCall() throws CallStateException {
        if (this.ringingCall.getState() == Call.State.INCOMING) {
            Log.i("phone", "acceptCall: incoming...");
            this.setMute(false);
            this.cm.acceptCall(this.obtainCompleteMessage());
            return;
        }
        if (this.ringingCall.getState() == Call.State.WAITING) {
            this.setMute(false);
            this.switchWaitingOrHoldingAndActive();
            return;
        }
        throw new CallStateException("phone not ringing");
    }

    boolean canConference() {
        return this.foregroundCall.getState() == Call.State.ACTIVE && this.backgroundCall.getState() == Call.State.HOLDING && !this.backgroundCall.isFull() && !this.foregroundCall.isFull();
    }

    boolean canDial() {
        int n = this.phone.getServiceState().getState();
        String string2 = SystemProperties.get("ro.telephony.disable-call", "false");
        return n != 3 && this.pendingMO == null && !this.ringingCall.isRinging() && !string2.equals("true") && (!this.foregroundCall.getState().isAlive() || !this.backgroundCall.getState().isAlive());
    }

    boolean canTransfer() {
        return this.foregroundCall.getState() == Call.State.ACTIVE && this.backgroundCall.getState() == Call.State.HOLDING;
    }

    void clearDisconnected() {
        this.internalClearDisconnected();
        this.updatePhoneState();
        this.phone.notifyPreciseCallStateChanged();
    }

    void conference() throws CallStateException {
        this.cm.conference(this.obtainCompleteMessage(11));
    }

    Connection dial(String string2) throws CallStateException {
        return this.dial(string2, 0, null);
    }

    Connection dial(String string2, int n) throws CallStateException {
        return this.dial(string2, n, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    Connection dial(String string2, int n, UUSInfo uUSInfo) throws CallStateException {
        this.clearDisconnected();
        if (!this.canDial()) {
            throw new CallStateException("cannot dial in current state");
        }
        if (this.foregroundCall.getState() == Call.State.ACTIVE) {
            this.switchWaitingOrHoldingAndActive();
            this.fakeHoldForegroundBeforeDial();
        }
        if (this.foregroundCall.getState() != Call.State.IDLE) {
            throw new CallStateException("cannot dial in current state");
        }
        this.pendingMO = new GsmConnection(this.phone.getContext(), string2, this, this.foregroundCall);
        this.hangupPendingMO = false;
        if (this.pendingMO.address == null || this.pendingMO.address.length() == 0 || this.pendingMO.address.indexOf(78) >= 0) {
            this.pendingMO.cause = Connection.DisconnectCause.INVALID_NUMBER;
            this.pollCallsWhenSafe();
        } else {
            this.setMute(false);
            this.cm.dial(this.pendingMO.address, n, uUSInfo, this.obtainCompleteMessage());
        }
        this.updatePhoneState();
        this.phone.notifyPreciseCallStateChanged();
        return this.pendingMO;
    }

    Connection dial(String string2, UUSInfo uUSInfo) throws CallStateException {
        return this.dial(string2, 0, uUSInfo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispose() {
        this.cm.unregisterForCallStateChanged(this);
        this.cm.unregisterForOn(this);
        this.cm.unregisterForNotAvailable(this);
        for (GsmConnection gsmConnection : this.connections) {
            if (gsmConnection == null) continue;
            try {
                this.hangup(gsmConnection);
            }
            catch (CallStateException callStateException) {
                Log.e(LOG_TAG, "unexpected error on hangup during dispose");
            }
        }
        try {
            if (this.pendingMO != null) {
                this.hangup(this.pendingMO);
            }
        }
        catch (CallStateException callStateException) {
            Log.e(LOG_TAG, "unexpected error on hangup during dispose");
        }
        this.clearDisconnected();
    }

    void explicitCallTransfer() throws CallStateException {
        this.cm.explicitCallTransfer(this.obtainCompleteMessage(13));
    }

    protected void finalize() {
        Log.d(LOG_TAG, "GsmCallTracker finalized");
    }

    GsmConnection getConnectionByIndex(GsmCall gsmCall, int n) throws CallStateException {
        int n2 = gsmCall.connections.size();
        for (int i = 0; i < n2; ++i) {
            GsmConnection gsmConnection = (GsmConnection)gsmCall.connections.get(i);
            if (gsmConnection.getGSMIndex() != n) continue;
            return gsmConnection;
        }
        return null;
    }

    boolean getMute() {
        return this.desiredMute;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void handleMessage(Message message) {
        switch (message.what) {
            case 1: {
                AsyncResult cfr_ignored_0 = (AsyncResult)message.obj;
                if (message == this.lastRelevantPoll) {
                    this.needsPoll = false;
                    this.lastRelevantPoll = null;
                    this.handlePollCalls((AsyncResult)message.obj);
                    return;
                }
            }
            default: {
                return;
            }
            case 4: {
                AsyncResult cfr_ignored_1 = (AsyncResult)message.obj;
                this.operationComplete();
                return;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                if (((AsyncResult)message.obj).exception != null) {
                    this.phone.notifySuppServiceFailed(this.getFailedService(message.what));
                }
                this.operationComplete();
                return;
            }
            case 5: {
                int n;
                AsyncResult asyncResult = (AsyncResult)message.obj;
                this.operationComplete();
                if (asyncResult.exception != null) {
                    n = 16;
                    Log.i(LOG_TAG, "Exception during getLastCallFailCause, assuming normal disconnect");
                } else {
                    n = ((int[])asyncResult.result)[0];
                }
                if (n == 34 || n == 41 || n == 42 || n == 44 || n == 49 || n == 58 || n == 65535) {
                    GsmCellLocation gsmCellLocation = (GsmCellLocation)this.phone.getCellLocation();
                    Object[] objectArray = new Object[3];
                    objectArray[0] = n;
                    int n2 = gsmCellLocation != null ? gsmCellLocation.getCid() : -1;
                    objectArray[1] = n2;
                    objectArray[2] = TelephonyManager.getDefault().getNetworkType();
                    EventLog.writeEvent(50106, objectArray);
                }
                int n3 = 0;
                int n4 = this.droppedDuringPoll.size();
                while (true) {
                    if (n3 >= n4) {
                        this.updatePhoneState();
                        this.phone.notifyPreciseCallStateChanged();
                        this.droppedDuringPoll.clear();
                        return;
                    }
                    this.droppedDuringPoll.get(n3).onRemoteDisconnect(n);
                    ++n3;
                }
            }
            case 2: 
            case 3: {
                this.pollCallsWhenSafe();
                return;
            }
            case 9: {
                this.handleRadioAvailable();
                return;
            }
            case 10: 
        }
        this.handleRadioNotAvailable();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    @Override
    protected void handlePollCalls(AsyncResult asyncResult) {
        int n;
        ArrayList arrayList;
        if (asyncResult.exception == null) {
            arrayList = (ArrayList)asyncResult.result;
        } else {
            if (!this.isCommandExceptionRadioNotAvailable(asyncResult.exception)) {
                this.pollCallsAfterDelay();
                return;
            }
            arrayList = new ArrayList();
        }
        GsmConnection gsmConnection = null;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        int n3 = arrayList.size();
        for (int i = 0; i < (n = this.connections.length); ++i) {
            GsmConnection gsmConnection2 = this.connections[i];
            DriverCall driverCall = null;
            if (n2 < n3) {
                driverCall = (DriverCall)arrayList.get(n2);
                if (driverCall.index == i + 1) {
                    ++n2;
                } else {
                    driverCall = null;
                }
            }
            if (gsmConnection2 == null && driverCall != null) {
                if (this.pendingMO != null && this.pendingMO.compareTo(driverCall)) {
                    this.connections[i] = this.pendingMO;
                    this.pendingMO.index = i;
                    this.pendingMO.update(driverCall);
                    this.pendingMO = null;
                    if (this.hangupPendingMO) {
                        this.hangupPendingMO = false;
                        try {
                            this.log("poll: hangupPendingMO, hangup conn " + i);
                            this.hangup(this.connections[i]);
                            return;
                        }
                        catch (CallStateException callStateException) {
                            Log.e(LOG_TAG, "unexpected error on hangup");
                            return;
                        }
                    }
                } else {
                    GsmConnection gsmConnection3;
                    GsmConnection[] gsmConnectionArray = this.connections;
                    gsmConnectionArray[i] = gsmConnection3 = new GsmConnection(this.phone.getContext(), driverCall, this, i);
                    if (this.connections[i].getCall() == this.ringingCall) {
                        gsmConnection = this.connections[i];
                    } else {
                        Log.i(LOG_TAG, "Phantom call appeared " + driverCall);
                        if (driverCall.state != DriverCall.State.ALERTING && driverCall.state != DriverCall.State.DIALING) {
                            this.connections[i].connectTime = System.currentTimeMillis();
                        }
                        bl2 = true;
                    }
                }
                bl = true;
                continue;
            }
            if (gsmConnection2 != null && driverCall == null) {
                this.droppedDuringPoll.add(gsmConnection2);
                this.connections[i] = null;
                continue;
            }
            if (gsmConnection2 != null && driverCall != null && !gsmConnection2.compareTo(driverCall)) {
                GsmConnection gsmConnection4;
                this.droppedDuringPoll.add(gsmConnection2);
                GsmConnection[] gsmConnectionArray = this.connections;
                gsmConnectionArray[i] = gsmConnection4 = new GsmConnection(this.phone.getContext(), driverCall, this, i);
                if (this.connections[i].getCall() == this.ringingCall) {
                    gsmConnection = this.connections[i];
                }
                bl = true;
                continue;
            }
            if (gsmConnection2 == null || driverCall == null) continue;
            boolean bl3 = gsmConnection2.update(driverCall);
            bl = bl || bl3;
        }
        if (this.pendingMO != null) {
            Log.d(LOG_TAG, "Pending MO dropped before poll fg state:" + (Object)((Object)this.foregroundCall.getState()));
            this.droppedDuringPoll.add(this.pendingMO);
            this.pendingMO = null;
            this.hangupPendingMO = false;
        }
        if (gsmConnection != null) {
            this.phone.notifyNewRingingConnection(gsmConnection);
        }
        for (int i = this.droppedDuringPoll.size() - 1; i >= 0; --i) {
            GsmConnection gsmConnection5 = this.droppedDuringPoll.get(i);
            if (gsmConnection5.isIncoming() && gsmConnection5.getConnectTime() == 0L) {
                Connection.DisconnectCause disconnectCause = gsmConnection5.cause == Connection.DisconnectCause.LOCAL ? Connection.DisconnectCause.INCOMING_REJECTED : Connection.DisconnectCause.INCOMING_MISSED;
                this.log("missed/rejected call, conn.cause=" + (Object)((Object)gsmConnection5.cause));
                this.log("setting cause to " + (Object)((Object)disconnectCause));
                this.droppedDuringPoll.remove(i);
                gsmConnection5.onDisconnect(disconnectCause);
                continue;
            }
            if (gsmConnection5.cause == Connection.DisconnectCause.LOCAL) {
                this.droppedDuringPoll.remove(i);
                gsmConnection5.onDisconnect(Connection.DisconnectCause.LOCAL);
                continue;
            }
            if (gsmConnection5.cause != Connection.DisconnectCause.INVALID_NUMBER) continue;
            this.droppedDuringPoll.remove(i);
            gsmConnection5.onDisconnect(Connection.DisconnectCause.INVALID_NUMBER);
        }
        if (this.droppedDuringPoll.size() > 0) {
            this.cm.getLastCallFailCause(this.obtainNoPollCompleteMessage(5));
        }
        if (gsmConnection != null || bl) {
            this.internalClearDisconnected();
        }
        this.updatePhoneState();
        if (bl2) {
            this.phone.notifyUnknownConnection();
        }
        if (!bl) {
            if (gsmConnection == null) return;
        }
        this.phone.notifyPreciseCallStateChanged();
    }

    /*
     * Enabled aggressive block sorting
     */
    void hangup(GsmCall gsmCall) throws CallStateException {
        if (gsmCall.getConnections().size() == 0) {
            throw new CallStateException("no connections in call");
        }
        if (gsmCall == this.ringingCall) {
            this.log("(ringing) hangup waiting or background");
            this.cm.hangupWaitingOrBackground(this.obtainCompleteMessage());
        } else if (gsmCall == this.foregroundCall) {
            if (gsmCall.isDialingOrAlerting()) {
                this.log("(foregnd) hangup dialing or alerting...");
                this.hangup((GsmConnection)gsmCall.getConnections().get(0));
            } else {
                this.hangupForegroundResumeBackground();
            }
        } else {
            if (gsmCall != this.backgroundCall) {
                throw new RuntimeException("GsmCall " + gsmCall + "does not belong to GsmCallTracker " + this);
            }
            if (this.ringingCall.isRinging()) {
                this.log("hangup all conns in background call");
                this.hangupAllConnections(gsmCall);
            } else {
                this.hangupWaitingOrBackground();
            }
        }
        gsmCall.onHangupLocal();
        this.phone.notifyPreciseCallStateChanged();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void hangup(GsmConnection gsmConnection) throws CallStateException {
        if (gsmConnection.owner != this) {
            throw new CallStateException("GsmConnection " + gsmConnection + "does not belong to GsmCallTracker " + this);
        }
        if (gsmConnection == this.pendingMO) {
            this.log("hangup: set hangupPendingMO to true");
            this.hangupPendingMO = true;
        } else {
            try {
                this.cm.hangupConnection(gsmConnection.getGSMIndex(), this.obtainCompleteMessage());
            }
            catch (CallStateException callStateException) {
                Log.w(LOG_TAG, "GsmCallTracker WARN: hangup() on absent connection " + gsmConnection);
            }
        }
        gsmConnection.onHangupLocal();
    }

    void hangupAllConnections(GsmCall gsmCall) throws CallStateException {
        int n = gsmCall.connections.size();
        for (int i = 0; i < n; ++i) {
            try {
                GsmConnection gsmConnection = (GsmConnection)gsmCall.connections.get(i);
                this.cm.hangupConnection(gsmConnection.getGSMIndex(), this.obtainCompleteMessage());
                continue;
            }
            catch (CallStateException callStateException) {
                Log.e(LOG_TAG, "hangupConnectionByIndex caught " + callStateException);
                break;
            }
        }
    }

    void hangupConnectionByIndex(GsmCall gsmCall, int n) throws CallStateException {
        int n2 = gsmCall.connections.size();
        for (int i = 0; i < n2; ++i) {
            if (((GsmConnection)gsmCall.connections.get(i)).getGSMIndex() != n) continue;
            this.cm.hangupConnection(n, this.obtainCompleteMessage());
            return;
        }
        throw new CallStateException("no gsm index found");
    }

    void hangupForegroundResumeBackground() {
        this.log("hangupForegroundResumeBackground");
        this.cm.hangupForegroundResumeBackground(this.obtainCompleteMessage());
    }

    void hangupWaitingOrBackground() {
        this.log("hangupWaitingOrBackground");
        this.cm.hangupWaitingOrBackground(this.obtainCompleteMessage());
    }

    @Override
    protected void log(String string2) {
        Log.d(LOG_TAG, "[GsmCallTracker] " + string2);
    }

    public void registerForVoiceCallEnded(Handler handler, int n, Object object) {
        Registrant registrant = new Registrant(handler, n, object);
        this.voiceCallEndedRegistrants.add(registrant);
    }

    public void registerForVoiceCallStarted(Handler handler, int n, Object object) {
        Registrant registrant = new Registrant(handler, n, object);
        this.voiceCallStartedRegistrants.add(registrant);
    }

    void rejectCall() throws CallStateException {
        if (this.ringingCall.getState().isRinging()) {
            this.cm.rejectCall(this.obtainCompleteMessage());
            return;
        }
        throw new CallStateException("phone not ringing");
    }

    void separate(GsmConnection gsmConnection) throws CallStateException {
        if (gsmConnection.owner != this) {
            throw new CallStateException("GsmConnection " + gsmConnection + "does not belong to GsmCallTracker " + this);
        }
        try {
            this.cm.separateConnection(gsmConnection.getGSMIndex(), this.obtainCompleteMessage(12));
            return;
        }
        catch (CallStateException callStateException) {
            Log.w(LOG_TAG, "GsmCallTracker WARN: separate() on absent connection " + gsmConnection);
            return;
        }
    }

    void setMute(boolean bl) {
        this.desiredMute = bl;
        this.cm.setMute(this.desiredMute, null);
    }

    void switchWaitingOrHoldingAndActive() throws CallStateException {
        if (this.ringingCall.getState() == Call.State.INCOMING) {
            throw new CallStateException("cannot be in the incoming state");
        }
        this.cm.switchWaitingOrHoldingAndActive(this.obtainCompleteMessage(8));
    }

    public void unregisterForVoiceCallEnded(Handler handler) {
        this.voiceCallEndedRegistrants.remove(handler);
    }

    public void unregisterForVoiceCallStarted(Handler handler) {
        this.voiceCallStartedRegistrants.remove(handler);
    }
}

