/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.Registrant;
import android.os.SystemClock;
import android.telephony.PhoneNumberUtils;
import android.util.Log;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.gsm.GsmCall;
import com.android.internal.telephony.gsm.GsmCallTracker;

public class GsmConnection
extends Connection {
    static final int EVENT_DTMF_DONE = 1;
    static final int EVENT_NEXT_POST_DIAL = 3;
    static final int EVENT_PAUSE_DONE = 2;
    static final int EVENT_WAKE_LOCK_TIMEOUT = 4;
    static final String LOG_TAG = "GSM";
    static final int PAUSE_DELAY_FIRST_MILLIS = 100;
    static final int PAUSE_DELAY_MILLIS = 3000;
    static final int WAKE_LOCK_TIMEOUT_MILLIS = 60000;
    String address;
    Connection.DisconnectCause cause = Connection.DisconnectCause.NOT_DISCONNECTED;
    long connectTime;
    long connectTimeReal;
    long createTime;
    String dialString;
    long disconnectTime;
    boolean disconnected;
    long duration;
    Handler h;
    long holdingStartTime;
    int index;
    boolean isIncoming;
    private PowerManager.WakeLock mPartialWakeLock;
    int nextPostDialChar;
    int numberPresentation;
    GsmCallTracker owner;
    GsmCall parent;
    Connection.PostDialState postDialState = Connection.PostDialState.NOT_STARTED;
    String postDialString;
    UUSInfo uusInfo;

    GsmConnection(Context context, DriverCall driverCall, GsmCallTracker gsmCallTracker, int n) {
        this.numberPresentation = Connection.PRESENTATION_ALLOWED;
        this.createWakeLock(context);
        this.acquireWakeLock();
        this.owner = gsmCallTracker;
        this.h = new MyHandler(this.owner.getLooper());
        this.address = driverCall.number;
        this.isIncoming = driverCall.isMT;
        this.createTime = System.currentTimeMillis();
        this.numberPresentation = driverCall.numberPresentation;
        this.uusInfo = driverCall.uusInfo;
        this.index = n;
        this.parent = this.parentFromDCState(driverCall.state);
        this.parent.attach(this, driverCall);
    }

    GsmConnection(Context context, String string2, GsmCallTracker gsmCallTracker, GsmCall gsmCall) {
        this.numberPresentation = Connection.PRESENTATION_ALLOWED;
        this.createWakeLock(context);
        this.acquireWakeLock();
        this.owner = gsmCallTracker;
        this.h = new MyHandler(this.owner.getLooper());
        this.dialString = string2;
        this.address = PhoneNumberUtils.extractNetworkPortionAlt((String)string2);
        this.postDialString = PhoneNumberUtils.extractPostDialPortion(string2);
        this.index = -1;
        this.isIncoming = false;
        this.createTime = System.currentTimeMillis();
        this.parent = gsmCall;
        gsmCall.attachFake(this, Call.State.DIALING);
    }

    private void acquireWakeLock() {
        this.log("acquireWakeLock");
        this.mPartialWakeLock.acquire();
    }

    private void createWakeLock(Context context) {
        this.mPartialWakeLock = ((PowerManager)context.getSystemService("power")).newWakeLock(1, LOG_TAG);
    }

    static boolean equalsHandlesNulls(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    private boolean isConnectingInOrOut() {
        return this.parent == null || this.parent == this.owner.ringingCall || this.parent.state == Call.State.DIALING || this.parent.state == Call.State.ALERTING;
    }

    private void log(String string2) {
        Log.d(LOG_TAG, "[GSMConn] " + string2);
    }

    private void onStartedHolding() {
        this.holdingStartTime = SystemClock.elapsedRealtime();
    }

    private GsmCall parentFromDCState(DriverCall.State state) {
        switch (1.$SwitchMap$com$android$internal$telephony$DriverCall$State[state.ordinal()]) {
            default: {
                throw new RuntimeException("illegal call state: " + (Object)((Object)state));
            }
            case 1: 
            case 2: 
            case 3: {
                return this.owner.foregroundCall;
            }
            case 4: {
                return this.owner.backgroundCall;
            }
            case 5: 
            case 6: 
        }
        return this.owner.ringingCall;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processNextPostDialChar() {
        Message message;
        char c;
        block7: {
            block6: {
                Registrant registrant;
                if (this.postDialState == Connection.PostDialState.CANCELLED) break block6;
                if (this.postDialString == null || this.postDialString.length() <= this.nextPostDialChar) {
                    this.setPostDialState(Connection.PostDialState.COMPLETE);
                    c = '\u0000';
                } else {
                    this.setPostDialState(Connection.PostDialState.STARTED);
                    String string2 = this.postDialString;
                    int n = this.nextPostDialChar;
                    this.nextPostDialChar = n + 1;
                    c = string2.charAt(n);
                    if (!this.processPostDialChar(c)) {
                        this.h.obtainMessage(3).sendToTarget();
                        Log.e(LOG_TAG, "processNextPostDialChar: c=" + c + " isn't valid!");
                        return;
                    }
                }
                if ((registrant = this.owner.phone.mPostDialHandler) != null && (message = registrant.messageForRegistrant()) != null) break block7;
            }
            return;
        }
        Connection.PostDialState postDialState = this.postDialState;
        AsyncResult asyncResult = AsyncResult.forMessage(message);
        asyncResult.result = this;
        asyncResult.userObj = postDialState;
        message.arg1 = c;
        message.sendToTarget();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean processPostDialChar(char c) {
        if (PhoneNumberUtils.is12Key(c)) {
            this.owner.cm.sendDtmf(c, this.h.obtainMessage(1));
            return true;
        }
        if (c == ',') {
            if (this.nextPostDialChar == 1) {
                this.h.sendMessageDelayed(this.h.obtainMessage(2), 100L);
                return true;
            }
            this.h.sendMessageDelayed(this.h.obtainMessage(2), 3000L);
            return true;
        }
        if (c == ';') {
            this.setPostDialState(Connection.PostDialState.WAIT);
            return true;
        }
        if (c != 'N') return false;
        this.setPostDialState(Connection.PostDialState.WILD);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void releaseWakeLock() {
        PowerManager.WakeLock wakeLock = this.mPartialWakeLock;
        synchronized (wakeLock) {
            if (this.mPartialWakeLock.isHeld()) {
                this.log("releaseWakeLock");
                this.mPartialWakeLock.release();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setPostDialState(Connection.PostDialState postDialState) {
        if (this.postDialState != Connection.PostDialState.STARTED && postDialState == Connection.PostDialState.STARTED) {
            this.acquireWakeLock();
            Message message = this.h.obtainMessage(4);
            this.h.sendMessageDelayed(message, 60000L);
        } else if (this.postDialState == Connection.PostDialState.STARTED && postDialState != Connection.PostDialState.STARTED) {
            this.h.removeMessages(4);
            this.releaseWakeLock();
        }
        this.postDialState = postDialState;
    }

    @Override
    public void cancelPostDial() {
        this.setPostDialState(Connection.PostDialState.CANCELLED);
    }

    boolean compareTo(DriverCall driverCall) {
        if (!this.isIncoming && !driverCall.isMT) {
            return true;
        }
        String string2 = PhoneNumberUtils.stringFromStringAndTOA(driverCall.number, driverCall.TOA);
        return this.isIncoming == driverCall.isMT && GsmConnection.equalsHandlesNulls(this.address, string2);
    }

    Connection.DisconnectCause disconnectCauseFromCode(int n) {
        int n2;
        GSMPhone gSMPhone;
        switch (n) {
            default: {
                gSMPhone = this.owner.phone;
                n2 = gSMPhone.getServiceState().getState();
                if (n2 != 3) break;
                return Connection.DisconnectCause.POWER_OFF;
            }
            case 17: {
                return Connection.DisconnectCause.BUSY;
            }
            case 34: 
            case 41: 
            case 42: 
            case 44: 
            case 49: 
            case 58: {
                return Connection.DisconnectCause.CONGESTION;
            }
            case 68: {
                return Connection.DisconnectCause.LIMIT_EXCEEDED;
            }
            case 240: {
                return Connection.DisconnectCause.CALL_BARRED;
            }
            case 241: {
                return Connection.DisconnectCause.FDN_BLOCKED;
            }
            case 1: {
                return Connection.DisconnectCause.UNOBTAINABLE_NUMBER;
            }
        }
        if (n2 == 1 || n2 == 2) {
            return Connection.DisconnectCause.OUT_OF_SERVICE;
        }
        if (gSMPhone.getIccCard().getState() != IccCard.State.READY) {
            return Connection.DisconnectCause.ICC_ERROR;
        }
        if (n == 65535) {
            if (gSMPhone.mSST.rs.isCsRestricted()) {
                return Connection.DisconnectCause.CS_RESTRICTED;
            }
            if (gSMPhone.mSST.rs.isCsEmergencyRestricted()) {
                return Connection.DisconnectCause.CS_RESTRICTED_EMERGENCY;
            }
            if (gSMPhone.mSST.rs.isCsNormalRestricted()) {
                return Connection.DisconnectCause.CS_RESTRICTED_NORMAL;
            }
            return Connection.DisconnectCause.ERROR_UNSPECIFIED;
        }
        if (n == 16) {
            return Connection.DisconnectCause.NORMAL;
        }
        return Connection.DisconnectCause.ERROR_UNSPECIFIED;
    }

    public void dispose() {
    }

    void fakeHoldBeforeDial() {
        if (this.parent != null) {
            this.parent.detach(this);
        }
        this.parent = this.owner.backgroundCall;
        this.parent.attachFake(this, Call.State.HOLDING);
        this.onStartedHolding();
    }

    protected void finalize() {
        if (this.mPartialWakeLock.isHeld()) {
            Log.e(LOG_TAG, "[GSMConn] UNEXPECTED; mPartialWakeLock is held when finalizing.");
        }
        this.releaseWakeLock();
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public GsmCall getCall() {
        return this.parent;
    }

    @Override
    public long getConnectTime() {
        return this.connectTime;
    }

    @Override
    public long getCreateTime() {
        return this.createTime;
    }

    @Override
    public Connection.DisconnectCause getDisconnectCause() {
        return this.cause;
    }

    @Override
    public long getDisconnectTime() {
        return this.disconnectTime;
    }

    @Override
    public long getDurationMillis() {
        if (this.connectTimeReal == 0L) {
            return 0L;
        }
        if (this.duration == 0L) {
            return SystemClock.elapsedRealtime() - this.connectTimeReal;
        }
        return this.duration;
    }

    int getGSMIndex() throws CallStateException {
        if (this.index >= 0) {
            return 1 + this.index;
        }
        throw new CallStateException("GSM index not yet assigned");
    }

    @Override
    public long getHoldDurationMillis() {
        if (this.getState() != Call.State.HOLDING) {
            return 0L;
        }
        return SystemClock.elapsedRealtime() - this.holdingStartTime;
    }

    @Override
    public int getNumberPresentation() {
        return this.numberPresentation;
    }

    @Override
    public Connection.PostDialState getPostDialState() {
        return this.postDialState;
    }

    @Override
    public String getRemainingPostDialString() {
        if (this.postDialState == Connection.PostDialState.CANCELLED || this.postDialState == Connection.PostDialState.COMPLETE || this.postDialString == null || this.postDialString.length() <= this.nextPostDialChar) {
            return "";
        }
        return this.postDialString.substring(this.nextPostDialChar);
    }

    @Override
    public Call.State getState() {
        if (this.disconnected) {
            return Call.State.DISCONNECTED;
        }
        return super.getState();
    }

    @Override
    public UUSInfo getUUSInfo() {
        return this.uusInfo;
    }

    @Override
    public void hangup() throws CallStateException {
        if (!this.disconnected) {
            this.owner.hangup(this);
            return;
        }
        throw new CallStateException("disconnected");
    }

    @Override
    public boolean isIncoming() {
        return this.isIncoming;
    }

    void onConnectedInOrOut() {
        this.connectTime = System.currentTimeMillis();
        this.connectTimeReal = SystemClock.elapsedRealtime();
        this.duration = 0L;
        this.log("onConnectedInOrOut: connectTime=" + this.connectTime);
        if (!this.isIncoming) {
            this.processNextPostDialChar();
        }
        this.releaseWakeLock();
    }

    void onDisconnect(Connection.DisconnectCause disconnectCause) {
        this.cause = disconnectCause;
        if (!this.disconnected) {
            this.index = -1;
            this.disconnectTime = System.currentTimeMillis();
            this.duration = SystemClock.elapsedRealtime() - this.connectTimeReal;
            this.disconnected = true;
            Log.d(LOG_TAG, "[GSMConn] onDisconnect: cause=" + (Object)((Object)disconnectCause));
            this.owner.phone.notifyDisconnect(this);
            if (this.parent != null) {
                this.parent.connectionDisconnected(this);
            }
        }
        this.releaseWakeLock();
    }

    void onHangupLocal() {
        this.cause = Connection.DisconnectCause.LOCAL;
    }

    void onRemoteDisconnect(int n) {
        this.onDisconnect(this.disconnectCauseFromCode(n));
    }

    @Override
    public void proceedAfterWaitChar() {
        if (this.postDialState != Connection.PostDialState.WAIT) {
            Log.w(LOG_TAG, "GsmConnection.proceedAfterWaitChar(): Expected getPostDialState() to be WAIT but was " + (Object)((Object)this.postDialState));
            return;
        }
        this.setPostDialState(Connection.PostDialState.STARTED);
        this.processNextPostDialChar();
    }

    @Override
    public void proceedAfterWildChar(String string2) {
        if (this.postDialState != Connection.PostDialState.WILD) {
            Log.w(LOG_TAG, "GsmConnection.proceedAfterWaitChar(): Expected getPostDialState() to be WILD but was " + (Object)((Object)this.postDialState));
            return;
        }
        this.setPostDialState(Connection.PostDialState.STARTED);
        StringBuilder stringBuilder = new StringBuilder(string2);
        stringBuilder.append(this.postDialString.substring(this.nextPostDialChar));
        this.postDialString = stringBuilder.toString();
        this.nextPostDialChar = 0;
        this.log("proceedAfterWildChar: new postDialString is " + this.postDialString);
        this.processNextPostDialChar();
    }

    @Override
    public void separate() throws CallStateException {
        if (!this.disconnected) {
            this.owner.separate(this);
            return;
        }
        throw new CallStateException("disconnected");
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean update(DriverCall driverCall) {
        boolean bl;
        boolean bl2 = this.isConnectingInOrOut();
        boolean bl3 = this.getState() == Call.State.HOLDING;
        GsmCall gsmCall = this.parentFromDCState(driverCall.state);
        boolean bl4 = GsmConnection.equalsHandlesNulls(this.address, driverCall.number);
        boolean bl5 = false;
        if (!bl4) {
            this.log("update: phone # changed!");
            this.address = driverCall.number;
            bl5 = true;
        }
        if (gsmCall != this.parent) {
            if (this.parent != null) {
                this.parent.detach(this);
            }
            gsmCall.attach(this, driverCall);
            this.parent = gsmCall;
            bl = true;
        } else {
            boolean bl6 = this.parent.update(this, driverCall);
            bl = bl5 || bl6;
        }
        StringBuilder stringBuilder = new StringBuilder().append("update: parent=").append(this.parent).append(", hasNewParent=");
        boolean bl7 = gsmCall != this.parent;
        this.log(stringBuilder.append(bl7).append(", wasConnectingInOrOut=").append(bl2).append(", wasHolding=").append(bl3).append(", isConnectingInOrOut=").append(this.isConnectingInOrOut()).append(", changed=").append(bl).toString());
        if (bl2 && !this.isConnectingInOrOut()) {
            this.onConnectedInOrOut();
        }
        if (bl && !bl3 && this.getState() == Call.State.HOLDING) {
            this.onStartedHolding();
        }
        return bl;
    }

    class MyHandler
    extends Handler {
        MyHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    return;
                }
                case 1: 
                case 2: 
                case 3: {
                    GsmConnection.this.processNextPostDialChar();
                    return;
                }
                case 4: 
            }
            GsmConnection.this.releaseWakeLock();
        }
    }
}

