/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.os.Message;
import android.util.Log;
import android.util.Patterns;
import com.android.internal.telephony.DataConnection;
import com.android.internal.telephony.gsm.ApnSetting;
import com.android.internal.telephony.gsm.GSMPhone;

public class GsmDataConnection
extends DataConnection {
    private static final String LOG_TAG = "GSM";
    private static final int PDP_FAIL_ACTIVATION_REJECT_GGSN = 30;
    private static final int PDP_FAIL_ACTIVATION_REJECT_UNSPECIFIED = 31;
    private static final int PDP_FAIL_ERROR_UNSPECIFIED = 65535;
    private static final int PDP_FAIL_GPRS_REGISTRATION_FAIL = -2;
    private static final int PDP_FAIL_INSUFFICIENT_RESOURCES = 26;
    private static final int PDP_FAIL_MISSING_UKNOWN_APN = 27;
    private static final int PDP_FAIL_NSAPI_IN_USE = 35;
    private static final int PDP_FAIL_OPERATOR_BARRED = 8;
    private static final int PDP_FAIL_PROTOCOL_ERRORS = 111;
    private static final int PDP_FAIL_REGISTRATION_FAIL = -1;
    private static final int PDP_FAIL_SERVICE_OPTION_NOT_SUBSCRIBED = 33;
    private static final int PDP_FAIL_SERVICE_OPTION_NOT_SUPPORTED = 32;
    private static final int PDP_FAIL_SERVICE_OPTION_OUT_OF_ORDER = 34;
    private static final int PDP_FAIL_UNKNOWN_PDP_ADDRESS_TYPE = 28;
    private static final int PDP_FAIL_USER_AUTHENTICATION = 29;
    private ApnSetting apn;

    private GsmDataConnection(GSMPhone gSMPhone, String string2) {
        super(gSMPhone, string2);
    }

    private boolean isIpAddress(String string2) {
        if (string2 == null) {
            return false;
        }
        return Patterns.IP_ADDRESS.matcher(this.apn.mmsProxy).matches();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static GsmDataConnection makeDataConnection(GSMPhone gSMPhone) {
        Object object = mCountLock;
        synchronized (object) {
            mCount = 1 + mCount;
        }
        GsmDataConnection gsmDataConnection = new GsmDataConnection(gSMPhone, "GsmDataConnection-" + mCount);
        gsmDataConnection.start();
        gsmDataConnection.log("Made " + gsmDataConnection.getName());
        return gsmDataConnection;
    }

    private void setHttpProxy(String string2, String string3) {
        if (string2 == null || string2.length() == 0) {
            this.phone.setSystemProperty("net.gprs.http-proxy", null);
            return;
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "8080";
        }
        this.phone.setSystemProperty("net.gprs.http-proxy", "http://" + string2 + ":" + string3 + "/");
    }

    @Override
    protected void clearSettings() {
        super.clearSettings();
        this.apn = null;
    }

    public ApnSetting getApn() {
        return this.apn;
    }

    @Override
    protected DataConnection.FailCause getFailCauseFromRequest(int n) {
        switch (n) {
            default: {
                return DataConnection.FailCause.UNKNOWN;
            }
            case 8: {
                return DataConnection.FailCause.OPERATOR_BARRED;
            }
            case 26: {
                return DataConnection.FailCause.INSUFFICIENT_RESOURCES;
            }
            case 27: {
                return DataConnection.FailCause.MISSING_UNKNOWN_APN;
            }
            case 28: {
                return DataConnection.FailCause.UNKNOWN_PDP_ADDRESS;
            }
            case 29: {
                return DataConnection.FailCause.USER_AUTHENTICATION;
            }
            case 30: {
                return DataConnection.FailCause.ACTIVATION_REJECT_GGSN;
            }
            case 31: {
                return DataConnection.FailCause.ACTIVATION_REJECT_UNSPECIFIED;
            }
            case 34: {
                return DataConnection.FailCause.SERVICE_OPTION_OUT_OF_ORDER;
            }
            case 32: {
                return DataConnection.FailCause.SERVICE_OPTION_NOT_SUPPORTED;
            }
            case 33: {
                return DataConnection.FailCause.SERVICE_OPTION_NOT_SUBSCRIBED;
            }
            case 35: {
                return DataConnection.FailCause.NSAPI_IN_USE;
            }
            case 111: {
                return DataConnection.FailCause.PROTOCOL_ERRORS;
            }
            case 65535: {
                return DataConnection.FailCause.UNKNOWN;
            }
            case -1: {
                return DataConnection.FailCause.REGISTRATION_FAIL;
            }
            case -2: 
        }
        return DataConnection.FailCause.GPRS_REGISTRATION_FAIL;
    }

    @Override
    protected boolean isDnsOk(String[] stringArray) {
        return !"0.0.0.0".equals(this.dnsServers[0]) || !"0.0.0.0".equals(this.dnsServers[1]) || ((GSMPhone)this.phone).isDnsCheckDisabled() || this.apn.types[0].equals("mms") && this.isIpAddress(this.apn.mmsProxy);
    }

    @Override
    protected void log(String string2) {
        Log.d(LOG_TAG, "[" + this.getName() + "] " + string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onConnect(DataConnection.ConnectionParams connectionParams) {
        this.apn = connectionParams.apn;
        this.log("Connecting to carrier: '" + this.apn.carrier + "' APN: '" + this.apn.apn + "' proxy: '" + this.apn.proxy + "' port: '" + this.apn.port);
        this.setHttpProxy(this.apn.proxy, this.apn.port);
        this.createTime = -1L;
        this.lastFailTime = -1L;
        this.lastFailCause = DataConnection.FailCause.NONE;
        Message message = this.obtainMessage(3, connectionParams);
        message.obj = connectionParams;
        int n = this.apn.authType;
        if (n == -1) {
            n = this.apn.user != null ? 3 : 0;
        }
        this.phone.mCM.setupDataCall(Integer.toString(1), Integer.toString(0), this.apn.apn, this.apn.user, this.apn.password, Integer.toString(n), message);
    }

    @Override
    public String toString() {
        return "State=" + this.getCurrentState().getName() + " Apn=" + this.apn + " create=" + this.createTime + " lastFail=" + this.lastFailTime + " lastFailCause=" + (Object)((Object)this.lastFailCause);
    }
}

