/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.IConnectivityManager;
import android.net.NetworkInfo;
import android.net.TrafficStats;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Message;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.provider.Telephony;
import android.telephony.TelephonyManager;
import android.telephony.gsm.GsmCellLocation;
import android.util.EventLog;
import android.util.Log;
import com.android.internal.telephony.DataCallState;
import com.android.internal.telephony.DataConnection;
import com.android.internal.telephony.DataConnectionTracker;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.RetryManager;
import com.android.internal.telephony.gsm.ApnSetting;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.gsm.GsmDataConnection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public final class GsmDataConnectionTracker
extends DataConnectionTracker {
    protected static final int APN_DELAY_MILLIS = 5000;
    static final String APN_ID = "apn_id";
    private static final String INTENT_RECONNECT_ALARM = "com.android.internal.telephony.gprs-reconnect";
    private static final String INTENT_RECONNECT_ALARM_EXTRA_REASON = "reason";
    private static final int PDP_CONNECTION_POOL_SIZE = 1;
    private static final int POLL_PDP_MILLIS = 5000;
    static final Uri PREFERAPN_URI = Uri.parse("content://telephony/carriers/preferapn");
    protected final String LOG_TAG;
    private ArrayList<ApnSetting> allApns = null;
    private ApnChangeObserver apnObserver;
    private boolean canSetPreferApn = false;
    boolean failNextConnect = false;
    protected ApnSetting mActiveApn;
    private GsmDataConnection mActivePdp;
    private RetryManager mDefaultRetryManager;
    private GSMPhone mGsmPhone;
    BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            String string2 = intent.getAction();
            if (!string2.equals("android.intent.action.SCREEN_ON")) {
                if (string2.equals("android.intent.action.SCREEN_OFF")) {
                    GsmDataConnectionTracker.access$102(GsmDataConnectionTracker.this, false);
                    GsmDataConnectionTracker.this.stopNetStatPoll();
                    GsmDataConnectionTracker.this.startNetStatPoll();
                    return;
                }
                if (string2.equals(GsmDataConnectionTracker.INTENT_RECONNECT_ALARM)) {
                    Log.d("GSM", "GPRS reconnect alarm. Previous state was " + (Object)((Object)GsmDataConnectionTracker.this.state));
                    String string3 = intent.getStringExtra(GsmDataConnectionTracker.INTENT_RECONNECT_ALARM_EXTRA_REASON);
                    if (GsmDataConnectionTracker.this.state == DataConnectionTracker.State.FAILED) {
                        Message message = GsmDataConnectionTracker.this.obtainMessage(34);
                        message.arg1 = 0;
                        message.obj = string3;
                        GsmDataConnectionTracker.this.sendMessage(message);
                    }
                    GsmDataConnectionTracker.this.sendMessage(GsmDataConnectionTracker.this.obtainMessage(5));
                    return;
                }
                if (string2.equals("android.net.wifi.STATE_CHANGE")) {
                    NetworkInfo networkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                    GsmDataConnectionTracker gsmDataConnectionTracker = GsmDataConnectionTracker.this;
                    boolean bl = networkInfo != null && networkInfo.isConnected();
                    GsmDataConnectionTracker.access$402(gsmDataConnectionTracker, bl);
                    return;
                }
                if (!string2.equals("android.net.wifi.WIFI_STATE_CHANGED")) return;
                if (intent.getIntExtra("wifi_state", 4) == 3) {
                    return;
                }
                boolean bl = false;
                if (bl) return;
                GsmDataConnectionTracker.access$502(GsmDataConnectionTracker.this, false);
                return;
            }
            GsmDataConnectionTracker.access$102(GsmDataConnectionTracker.this, true);
            GsmDataConnectionTracker.this.stopNetStatPoll();
            GsmDataConnectionTracker.this.startNetStatPoll();
        }
    };
    private boolean mIsPsRestricted = false;
    private boolean mIsScreenOn = true;
    private int mPdpResetCount = 0;
    private boolean mPingTestActive = false;
    private Runnable mPollNetStat = new Runnable(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void run() {
            long l = GsmDataConnectionTracker.this.txPkts;
            long l2 = GsmDataConnectionTracker.this.rxPkts;
            GsmDataConnectionTracker.access$802(GsmDataConnectionTracker.this, TrafficStats.getMobileTxPackets());
            GsmDataConnectionTracker.access$902(GsmDataConnectionTracker.this, TrafficStats.getMobileRxPackets());
            if (GsmDataConnectionTracker.this.netStatPollEnabled && (l > 0L || l2 > 0L)) {
                DataConnectionTracker.Activity activity;
                long l3 = GsmDataConnectionTracker.this.txPkts - l;
                long l4 = GsmDataConnectionTracker.this.rxPkts - l2;
                if (l3 > 0L && l4 > 0L) {
                    GsmDataConnectionTracker.access$1302(GsmDataConnectionTracker.this, 0L);
                    activity = DataConnectionTracker.Activity.DATAINANDOUT;
                    GsmDataConnectionTracker.access$1402(GsmDataConnectionTracker.this, 0);
                } else if (l3 > 0L && l4 == 0L) {
                    if (GsmDataConnectionTracker.this.phone.getState() == Phone.State.IDLE) {
                        GsmDataConnectionTracker.access$1614(GsmDataConnectionTracker.this, l3);
                    } else {
                        GsmDataConnectionTracker.access$1702(GsmDataConnectionTracker.this, 0L);
                    }
                    activity = DataConnectionTracker.Activity.DATAOUT;
                } else if (l3 == 0L && l4 > 0L) {
                    GsmDataConnectionTracker.access$1802(GsmDataConnectionTracker.this, 0L);
                    activity = DataConnectionTracker.Activity.DATAIN;
                    GsmDataConnectionTracker.access$1402(GsmDataConnectionTracker.this, 0);
                } else if (l3 == 0L && l4 == 0L) {
                    activity = DataConnectionTracker.Activity.NONE;
                } else {
                    GsmDataConnectionTracker.access$1902(GsmDataConnectionTracker.this, 0L);
                    activity = DataConnectionTracker.Activity.NONE;
                }
                if (GsmDataConnectionTracker.this.activity != activity && GsmDataConnectionTracker.this.mIsScreenOn) {
                    GsmDataConnectionTracker.access$2102(GsmDataConnectionTracker.this, activity);
                    GsmDataConnectionTracker.this.phone.notifyDataActivity();
                }
            }
            int n = Settings.Secure.getInt(GsmDataConnectionTracker.this.mResolver, "pdp_watchdog_trigger_packet_count", 10);
            if (GsmDataConnectionTracker.this.sentSinceLastRecv >= (long)n) {
                if (GsmDataConnectionTracker.this.mNoRecvPollCount == 0) {
                    EventLog.writeEvent(50101, GsmDataConnectionTracker.this.sentSinceLastRecv);
                }
                int n2 = Settings.Secure.getInt(GsmDataConnectionTracker.this.mResolver, "pdp_watchdog_error_poll_count", 24);
                if (GsmDataConnectionTracker.this.mNoRecvPollCount < n2) {
                    ((GsmDataConnectionTracker)GsmDataConnectionTracker.this).phone.mCM.getDataCallList(GsmDataConnectionTracker.this.obtainMessage(11));
                    GsmDataConnectionTracker.access$2908(GsmDataConnectionTracker.this);
                    GsmDataConnectionTracker.access$3002(GsmDataConnectionTracker.this, Settings.Secure.getInt(GsmDataConnectionTracker.this.mResolver, "pdp_watchdog_error_poll_interval_ms", 5000));
                } else {
                    GsmDataConnectionTracker.this.stopNetStatPoll();
                    Thread thread = new Thread(){

                        @Override
                        public void run() {
                            GsmDataConnectionTracker.this.runPingTest();
                        }
                    };
                    GsmDataConnectionTracker.access$3202(GsmDataConnectionTracker.this, true);
                    thread.start();
                }
            } else {
                GsmDataConnectionTracker.access$3302(GsmDataConnectionTracker.this, 0);
                if (GsmDataConnectionTracker.this.mIsScreenOn) {
                    GsmDataConnectionTracker.access$3402(GsmDataConnectionTracker.this, Settings.Secure.getInt(GsmDataConnectionTracker.this.mResolver, "pdp_watchdog_poll_interval_ms", 1000));
                } else {
                    GsmDataConnectionTracker.access$3502(GsmDataConnectionTracker.this, Settings.Secure.getInt(GsmDataConnectionTracker.this.mResolver, "pdp_watchdog_long_poll_interval_ms", 600000));
                }
            }
            if (GsmDataConnectionTracker.this.netStatPollEnabled) {
                GsmDataConnectionTracker.this.mDataConnectionTracker.postDelayed(this, GsmDataConnectionTracker.this.netStatPollPeriod);
            }
        }
    };
    private boolean mReregisterOnReconnectFailure = false;
    private ContentResolver mResolver;
    private RetryManager mSecondaryRetryManager;
    private boolean noAutoAttach = false;
    private ArrayList<DataConnection> pdpList;
    private ApnSetting preferredApn = null;
    private ArrayList<ApnSetting> waitingApns = null;
    private int waitingApnsPermanentFailureCountDown = 0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    GsmDataConnectionTracker(GSMPhone gSMPhone) {
        super(gSMPhone);
        this.LOG_TAG = "GSM";
        this.mGsmPhone = gSMPhone;
        gSMPhone.mCM.registerForAvailable(this, 3, null);
        gSMPhone.mCM.registerForOffOrNotAvailable(this, 12, null);
        gSMPhone.mSIMRecords.registerForRecordsLoaded(this, 4, null);
        gSMPhone.mCM.registerForDataStateChanged(this, 6, null);
        gSMPhone.mCT.registerForVoiceCallEnded(this, 15, null);
        gSMPhone.mCT.registerForVoiceCallStarted(this, 14, null);
        gSMPhone.mSST.registerForGprsAttached(this, 26, null);
        gSMPhone.mSST.registerForGprsDetached(this, 19, null);
        gSMPhone.mSST.registerForRoamingOn(this, 21, null);
        gSMPhone.mSST.registerForRoamingOff(this, 22, null);
        gSMPhone.mSST.registerForPsRestrictedEnabled(this, 32, null);
        gSMPhone.mSST.registerForPsRestrictedDisabled(this, 33, null);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(INTENT_RECONNECT_ALARM);
        intentFilter.addAction("android.intent.action.SCREEN_ON");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        intentFilter.addAction("android.net.wifi.STATE_CHANGE");
        intentFilter.addAction("android.net.wifi.WIFI_STATE_CHANGED");
        gSMPhone.getContext().registerReceiver(this.mIntentReceiver, intentFilter, null, gSMPhone);
        this.mDataConnectionTracker = this;
        this.mResolver = this.phone.getContext().getContentResolver();
        this.apnObserver = new ApnChangeObserver();
        gSMPhone.getContext().getContentResolver().registerContentObserver(Telephony.Carriers.CONTENT_URI, true, this.apnObserver);
        this.createAllPdpList();
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences(this.phone.getContext());
        boolean bl = true;
        try {
            boolean bl2;
            bl = bl2 = IConnectivityManager.Stub.asInterface(ServiceManager.getService("connectivity")).getMobileDataEnabled();
        }
        catch (Exception exception) {}
        boolean[] blArray = this.dataEnabled;
        boolean bl3 = !sharedPreferences.getBoolean("disabled_on_boot_key", false) && bl;
        blArray[0] = bl3;
        if (this.dataEnabled[0]) {
            this.enabledCount = 1 + this.enabledCount;
        }
        boolean bl4 = !this.dataEnabled[0];
        this.noAutoAttach = bl4;
        if (!this.mRetryMgr.configure(SystemProperties.get("ro.gsm.data_retry_config")) && !this.mRetryMgr.configure("default_randomization=2000,5000,10000,20000,40000,80000:5000,160000:5000,320000:5000,640000:5000,1280000:5000,1800000:5000")) {
            Log.e("GSM", "Could not configure using DEFAULT_DATA_RETRY_CONFIG=default_randomization=2000,5000,10000,20000,40000,80000:5000,160000:5000,320000:5000,640000:5000,1280000:5000,1800000:5000");
            this.mRetryMgr.configure(20, 2000, 1000);
        }
        this.mDefaultRetryManager = this.mRetryMgr;
        this.mSecondaryRetryManager = new RetryManager();
        if (!this.mSecondaryRetryManager.configure(SystemProperties.get("ro.gsm.2nd_data_retry_config")) && !this.mSecondaryRetryManager.configure("max_retries=3, 5000, 5000, 5000")) {
            Log.e("GSM", "Could note configure using SECONDARY_DATA_RETRY_CONFIG=max_retries=3, 5000, 5000, 5000");
            this.mSecondaryRetryManager.configure("max_retries=3, 333, 333, 333");
        }
    }

    static /* synthetic */ boolean access$102(GsmDataConnectionTracker gsmDataConnectionTracker, boolean bl) {
        gsmDataConnectionTracker.mIsScreenOn = bl;
        return bl;
    }

    static /* synthetic */ long access$1302(GsmDataConnectionTracker gsmDataConnectionTracker, long l) {
        gsmDataConnectionTracker.sentSinceLastRecv = l;
        return l;
    }

    static /* synthetic */ int access$1402(GsmDataConnectionTracker gsmDataConnectionTracker, int n) {
        gsmDataConnectionTracker.mPdpResetCount = n;
        return n;
    }

    static /* synthetic */ long access$1614(GsmDataConnectionTracker gsmDataConnectionTracker, long l) {
        long l2;
        gsmDataConnectionTracker.sentSinceLastRecv = l2 = l + gsmDataConnectionTracker.sentSinceLastRecv;
        return l2;
    }

    static /* synthetic */ long access$1702(GsmDataConnectionTracker gsmDataConnectionTracker, long l) {
        gsmDataConnectionTracker.sentSinceLastRecv = l;
        return l;
    }

    static /* synthetic */ long access$1802(GsmDataConnectionTracker gsmDataConnectionTracker, long l) {
        gsmDataConnectionTracker.sentSinceLastRecv = l;
        return l;
    }

    static /* synthetic */ long access$1902(GsmDataConnectionTracker gsmDataConnectionTracker, long l) {
        gsmDataConnectionTracker.sentSinceLastRecv = l;
        return l;
    }

    static /* synthetic */ DataConnectionTracker.Activity access$2102(GsmDataConnectionTracker gsmDataConnectionTracker, DataConnectionTracker.Activity activity) {
        gsmDataConnectionTracker.activity = activity;
        return activity;
    }

    static /* synthetic */ int access$2908(GsmDataConnectionTracker gsmDataConnectionTracker) {
        int n = gsmDataConnectionTracker.mNoRecvPollCount;
        gsmDataConnectionTracker.mNoRecvPollCount = n + 1;
        return n;
    }

    static /* synthetic */ int access$3002(GsmDataConnectionTracker gsmDataConnectionTracker, int n) {
        gsmDataConnectionTracker.netStatPollPeriod = n;
        return n;
    }

    static /* synthetic */ boolean access$3202(GsmDataConnectionTracker gsmDataConnectionTracker, boolean bl) {
        gsmDataConnectionTracker.mPingTestActive = bl;
        return bl;
    }

    static /* synthetic */ int access$3302(GsmDataConnectionTracker gsmDataConnectionTracker, int n) {
        gsmDataConnectionTracker.mNoRecvPollCount = n;
        return n;
    }

    static /* synthetic */ int access$3402(GsmDataConnectionTracker gsmDataConnectionTracker, int n) {
        gsmDataConnectionTracker.netStatPollPeriod = n;
        return n;
    }

    static /* synthetic */ int access$3502(GsmDataConnectionTracker gsmDataConnectionTracker, int n) {
        gsmDataConnectionTracker.netStatPollPeriod = n;
        return n;
    }

    static /* synthetic */ boolean access$402(GsmDataConnectionTracker gsmDataConnectionTracker, boolean bl) {
        gsmDataConnectionTracker.mIsWifiConnected = bl;
        return bl;
    }

    static /* synthetic */ boolean access$502(GsmDataConnectionTracker gsmDataConnectionTracker, boolean bl) {
        gsmDataConnectionTracker.mIsWifiConnected = bl;
        return bl;
    }

    static /* synthetic */ long access$802(GsmDataConnectionTracker gsmDataConnectionTracker, long l) {
        gsmDataConnectionTracker.txPkts = l;
        return l;
    }

    static /* synthetic */ long access$902(GsmDataConnectionTracker gsmDataConnectionTracker, long l) {
        gsmDataConnectionTracker.rxPkts = l;
        return l;
    }

    private String apnListToString(ArrayList<ApnSetting> arrayList) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append('[').append(arrayList.get(i).toString()).append(']');
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private ArrayList<ApnSetting> buildWaitingApns() {
        ArrayList<ApnSetting> arrayList = new ArrayList<ApnSetting>();
        if (this.mRequestedApnType.equals("dun")) {
            ApnSetting apnSetting = this.fetchDunApn();
            if (apnSetting == null) return arrayList;
            arrayList.add(apnSetting);
            return arrayList;
        } else {
            String string2 = this.mGsmPhone.mSIMRecords.getSIMOperatorNumeric();
            if (this.mRequestedApnType.equals("default") && this.canSetPreferApn && this.preferredApn != null) {
                Log.i("GSM", "Preferred APN:" + string2 + ":" + this.preferredApn.numeric + ":" + this.preferredApn);
                if (this.preferredApn.numeric.equals(string2)) {
                    Log.i("GSM", "Waiting APN set to preferred APN");
                    arrayList.add(this.preferredApn);
                    return arrayList;
                }
                this.setPreferredApn(-1);
                this.preferredApn = null;
            }
            if (this.allApns == null) return arrayList;
            for (ApnSetting apnSetting : this.allApns) {
                if (!apnSetting.canHandleType(this.mRequestedApnType)) continue;
                arrayList.add(apnSetting);
            }
        }
        return arrayList;
    }

    private void cleanUpConnection(boolean bl, String string2) {
        if (this.mReconnectIntent != null) {
            ((AlarmManager)this.phone.getContext().getSystemService("alarm")).cancel(this.mReconnectIntent);
            this.mReconnectIntent = null;
        }
        this.setState(DataConnectionTracker.State.DISCONNECTING);
        boolean bl2 = false;
        for (DataConnection dataConnection : this.pdpList) {
            if (bl) {
                dataConnection.disconnect(this.obtainMessage(25, string2));
                bl2 = true;
                continue;
            }
            dataConnection.resetSynchronously();
            bl2 = false;
        }
        this.stopNetStatPoll();
        if (!bl2) {
            this.gotoIdleAndNotifyDataConnection(string2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void createAllApnList() {
        this.allApns = new ArrayList();
        String string2 = this.mGsmPhone.mSIMRecords.getSIMOperatorNumeric();
        if (string2 != null) {
            String string3 = "numeric = '" + string2 + "'";
            Cursor cursor = this.phone.getContext().getContentResolver().query(Telephony.Carriers.CONTENT_URI, null, string3, null, null);
            if (cursor != null) {
                if (cursor.getCount() > 0) {
                    this.allApns = this.createApnList(cursor);
                }
                cursor.close();
            }
        }
        if (this.allApns.isEmpty()) {
            this.preferredApn = null;
            this.notifyNoData(DataConnection.FailCause.MISSING_UNKNOWN_APN);
            return;
        } else {
            this.preferredApn = this.getPreferredApn();
            Log.d("GSM", "Get PreferredAPN");
            if (this.preferredApn == null || this.preferredApn.numeric.equals(string2)) return;
            this.preferredApn = null;
            this.setPreferredApn(-1);
            return;
        }
    }

    private void createAllPdpList() {
        this.pdpList = new ArrayList();
        for (int i = 0; i < 1; ++i) {
            GsmDataConnection gsmDataConnection = GsmDataConnection.makeDataConnection(this.mGsmPhone);
            this.pdpList.add(gsmDataConnection);
        }
    }

    private ArrayList<ApnSetting> createApnList(Cursor cursor) {
        ArrayList<ApnSetting> arrayList = new ArrayList<ApnSetting>();
        if (cursor.moveToFirst()) {
            do {
                String[] stringArray = this.parseTypes(cursor.getString(cursor.getColumnIndexOrThrow("type")));
                arrayList.add(new ApnSetting(cursor.getInt(cursor.getColumnIndexOrThrow("_id")), cursor.getString(cursor.getColumnIndexOrThrow("numeric")), cursor.getString(cursor.getColumnIndexOrThrow("name")), cursor.getString(cursor.getColumnIndexOrThrow("apn")), cursor.getString(cursor.getColumnIndexOrThrow("proxy")), cursor.getString(cursor.getColumnIndexOrThrow("port")), cursor.getString(cursor.getColumnIndexOrThrow("mmsc")), cursor.getString(cursor.getColumnIndexOrThrow("mmsproxy")), cursor.getString(cursor.getColumnIndexOrThrow("mmsport")), cursor.getString(cursor.getColumnIndexOrThrow("user")), cursor.getString(cursor.getColumnIndexOrThrow("password")), cursor.getInt(cursor.getColumnIndexOrThrow("authtype")), stringArray));
            } while (cursor.moveToNext());
        }
        return arrayList;
    }

    private void destroyAllPdpList() {
        if (this.pdpList != null) {
            this.pdpList.removeAll(this.pdpList);
        }
    }

    private void doRecovery() {
        block3: {
            block2: {
                if (this.state != DataConnectionTracker.State.CONNECTED) break block2;
                int n = Settings.Secure.getInt(this.mResolver, "pdp_watchdog_max_pdp_reset_fail_count", 3);
                if (this.mPdpResetCount >= n) break block3;
                this.mPdpResetCount = 1 + this.mPdpResetCount;
                EventLog.writeEvent(50102, this.sentSinceLastRecv);
                this.cleanUpConnection(true, "pdpReset");
            }
            return;
        }
        this.mPdpResetCount = 0;
        EventLog.writeEvent(50104, this.sentSinceLastRecv);
        this.mGsmPhone.mSST.reRegisterNetwork(null);
    }

    private ApnSetting fetchDunApn() {
        Context context = this.phone.getContext();
        ApnSetting apnSetting = ApnSetting.fromString(Settings.Secure.getString(context.getContentResolver(), "tether_dun_apn"));
        if (apnSetting != null) {
            return apnSetting;
        }
        return ApnSetting.fromString(context.getResources().getString(17039383));
    }

    private GsmDataConnection findFreePdp() {
        for (GsmDataConnection gsmDataConnection : this.pdpList) {
            if (!gsmDataConnection.isInactive()) continue;
            return gsmDataConnection;
        }
        return null;
    }

    private ApnSetting getNextApn() {
        ArrayList<ApnSetting> arrayList = this.waitingApns;
        ApnSetting apnSetting = null;
        if (arrayList != null) {
            boolean bl = arrayList.isEmpty();
            apnSetting = null;
            if (!bl) {
                apnSetting = arrayList.get(0);
            }
        }
        return apnSetting;
    }

    /*
     * Enabled aggressive block sorting
     */
    private ApnSetting getPreferredApn() {
        if (this.allApns.isEmpty()) {
            return null;
        }
        Cursor cursor = this.phone.getContext().getContentResolver().query(PREFERAPN_URI, new String[]{"_id", "name", "apn"}, null, null, "name ASC");
        this.canSetPreferApn = cursor != null;
        if (this.canSetPreferApn && cursor.getCount() > 0) {
            cursor.moveToFirst();
            int n = cursor.getInt(cursor.getColumnIndexOrThrow("_id"));
            for (ApnSetting apnSetting : this.allApns) {
                if (apnSetting.id != n || !apnSetting.canHandleType(this.mRequestedApnType)) continue;
                cursor.close();
                return apnSetting;
            }
        }
        if (cursor != null) {
            cursor.close();
        }
        return null;
    }

    private void gotoIdleAndNotifyDataConnection(String string2) {
        this.setState(DataConnectionTracker.State.IDLE);
        this.phone.notifyDataConnection(string2);
        this.mActiveApn = null;
    }

    private boolean isDataAllowed() {
        boolean bl = this.phone.getServiceState().getRoaming();
        return this.getAnyDataEnabled() && (!bl || this.getDataOnRoamingEnabled()) && this.mMasterDataEnabled;
    }

    private void notifyDefaultData(String string2) {
        this.setState(DataConnectionTracker.State.CONNECTED);
        this.phone.notifyDataConnection(string2);
        this.startNetStatPoll();
        this.mRetryMgr.resetRetryCount();
        this.mReregisterOnReconnectFailure = false;
    }

    private void notifyNoData(DataConnection.FailCause failCause) {
        this.setState(DataConnectionTracker.State.FAILED);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onApnChanged() {
        boolean bl = this.state != DataConnectionTracker.State.IDLE && this.state != DataConnectionTracker.State.FAILED;
        this.mGsmPhone.updateCurrentCarrierInProvider();
        this.createAllApnList();
        if (this.state != DataConnectionTracker.State.DISCONNECTING) {
            this.cleanUpConnection(bl, "apnChanged");
            if (!bl) {
                this.mRetryMgr.resetRetryCount();
                this.mReregisterOnReconnectFailure = false;
                this.trySetupData("apnChanged");
            }
        }
    }

    private void onGprsAttached() {
        if (this.state == DataConnectionTracker.State.CONNECTED) {
            this.startNetStatPoll();
            this.phone.notifyDataConnection("gprsAttached");
            return;
        }
        if (this.state == DataConnectionTracker.State.FAILED) {
            this.cleanUpConnection(false, "gprsAttached");
            this.mRetryMgr.resetRetryCount();
        }
        this.trySetupData("gprsAttached");
    }

    private String[] parseTypes(String string2) {
        if (string2 == null || string2.equals("")) {
            return new String[]{"*"};
        }
        return string2.split(",");
    }

    private boolean pdpStatesHasActiveCID(ArrayList<DataCallState> arrayList, int n) {
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            if (arrayList.get((int)i).cid != n || arrayList.get((int)i).active == 0) continue;
            return true;
        }
        return false;
    }

    private boolean pdpStatesHasCID(ArrayList<DataCallState> arrayList, int n) {
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            if (arrayList.get((int)i).cid != n) continue;
            return true;
        }
        return false;
    }

    private void reconnectAfterFail(DataConnection.FailCause failCause, String string2) {
        block8: {
            block9: {
                block7: {
                    if (this.state != DataConnectionTracker.State.FAILED) break block7;
                    if (this.mRetryMgr.isRetryNeeded()) break block8;
                    if (this.mRequestedApnType.equals("default")) break block9;
                    this.phone.notifyDataConnection("apnFailed");
                    this.onEnableApn(this.apnTypeToId(this.mRequestedApnType), 0);
                }
                return;
            }
            if (!this.mReregisterOnReconnectFailure) {
                Log.d("GSM", "PDP activate failed, Reregistering to the network");
                this.mReregisterOnReconnectFailure = true;
                this.mGsmPhone.mSST.reRegisterNetwork(null);
                this.mRetryMgr.resetRetryCount();
                return;
            }
            this.mRetryMgr.retryForeverUsingLastTimeout();
        }
        int n = this.mRetryMgr.getRetryTimer();
        Log.d("GSM", "PDP activate failed. Scheduling next attempt for " + n / 1000 + "s");
        AlarmManager alarmManager = (AlarmManager)this.phone.getContext().getSystemService("alarm");
        Intent intent = new Intent(INTENT_RECONNECT_ALARM);
        intent.putExtra(INTENT_RECONNECT_ALARM_EXTRA_REASON, string2);
        this.mReconnectIntent = PendingIntent.getBroadcast(this.phone.getContext(), 0, intent, 0);
        alarmManager.set(2, SystemClock.elapsedRealtime() + (long)n, this.mReconnectIntent);
        this.mRetryMgr.increaseRetryCount();
        if (!this.shouldPostNotification(failCause)) {
            Log.d("GSM", "NOT Posting GPRS Unavailable notification -- likely transient error");
            return;
        }
        this.notifyNoData(failCause);
    }

    private void resetPollStats() {
        this.txPkts = -1L;
        this.rxPkts = -1L;
        this.sentSinceLastRecv = 0L;
        this.netStatPollPeriod = 1000;
        this.mNoRecvPollCount = 0;
    }

    private boolean retryAfterDisconnected(String string2) {
        boolean bl = true;
        if ("radioTurnedOff".equals(string2)) {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runPingTest() {
        int n = -1;
        try {
            String string2 = Settings.Secure.getString(this.mResolver, "pdp_watchdog_ping_address");
            int n2 = Settings.Secure.getInt(this.mResolver, "pdp_watchdog_ping_deadline", 5);
            if (string2 != null && !"0.0.0.0".equals(string2)) {
                int n3;
                n = n3 = Runtime.getRuntime().exec("ping -c 1 -i 1 -w " + n2 + " " + string2).waitFor();
            }
        }
        catch (IOException iOException) {
            Log.w("GSM", "ping failed: IOException");
        }
        catch (Exception exception) {
            Log.w("GSM", "exception trying to ping");
        }
        if (n == 0) {
            EventLog.writeEvent(50102, -1);
            this.mPdpResetCount = 0;
            this.sendMessage(this.obtainMessage(27));
            return;
        }
        this.sendMessage(this.obtainMessage(28));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setPreferredApn(int n) {
        ContentResolver contentResolver;
        block3: {
            block2: {
                if (!this.canSetPreferApn) break block2;
                contentResolver = this.phone.getContext().getContentResolver();
                contentResolver.delete(PREFERAPN_URI, null, null);
                if (n >= 0) break block3;
            }
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put(APN_ID, n);
        contentResolver.insert(PREFERAPN_URI, contentValues);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean setupData(String string2) {
        GsmDataConnection gsmDataConnection;
        ApnSetting apnSetting = this.getNextApn();
        if (apnSetting == null || (gsmDataConnection = this.findFreePdp()) == null) {
            return false;
        }
        this.mActiveApn = apnSetting;
        this.mActivePdp = gsmDataConnection;
        Message message = this.obtainMessage();
        message.what = 1;
        message.obj = string2;
        gsmDataConnection.connect(message, apnSetting);
        this.setState(DataConnectionTracker.State.INITING);
        this.phone.notifyDataConnection(string2);
        return true;
    }

    private boolean shouldPostNotification(DataConnection.FailCause failCause) {
        return failCause != DataConnection.FailCause.UNKNOWN;
    }

    private void startDelayedRetry(DataConnection.FailCause failCause, String string2) {
        this.notifyNoData(failCause);
        this.reconnectAfterFail(failCause, string2);
    }

    private void startPeriodicPdpPoll() {
        this.removeMessages(7);
        this.sendMessageDelayed(this.obtainMessage(7), 5000L);
    }

    private boolean trySetupData(String string2) {
        Log.d("GSM", "[DSAC DEB] trySetupData with mIsPsRestricted=" + this.mIsPsRestricted);
        if (this.phone.getSimulatedRadioControl() != null) {
            this.setState(DataConnectionTracker.State.CONNECTED);
            this.phone.notifyDataConnection(string2);
            Log.i("GSM", "(fix?) We're on the simulator; assuming data is connected");
            return true;
        }
        int n = this.mGsmPhone.mSST.getCurrentGprsState();
        boolean bl = this.mGsmPhone.mSST.getDesiredPowerState();
        if ((this.state == DataConnectionTracker.State.IDLE || this.state == DataConnectionTracker.State.SCANNING) && (n == 0 || this.noAutoAttach) && this.mGsmPhone.mSIMRecords.getRecordsLoaded() && this.phone.getState() == Phone.State.IDLE && this.isDataAllowed() && !this.mIsPsRestricted && bl) {
            if (this.state == DataConnectionTracker.State.IDLE) {
                this.waitingApns = this.buildWaitingApns();
                this.waitingApnsPermanentFailureCountDown = this.waitingApns.size();
                if (this.waitingApns.isEmpty()) {
                    this.notifyNoData(DataConnection.FailCause.MISSING_UNKNOWN_APN);
                    return false;
                }
                this.log("Create from allApns : " + this.apnListToString(this.allApns));
            }
            return this.setupData(string2);
        }
        return false;
    }

    @Override
    public void dispose() {
        this.phone.mCM.unregisterForAvailable(this);
        this.phone.mCM.unregisterForOffOrNotAvailable(this);
        this.mGsmPhone.mSIMRecords.unregisterForRecordsLoaded(this);
        this.phone.mCM.unregisterForDataStateChanged(this);
        this.mGsmPhone.mCT.unregisterForVoiceCallEnded(this);
        this.mGsmPhone.mCT.unregisterForVoiceCallStarted(this);
        this.mGsmPhone.mSST.unregisterForGprsAttached(this);
        this.mGsmPhone.mSST.unregisterForGprsDetached(this);
        this.mGsmPhone.mSST.unregisterForRoamingOn(this);
        this.mGsmPhone.mSST.unregisterForRoamingOff(this);
        this.mGsmPhone.mSST.unregisterForPsRestrictedEnabled(this);
        this.mGsmPhone.mSST.unregisterForPsRestrictedDisabled(this);
        this.phone.getContext().unregisterReceiver(this.mIntentReceiver);
        this.phone.getContext().getContentResolver().unregisterContentObserver(this.apnObserver);
        this.destroyAllPdpList();
    }

    protected void finalize() {
    }

    @Override
    protected String getActiveApnString() {
        ApnSetting apnSetting = this.mActiveApn;
        String string2 = null;
        if (apnSetting != null) {
            string2 = this.mActiveApn.apn;
        }
        return string2;
    }

    @Override
    public String[] getActiveApnTypes() {
        if (this.mActiveApn != null) {
            return this.mActiveApn.types;
        }
        return new String[]{"default"};
    }

    @Override
    public ArrayList<DataConnection> getAllDataConnections() {
        return (ArrayList)this.pdpList.clone();
    }

    @Override
    protected String[] getDnsServers(String string2) {
        if (this.mActivePdp != null && (string2 == null || this.mActiveApn != null && this.mActiveApn.canHandleType(string2))) {
            return this.mActivePdp.getDnsServers();
        }
        return null;
    }

    @Override
    public String getGateway(String string2) {
        if (this.mActivePdp != null && (string2 == null || this.mActiveApn != null && this.mActiveApn.canHandleType(string2))) {
            return this.mActivePdp.getGatewayAddress();
        }
        return null;
    }

    @Override
    protected String getInterfaceName(String string2) {
        if (this.mActivePdp != null && (string2 == null || this.mActiveApn != null && this.mActiveApn.canHandleType(string2))) {
            return this.mActivePdp.getInterface();
        }
        return null;
    }

    @Override
    protected String getIpAddress(String string2) {
        if (this.mActivePdp != null && (string2 == null || this.mActiveApn != null && this.mActiveApn.canHandleType(string2))) {
            return this.mActivePdp.getIpAddress();
        }
        return null;
    }

    @Override
    public void handleMessage(Message message) {
        if (!this.mGsmPhone.mIsTheCurrentActivePhone) {
            Log.d("GSM", "Ignore GSM msgs since GSM phone is inactive");
            return;
        }
        switch (message.what) {
            default: {
                super.handleMessage(message);
                return;
            }
            case 4: {
                this.onRecordsLoaded();
                return;
            }
            case 19: {
                this.onGprsDetached();
                return;
            }
            case 26: {
                this.onGprsAttached();
                return;
            }
            case 6: {
                this.onPdpStateChanged((AsyncResult)message.obj, false);
                return;
            }
            case 11: {
                this.onPdpStateChanged((AsyncResult)message.obj, true);
                return;
            }
            case 7: {
                this.onPollPdp();
                return;
            }
            case 27: {
                this.mPingTestActive = false;
                this.startNetStatPoll();
                return;
            }
            case 28: {
                this.mPingTestActive = false;
                this.doRecovery();
                return;
            }
            case 29: {
                this.onApnChanged();
                return;
            }
            case 32: {
                Log.d("GSM", "[DSAC DEB] EVENT_PS_RESTRICT_ENABLED " + this.mIsPsRestricted);
                this.stopNetStatPoll();
                this.mIsPsRestricted = true;
                return;
            }
            case 33: 
        }
        Log.d("GSM", "[DSAC DEB] EVENT_PS_RESTRICT_DISABLED " + this.mIsPsRestricted);
        this.mIsPsRestricted = false;
        if (this.state == DataConnectionTracker.State.CONNECTED) {
            this.startNetStatPoll();
            return;
        }
        if (this.state == DataConnectionTracker.State.FAILED) {
            this.cleanUpConnection(false, "psRestrictEnabled");
            this.mRetryMgr.resetRetryCount();
            this.mReregisterOnReconnectFailure = false;
        }
        this.trySetupData("psRestrictEnabled");
    }

    @Override
    protected boolean isApnTypeActive(String string2) {
        return this.mActiveApn != null && this.mActiveApn.canHandleType(string2);
    }

    @Override
    protected boolean isApnTypeAvailable(String string2) {
        if (string2.equals("dun")) {
            return this.fetchDunApn() != null;
        }
        if (this.allApns != null) {
            Iterator<ApnSetting> iterator = this.allApns.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().canHandleType(string2)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isDataConnectionAsDesired() {
        boolean bl = this.phone.getServiceState().getRoaming();
        if (!(!this.mGsmPhone.mSIMRecords.getRecordsLoaded() || this.mGsmPhone.mSST.getCurrentGprsState() != 0 || bl && !this.getDataOnRoamingEnabled() || this.mIsWifiConnected || this.mIsPsRestricted)) {
            return this.state == DataConnectionTracker.State.CONNECTED;
        }
        return true;
    }

    @Override
    protected void log(String string2) {
        Log.d("GSM", "[GsmDataConnectionTracker] " + string2);
    }

    @Override
    protected void onCleanUpConnection(boolean bl, String string2) {
        this.cleanUpConnection(bl, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onDataSetupComplete(AsyncResult asyncResult) {
        boolean bl = asyncResult.userObj instanceof String;
        String string2 = null;
        if (bl) {
            string2 = (String)asyncResult.userObj;
        }
        if (asyncResult.exception == null) {
            if (this.isApnTypeActive("default")) {
                SystemProperties.set("gsm.defaultpdpcontext.active", "true");
                if (this.canSetPreferApn && this.preferredApn == null) {
                    Log.d("GSM", "PREFERRED APN is null");
                    this.preferredApn = this.mActiveApn;
                    this.setPreferredApn(this.preferredApn.id);
                }
            } else {
                SystemProperties.set("gsm.defaultpdpcontext.active", "false");
            }
            this.notifyDefaultData(string2);
            return;
        }
        DataConnection.FailCause failCause = (DataConnection.FailCause)((Object)asyncResult.result);
        if (failCause.isEventLoggable()) {
            GsmCellLocation gsmCellLocation = (GsmCellLocation)this.phone.getCellLocation();
            Object[] objectArray = new Object[3];
            objectArray[0] = failCause.ordinal();
            int n = gsmCellLocation != null ? gsmCellLocation.getCid() : -1;
            objectArray[1] = n;
            objectArray[2] = TelephonyManager.getDefault().getNetworkType();
            EventLog.writeEvent(50105, objectArray);
        }
        int n = this.waitingApnsPermanentFailureCountDown;
        int n2 = failCause.isPermanentFail() ? 1 : 0;
        this.waitingApnsPermanentFailureCountDown = n - n2;
        this.waitingApns.remove(0);
        if (!this.waitingApns.isEmpty()) {
            this.setState(DataConnectionTracker.State.SCANNING);
            this.sendMessageDelayed(this.obtainMessage(5, string2), 5000L);
            return;
        }
        if (this.waitingApnsPermanentFailureCountDown == 0) {
            this.notifyNoData(failCause);
            this.phone.notifyDataConnection("apnFailed");
            return;
        }
        this.startDelayedRetry(failCause, string2);
    }

    @Override
    protected void onDisconnectDone(AsyncResult asyncResult) {
        boolean bl = asyncResult.userObj instanceof String;
        String string2 = null;
        if (bl) {
            string2 = (String)asyncResult.userObj;
        }
        this.setState(DataConnectionTracker.State.IDLE);
        this.phone.notifyDataConnection(string2);
        this.mActiveApn = null;
        if (this.retryAfterDisconnected(string2)) {
            this.trySetupData(string2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onEnableNewApn() {
        this.mRetryMgr = this.mRequestedApnType.equals("default") ? this.mDefaultRetryManager : this.mSecondaryRetryManager;
        this.mRetryMgr.resetRetryCount();
        this.cleanUpConnection(true, "apnSwitched");
    }

    protected void onGprsDetached() {
        this.stopNetStatPoll();
        this.phone.notifyDataConnection("gprsDetached");
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onPdpStateChanged(AsyncResult asyncResult, boolean bl) {
        block6: {
            block5: {
                ArrayList arrayList = (ArrayList)asyncResult.result;
                if (asyncResult.exception != null || this.state != DataConnectionTracker.State.CONNECTED) break block5;
                if (!this.pdpStatesHasCID(arrayList, this.cidActive)) {
                    Log.i("GSM", "PDP connection has dropped. Reconnecting");
                    GsmCellLocation gsmCellLocation = (GsmCellLocation)this.phone.getCellLocation();
                    Object[] objectArray = new Object[2];
                    int n = gsmCellLocation != null ? gsmCellLocation.getCid() : -1;
                    objectArray[0] = n;
                    objectArray[1] = TelephonyManager.getDefault().getNetworkType();
                    EventLog.writeEvent(50109, objectArray);
                    this.cleanUpConnection(true, null);
                    return;
                }
                if (!this.pdpStatesHasActiveCID(arrayList, this.cidActive)) break block6;
            }
            return;
        }
        if (!bl) {
            this.phone.mCM.getPDPContextList(this.obtainMessage(11));
            return;
        }
        Log.i("GSM", "PDP connection has dropped (active=false case).  Reconnecting");
        GsmCellLocation gsmCellLocation = (GsmCellLocation)this.phone.getCellLocation();
        Object[] objectArray = new Object[2];
        int n = gsmCellLocation != null ? gsmCellLocation.getCid() : -1;
        objectArray[0] = n;
        objectArray[1] = TelephonyManager.getDefault().getNetworkType();
        EventLog.writeEvent(50109, objectArray);
        this.cleanUpConnection(true, null);
    }

    protected void onPollPdp() {
        if (this.state == DataConnectionTracker.State.CONNECTED) {
            this.phone.mCM.getPDPContextList(this.obtainMessage(11));
            this.sendMessageDelayed(this.obtainMessage(7), 5000L);
        }
    }

    @Override
    protected void onRadioAvailable() {
        if (this.phone.getSimulatedRadioControl() != null) {
            this.setState(DataConnectionTracker.State.CONNECTED);
            this.phone.notifyDataConnection(null);
            Log.i("GSM", "We're on the simulator; assuming data is connected");
        }
        if (this.state != DataConnectionTracker.State.IDLE) {
            this.cleanUpConnection(true, null);
        }
    }

    @Override
    protected void onRadioOffOrNotAvailable() {
        this.mRetryMgr.resetRetryCount();
        this.mReregisterOnReconnectFailure = false;
        if (this.phone.getSimulatedRadioControl() != null) {
            Log.i("GSM", "We're on the simulator; assuming radio off is meaningless");
            return;
        }
        this.cleanUpConnection(false, "radioTurnedOff");
    }

    protected void onRecordsLoaded() {
        this.createAllApnList();
        if (this.state == DataConnectionTracker.State.FAILED) {
            this.cleanUpConnection(false, null);
        }
        this.sendMessage(this.obtainMessage(5, "simLoaded"));
    }

    @Override
    protected void onResetDone(AsyncResult asyncResult) {
        boolean bl = asyncResult.userObj instanceof String;
        String string2 = null;
        if (bl) {
            string2 = (String)asyncResult.userObj;
        }
        this.gotoIdleAndNotifyDataConnection(string2);
    }

    @Override
    protected void onRoamingOff() {
        this.trySetupData("roamingOff");
    }

    @Override
    protected void onRoamingOn() {
        if (this.getDataOnRoamingEnabled()) {
            this.trySetupData("roamingOn");
            return;
        }
        this.cleanUpConnection(true, "roamingOn");
    }

    @Override
    protected boolean onTrySetupData(String string2) {
        return this.trySetupData(string2);
    }

    @Override
    protected void onVoiceCallEnded() {
        if (this.state == DataConnectionTracker.State.CONNECTED) {
            if (!this.mGsmPhone.mSST.isConcurrentVoiceAndData()) {
                this.startNetStatPoll();
                this.phone.notifyDataConnection("2GVoiceCallEnded");
                return;
            }
            this.resetPollStats();
            return;
        }
        this.mRetryMgr.resetRetryCount();
        this.mReregisterOnReconnectFailure = false;
        this.trySetupData("2GVoiceCallEnded");
    }

    @Override
    protected void onVoiceCallStarted() {
        if (this.state == DataConnectionTracker.State.CONNECTED && !this.mGsmPhone.mSST.isConcurrentVoiceAndData()) {
            this.stopNetStatPoll();
            this.phone.notifyDataConnection("2GVoiceCallStarted");
        }
    }

    @Override
    protected void restartRadio() {
        Log.d("GSM", "************TURN OFF RADIO**************");
        this.cleanUpConnection(true, "radioTurnedOff");
        this.mGsmPhone.mSST.powerOffRadioSafely();
        SystemProperties.set("net.ppp.reset-by-timeout", String.valueOf(1 + Integer.parseInt(SystemProperties.get("net.ppp.reset-by-timeout", "0"))));
    }

    @Override
    protected void setState(DataConnectionTracker.State state) {
        if (this.state != state) {
            Object[] objectArray = new Object[]{this.state.toString(), state.toString()};
            EventLog.writeEvent(50113, objectArray);
            this.state = state;
        }
        if (this.state == DataConnectionTracker.State.FAILED && this.waitingApns != null) {
            this.waitingApns.clear();
        }
    }

    @Override
    protected void startNetStatPoll() {
        if (this.state == DataConnectionTracker.State.CONNECTED && !this.mPingTestActive && !this.netStatPollEnabled) {
            Log.d("GSM", "[DataConnection] Start poll NetStat");
            this.resetPollStats();
            this.netStatPollEnabled = true;
            this.mPollNetStat.run();
        }
    }

    @Override
    protected void stopNetStatPoll() {
        this.netStatPollEnabled = false;
        this.removeCallbacks(this.mPollNetStat);
        Log.d("GSM", "[DataConnection] Stop poll NetStat");
    }

    private class ApnChangeObserver
    extends ContentObserver {
        public ApnChangeObserver() {
            super(GsmDataConnectionTracker.this.mDataConnectionTracker);
        }

        @Override
        public void onChange(boolean bl) {
            GsmDataConnectionTracker.this.sendMessage(GsmDataConnectionTracker.this.obtainMessage(29));
        }
    }
}

