/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.telephony.PhoneNumberUtils;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.telephony.CallForwardInfo;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.MmiCode;
import com.android.internal.telephony.gsm.GSMPhone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class GsmMmiCode
extends Handler
implements MmiCode {
    static final String ACTION_ACTIVATE = "*";
    static final String ACTION_DEACTIVATE = "#";
    static final String ACTION_ERASURE = "##";
    static final String ACTION_INTERROGATE = "*#";
    static final String ACTION_REGISTER = "**";
    static final int EVENT_GET_CLIR_COMPLETE = 2;
    static final int EVENT_QUERY_CF_COMPLETE = 3;
    static final int EVENT_QUERY_COMPLETE = 5;
    static final int EVENT_SET_CFF_COMPLETE = 6;
    static final int EVENT_SET_COMPLETE = 1;
    static final int EVENT_USSD_CANCEL_COMPLETE = 7;
    static final int EVENT_USSD_COMPLETE = 4;
    static final String LOG_TAG = "GSM";
    static final int MATCH_GROUP_ACTION = 2;
    static final int MATCH_GROUP_DIALING_NUMBER = 12;
    static final int MATCH_GROUP_POUND_STRING = 1;
    static final int MATCH_GROUP_PWD_CONFIRM = 11;
    static final int MATCH_GROUP_SERVICE_CODE = 3;
    static final int MATCH_GROUP_SIA = 5;
    static final int MATCH_GROUP_SIB = 7;
    static final int MATCH_GROUP_SIC = 9;
    static final String SC_BAIC = "35";
    static final String SC_BAICr = "351";
    static final String SC_BAOC = "33";
    static final String SC_BAOIC = "331";
    static final String SC_BAOICxH = "332";
    static final String SC_BA_ALL = "330";
    static final String SC_BA_MO = "333";
    static final String SC_BA_MT = "353";
    static final String SC_CFB = "67";
    static final String SC_CFNR = "62";
    static final String SC_CFNRy = "61";
    static final String SC_CFU = "21";
    static final String SC_CF_All = "002";
    static final String SC_CF_All_Conditional = "004";
    static final String SC_CLIP = "30";
    static final String SC_CLIR = "31";
    static final String SC_PIN = "04";
    static final String SC_PIN2 = "042";
    static final String SC_PUK = "05";
    static final String SC_PUK2 = "052";
    static final String SC_PWD = "03";
    static final String SC_WAIT = "43";
    static Pattern sPatternSuppService = Pattern.compile("((\\*|#|\\*#|\\*\\*|##)(\\d{2,3})(\\*([^*#]*)(\\*([^*#]*)(\\*([^*#]*)(\\*([^*#]*))?)?)?)?#)(.*)");
    private static String[] sTwoDigitNumberPattern;
    String action;
    Context context;
    String dialingNumber;
    private boolean isPendingUSSD;
    private boolean isUssdRequest;
    CharSequence message;
    GSMPhone phone;
    String poundString;
    String pwd;
    String sc;
    String sia;
    String sib;
    String sic;
    MmiCode.State state = MmiCode.State.PENDING;

    GsmMmiCode(GSMPhone gSMPhone) {
        super(gSMPhone.getHandler().getLooper());
        this.phone = gSMPhone;
        this.context = gSMPhone.getContext();
    }

    private CharSequence createQueryCallBarringResultMessage(int n) {
        StringBuilder stringBuilder = new StringBuilder(this.context.getText(17039541));
        for (int i = 1; i <= 128; i <<= 1) {
            if ((i & n) == 0) continue;
            stringBuilder.append("\n");
            stringBuilder.append(this.serviceClassToCFString(i & n));
        }
        return stringBuilder;
    }

    private CharSequence createQueryCallWaitingResultMessage(int n) {
        StringBuilder stringBuilder = new StringBuilder(this.context.getText(17039541));
        for (int i = 1; i <= 128; i <<= 1) {
            if ((i & n) == 0) continue;
            stringBuilder.append("\n");
            stringBuilder.append(this.serviceClassToCFString(i & n));
        }
        return stringBuilder;
    }

    private CharSequence getErrorMessage(AsyncResult asyncResult) {
        if (asyncResult.exception instanceof CommandException && ((CommandException)asyncResult.exception).getCommandError() == CommandException.Error.FDN_CHECK_FAILURE) {
            Log.i(LOG_TAG, "FDN_CHECK_FAILURE");
            return this.context.getText(17039539);
        }
        return this.context.getText(17039538);
    }

    private CharSequence getScString() {
        if (this.sc != null) {
            if (GsmMmiCode.isServiceCodeCallBarring(this.sc)) {
                return this.context.getText(17039557);
            }
            if (GsmMmiCode.isServiceCodeCallForwarding(this.sc)) {
                return this.context.getText(17039555);
            }
            if (this.sc.equals(SC_CLIP)) {
                return this.context.getText(17039553);
            }
            if (this.sc.equals(SC_CLIR)) {
                return this.context.getText(17039554);
            }
            if (this.sc.equals(SC_PWD)) {
                return this.context.getText(17039558);
            }
            if (this.sc.equals(SC_WAIT)) {
                return this.context.getText(17039556);
            }
            if (this.isPinCommand()) {
                return this.context.getText(17039559);
            }
        }
        return "";
    }

    private void handlePasswordError(int n) {
        this.state = MmiCode.State.FAILED;
        StringBuilder stringBuilder = new StringBuilder(this.getScString());
        stringBuilder.append("\n");
        stringBuilder.append(this.context.getText(n));
        this.message = stringBuilder;
        this.phone.onMMIDone(this);
    }

    private static boolean isEmptyOrNull(CharSequence charSequence) {
        return charSequence == null || charSequence.length() == 0;
    }

    static boolean isServiceCodeCallBarring(String string2) {
        return string2 != null && (string2.equals(SC_BAOC) || string2.equals(SC_BAOIC) || string2.equals(SC_BAOICxH) || string2.equals(SC_BAIC) || string2.equals(SC_BAICr) || string2.equals(SC_BA_ALL) || string2.equals(SC_BA_MO) || string2.equals(SC_BA_MT));
    }

    static boolean isServiceCodeCallForwarding(String string2) {
        return string2 != null && (string2.equals(SC_CFU) || string2.equals(SC_CFB) || string2.equals(SC_CFNRy) || string2.equals(SC_CFNR) || string2.equals(SC_CF_All) || string2.equals(SC_CF_All_Conditional));
    }

    private static boolean isShortCode(String string2, GSMPhone gSMPhone) {
        return string2 != null && string2.length() <= 2 && !PhoneNumberUtils.isEmergencyNumber(string2) && (gSMPhone.isInCall() || (string2.length() != 2 || string2.charAt(0) != '1') && !string2.equals("0") && !string2.equals("00"));
    }

    private static boolean isTwoDigitShortCode(Context context, String string2) {
        Log.d(LOG_TAG, "isTwoDigitShortCode");
        if (string2 == null || string2.length() != 2) {
            return false;
        }
        if (sTwoDigitNumberPattern == null) {
            sTwoDigitNumberPattern = context.getResources().getStringArray(17235994);
        }
        for (String string3 : sTwoDigitNumberPattern) {
            Log.d(LOG_TAG, "Two Digit Number Pattern " + string3);
            if (!string2.equals(string3)) continue;
            Log.d(LOG_TAG, "Two Digit Number Pattern -true");
            return true;
        }
        Log.d(LOG_TAG, "Two Digit Number Pattern -false");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private CharSequence makeCFQueryResultMessage(CallForwardInfo callForwardInfo, int n) {
        String[] stringArray = new String[]{"{0}", "{1}", "{2}"};
        CharSequence[] charSequenceArray = new CharSequence[3];
        boolean bl = callForwardInfo.reason == 2;
        CharSequence charSequence = callForwardInfo.status == 1 ? (bl ? this.context.getText(17039605) : this.context.getText(17039604)) : (callForwardInfo.status == 0 && GsmMmiCode.isEmptyOrNull(callForwardInfo.number) ? this.context.getText(17039603) : (bl ? this.context.getText(17039607) : this.context.getText(17039606)));
        charSequenceArray[0] = this.serviceClassToCFString(n & callForwardInfo.serviceClass);
        charSequenceArray[1] = PhoneNumberUtils.stringFromStringAndTOA(callForwardInfo.number, callForwardInfo.toa);
        charSequenceArray[2] = Integer.toString(callForwardInfo.timeSeconds);
        if (callForwardInfo.reason == 0 && (n & callForwardInfo.serviceClass) == 1) {
            boolean bl2 = callForwardInfo.status == 1;
            this.phone.mSIMRecords.setVoiceCallForwardingFlag(1, bl2);
        }
        return TextUtils.replace(charSequence, stringArray, charSequenceArray);
    }

    private static String makeEmptyNull(String string2) {
        if (string2 != null && string2.length() == 0) {
            return null;
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    static GsmMmiCode newFromDialString(String string2, GSMPhone gSMPhone) {
        GsmMmiCode gsmMmiCode;
        Matcher matcher = sPatternSuppService.matcher(string2);
        if (matcher.matches()) {
            gsmMmiCode = new GsmMmiCode(gSMPhone);
            gsmMmiCode.poundString = GsmMmiCode.makeEmptyNull(matcher.group(1));
            gsmMmiCode.action = GsmMmiCode.makeEmptyNull(matcher.group(2));
            gsmMmiCode.sc = GsmMmiCode.makeEmptyNull(matcher.group(3));
            gsmMmiCode.sia = GsmMmiCode.makeEmptyNull(matcher.group(5));
            gsmMmiCode.sib = GsmMmiCode.makeEmptyNull(matcher.group(7));
            gsmMmiCode.sic = GsmMmiCode.makeEmptyNull(matcher.group(9));
            gsmMmiCode.pwd = GsmMmiCode.makeEmptyNull(matcher.group(11));
            gsmMmiCode.dialingNumber = GsmMmiCode.makeEmptyNull(matcher.group(12));
            return gsmMmiCode;
        } else {
            if (string2.endsWith(ACTION_DEACTIVATE)) {
                GsmMmiCode gsmMmiCode2 = new GsmMmiCode(gSMPhone);
                gsmMmiCode2.poundString = string2;
                return gsmMmiCode2;
            }
            if (GsmMmiCode.isTwoDigitShortCode(gSMPhone.getContext(), string2)) {
                return null;
            }
            boolean bl = GsmMmiCode.isShortCode(string2, gSMPhone);
            gsmMmiCode = null;
            if (!bl) return gsmMmiCode;
            GsmMmiCode gsmMmiCode3 = new GsmMmiCode(gSMPhone);
            gsmMmiCode3.dialingNumber = string2;
            return gsmMmiCode3;
        }
    }

    static GsmMmiCode newFromUssdUserInput(String string2, GSMPhone gSMPhone) {
        GsmMmiCode gsmMmiCode = new GsmMmiCode(gSMPhone);
        gsmMmiCode.message = string2;
        gsmMmiCode.state = MmiCode.State.PENDING;
        gsmMmiCode.isPendingUSSD = true;
        return gsmMmiCode;
    }

    static GsmMmiCode newNetworkInitiatedUssd(String string2, boolean bl, GSMPhone gSMPhone) {
        GsmMmiCode gsmMmiCode = new GsmMmiCode(gSMPhone);
        gsmMmiCode.message = string2;
        gsmMmiCode.isUssdRequest = bl;
        if (bl) {
            gsmMmiCode.isPendingUSSD = true;
            gsmMmiCode.state = MmiCode.State.PENDING;
            return gsmMmiCode;
        }
        gsmMmiCode.state = MmiCode.State.COMPLETE;
        return gsmMmiCode;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onGetClirComplete(AsyncResult asyncResult) {
        StringBuilder stringBuilder = new StringBuilder(this.getScString());
        stringBuilder.append("\n");
        if (asyncResult.exception != null) {
            this.state = MmiCode.State.FAILED;
            stringBuilder.append(this.getErrorMessage(asyncResult));
        } else {
            int[] nArray = (int[])asyncResult.result;
            switch (nArray[1]) {
                default: {
                    break;
                }
                case 0: {
                    stringBuilder.append(this.context.getText(17039570));
                    this.state = MmiCode.State.COMPLETE;
                    break;
                }
                case 1: {
                    stringBuilder.append(this.context.getText(17039571));
                    this.state = MmiCode.State.COMPLETE;
                    break;
                }
                case 2: {
                    stringBuilder.append(this.context.getText(17039538));
                    this.state = MmiCode.State.FAILED;
                    break;
                }
                case 3: {
                    switch (nArray[0]) {
                        default: {
                            stringBuilder.append(this.context.getText(17039566));
                            break;
                        }
                        case 1: {
                            stringBuilder.append(this.context.getText(17039566));
                            break;
                        }
                        case 2: {
                            stringBuilder.append(this.context.getText(17039567));
                        }
                    }
                    this.state = MmiCode.State.COMPLETE;
                    break;
                }
                case 4: {
                    switch (nArray[0]) {
                        default: {
                            stringBuilder.append(this.context.getText(17039569));
                            break;
                        }
                        case 1: {
                            stringBuilder.append(this.context.getText(17039568));
                            break;
                        }
                        case 2: {
                            stringBuilder.append(this.context.getText(17039569));
                        }
                    }
                    this.state = MmiCode.State.COMPLETE;
                }
            }
        }
        this.message = stringBuilder;
        this.phone.onMMIDone(this);
    }

    /*
     * Unable to fully structure code
     */
    private void onQueryCfComplete(AsyncResult var1_1) {
        var2_2 = new StringBuilder(this.getScString());
        var2_2.append("\n");
        if (var1_1.exception != null) {
            this.state = MmiCode.State.FAILED;
            var2_2.append(this.getErrorMessage(var1_1));
lbl8:
            // 2 sources

            while (true) {
                this.message = var2_2;
                this.phone.onMMIDone(this);
                return;
            }
        }
        var4_3 = (CallForwardInfo[])var1_1.result;
        if (var4_3.length == 0) {
            var2_2.append(this.context.getText(17039542));
            this.phone.mSIMRecords.setVoiceCallForwardingFlag(1, false);
lbl17:
            // 2 sources

            while (true) {
                this.state = MmiCode.State.COMPLETE;
                ** continue;
                break;
            }
        }
        var5_4 = new SpannableStringBuilder();
        for (var6_5 = 1; var6_5 <= 128; var6_5 <<= 1) {
            var9_7 = var4_3.length;
            for (var8_6 = 0; var8_6 < var9_7; ++var8_6) {
                if ((var6_5 & var4_3[var8_6].serviceClass) == 0) continue;
                var5_4.append(this.makeCFQueryResultMessage(var4_3[var8_6], var6_5));
                var5_4.append("\n");
            }
        }
        var2_2.append(var5_4);
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onQueryComplete(AsyncResult asyncResult) {
        StringBuilder stringBuilder;
        block6: {
            block4: {
                block7: {
                    int[] nArray;
                    block9: {
                        block8: {
                            block5: {
                                stringBuilder = new StringBuilder(this.getScString());
                                stringBuilder.append("\n");
                                if (asyncResult.exception == null) break block5;
                                this.state = MmiCode.State.FAILED;
                                stringBuilder.append(this.getErrorMessage(asyncResult));
                                break block6;
                            }
                            nArray = (int[])asyncResult.result;
                            if (nArray.length == 0) break block7;
                            if (nArray[0] != 0) break block8;
                            stringBuilder.append(this.context.getText(17039542));
                            break block4;
                        }
                        if (!this.sc.equals(SC_WAIT)) break block9;
                        stringBuilder.append(this.createQueryCallWaitingResultMessage(nArray[1]));
                        break block4;
                    }
                    if (GsmMmiCode.isServiceCodeCallBarring(this.sc)) {
                        stringBuilder.append(this.createQueryCallBarringResultMessage(nArray[0]));
                        break block4;
                    } else if (nArray[0] == 1) {
                        stringBuilder.append(this.context.getText(17039540));
                        break block4;
                    } else {
                        stringBuilder.append(this.context.getText(17039538));
                    }
                    break block4;
                }
                stringBuilder.append(this.context.getText(17039538));
            }
            this.state = MmiCode.State.COMPLETE;
        }
        this.message = stringBuilder;
        this.phone.onMMIDone(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onSetComplete(AsyncResult asyncResult) {
        StringBuilder stringBuilder;
        block18: {
            block19: {
                block20: {
                    CommandException.Error error;
                    block21: {
                        stringBuilder = new StringBuilder(this.getScString());
                        stringBuilder.append("\n");
                        if (asyncResult.exception == null) break block19;
                        this.state = MmiCode.State.FAILED;
                        if (!(asyncResult.exception instanceof CommandException)) break block20;
                        error = ((CommandException)asyncResult.exception).getCommandError();
                        if (error != CommandException.Error.PASSWORD_INCORRECT) break block21;
                        if (this.isPinCommand()) {
                            if (this.sc.equals(SC_PUK) || this.sc.equals(SC_PUK2)) {
                                stringBuilder.append(this.context.getText(17039548));
                                break block18;
                            } else {
                                stringBuilder.append(this.context.getText(17039547));
                            }
                            break block18;
                        } else {
                            stringBuilder.append(this.context.getText(17039545));
                        }
                        break block18;
                    }
                    if (error == CommandException.Error.SIM_PUK2) {
                        stringBuilder.append(this.context.getText(17039547));
                        stringBuilder.append("\n");
                        stringBuilder.append(this.context.getText(17039552));
                        break block18;
                    } else if (error == CommandException.Error.FDN_CHECK_FAILURE) {
                        Log.i(LOG_TAG, "FDN_CHECK_FAILURE");
                        stringBuilder.append(this.context.getText(17039539));
                        break block18;
                    } else {
                        stringBuilder.append(this.context.getText(17039538));
                    }
                    break block18;
                }
                stringBuilder.append(this.context.getText(17039538));
                break block18;
            }
            if (this.isActivate()) {
                this.state = MmiCode.State.COMPLETE;
                stringBuilder.append(this.context.getText(17039540));
                if (this.sc.equals(SC_CLIR)) {
                    this.phone.saveClirSetting(1);
                }
            } else if (this.isDeactivate()) {
                this.state = MmiCode.State.COMPLETE;
                stringBuilder.append(this.context.getText(17039542));
                if (this.sc.equals(SC_CLIR)) {
                    this.phone.saveClirSetting(2);
                }
            } else if (this.isRegister()) {
                this.state = MmiCode.State.COMPLETE;
                stringBuilder.append(this.context.getText(17039543));
            } else if (this.isErasure()) {
                this.state = MmiCode.State.COMPLETE;
                stringBuilder.append(this.context.getText(17039544));
            } else {
                this.state = MmiCode.State.FAILED;
                stringBuilder.append(this.context.getText(17039538));
            }
        }
        this.message = stringBuilder;
        this.phone.onMMIDone(this);
    }

    static String scToBarringFacility(String string2) {
        if (string2 == null) {
            throw new RuntimeException("invalid call barring sc");
        }
        if (string2.equals(SC_BAOC)) {
            return "AO";
        }
        if (string2.equals(SC_BAOIC)) {
            return "OI";
        }
        if (string2.equals(SC_BAOICxH)) {
            return "OX";
        }
        if (string2.equals(SC_BAIC)) {
            return "AI";
        }
        if (string2.equals(SC_BAICr)) {
            return "IR";
        }
        if (string2.equals(SC_BA_ALL)) {
            return "AB";
        }
        if (string2.equals(SC_BA_MO)) {
            return "AG";
        }
        if (string2.equals(SC_BA_MT)) {
            return "AC";
        }
        throw new RuntimeException("invalid call barring sc");
    }

    private static int scToCallForwardReason(String string2) {
        if (string2 == null) {
            throw new RuntimeException("invalid call forward sc");
        }
        if (string2.equals(SC_CF_All)) {
            return 4;
        }
        if (string2.equals(SC_CFU)) {
            return 0;
        }
        if (string2.equals(SC_CFB)) {
            return 1;
        }
        if (string2.equals(SC_CFNR)) {
            return 3;
        }
        if (string2.equals(SC_CFNRy)) {
            return 2;
        }
        if (string2.equals(SC_CF_All_Conditional)) {
            return 5;
        }
        throw new RuntimeException("invalid call forward sc");
    }

    private CharSequence serviceClassToCFString(int n) {
        switch (n) {
            default: {
                return null;
            }
            case 1: {
                return this.context.getText(17039581);
            }
            case 2: {
                return this.context.getText(17039582);
            }
            case 4: {
                return this.context.getText(17039583);
            }
            case 8: {
                return this.context.getText(17039584);
            }
            case 16: {
                return this.context.getText(17039586);
            }
            case 32: {
                return this.context.getText(17039585);
            }
            case 64: {
                return this.context.getText(17039587);
            }
            case 128: 
        }
        return this.context.getText(17039588);
    }

    private static int siToServiceClass(String string2) {
        if (string2 == null || string2.length() == 0) {
            return 0;
        }
        switch (Integer.parseInt(string2, 10)) {
            default: {
                throw new RuntimeException("unsupported MMI service code " + string2);
            }
            case 10: {
                return 13;
            }
            case 11: {
                return 1;
            }
            case 12: {
                return 12;
            }
            case 13: {
                return 4;
            }
            case 16: {
                return 8;
            }
            case 19: {
                return 5;
            }
            case 20: {
                return 48;
            }
            case 21: {
                return 160;
            }
            case 22: {
                return 80;
            }
            case 24: {
                return 16;
            }
            case 25: {
                return 32;
            }
            case 26: {
                return 17;
            }
            case 99: 
        }
        return 64;
    }

    private static int siToTime(String string2) {
        if (string2 == null || string2.length() == 0) {
            return 0;
        }
        return Integer.parseInt(string2, 10);
    }

    @Override
    public void cancel() {
        if (this.state == MmiCode.State.COMPLETE || this.state == MmiCode.State.FAILED) {
            return;
        }
        this.state = MmiCode.State.CANCELLED;
        if (this.isPendingUSSD) {
            this.phone.mCM.cancelPendingUssd(this.obtainMessage(7, this));
            return;
        }
        this.phone.onMMIDone(this);
    }

    int getCLIRMode() {
        if (this.sc != null && this.sc.equals(SC_CLIR)) {
            if (this.isActivate()) {
                return 2;
            }
            if (this.isDeactivate()) {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public CharSequence getMessage() {
        return this.message;
    }

    @Override
    public MmiCode.State getState() {
        return this.state;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void handleMessage(Message message) {
        switch (message.what) {
            case 1: {
                this.onSetComplete((AsyncResult)message.obj);
                return;
            }
            case 6: {
                AsyncResult asyncResult = (AsyncResult)message.obj;
                if (asyncResult.exception == null && message.arg1 == 1) {
                    boolean bl = message.arg2 == 1;
                    this.phone.mSIMRecords.setVoiceCallForwardingFlag(1, bl);
                }
                this.onSetComplete(asyncResult);
                return;
            }
            case 2: {
                this.onGetClirComplete((AsyncResult)message.obj);
                return;
            }
            case 3: {
                this.onQueryCfComplete((AsyncResult)message.obj);
                return;
            }
            case 5: {
                this.onQueryComplete((AsyncResult)message.obj);
                return;
            }
            case 4: {
                AsyncResult asyncResult = (AsyncResult)message.obj;
                if (asyncResult.exception != null) {
                    this.state = MmiCode.State.FAILED;
                    this.message = this.getErrorMessage(asyncResult);
                    this.phone.onMMIDone(this);
                    return;
                }
            }
            default: {
                return;
            }
            case 7: 
        }
        this.phone.onMMIDone(this);
    }

    boolean isActivate() {
        return this.action != null && this.action.equals(ACTION_ACTIVATE);
    }

    @Override
    public boolean isCancelable() {
        return this.isPendingUSSD;
    }

    boolean isDeactivate() {
        return this.action != null && this.action.equals(ACTION_DEACTIVATE);
    }

    boolean isErasure() {
        return this.action != null && this.action.equals(ACTION_ERASURE);
    }

    boolean isInterrogate() {
        return this.action != null && this.action.equals(ACTION_INTERROGATE);
    }

    boolean isMMI() {
        return this.poundString != null;
    }

    public boolean isPendingUSSD() {
        return this.isPendingUSSD;
    }

    boolean isPinCommand() {
        return this.sc != null && (this.sc.equals(SC_PIN) || this.sc.equals(SC_PIN2) || this.sc.equals(SC_PUK) || this.sc.equals(SC_PUK2));
    }

    boolean isRegister() {
        return this.action != null && this.action.equals(ACTION_REGISTER);
    }

    boolean isShortCode() {
        return this.poundString == null && this.dialingNumber != null && this.dialingNumber.length() <= 2;
    }

    boolean isTemporaryModeCLIR() {
        return this.sc != null && this.sc.equals(SC_CLIR) && this.dialingNumber != null && (this.isActivate() || this.isDeactivate());
    }

    @Override
    public boolean isUssdRequest() {
        return this.isUssdRequest;
    }

    /*
     * Enabled aggressive block sorting
     */
    void onUssdFinished(String string2, boolean bl) {
        if (this.state == MmiCode.State.PENDING) {
            this.message = string2 == null ? this.context.getText(17039546) : string2;
            this.isUssdRequest = bl;
            if (!bl) {
                this.state = MmiCode.State.COMPLETE;
            }
            this.phone.onMMIDone(this);
        }
    }

    void onUssdFinishedError() {
        if (this.state == MmiCode.State.PENDING) {
            this.state = MmiCode.State.FAILED;
            this.message = this.context.getText(17039538);
            this.phone.onMMIDone(this);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void processCode() {
        try {
            if (this.isShortCode()) {
                Log.d(LOG_TAG, "isShortCode");
                this.sendUssd(this.dialingNumber);
                return;
            }
            if (this.dialingNumber != null) {
                throw new RuntimeException("Invalid or Unsupported MMI Code");
            }
        }
        catch (RuntimeException runtimeException) {
            this.state = MmiCode.State.FAILED;
            this.message = this.context.getText(17039538);
            this.phone.onMMIDone(this);
            return;
        }
        {
            int n;
            String string2;
            String string3;
            block38: {
                int n2;
                int n3;
                int n4;
                int n5;
                String string4;
                block37: {
                    block39: {
                        block40: {
                            if (this.sc != null && this.sc.equals(SC_CLIP)) {
                                Log.d(LOG_TAG, "is CLIP");
                                if (this.isInterrogate()) {
                                    this.phone.mCM.queryCLIP(this.obtainMessage(5, this));
                                    return;
                                }
                                throw new RuntimeException("Invalid or Unsupported MMI Code");
                            }
                            if (this.sc != null && this.sc.equals(SC_CLIR)) {
                                Log.d(LOG_TAG, "is CLIR");
                                if (this.isActivate()) {
                                    this.phone.mCM.setCLIR(1, this.obtainMessage(1, this));
                                    return;
                                }
                                if (this.isDeactivate()) {
                                    this.phone.mCM.setCLIR(2, this.obtainMessage(1, this));
                                    return;
                                }
                                if (this.isInterrogate()) {
                                    this.phone.mCM.getCLIR(this.obtainMessage(2, this));
                                    return;
                                }
                                throw new RuntimeException("Invalid or Unsupported MMI Code");
                            }
                            if (!GsmMmiCode.isServiceCodeCallForwarding(this.sc)) break block39;
                            Log.d(LOG_TAG, "is CF");
                            string4 = this.sia;
                            n5 = GsmMmiCode.siToServiceClass(this.sib);
                            n4 = GsmMmiCode.scToCallForwardReason(this.sc);
                            n3 = GsmMmiCode.siToTime(this.sic);
                            if (this.isInterrogate()) {
                                this.phone.mCM.queryCallForwardStatus(n4, n5, string4, this.obtainMessage(3, this));
                                return;
                            }
                            if (!this.isActivate()) break block40;
                            n2 = 1;
                            break block37;
                        }
                        if (this.isDeactivate()) {
                            n2 = 0;
                            break block37;
                        } else if (this.isRegister()) {
                            n2 = 3;
                            break block37;
                        } else {
                            if (!this.isErasure()) {
                                throw new RuntimeException("invalid action");
                            }
                            n2 = 4;
                        }
                        break block37;
                    }
                    if (GsmMmiCode.isServiceCodeCallBarring(this.sc)) {
                        String string5 = this.sia;
                        int n6 = GsmMmiCode.siToServiceClass(this.sib);
                        String string6 = GsmMmiCode.scToBarringFacility(this.sc);
                        if (this.isInterrogate()) {
                            this.phone.mCM.queryFacilityLock(string6, string5, n6, this.obtainMessage(5, this));
                            return;
                        }
                        if (!this.isActivate() && !this.isDeactivate()) {
                            throw new RuntimeException("Invalid or Unsupported MMI Code");
                        }
                        this.phone.mCM.setFacilityLock(string6, this.isActivate(), string5, n6, this.obtainMessage(1, this));
                        return;
                    }
                    if (this.sc != null && this.sc.equals(SC_PWD)) {
                        String string7 = this.sib;
                        String string8 = this.sic;
                        if (!this.isActivate() && !this.isRegister()) {
                            throw new RuntimeException("Invalid or Unsupported MMI Code");
                        }
                        this.action = ACTION_REGISTER;
                        String string9 = this.sia == null ? "AB" : GsmMmiCode.scToBarringFacility(this.sia);
                        if (string8.equals(this.pwd)) {
                            CommandsInterface commandsInterface = this.phone.mCM;
                            Message message = this.obtainMessage(1, this);
                            commandsInterface.changeBarringPassword(string9, string7, string8, message);
                            return;
                        }
                        this.handlePasswordError(17039545);
                        return;
                    }
                    if (this.sc != null && this.sc.equals(SC_WAIT)) {
                        int n7 = GsmMmiCode.siToServiceClass(this.sia);
                        if (this.isActivate() || this.isDeactivate()) {
                            this.phone.mCM.setCallWaiting(this.isActivate(), n7, this.obtainMessage(1, this));
                            return;
                        }
                        if (this.isInterrogate()) {
                            this.phone.mCM.queryCallWaiting(n7, this.obtainMessage(5, this));
                            return;
                        }
                        throw new RuntimeException("Invalid or Unsupported MMI Code");
                    }
                    if (this.isPinCommand()) {
                        string3 = this.sia;
                        string2 = this.sib;
                        n = string2.length();
                        if (!this.isRegister()) {
                            throw new RuntimeException("Invalid or Unsupported MMI Code");
                        }
                        if (!string2.equals(this.sic)) {
                            this.handlePasswordError(17039549);
                            return;
                        }
                        break block38;
                    } else {
                        if (this.poundString != null) {
                            this.sendUssd(this.poundString);
                            return;
                        }
                        throw new RuntimeException("Invalid or Unsupported MMI Code");
                    }
                }
                int n8 = !(n4 != 0 && n4 != 4 || (n5 & 1) == 0 && n5 != 0) ? 1 : 0;
                int n9 = n2 == 1 || n2 == 3 ? 1 : 0;
                Log.d(LOG_TAG, "is CF setCallForward");
                this.phone.mCM.setCallForward(n2, n4, n5, string4, n3, this.obtainMessage(6, n8, n9, this));
                return;
            }
            if (n >= 4 && n <= 8) {
                if (this.sc.equals(SC_PIN) && this.phone.mSimCard.getState() == IccCard.State.PUK_REQUIRED) {
                    this.handlePasswordError(17039551);
                    return;
                }
                if (this.sc.equals(SC_PIN)) {
                    this.phone.mCM.changeIccPin(string3, string2, this.obtainMessage(1, this));
                    return;
                }
                if (this.sc.equals(SC_PIN2)) {
                    this.phone.mCM.changeIccPin2(string3, string2, this.obtainMessage(1, this));
                    return;
                }
                if (this.sc.equals(SC_PUK)) {
                    this.phone.mCM.supplyIccPuk(string3, string2, this.obtainMessage(1, this));
                    return;
                }
                if (this.sc.equals(SC_PUK2)) {
                    this.phone.mCM.supplyIccPuk2(string3, string2, this.obtainMessage(1, this));
                    return;
                }
                return;
            }
            this.handlePasswordError(17039550);
            return;
        }
    }

    void sendUssd(String string2) {
        this.isPendingUSSD = true;
        this.phone.mCM.sendUSSD(string2, this.obtainMessage(4, this));
    }
}

