/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.app.PendingIntent;
import android.content.Intent;
import android.os.AsyncResult;
import android.os.Message;
import android.telephony.SmsMessage;
import android.util.Log;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.SMSDispatcher;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.gsm.SmsMessage;
import java.util.ArrayList;
import java.util.HashMap;

final class GsmSMSDispatcher
extends SMSDispatcher {
    private static final String TAG = "GSM";
    private GSMPhone mGsmPhone;

    GsmSMSDispatcher(GSMPhone gSMPhone) {
        super(gSMPhone);
        this.mGsmPhone = gSMPhone;
    }

    private int resultToCause(int n) {
        switch (n) {
            default: {
                return 255;
            }
            case -1: 
            case 1: {
                return 0;
            }
            case 3: 
        }
        return 211;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void sendMultipartTextWithPermit(String string2, String string3, ArrayList<String> arrayList, ArrayList<PendingIntent> arrayList2, ArrayList<PendingIntent> arrayList3) {
        int n = this.mPhone.getServiceState().getState();
        if (n != 0) {
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                PendingIntent pendingIntent = null;
                if (arrayList2 != null) {
                    int n3 = arrayList2.size();
                    pendingIntent = null;
                    if (n3 > i) {
                        pendingIntent = arrayList2.get(i);
                    }
                }
                this.handleNotInService(n, this.SmsTrackerFactory(null, pendingIntent, null));
            }
            return;
        } else {
            int n4 = 0xFF & GsmSMSDispatcher.getNextConcatenatedRef();
            int n5 = arrayList.size();
            int n6 = 0;
            mRemainingMessages = n5;
            for (int i = 0; i < n5; ++i) {
                SmsMessageBase.TextEncodingDetails textEncodingDetails = SmsMessage.calculateLength(arrayList.get(i), false);
                if (n6 == textEncodingDetails.codeUnitSize || n6 != 0 && n6 != 1) continue;
                n6 = textEncodingDetails.codeUnitSize;
            }
            for (int i = 0; i < n5; ++i) {
                SmsHeader.ConcatRef concatRef = new SmsHeader.ConcatRef();
                concatRef.refNumber = n4;
                concatRef.seqNumber = i + 1;
                concatRef.msgCount = n5;
                concatRef.isEightBits = false;
                SmsHeader smsHeader = new SmsHeader();
                smsHeader.concatRef = concatRef;
                PendingIntent pendingIntent = null;
                if (arrayList2 != null) {
                    int n7 = arrayList2.size();
                    pendingIntent = null;
                    if (n7 > i) {
                        pendingIntent = arrayList2.get(i);
                    }
                }
                PendingIntent pendingIntent2 = null;
                if (arrayList3 != null) {
                    int n8 = arrayList3.size();
                    pendingIntent2 = null;
                    if (n8 > i) {
                        pendingIntent2 = arrayList3.get(i);
                    }
                }
                String string4 = arrayList.get(i);
                boolean bl = pendingIntent2 != null;
                SmsMessage.SubmitPdu submitPdu = SmsMessage.getSubmitPdu(string3, string2, string4, bl, SmsHeader.toByteArray(smsHeader), n6);
                HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
                hashMap.put("smsc", submitPdu.encodedScAddress);
                hashMap.put("pdu", submitPdu.encodedMessage);
                this.sendSms(this.SmsTrackerFactory(hashMap, pendingIntent, pendingIntent2));
            }
        }
    }

    @Override
    protected void acknowledgeLastIncomingSms(boolean bl, int n, Message message) {
        if (this.mCm != null) {
            this.mCm.acknowledgeLastIncomingGsmSms(bl, this.resultToCause(n), message);
        }
    }

    @Override
    protected void activateCellBroadcastSms(int n, Message message) {
        Log.e(TAG, "Error! The functionality cell broadcast sms is not implemented for GSM.");
        message.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected int dispatchMessage(SmsMessageBase smsMessageBase) {
        boolean bl;
        if (smsMessageBase == null) {
            return 2;
        }
        SmsMessage smsMessage = (SmsMessage)smsMessageBase;
        if (smsMessage.isTypeZero()) {
            Log.d(TAG, "Received short message type 0, Don't display or store it. Send Ack");
            return 1;
        }
        if (smsMessage.isMWISetMessage()) {
            this.mGsmPhone.updateMessageWaitingIndicator(true);
            bl = smsMessage.isMwiDontStore();
            StringBuilder stringBuilder = new StringBuilder().append("Received voice mail indicator set SMS shouldStore=");
            boolean bl2 = !bl;
            Log.d(TAG, stringBuilder.append(bl2).toString());
        } else {
            boolean bl3 = smsMessage.isMWIClearMessage();
            bl = false;
            if (bl3) {
                this.mGsmPhone.updateMessageWaitingIndicator(false);
                bl = smsMessage.isMwiDontStore();
                StringBuilder stringBuilder = new StringBuilder().append("Received voice mail indicator clear SMS shouldStore=");
                boolean bl4 = !bl;
                Log.d(TAG, stringBuilder.append(bl4).toString());
            }
        }
        if (bl) {
            return 1;
        }
        if (!this.mStorageAvailable && smsMessage.getMessageClass() != SmsMessage.MessageClass.CLASS_0) {
            return 3;
        }
        SmsHeader smsHeader = smsMessage.getUserDataHeader();
        if (smsHeader != null) {
            if (smsHeader.concatRef != null) return this.processMessagePart(smsMessage, smsHeader.concatRef, smsHeader.portAddrs);
        }
        byte[][] byArrayArray = new byte[][]{smsMessage.getPdu()};
        if (smsHeader != null && smsHeader.portAddrs != null) {
            if (smsHeader.portAddrs.destPort == 2948) {
                return this.mWapPush.dispatchWapPdu(smsMessage.getUserData());
            }
            this.dispatchPortAddressedPdus(byArrayArray, smsHeader.portAddrs.destPort);
            return -1;
        }
        this.dispatchPdus(byArrayArray);
        return -1;
    }

    @Override
    protected void getCellBroadcastSmsConfig(Message message) {
        Log.e(TAG, "Error! The functionality cell broadcast sms is not implemented for GSM.");
        message.recycle();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void handleStatusReport(AsyncResult asyncResult) {
        String string2 = (String)asyncResult.result;
        SmsMessage smsMessage = SmsMessage.newFromCDS(string2);
        int n = smsMessage.getStatus();
        if (smsMessage != null) {
            int n2 = smsMessage.messageRef;
            int n3 = this.deliveryPendingList.size();
            for (int i = 0; i < n3; ++i) {
                SMSDispatcher.SmsTracker smsTracker = (SMSDispatcher.SmsTracker)this.deliveryPendingList.get(i);
                if (smsTracker.mMessageRef != n2) continue;
                if (n >= 64 || n < 32) {
                    this.deliveryPendingList.remove(i);
                }
                PendingIntent pendingIntent = smsTracker.mDeliveryIntent;
                Intent intent = new Intent();
                intent.putExtra("pdu", IccUtils.hexStringToBytes(string2));
                try {
                    pendingIntent.send(this.mContext, -1, intent);
                }
                catch (PendingIntent.CanceledException canceledException) {}
                break;
            }
        }
        this.acknowledgeLastIncomingSms(true, 1, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void sendData(String string2, String string3, int n, byte[] byArray, PendingIntent pendingIntent, PendingIntent pendingIntent2) {
        boolean bl = pendingIntent2 != null;
        SmsMessage.SubmitPdu submitPdu = SmsMessage.getSubmitPdu(string3, string2, n, byArray, bl);
        this.sendRawPdu(submitPdu.encodedScAddress, submitPdu.encodedMessage, pendingIntent, pendingIntent2);
    }

    @Override
    protected void sendMultipartSms(SMSDispatcher.SmsTracker smsTracker) {
        HashMap hashMap = smsTracker.mData;
        this.sendMultipartTextWithPermit((String)hashMap.get("destination"), (String)hashMap.get("scaddress"), (ArrayList)hashMap.get("parts"), (ArrayList)hashMap.get("sentIntents"), (ArrayList)hashMap.get("deliveryIntents"));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void sendMultipartText(String string2, String string3, ArrayList<String> arrayList, ArrayList<PendingIntent> arrayList2, ArrayList<PendingIntent> arrayList3) {
        int n = 0xFF & GsmSMSDispatcher.getNextConcatenatedRef();
        int n2 = arrayList.size();
        int n3 = 0;
        mRemainingMessages = n2;
        for (int i = 0; i < n2; ++i) {
            SmsMessageBase.TextEncodingDetails textEncodingDetails = SmsMessage.calculateLength(arrayList.get(i), false);
            if (n3 == textEncodingDetails.codeUnitSize || n3 != 0 && n3 != 1) continue;
            n3 = textEncodingDetails.codeUnitSize;
        }
        int n4 = 0;
        while (n4 < n2) {
            SmsHeader.ConcatRef concatRef = new SmsHeader.ConcatRef();
            concatRef.refNumber = n;
            concatRef.seqNumber = n4 + 1;
            concatRef.msgCount = n2;
            concatRef.isEightBits = true;
            SmsHeader smsHeader = new SmsHeader();
            smsHeader.concatRef = concatRef;
            PendingIntent pendingIntent = null;
            if (arrayList2 != null) {
                int n5 = arrayList2.size();
                pendingIntent = null;
                if (n5 > n4) {
                    pendingIntent = arrayList2.get(n4);
                }
            }
            PendingIntent pendingIntent2 = null;
            if (arrayList3 != null) {
                int n6 = arrayList3.size();
                pendingIntent2 = null;
                if (n6 > n4) {
                    pendingIntent2 = arrayList3.get(n4);
                }
            }
            String string4 = arrayList.get(n4);
            boolean bl = pendingIntent2 != null;
            SmsMessage.SubmitPdu submitPdu = SmsMessage.getSubmitPdu(string3, string2, string4, bl, SmsHeader.toByteArray(smsHeader), n3);
            this.sendRawPdu(submitPdu.encodedScAddress, submitPdu.encodedMessage, pendingIntent, pendingIntent2);
            ++n4;
        }
        return;
    }

    @Override
    protected void sendSms(SMSDispatcher.SmsTracker smsTracker) {
        HashMap hashMap = smsTracker.mData;
        byte[] byArray = (byte[])hashMap.get("smsc");
        byte[] byArray2 = (byte[])hashMap.get("pdu");
        Message message = this.obtainMessage(2, smsTracker);
        this.mCm.sendSMS(IccUtils.bytesToHexString(byArray), IccUtils.bytesToHexString(byArray2), message);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void sendText(String string2, String string3, String string4, PendingIntent pendingIntent, PendingIntent pendingIntent2) {
        boolean bl = pendingIntent2 != null;
        SmsMessage.SubmitPdu submitPdu = SmsMessage.getSubmitPdu(string3, string2, string4, bl);
        this.sendRawPdu(submitPdu.encodedScAddress, submitPdu.encodedMessage, pendingIntent, pendingIntent2);
    }

    @Override
    protected void setCellBroadcastConfig(int[] nArray, Message message) {
        Log.e(TAG, "Error! The functionality cell broadcast sms is not implemented for GSM.");
        message.recycle();
    }
}

