/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.app.AlarmManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.provider.Settings;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.telephony.gsm.GsmCellLocation;
import android.text.TextUtils;
import android.util.EventLog;
import android.util.Log;
import android.util.TimeUtils;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.DataConnectionTracker;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.ServiceStateTracker;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.gsm.RestrictedState;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

final class GsmServiceStateTracker
extends ServiceStateTracker {
    static final int CS_DISABLED = 1004;
    static final int CS_EMERGENCY_ENABLED = 1006;
    static final int CS_ENABLED = 1003;
    static final int CS_NORMAL_ENABLED = 1005;
    static final int CS_NOTIFICATION = 999;
    static final boolean DBG = true;
    static final int DEFAULT_GPRS_CHECK_PERIOD_MILLIS = 60000;
    static final String LOG_TAG = "GSM";
    static final int MAX_NUM_DATA_STATE_READS = 15;
    static final int PS_DISABLED = 1002;
    static final int PS_ENABLED = 1001;
    static final int PS_NOTIFICATION = 888;
    private static final String WAKELOCK_TAG = "ServiceStateTracker";
    GsmCellLocation cellLoc;
    private ContentResolver cr;
    private String curPlmn = null;
    private String curSpn = null;
    private int curSpnRule = 0;
    private RegistrantList gprsAttachedRegistrants = new RegistrantList();
    private RegistrantList gprsDetachedRegistrants = new RegistrantList();
    private int gprsState = 1;
    private ContentObserver mAutoTimeObserver;
    private boolean mDataRoaming = false;
    private boolean mEmergencyOnly = false;
    private boolean mGotCountryCode = false;
    private boolean mGsmRoaming = false;
    private BroadcastReceiver mIntentReceiver;
    private boolean mNeedFixZone = false;
    private boolean mNeedToRegForSimLoaded;
    private Notification mNotification;
    int mPreferredNetworkType;
    private boolean mReportedGprsNoReg = false;
    long mSavedAtTime;
    long mSavedTime;
    String mSavedTimeZone;
    private boolean mStartedGprsRegCheck = false;
    private PowerManager.WakeLock mWakeLock;
    private boolean mZoneDst;
    private int mZoneOffset;
    private long mZoneTime;
    private int networkType = 0;
    GsmCellLocation newCellLoc;
    private int newGPRSState = 1;
    private int newNetworkType = 0;
    GSMPhone phone;
    private RegistrantList psRestrictDisabledRegistrants;
    private RegistrantList psRestrictEnabledRegistrants = new RegistrantList();
    RestrictedState rs;

    /*
     * Enabled aggressive block sorting
     */
    public GsmServiceStateTracker(GSMPhone gSMPhone) {
        this.psRestrictDisabledRegistrants = new RegistrantList();
        this.mIntentReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                if (intent.getAction().equals("android.intent.action.LOCALE_CHANGED")) {
                    GsmServiceStateTracker.this.updateSpnDisplay();
                }
            }
        };
        this.mAutoTimeObserver = new ContentObserver(new Handler()){

            @Override
            public void onChange(boolean bl) {
                Log.i("GsmServiceStateTracker", "Auto time state changed");
                GsmServiceStateTracker.this.revertToNitz();
            }
        };
        this.phone = gSMPhone;
        this.cm = gSMPhone.mCM;
        this.ss = new ServiceState();
        this.newSS = new ServiceState();
        this.cellLoc = new GsmCellLocation();
        this.newCellLoc = new GsmCellLocation();
        this.rs = new RestrictedState();
        this.mSignalStrength = new SignalStrength();
        this.mWakeLock = ((PowerManager)gSMPhone.getContext().getSystemService("power")).newWakeLock(1, WAKELOCK_TAG);
        this.cm.registerForAvailable(this, 13, null);
        this.cm.registerForRadioStateChanged(this, 1, null);
        this.cm.registerForNetworkStateChanged(this, 2, null);
        this.cm.setOnNITZTime(this, 11, null);
        this.cm.setOnSignalStrengthUpdate(this, 12, null);
        this.cm.setOnRestrictedStateChanged(this, 23, null);
        this.cm.registerForSIMReady(this, 17, null);
        boolean bl = Settings.System.getInt(gSMPhone.getContext().getContentResolver(), "airplane_mode_on", 0) <= 0;
        this.mDesiredPowerState = bl;
        this.cr = gSMPhone.getContext().getContentResolver();
        this.cr.registerContentObserver(Settings.System.getUriFor("auto_time"), true, this.mAutoTimeObserver);
        this.setSignalStrengthDefaultValues();
        this.mNeedToRegForSimLoaded = true;
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.LOCALE_CHANGED");
        gSMPhone.getContext().registerReceiver(this.mIntentReceiver, intentFilter);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String displayNameFor(int n) {
        int n2 = n / 1000 / 60;
        char[] cArray = new char[9];
        cArray[0] = 71;
        cArray[1] = 77;
        cArray[2] = 84;
        if (n2 < 0) {
            cArray[3] = 45;
            n2 = -n2;
        } else {
            cArray[3] = 43;
        }
        int n3 = n2 / 60;
        int n4 = n2 % 60;
        cArray[4] = (char)(48 + n3 / 10);
        cArray[5] = (char)(48 + n3 % 10);
        cArray[6] = 58;
        cArray[7] = (char)(48 + n4 / 10);
        cArray[8] = (char)(48 + n4 % 10);
        return new String(cArray);
    }

    private TimeZone findTimeZone(int n, boolean bl, long l) {
        int n2 = n;
        if (bl) {
            n2 -= 3600000;
        }
        String[] stringArray = TimeZone.getAvailableIDs(n2);
        Date date = new Date(l);
        int n3 = stringArray.length;
        int n4 = 0;
        while (true) {
            block6: {
                TimeZone timeZone;
                block5: {
                    timeZone = null;
                    if (n4 >= n3) break block5;
                    TimeZone timeZone2 = TimeZone.getTimeZone(stringArray[n4]);
                    if (timeZone2.getOffset(l) != n || timeZone2.inDaylightTime(date) != bl) break block6;
                    timeZone = timeZone2;
                }
                return timeZone;
            }
            ++n4;
        }
    }

    private boolean getAutoTime() {
        try {
            int n = Settings.System.getInt(this.phone.getContext().getContentResolver(), "auto_time");
            return n > 0;
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private TimeZone getNitzTimeZone(int n, boolean bl, long l) {
        TimeZone timeZone = this.findTimeZone(n, bl, l);
        if (timeZone == null) {
            boolean bl2 = !bl;
            timeZone = this.findTimeZone(n, bl2, l);
        }
        StringBuilder stringBuilder = new StringBuilder().append("getNitzTimeZone returning ");
        Object object = timeZone == null ? timeZone : timeZone.getID();
        Log.d(LOG_TAG, stringBuilder.append(object).toString());
        return timeZone;
    }

    private boolean isGprsConsistent(int n, int n2) {
        return n2 != 0 || n == 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isRoamingBetweenOperators(boolean bl, ServiceState serviceState) {
        String string2 = SystemProperties.get("gsm.sim.operator.alpha", "empty");
        String string3 = serviceState.getOperatorAlphaLong();
        String string4 = serviceState.getOperatorAlphaShort();
        boolean bl2 = string3 != null && string2.equals(string3);
        boolean bl3 = string4 != null && string2.equals(string4);
        String string5 = SystemProperties.get("gsm.sim.operator.numeric", "");
        String string6 = serviceState.getOperatorNumeric();
        boolean bl4 = true;
        try {
            boolean bl5;
            bl4 = bl5 = string5.substring(0, 3).equals(string6.substring(0, 3));
            return bl && (!bl4 || !bl2 && !bl3);
        }
        catch (Exception exception) {}
        return bl && (!bl4 || !bl2 && !bl3);
    }

    private void log(String string2) {
        Log.d(LOG_TAG, "[GsmServiceStateTracker] " + string2);
    }

    private static String networkTypeToString(int n) {
        switch (n) {
            default: {
                Log.e(LOG_TAG, "Wrong network type: " + Integer.toString(n));
                return "unknown";
            }
            case 1: {
                return "GPRS";
            }
            case 2: {
                return "EDGE";
            }
            case 3: {
                return "UMTS";
            }
            case 9: {
                return "HSDPA";
            }
            case 10: {
                return "HSUPA";
            }
            case 11: 
        }
        return "HSPA";
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onRestrictedStateChanged(AsyncResult asyncResult) {
        block18: {
            RestrictedState restrictedState;
            block21: {
                block24: {
                    block25: {
                        block22: {
                            block23: {
                                block19: {
                                    block20: {
                                        Log.d(LOG_TAG, "[DSAC DEB] onRestrictedStateChanged");
                                        restrictedState = new RestrictedState();
                                        Log.d(LOG_TAG, "[DSAC DEB] current rs at enter " + this.rs);
                                        if (asyncResult.exception != null) break block18;
                                        int n = ((int[])asyncResult.result)[0];
                                        boolean bl = (n & 1) != 0 || (n & 4) != 0;
                                        restrictedState.setCsEmergencyRestricted(bl);
                                        if (this.phone.getIccCard().getState() == IccCard.State.READY) {
                                            boolean bl2 = (n & 2) != 0 || (n & 4) != 0;
                                            restrictedState.setCsNormalRestricted(bl2);
                                            boolean bl3 = (n & 0x10) != 0;
                                            restrictedState.setPsRestricted(bl3);
                                        }
                                        Log.d(LOG_TAG, "[DSAC DEB] new rs " + restrictedState);
                                        if (!this.rs.isPsRestricted() && restrictedState.isPsRestricted()) {
                                            this.psRestrictEnabledRegistrants.notifyRegistrants();
                                            this.setNotification(1001);
                                        } else if (this.rs.isPsRestricted() && !restrictedState.isPsRestricted()) {
                                            this.psRestrictDisabledRegistrants.notifyRegistrants();
                                            this.setNotification(1002);
                                        }
                                        if (!this.rs.isCsRestricted()) break block19;
                                        if (restrictedState.isCsRestricted()) break block20;
                                        this.setNotification(1004);
                                        break block21;
                                    }
                                    if (!restrictedState.isCsNormalRestricted()) {
                                        this.setNotification(1006);
                                        break block21;
                                    } else if (!restrictedState.isCsEmergencyRestricted()) {
                                        this.setNotification(1005);
                                    }
                                    break block21;
                                }
                                if (!this.rs.isCsEmergencyRestricted() || this.rs.isCsNormalRestricted()) break block22;
                                if (restrictedState.isCsRestricted()) break block23;
                                this.setNotification(1004);
                                break block21;
                            }
                            if (restrictedState.isCsRestricted()) {
                                this.setNotification(1003);
                                break block21;
                            } else if (restrictedState.isCsNormalRestricted()) {
                                this.setNotification(1005);
                            }
                            break block21;
                        }
                        if (this.rs.isCsEmergencyRestricted() || !this.rs.isCsNormalRestricted()) break block24;
                        if (restrictedState.isCsRestricted()) break block25;
                        this.setNotification(1004);
                        break block21;
                    }
                    if (restrictedState.isCsRestricted()) {
                        this.setNotification(1003);
                        break block21;
                    } else if (restrictedState.isCsEmergencyRestricted()) {
                        this.setNotification(1006);
                    }
                    break block21;
                }
                if (restrictedState.isCsRestricted()) {
                    this.setNotification(1003);
                } else if (restrictedState.isCsEmergencyRestricted()) {
                    this.setNotification(1006);
                } else if (restrictedState.isCsNormalRestricted()) {
                    this.setNotification(1005);
                }
            }
            this.rs = restrictedState;
        }
        Log.d(LOG_TAG, "[DSAC DEB] current rs at return " + this.rs);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void onSignalStrengthResult(AsyncResult asyncResult) {
        SignalStrength signalStrength = this.mSignalStrength;
        int n = 99;
        if (asyncResult.exception != null) {
            this.setSignalStrengthDefaultValues();
        } else {
            int[] nArray = (int[])asyncResult.result;
            if (nArray.length != 0) {
                n = nArray[0];
            } else {
                Log.e(LOG_TAG, "Bogus signal strength response");
                n = 99;
            }
        }
        this.mSignalStrength = new SignalStrength(n, -1, -1, -1, -1, -1, -1, true);
        if (this.mSignalStrength.equals(signalStrength)) return;
        try {
            this.phone.notifySignalStrength();
            return;
        }
        catch (NullPointerException nullPointerException) {
            this.log("onSignalStrengthResult() Phone already destroyed: " + nullPointerException + "SignalStrength not notified");
            return;
        }
    }

    private void pollState() {
        this.pollingContext = new int[1];
        this.pollingContext[0] = 0;
        switch (3.$SwitchMap$com$android$internal$telephony$CommandsInterface$RadioState[this.cm.getRadioState().ordinal()]) {
            default: {
                int[] nArray = this.pollingContext;
                nArray[0] = 1 + nArray[0];
                this.cm.getOperator(this.obtainMessage(6, this.pollingContext));
                int[] nArray2 = this.pollingContext;
                nArray2[0] = 1 + nArray2[0];
                this.cm.getGPRSRegistrationState(this.obtainMessage(5, this.pollingContext));
                int[] nArray3 = this.pollingContext;
                nArray3[0] = 1 + nArray3[0];
                this.cm.getRegistrationState(this.obtainMessage(4, this.pollingContext));
                int[] nArray4 = this.pollingContext;
                nArray4[0] = 1 + nArray4[0];
                this.cm.getNetworkSelectionMode(this.obtainMessage(14, this.pollingContext));
                return;
            }
            case 1: {
                this.newSS.setStateOutOfService();
                this.newCellLoc.setStateInvalid();
                this.setSignalStrengthDefaultValues();
                this.mGotCountryCode = false;
                this.pollStateDone();
                return;
            }
            case 2: {
                this.newSS.setStateOff();
                this.newCellLoc.setStateInvalid();
                this.setSignalStrengthDefaultValues();
                this.mGotCountryCode = false;
                this.pollStateDone();
                return;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
        }
        Log.d(LOG_TAG, "Radio Technology Change ongoing, setting SS to off");
        this.newSS.setStateOff();
        this.newCellLoc.setStateInvalid();
        this.setSignalStrengthDefaultValues();
        this.mGotCountryCode = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void pollStateDone() {
        Log.d(LOG_TAG, "Poll ServiceState done:  oldSS=[" + this.ss + "] newSS=[" + this.newSS + "] oldGprs=" + this.gprsState + " newGprs=" + this.newGPRSState + " oldType=" + GsmServiceStateTracker.networkTypeToString(this.networkType) + " newType=" + GsmServiceStateTracker.networkTypeToString(this.newNetworkType));
        boolean bl = this.ss.getState() != 0 && this.newSS.getState() == 0;
        if (this.ss.getState() != 0 || this.newSS.getState() != 0) {
            // empty if block
        }
        boolean bl2 = this.gprsState != 0 && this.newGPRSState == 0;
        boolean bl3 = this.gprsState == 0 && this.newGPRSState != 0;
        boolean bl4 = this.networkType != this.newNetworkType;
        boolean bl5 = !this.newSS.equals(this.ss);
        boolean bl6 = !this.ss.getRoaming() && this.newSS.getRoaming();
        boolean bl7 = this.ss.getRoaming() && !this.newSS.getRoaming();
        boolean bl8 = !this.newCellLoc.equals(this.cellLoc);
        if (this.ss.getState() != this.newSS.getState() || this.gprsState != this.newGPRSState) {
            Object[] objectArray = new Object[]{this.ss.getState(), this.gprsState, this.newSS.getState(), this.newGPRSState};
            EventLog.writeEvent(50114, objectArray);
        }
        ServiceState serviceState = this.ss;
        this.ss = this.newSS;
        this.newSS = serviceState;
        this.newSS.setStateOutOfService();
        GsmCellLocation gsmCellLocation = this.cellLoc;
        this.cellLoc = this.newCellLoc;
        this.newCellLoc = gsmCellLocation;
        if (bl4) {
            int n = -1;
            GsmCellLocation gsmCellLocation2 = (GsmCellLocation)this.phone.getCellLocation();
            if (gsmCellLocation2 != null) {
                n = gsmCellLocation2.getCid();
            }
            Object[] objectArray = new Object[]{n, this.networkType, this.newNetworkType};
            EventLog.writeEvent(50112, objectArray);
            Log.d(LOG_TAG, "RAT switched " + GsmServiceStateTracker.networkTypeToString(this.networkType) + " -> " + GsmServiceStateTracker.networkTypeToString(this.newNetworkType) + " at cell " + n);
        }
        this.gprsState = this.newGPRSState;
        this.networkType = this.newNetworkType;
        this.newSS.setStateOutOfService();
        if (bl4) {
            this.phone.setSystemProperty("gsm.network.type", GsmServiceStateTracker.networkTypeToString(this.networkType));
        }
        if (bl) {
            this.networkAttachedRegistrants.notifyRegistrants();
        }
        if (bl5) {
            this.updateSpnDisplay();
            this.phone.setSystemProperty("gsm.operator.alpha", this.ss.getOperatorAlphaLong());
            String string2 = this.ss.getOperatorNumeric();
            this.phone.setSystemProperty("gsm.operator.numeric", string2);
            if (string2 == null) {
                this.phone.setSystemProperty("gsm.operator.iso-country", "");
            } else {
                String string3 = "";
                try {
                    String string4;
                    string3 = string4 = MccTable.countryCodeForMcc(Integer.parseInt(string2.substring(0, 3)));
                }
                catch (NumberFormatException numberFormatException) {
                    Log.w(LOG_TAG, "countryCodeForMcc error" + numberFormatException);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    Log.w(LOG_TAG, "countryCodeForMcc error" + stringIndexOutOfBoundsException);
                }
                this.phone.setSystemProperty("gsm.operator.iso-country", string3);
                this.mGotCountryCode = true;
                if (this.mNeedFixZone) {
                    TimeZone timeZone;
                    String string5 = SystemProperties.get("persist.sys.timezone");
                    if (this.mZoneOffset == 0 && !this.mZoneDst && string5 != null && string5.length() > 0 && Arrays.binarySearch(GMT_COUNTRY_CODES, string3) < 0) {
                        timeZone = TimeZone.getDefault();
                        long l = System.currentTimeMillis();
                        long l2 = timeZone.getOffset(l);
                        if (this.getAutoTime()) {
                            this.setAndBroadcastNetworkSetTime(System.currentTimeMillis() - l2);
                        } else {
                            this.mSavedTime -= l2;
                        }
                    } else {
                        timeZone = string3.equals("") ? this.getNitzTimeZone(this.mZoneOffset, this.mZoneDst, this.mZoneTime) : TimeUtils.getTimeZone(this.mZoneOffset, this.mZoneDst, this.mZoneTime, string3);
                    }
                    this.mNeedFixZone = false;
                    if (timeZone != null) {
                        if (this.getAutoTime()) {
                            this.setAndBroadcastNetworkSetTimeZone(timeZone.getID());
                        }
                        this.saveNitzTimeZone(timeZone.getID());
                    }
                }
            }
            GSMPhone gSMPhone = this.phone;
            String string6 = this.ss.getRoaming() ? "true" : "false";
            gSMPhone.setSystemProperty("gsm.operator.isroaming", string6);
            this.phone.notifyServiceStateChanged(this.ss);
        }
        if (bl2) {
            this.gprsAttachedRegistrants.notifyRegistrants();
        }
        if (bl3) {
            this.gprsDetachedRegistrants.notifyRegistrants();
        }
        if (bl4) {
            this.phone.notifyDataConnection(null);
        }
        if (bl6) {
            this.roamingOnRegistrants.notifyRegistrants();
        }
        if (bl7) {
            this.roamingOffRegistrants.notifyRegistrants();
        }
        if (bl8) {
            this.phone.notifyLocationChanged();
        }
        if (this.isGprsConsistent(this.gprsState, this.ss.getState())) {
            this.mReportedGprsNoReg = false;
            return;
        }
        if (!this.mStartedGprsRegCheck && !this.mReportedGprsNoReg) {
            this.mStartedGprsRegCheck = true;
            int n = Settings.Secure.getInt(this.phone.getContext().getContentResolver(), "gprs_register_check_period_ms", 60000);
            this.sendMessageDelayed(this.obtainMessage(22), n);
        }
    }

    private void queueNextSignalStrengthPoll() {
        if (this.dontPollSignalStrength || this.cm.getRadioState().isCdma()) {
            return;
        }
        Message message = this.obtainMessage();
        message.what = 10;
        this.sendMessageDelayed(message, 20000L);
    }

    private boolean regCodeIsRoaming(int n) {
        return 5 == n;
    }

    private int regCodeToServiceState(int n) {
        int n2 = 0;
        switch (n) {
            default: {
                Log.w(LOG_TAG, "unexpected service state " + n);
                n2 = 1;
            }
            case 1: 
            case 5: {
                return n2;
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
        }
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void revertToNitz() {
        block3: {
            block2: {
                if (Settings.System.getInt(this.phone.getContext().getContentResolver(), "auto_time", 0) == 0) break block2;
                Log.d(LOG_TAG, "Reverting to NITZ: tz='" + this.mSavedTimeZone + "' mSavedTime=" + this.mSavedTime + " mSavedAtTime=" + this.mSavedAtTime);
                if (this.mSavedTimeZone != null && this.mSavedTime != 0L && this.mSavedAtTime != 0L) break block3;
            }
            return;
        }
        this.setAndBroadcastNetworkSetTimeZone(this.mSavedTimeZone);
        this.setAndBroadcastNetworkSetTime(this.mSavedTime + (SystemClock.elapsedRealtime() - this.mSavedAtTime));
    }

    private void saveNitzTime(long l) {
        this.mSavedTime = l;
        this.mSavedAtTime = SystemClock.elapsedRealtime();
    }

    private void saveNitzTimeZone(String string2) {
        this.mSavedTimeZone = string2;
    }

    private void setAndBroadcastNetworkSetTime(long l) {
        SystemClock.setCurrentTimeMillis(l);
        Intent intent = new Intent("android.intent.action.NETWORK_SET_TIME");
        intent.addFlags(0x20000000);
        intent.putExtra("time", l);
        this.phone.getContext().sendStickyBroadcast(intent);
    }

    private void setAndBroadcastNetworkSetTimeZone(String string2) {
        ((AlarmManager)this.phone.getContext().getSystemService("alarm")).setTimeZone(string2);
        Intent intent = new Intent("android.intent.action.NETWORK_SET_TIMEZONE");
        intent.addFlags(0x20000000);
        intent.putExtra("time-zone", string2);
        this.phone.getContext().sendStickyBroadcast(intent);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void setNotification(int n) {
        void var5_5;
        Log.d(LOG_TAG, "[DSAC DEB] create notification " + n);
        Context context = this.phone.getContext();
        this.mNotification = new Notification();
        this.mNotification.when = System.currentTimeMillis();
        this.mNotification.flags = 16;
        this.mNotification.icon = 17301642;
        Intent intent = new Intent();
        this.mNotification.contentIntent = PendingIntent.getActivity(context, 0, intent, 0x10000000);
        String string2 = "";
        CharSequence charSequence = context.getText(17039572);
        int n2 = 999;
        switch (n) {
            case 1001: {
                n2 = 888;
                CharSequence charSequence2 = context.getText(17039573);
                break;
            }
            case 1002: {
                n2 = 888;
                break;
            }
            case 1003: {
                CharSequence charSequence3 = context.getText(17039576);
                break;
            }
            case 1005: {
                CharSequence charSequence4 = context.getText(17039575);
                break;
            }
            case 1006: {
                CharSequence charSequence5 = context.getText(17039574);
            }
        }
        Log.d(LOG_TAG, "[DSAC DEB] put notification " + charSequence + " / " + var5_5);
        this.mNotification.tickerText = charSequence;
        this.mNotification.setLatestEventInfo(context, charSequence, (CharSequence)var5_5, this.mNotification.contentIntent);
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        if (n == 1002 || n == 1004) {
            notificationManager.cancel(n2);
            return;
        }
        notificationManager.notify(n2, this.mNotification);
    }

    private void setSignalStrengthDefaultValues() {
        this.mSignalStrength = new SignalStrength(99, -1, -1, -1, -1, -1, -1, true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setTimeFromNITZString(String var1_1, long var2_2) {
        block20: {
            block21: {
                var4_3 = SystemClock.elapsedRealtime();
                Log.i("GSM", "NITZ: " + var1_1 + "," + var2_2 + " start=" + var4_3 + " delay=" + (var4_3 - var2_2));
                var9_4 = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                var9_4.clear();
                var9_4.set(16, 0);
                var10_5 = var1_1.split("[/:,+-]");
                var9_4.set(1, 2000 + Integer.parseInt(var10_5[0]));
                var9_4.set(2, Integer.parseInt(var10_5[1]) - 1);
                var9_4.set(5, Integer.parseInt(var10_5[2]));
                var9_4.set(10, Integer.parseInt(var10_5[3]));
                var9_4.set(12, Integer.parseInt(var10_5[4]));
                var9_4.set(13, Integer.parseInt(var10_5[5]));
                var11_6 = var1_1.indexOf(45) == -1;
                var12_7 = Integer.parseInt(var10_5[6]);
                var13_8 = var10_5.length >= 8 ? Integer.parseInt(var10_5[7]) : 0;
lbl18:
                // 2 sources

                while (true) {
                    block19: {
                        var15_10 = 1000 * (60 * (15 * (var14_9 * var12_7)));
                        try {
                            block18: {
                                var16_11 = var10_5.length;
                                var17_12 = null;
                                if (var16_11 >= 9) {
                                    var17_12 = TimeZone.getTimeZone(var10_5[8].replace('!', '/'));
                                }
                                var18_13 = SystemProperties.get("gsm.operator.iso-country");
                                if (var17_12 == null && this.mGotCountryCode) {
                                    if (var18_13 != null && var18_13.length() > 0) {
                                        var19_14 = var13_8 != 0;
                                    }
                                    var33_18 = var13_8 != 0;
                                    var34_19 = var9_4.getTimeInMillis();
                                    var17_12 = var36_20 = this.getNitzTimeZone(var15_10, var33_18, var34_19);
                                    break block18;
                                    var20_15 = var9_4.getTimeInMillis();
                                    var17_12 = TimeUtils.getTimeZone(var15_10, var19_14, var20_15, var18_13);
                                }
                            }
                            if (var17_12 == null) {
                                this.mNeedFixZone = true;
                                this.mZoneOffset = var15_10;
                                var22_16 = var13_8 != 0;
                                this.mZoneDst = var22_16;
                                this.mZoneTime = var9_4.getTimeInMillis();
                            }
                            if (var17_12 != null) {
                                if (this.getAutoTime()) {
                                    this.setAndBroadcastNetworkSetTimeZone(var17_12.getID());
                                }
                                this.saveNitzTimeZone(var17_12.getID());
                            }
                            if ((var23_17 = SystemProperties.get("gsm.ignore-nitz")) == null || !var23_17.equals("yes")) break block19;
                            Log.i("GSM", "NITZ: Not setting clock because gsm.ignore-nitz is set");
                            return;
                        }
                        catch (RuntimeException var7_22) {
                            Log.e("GSM", "NITZ: Parsing NITZ time " + var1_1, var7_22);
                            return;
                        }
                    }
                    this.mWakeLock.acquire();
                    if (!this.getAutoTime()) ** GOTO lbl90
                    var25_21 = SystemClock.elapsedRealtime() - var2_2;
                    if (var25_21 >= 0L) break block20;
                    Log.i("GSM", "NITZ: not setting time, clock has rolled backwards since NITZ time was received, " + var1_1);
                    this.mWakeLock.release();
                    return;
                    break;
                }
                if (!var11_6) break block21;
                var14_9 = 1;
                ** GOTO lbl18
            }
            var14_9 = -1;
            ** while (true)
        }
        if (var25_21 > 0x7FFFFFFFL) {
            Log.i("GSM", "NITZ: not setting time, processing has taken " + var25_21 / 86400000L + " days");
            {
                this.mWakeLock.release();
                return;
            }
        }
        var28_23 = (int)var25_21;
        var9_4.add(14, var28_23);
        Log.i("GSM", "NITZ: Setting time of day to " + var9_4.getTime() + " NITZ receive delay(ms): " + var25_21 + " gained(ms): " + (var9_4.getTimeInMillis() - System.currentTimeMillis()) + " from " + var1_1);
        this.setAndBroadcastNetworkSetTime(var9_4.getTimeInMillis());
        Log.i("GSM", "NITZ: after Setting time of day");
        {
            catch (Throwable var24_24) {
                this.mWakeLock.release();
                throw var24_24;
            }
lbl90:
            // 2 sources

            SystemProperties.set("gsm.nitz.time", String.valueOf(var9_4.getTimeInMillis()));
            this.saveNitzTime(var9_4.getTimeInMillis());
            this.mWakeLock.release();
            return;
        }
    }

    private static int twoDigitsAt(String string2, int n) {
        int n2 = Character.digit(string2.charAt(n), 10);
        int n3 = Character.digit(string2.charAt(n + 1), 10);
        if (n2 < 0 || n3 < 0) {
            throw new RuntimeException("invalid format");
        }
        return n3 + n2 * 10;
    }

    public void dispose() {
        this.cm.unregisterForAvailable(this);
        this.cm.unregisterForRadioStateChanged(this);
        this.cm.unregisterForNetworkStateChanged(this);
        this.cm.unregisterForSIMReady(this);
        this.phone.mSIMRecords.unregisterForRecordsLoaded(this);
        this.cm.unSetOnSignalStrengthUpdate(this);
        this.cm.unSetOnRestrictedStateChanged(this);
        this.cm.unSetOnNITZTime(this);
        this.cr.unregisterContentObserver(this.mAutoTimeObserver);
    }

    protected void finalize() {
        Log.d(LOG_TAG, "GsmServiceStateTracker finalized");
    }

    int getCurrentGprsState() {
        return this.gprsState;
    }

    /*
     * Handled duff style switch with additional control
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleMessage(Message message) {
        int n = 0;
        block21: do {
            switch (n == 0 ? message.what : n) {
                default: {
                    Log.e(LOG_TAG, "Unhandled message with number: " + message.what);
                    n = 13;
                    continue block21;
                }
                case 17: {
                    if (this.mNeedToRegForSimLoaded) {
                        this.phone.mSIMRecords.registerForRecordsLoaded(this, 16, null);
                        this.mNeedToRegForSimLoaded = false;
                    }
                    if (!this.phone.getContext().getResources().getBoolean(17629203)) {
                        this.phone.restoreSavedNetworkSelection(null);
                    }
                    this.pollState();
                    this.queueNextSignalStrengthPoll();
                    return;
                }
                case 1: {
                    this.setPowerStateToDesired();
                    this.pollState();
                    return;
                }
                case 2: {
                    this.pollState();
                    return;
                }
                case 3: {
                    n = 13;
                    if (!this.cm.getRadioState().isOn()) continue block21;
                    n = 13;
                    if (this.cm.getRadioState().isCdma()) continue block21;
                    this.onSignalStrengthResult((AsyncResult)message.obj);
                    this.queueNextSignalStrengthPoll();
                    return;
                }
                case 15: {
                    AsyncResult asyncResult = (AsyncResult)message.obj;
                    if (asyncResult.exception == null) {
                        String[] stringArray = (String[])asyncResult.result;
                        int n2 = -1;
                        int n3 = -1;
                        if (stringArray.length >= 3) {
                            try {
                                if (stringArray[1] != null && stringArray[1].length() > 0) {
                                    n2 = Integer.parseInt(stringArray[1], 16);
                                }
                                if (stringArray[2] != null && stringArray[2].length() > 0) {
                                    int n4;
                                    n3 = n4 = Integer.parseInt(stringArray[2], 16);
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                Log.w(LOG_TAG, "error parsing location: " + numberFormatException);
                            }
                        }
                        this.cellLoc.setLacAndCid(n2, n3);
                        this.phone.notifyLocationChanged();
                    }
                    this.disableSingleLocationUpdate();
                    return;
                }
                case 4: 
                case 5: 
                case 6: 
                case 14: {
                    AsyncResult asyncResult = (AsyncResult)message.obj;
                    this.handlePollStateResult(message.what, asyncResult);
                    return;
                }
                case 10: {
                    this.cm.getSignalStrength(this.obtainMessage(3));
                    return;
                }
                case 11: {
                    AsyncResult asyncResult = (AsyncResult)message.obj;
                    this.setTimeFromNITZString((String)((Object[])asyncResult.result)[0], (Long)((Object[])asyncResult.result)[1]);
                    return;
                }
                case 12: {
                    AsyncResult asyncResult = (AsyncResult)message.obj;
                    this.dontPollSignalStrength = true;
                    this.onSignalStrengthResult(asyncResult);
                    return;
                }
                case 16: {
                    this.updateSpnDisplay();
                    return;
                }
                case 18: {
                    n = 13;
                    if (((AsyncResult)message.obj).exception != null) continue block21;
                    this.cm.getRegistrationState(this.obtainMessage(15, null));
                    return;
                }
                case 20: {
                    Message message2 = this.obtainMessage(21, ((AsyncResult)message.obj).userObj);
                    this.cm.setPreferredNetworkType(this.mPreferredNetworkType, message2);
                    return;
                }
                case 21: {
                    AsyncResult asyncResult = (AsyncResult)message.obj;
                    if (asyncResult.userObj != null) {
                        AsyncResult.forMessage((Message)((Message)asyncResult.userObj)).exception = asyncResult.exception;
                        ((Message)asyncResult.userObj).sendToTarget();
                        return;
                    }
                }
                case 13: {
                    return;
                }
                case 19: {
                    AsyncResult asyncResult = (AsyncResult)message.obj;
                    this.mPreferredNetworkType = asyncResult.exception == null ? ((int[])asyncResult.result)[0] : 7;
                    Message message3 = this.obtainMessage(20, asyncResult.userObj);
                    this.cm.setPreferredNetworkType(7, message3);
                    return;
                }
                case 22: {
                    if (this.ss != null && !this.isGprsConsistent(this.gprsState, this.ss.getState())) {
                        GsmCellLocation gsmCellLocation = (GsmCellLocation)this.phone.getCellLocation();
                        Object[] objectArray = new Object[2];
                        objectArray[0] = this.ss.getOperatorNumeric();
                        int n5 = gsmCellLocation != null ? gsmCellLocation.getCid() : -1;
                        objectArray[1] = n5;
                        EventLog.writeEvent(50107, objectArray);
                        this.mReportedGprsNoReg = true;
                    }
                    this.mStartedGprsRegCheck = false;
                    return;
                }
                case 23: 
            }
            break;
        } while (true);
        Log.d(LOG_TAG, "[DSAC DEB] EVENT_RESTRICTED_STATE_CHANGED");
        this.onRestrictedStateChanged((AsyncResult)message.obj);
    }

    /*
     * Exception decompiling
     */
    @Override
    protected void handlePollStateResult(int var1_1, AsyncResult var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [11 : 513->563)] java.lang.RuntimeException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    boolean isConcurrentVoiceAndData() {
        return this.networkType >= 3;
    }

    @Override
    protected void powerOffRadioSafely() {
        DataConnectionTracker dataConnectionTracker = this.phone.mDataConnection;
        Message message = dataConnectionTracker.obtainMessage(34);
        message.arg1 = 1;
        message.obj = "radioTurnedOff";
        dataConnectionTracker.sendMessage(message);
        int n = 0;
        while (true) {
            block6: {
                block5: {
                    if (n >= 15) break block5;
                    if (dataConnectionTracker.getState() == DataConnectionTracker.State.CONNECTED || dataConnectionTracker.getState() == DataConnectionTracker.State.DISCONNECTING) break block6;
                    Log.d(LOG_TAG, "Data shutdown complete.");
                }
                if (this.phone.isInCall()) {
                    this.phone.mCT.ringingCall.hangupIfAlive();
                    this.phone.mCT.backgroundCall.hangupIfAlive();
                    this.phone.mCT.foregroundCall.hangupIfAlive();
                }
                this.cm.setRadioPower(false, null);
                return;
            }
            SystemClock.sleep(100L);
            ++n;
        }
    }

    void registerForGprsAttached(Handler handler, int n, Object object) {
        Registrant registrant = new Registrant(handler, n, object);
        this.gprsAttachedRegistrants.add(registrant);
        if (this.gprsState == 0) {
            registrant.notifyRegistrant();
        }
    }

    void registerForGprsDetached(Handler handler, int n, Object object) {
        Registrant registrant = new Registrant(handler, n, object);
        this.gprsDetachedRegistrants.add(registrant);
        if (this.gprsState == 1) {
            registrant.notifyRegistrant();
        }
    }

    void registerForNetworkAttach(Handler handler, int n, Object object) {
        Registrant registrant = new Registrant(handler, n, object);
        this.networkAttachedRegistrants.add(registrant);
        if (this.ss.getState() == 0) {
            registrant.notifyRegistrant();
        }
    }

    void registerForPsRestrictedDisabled(Handler handler, int n, Object object) {
        Log.d(LOG_TAG, "[DSAC DEB] registerForPsRestrictedDisabled ");
        Registrant registrant = new Registrant(handler, n, object);
        this.psRestrictDisabledRegistrants.add(registrant);
        if (this.rs.isPsRestricted()) {
            registrant.notifyRegistrant();
        }
    }

    void registerForPsRestrictedEnabled(Handler handler, int n, Object object) {
        Log.d(LOG_TAG, "[DSAC DEB] registerForPsRestrictedEnabled ");
        Registrant registrant = new Registrant(handler, n, object);
        this.psRestrictEnabledRegistrants.add(registrant);
        if (this.rs.isPsRestricted()) {
            registrant.notifyRegistrant();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    @Override
    protected void setPowerStateToDesired() {
        if (this.mDesiredPowerState && this.cm.getRadioState() == CommandsInterface.RadioState.RADIO_OFF) {
            this.cm.setRadioPower(true, null);
            return;
        }
        if (this.mDesiredPowerState) return;
        if (!this.cm.getRadioState().isOn()) return;
        DataConnectionTracker dataConnectionTracker = this.phone.mDataConnection;
        if (!dataConnectionTracker.isDataConnectionAsDesired()) {
            Object[] objectArray = new Object[2];
            objectArray[0] = dataConnectionTracker.getStateInString();
            int n = dataConnectionTracker.getAnyDataEnabled() ? 1 : 0;
            objectArray[1] = n;
            EventLog.writeEvent(50108, objectArray);
        }
        this.powerOffRadioSafely();
    }

    void unregisterForGprsAttached(Handler handler) {
        this.gprsAttachedRegistrants.remove(handler);
    }

    void unregisterForGprsDetached(Handler handler) {
        this.gprsDetachedRegistrants.remove(handler);
    }

    void unregisterForNetworkAttach(Handler handler) {
        this.networkAttachedRegistrants.remove(handler);
    }

    void unregisterForPsRestrictedDisabled(Handler handler) {
        this.psRestrictDisabledRegistrants.remove(handler);
    }

    void unregisterForPsRestrictedEnabled(Handler handler) {
        this.psRestrictEnabledRegistrants.remove(handler);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void updateSpnDisplay() {
        int n = this.phone.mSIMRecords.getDisplayRule(this.ss.getOperatorNumeric());
        String string2 = this.phone.mSIMRecords.getServiceProviderName();
        String string3 = this.ss.getOperatorAlphaLong();
        if (this.mEmergencyOnly && this.cm.getRadioState().isOn()) {
            string3 = ((Object)Resources.getSystem().getText(17040016)).toString();
        }
        if (n != this.curSpnRule || !TextUtils.equals(string2, this.curSpn) || !TextUtils.equals(string3, this.curPlmn)) {
            boolean bl = !this.mEmergencyOnly && (n & 1) == 1;
            boolean bl2 = (n & 2) == 2;
            Intent intent = new Intent("android.provider.Telephony.SPN_STRINGS_UPDATED");
            intent.addFlags(0x20000000);
            intent.putExtra("showSpn", bl);
            intent.putExtra("spn", string2);
            intent.putExtra("showPlmn", bl2);
            intent.putExtra("plmn", string3);
            this.phone.getContext().sendStickyBroadcast(intent);
        }
        this.curSpnRule = n;
        this.curSpn = string2;
        this.curPlmn = string3;
    }
}

