/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.telephony.PhoneNumberUtils;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.SmsAddress;

public class GsmSmsAddress
extends SmsAddress {
    static final int OFFSET_ADDRESS_LENGTH = 0;
    static final int OFFSET_ADDRESS_VALUE = 2;
    static final int OFFSET_TOA = 1;

    public GsmSmsAddress(byte[] byArray, int n, int n2) {
        this.origBytes = new byte[n2];
        System.arraycopy(byArray, n, this.origBytes, 0, n2);
        int n3 = 0xFF & this.origBytes[0];
        int n4 = 0xFF & this.origBytes[1];
        this.ton = 7 & n4 >> 4;
        if ((n4 & 0x80) != 128) {
            throw new RuntimeException("Invalid TOA - high bit must be set");
        }
        if (this.isAlphanumeric()) {
            int n5 = n3 * 4 / 7;
            this.address = GsmAlphabet.gsm7BitPackedToString(this.origBytes, 2, n5);
            return;
        }
        byte by = this.origBytes[n2 - 1];
        if ((n3 & 1) == 1) {
            byte[] byArray2 = this.origBytes;
            int n6 = n2 - 1;
            byArray2[n6] = (byte)(0xF0 | byArray2[n6]);
        }
        this.address = PhoneNumberUtils.calledPartyBCDToString(this.origBytes, 1, n2 - 1);
        this.origBytes[n2 - 1] = by;
    }

    @Override
    public String getAddressString() {
        return this.address;
    }

    @Override
    public boolean isAlphanumeric() {
        return this.ton == 5;
    }

    public boolean isCphsVoiceMessageClear() {
        return this.isCphsVoiceMessageIndicatorAddress() && (0xFF & this.origBytes[2]) == 16;
    }

    public boolean isCphsVoiceMessageIndicatorAddress() {
        return (0xFF & this.origBytes[0]) == 4 && this.isAlphanumeric() && (0xF & this.origBytes[1]) == 0;
    }

    public boolean isCphsVoiceMessageSet() {
        return this.isCphsVoiceMessageIndicatorAddress() && (0xFF & this.origBytes[2]) == 17;
    }

    @Override
    public boolean isNetworkSpecific() {
        return this.ton == 3;
    }
}

