/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.Serializable;

public class NetworkInfo
implements Parcelable {
    public static final Parcelable.Creator<NetworkInfo> CREATOR = new Parcelable.Creator<NetworkInfo>(){

        @Override
        public NetworkInfo createFromParcel(Parcel parcel) {
            return new NetworkInfo(parcel.readString(), parcel.readString(), parcel.readString(), (State)((Object)parcel.readSerializable()));
        }

        public NetworkInfo[] newArray(int n) {
            return new NetworkInfo[n];
        }
    };
    String operatorAlphaLong;
    String operatorAlphaShort;
    String operatorNumeric;
    State state = State.UNKNOWN;

    NetworkInfo(String string2, String string3, String string4, State state) {
        this.operatorAlphaLong = string2;
        this.operatorAlphaShort = string3;
        this.operatorNumeric = string4;
        this.state = state;
    }

    public NetworkInfo(String string2, String string3, String string4, String string5) {
        this(string2, string3, string4, NetworkInfo.rilStateToState(string5));
    }

    private static State rilStateToState(String string2) {
        if (string2.equals("unknown")) {
            return State.UNKNOWN;
        }
        if (string2.equals("available")) {
            return State.AVAILABLE;
        }
        if (string2.equals("current")) {
            return State.CURRENT;
        }
        if (string2.equals("forbidden")) {
            return State.FORBIDDEN;
        }
        throw new RuntimeException("RIL impl error: Invalid network state '" + string2 + "'");
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String getOperatorAlphaLong() {
        return this.operatorAlphaLong;
    }

    public String getOperatorAlphaShort() {
        return this.operatorAlphaShort;
    }

    public String getOperatorNumeric() {
        return this.operatorNumeric;
    }

    public State getState() {
        return this.state;
    }

    public String toString() {
        return "NetworkInfo " + this.operatorAlphaLong + "/" + this.operatorAlphaShort + "/" + this.operatorNumeric + "/" + (Object)((Object)this.state);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.operatorAlphaLong);
        parcel.writeString(this.operatorAlphaShort);
        parcel.writeString(this.operatorNumeric);
        parcel.writeSerializable((Serializable)((Object)this.state));
    }

    public static final class State
    extends Enum<State> {
        private static final /* synthetic */ State[] $VALUES;
        public static final /* enum */ State AVAILABLE;
        public static final /* enum */ State CURRENT;
        public static final /* enum */ State FORBIDDEN;
        public static final /* enum */ State UNKNOWN;

        static {
            UNKNOWN = new State();
            AVAILABLE = new State();
            CURRENT = new State();
            FORBIDDEN = new State();
            State[] stateArray = new State[]{UNKNOWN, AVAILABLE, CURRENT, FORBIDDEN};
            $VALUES = stateArray;
        }

        public static State valueOf(String string2) {
            return Enum.valueOf(State.class, string2);
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }
    }
}

