/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

public class RestrictedState {
    private boolean mCsEmergencyRestricted;
    private boolean mCsNormalRestricted;
    private boolean mPsRestricted;

    public RestrictedState() {
        this.setPsRestricted(false);
        this.setCsNormalRestricted(false);
        this.setCsEmergencyRestricted(false);
    }

    public boolean equals(Object object) {
        RestrictedState restrictedState;
        try {
            restrictedState = (RestrictedState)object;
            if (object == null) {
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return this.mPsRestricted == restrictedState.mPsRestricted && this.mCsNormalRestricted == restrictedState.mCsNormalRestricted && this.mCsEmergencyRestricted == restrictedState.mCsEmergencyRestricted;
    }

    public boolean isCsEmergencyRestricted() {
        return this.mCsEmergencyRestricted;
    }

    public boolean isCsNormalRestricted() {
        return this.mCsNormalRestricted;
    }

    public boolean isCsRestricted() {
        return this.mCsNormalRestricted && this.mCsEmergencyRestricted;
    }

    public boolean isPsRestricted() {
        return this.mPsRestricted;
    }

    public void setCsEmergencyRestricted(boolean bl) {
        this.mCsEmergencyRestricted = bl;
    }

    public void setCsNormalRestricted(boolean bl) {
        this.mCsNormalRestricted = bl;
    }

    public void setPsRestricted(boolean bl) {
        this.mPsRestricted = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        String string2 = "none";
        if (this.mCsEmergencyRestricted && this.mCsNormalRestricted) {
            string2 = "all";
            return "Restricted State CS: " + string2 + " PS:" + this.mPsRestricted;
        }
        if (this.mCsEmergencyRestricted && !this.mCsNormalRestricted) {
            string2 = "emergency";
            return "Restricted State CS: " + string2 + " PS:" + this.mPsRestricted;
        }
        if (this.mCsEmergencyRestricted) return "Restricted State CS: " + string2 + " PS:" + this.mPsRestricted;
        if (!this.mCsNormalRestricted) return "Restricted State CS: " + string2 + " PS:" + this.mPsRestricted;
        string2 = "normal call";
        return "Restricted State CS: " + string2 + " PS:" + this.mPsRestricted;
    }
}

