/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.os.AsyncResult;
import android.os.Message;
import android.util.Log;
import com.android.internal.telephony.AdnRecord;
import com.android.internal.telephony.AdnRecordCache;
import com.android.internal.telephony.AdnRecordLoader;
import com.android.internal.telephony.IccFileHandler;
import com.android.internal.telephony.IccRecords;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.IccVmFixedException;
import com.android.internal.telephony.IccVmNotSupportedException;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.gsm.SimTlv;
import com.android.internal.telephony.gsm.SmsMessage;
import com.android.internal.telephony.gsm.SpnOverride;
import com.android.internal.telephony.gsm.VoiceMailConstants;
import java.util.ArrayList;
import java.util.Iterator;

public final class SIMRecords
extends IccRecords {
    static final int CFF_LINE1_MASK = 15;
    static final int CFF_LINE1_RESET = 240;
    static final int CFF_UNCONDITIONAL_ACTIVE = 10;
    static final int CFF_UNCONDITIONAL_DEACTIVE = 5;
    private static final int CPHS_SST_MBN_ENABLED = 48;
    private static final int CPHS_SST_MBN_MASK = 48;
    private static final boolean CRASH_RIL = false;
    private static final boolean DBG = true;
    private static final int EVENT_GET_AD_DONE = 9;
    private static final int EVENT_GET_ALL_SMS_DONE = 18;
    private static final int EVENT_GET_CFF_DONE = 24;
    private static final int EVENT_GET_CFIS_DONE = 32;
    private static final int EVENT_GET_CPHS_MAILBOX_DONE = 11;
    private static final int EVENT_GET_ICCID_DONE = 4;
    private static final int EVENT_GET_IMSI_DONE = 3;
    private static final int EVENT_GET_INFO_CPHS_DONE = 26;
    private static final int EVENT_GET_MBDN_DONE = 6;
    private static final int EVENT_GET_MBI_DONE = 5;
    private static final int EVENT_GET_MSISDN_DONE = 10;
    private static final int EVENT_GET_MWIS_DONE = 7;
    private static final int EVENT_GET_PNN_DONE = 15;
    private static final int EVENT_GET_SMS_DONE = 22;
    private static final int EVENT_GET_SPDI_DONE = 13;
    private static final int EVENT_GET_SPN_DONE = 12;
    private static final int EVENT_GET_SST_DONE = 17;
    private static final int EVENT_GET_VOICE_MAIL_INDICATOR_CPHS_DONE = 8;
    private static final int EVENT_MARK_SMS_READ_DONE = 19;
    private static final int EVENT_RADIO_OFF_OR_NOT_AVAILABLE = 2;
    private static final int EVENT_SET_CPHS_MAILBOX_DONE = 25;
    private static final int EVENT_SET_MBDN_DONE = 20;
    private static final int EVENT_SET_MSISDN_DONE = 30;
    private static final int EVENT_SIM_READY = 1;
    private static final int EVENT_SIM_REFRESH = 31;
    private static final int EVENT_SMS_ON_SIM = 21;
    private static final int EVENT_UPDATE_DONE = 14;
    static final String LOG_TAG = "GSM";
    private static final String[] MCCMNC_CODES_HAVING_3DIGITS_MNC = new String[]{"405025", "405026", "405027", "405028", "405029", "405030", "405031", "405032", "405033", "405034", "405035", "405036", "405037", "405038", "405039", "405040", "405041", "405042", "405043", "405044", "405045", "405046", "405047", "405750", "405751", "405752", "405753", "405754", "405755", "405756", "405799", "405800", "405801", "405802", "405803", "405804", "405805", "405806", "405807", "405808", "405809", "405810", "405811", "405812", "405813", "405814", "405815", "405816", "405817", "405818", "405819", "405820", "405821", "405822", "405823", "405824", "405825", "405826", "405827", "405828", "405829", "405830", "405831", "405832", "405833", "405834", "405835", "405836", "405837", "405838", "405839", "405840", "405841", "405842", "405843", "405844", "405845", "405846", "405847", "405848", "405849", "405850", "405851", "405852", "405853", "405875", "405876", "405877", "405878", "405879", "405880", "405881", "405882", "405883", "405884", "405885", "405886", "405908", "405909", "405910", "405911", "405925", "405926", "405927", "405928", "405929", "405932"};
    static final int SPN_RULE_SHOW_PLMN = 2;
    static final int SPN_RULE_SHOW_SPN = 1;
    static final int TAG_FULL_NETWORK_NAME = 67;
    static final int TAG_SHORT_NETWORK_NAME = 69;
    static final int TAG_SPDI_PLMN_LIST = 128;
    boolean callForwardingEnabled;
    byte[] efCPHS_MWI = null;
    byte[] efMWIS = null;
    String imsi;
    private byte[] mCphsInfo = null;
    byte[] mEfCff = null;
    byte[] mEfCfis = null;
    SpnOverride mSpnOverride;
    VoiceMailConstants mVmConfig;
    String pnnHomeName = null;
    ArrayList<String> spdiNetworks = null;
    int spnDisplayCondition;
    private Get_Spn_Fsm_State spnState;

    SIMRecords(GSMPhone gSMPhone) {
        super(gSMPhone);
        this.adnCache = new AdnRecordCache(this.phone);
        this.mVmConfig = new VoiceMailConstants();
        this.mSpnOverride = new SpnOverride();
        this.recordsRequested = false;
        this.recordsToLoad = 0;
        gSMPhone.mCM.registerForSIMReady(this, 1, null);
        gSMPhone.mCM.registerForOffOrNotAvailable(this, 2, null);
        gSMPhone.mCM.setOnSmsOnSim(this, 21, null);
        gSMPhone.mCM.setOnIccRefresh(this, 31, null);
        this.onRadioOffOrNotAvailable();
    }

    private void fetchSimRecords() {
        this.recordsRequested = true;
        IccFileHandler iccFileHandler = this.phone.getIccFileHandler();
        Log.v(LOG_TAG, "SIMRecords:fetchSimRecords " + this.recordsToLoad);
        this.phone.mCM.getIMSI(this.obtainMessage(3));
        this.recordsToLoad = 1 + this.recordsToLoad;
        iccFileHandler.loadEFTransparent(12258, this.obtainMessage(4));
        this.recordsToLoad = 1 + this.recordsToLoad;
        new AdnRecordLoader(this.phone).loadFromEF(28480, 28490, 1, this.obtainMessage(10));
        this.recordsToLoad = 1 + this.recordsToLoad;
        iccFileHandler.loadEFLinearFixed(28617, 1, this.obtainMessage(5));
        this.recordsToLoad = 1 + this.recordsToLoad;
        iccFileHandler.loadEFTransparent(28589, this.obtainMessage(9));
        this.recordsToLoad = 1 + this.recordsToLoad;
        iccFileHandler.loadEFLinearFixed(28618, 1, this.obtainMessage(7));
        this.recordsToLoad = 1 + this.recordsToLoad;
        iccFileHandler.loadEFTransparent(28433, this.obtainMessage(8));
        this.recordsToLoad = 1 + this.recordsToLoad;
        iccFileHandler.loadEFLinearFixed(28619, 1, this.obtainMessage(32));
        this.recordsToLoad = 1 + this.recordsToLoad;
        iccFileHandler.loadEFTransparent(28435, this.obtainMessage(24));
        this.recordsToLoad = 1 + this.recordsToLoad;
        this.getSpnFsm(true, null);
        iccFileHandler.loadEFTransparent(28621, this.obtainMessage(13));
        this.recordsToLoad = 1 + this.recordsToLoad;
        iccFileHandler.loadEFLinearFixed(28613, 1, this.obtainMessage(15));
        this.recordsToLoad = 1 + this.recordsToLoad;
        iccFileHandler.loadEFTransparent(28472, this.obtainMessage(17));
        this.recordsToLoad = 1 + this.recordsToLoad;
        iccFileHandler.loadEFTransparent(28438, this.obtainMessage(26));
        this.recordsToLoad = 1 + this.recordsToLoad;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void getSpnFsm(boolean bl, AsyncResult asyncResult) {
        if (bl) {
            this.spnState = Get_Spn_Fsm_State.INIT;
        }
        switch (1.$SwitchMap$com$android$internal$telephony$gsm$SIMRecords$Get_Spn_Fsm_State[this.spnState.ordinal()]) {
            default: {
                this.spnState = Get_Spn_Fsm_State.IDLE;
                return;
            }
            case 1: {
                this.spn = null;
                this.phone.getIccFileHandler().loadEFTransparent(28486, this.obtainMessage(12));
                this.recordsToLoad = 1 + this.recordsToLoad;
                this.spnState = Get_Spn_Fsm_State.READ_SPN_3GPP;
                return;
            }
            case 2: {
                if (asyncResult != null && asyncResult.exception == null) {
                    byte[] byArray = (byte[])asyncResult.result;
                    this.spnDisplayCondition = 0xFF & byArray[0];
                    this.spn = IccUtils.adnStringFieldToString(byArray, 1, byArray.length - 1);
                    this.log("Load EF_SPN: " + this.spn + " spnDisplayCondition: " + this.spnDisplayCondition);
                    this.phone.setSystemProperty("gsm.sim.operator.alpha", this.spn);
                    this.spnState = Get_Spn_Fsm_State.IDLE;
                    return;
                }
                this.phone.getIccFileHandler().loadEFTransparent(28436, this.obtainMessage(12));
                this.recordsToLoad = 1 + this.recordsToLoad;
                this.spnState = Get_Spn_Fsm_State.READ_SPN_CPHS;
                this.spnDisplayCondition = -1;
                return;
            }
            case 3: {
                if (asyncResult != null && asyncResult.exception == null) {
                    byte[] byArray = (byte[])asyncResult.result;
                    this.spn = IccUtils.adnStringFieldToString(byArray, 0, byArray.length - 1);
                    this.log("Load EF_SPN_CPHS: " + this.spn);
                    this.phone.setSystemProperty("gsm.sim.operator.alpha", this.spn);
                    this.spnState = Get_Spn_Fsm_State.IDLE;
                    return;
                }
                this.phone.getIccFileHandler().loadEFTransparent(28440, this.obtainMessage(12));
                this.recordsToLoad = 1 + this.recordsToLoad;
                this.spnState = Get_Spn_Fsm_State.READ_SPN_SHORT_CPHS;
                return;
            }
            case 4: 
        }
        if (asyncResult != null && asyncResult.exception == null) {
            byte[] byArray = (byte[])asyncResult.result;
            this.spn = IccUtils.adnStringFieldToString(byArray, 0, byArray.length - 1);
            this.log("Load EF_SPN_SHORT_CPHS: " + this.spn);
            this.phone.setSystemProperty("gsm.sim.operator.alpha", this.spn);
        } else {
            this.log("No SPN loaded in either CHPS or 3GPP");
        }
        this.spnState = Get_Spn_Fsm_State.IDLE;
    }

    private void handleFileUpdate(int n) {
        switch (n) {
            default: {
                this.adnCache.reset();
                this.fetchSimRecords();
                return;
            }
            case 28615: {
                this.recordsToLoad = 1 + this.recordsToLoad;
                new AdnRecordLoader(this.phone).loadFromEF(28615, 28616, this.mailboxIndex, this.obtainMessage(6));
                return;
            }
            case 28439: 
        }
        this.recordsToLoad = 1 + this.recordsToLoad;
        new AdnRecordLoader(this.phone).loadFromEF(28439, 28490, 1, this.obtainMessage(11));
    }

    private void handleSimRefresh(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            this.log("handleSimRefresh without input");
            return;
        }
        switch (nArray[0]) {
            default: {
                this.log("handleSimRefresh with unknown operation");
                return;
            }
            case 0: {
                this.log("handleSimRefresh with SIM_REFRESH_FILE_UPDATED");
                this.handleFileUpdate(nArray[1]);
                return;
            }
            case 1: {
                this.log("handleSimRefresh with SIM_REFRESH_INIT");
                this.adnCache.reset();
                this.fetchSimRecords();
                return;
            }
            case 2: 
        }
        this.log("handleSimRefresh with SIM_REFRESH_RESET");
        this.phone.mCM.setRadioPower(false, null);
    }

    private void handleSms(byte[] byArray) {
        if (byArray[0] != 0) {
            Log.d("ENF", "status : " + byArray[0]);
        }
        if (byArray[0] == 3) {
            int n = byArray.length;
            byte[] byArray2 = new byte[n - 1];
            System.arraycopy(byArray, 1, byArray2, 0, n - 1);
            SmsMessage smsMessage = SmsMessage.createFromPdu(byArray2);
            ((GSMPhone)this.phone).mSMS.dispatchMessage(smsMessage);
        }
    }

    private void handleSmses(ArrayList arrayList) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            byte[] byArray = (byte[])arrayList.get(i);
            if (byArray[0] != 0) {
                Log.i("ENF", "status " + i + ": " + byArray[0]);
            }
            if (byArray[0] != 3) continue;
            int n2 = byArray.length;
            byte[] byArray2 = new byte[n2 - 1];
            System.arraycopy(byArray, 1, byArray2, 0, n2 - 1);
            SmsMessage smsMessage = SmsMessage.createFromPdu(byArray2);
            ((GSMPhone)this.phone).mSMS.dispatchMessage(smsMessage);
            byArray[0] = 1;
        }
    }

    private boolean isCphsMailboxEnabled() {
        if (this.mCphsInfo == null) {
            return false;
        }
        return (0x30 & this.mCphsInfo[1]) == 48;
    }

    private boolean isOnMatchingPlmn(String string2) {
        if (string2 == null) {
            return false;
        }
        if (string2.equals(this.getSIMOperatorNumeric())) {
            return true;
        }
        if (this.spdiNetworks != null) {
            Iterator<String> iterator = this.spdiNetworks.iterator();
            while (iterator.hasNext()) {
                if (!string2.equals(iterator.next())) continue;
                return true;
            }
        }
        return false;
    }

    private void onSimReady() {
        ((GSMPhone)this.phone).mSimCard.broadcastIccStateChangedIntent("READY", null);
        this.fetchSimRecords();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseEfSpdi(byte[] byArray) {
        byte[] byArray2;
        SimTlv simTlv = new SimTlv(byArray, 0, byArray.length);
        while (true) {
            block5: {
                block4: {
                    boolean bl = simTlv.isValidObject();
                    byArray2 = null;
                    if (!bl) break block4;
                    if (simTlv.getTag() != 128) break block5;
                    byArray2 = simTlv.getData();
                }
                if (byArray2 != null) break;
                return;
            }
            simTlv.nextObject();
        }
        this.spdiNetworks = new ArrayList(byArray2.length / 3);
        int n = 0;
        while (n + 2 < byArray2.length) {
            String string2 = IccUtils.bcdToString(byArray2, n, 3);
            if (string2.length() >= 5) {
                this.log("EF_SPDI network: " + string2);
                this.spdiNetworks.add(string2);
            }
            n += 3;
        }
    }

    private void setSpnFromConfig(String string2) {
        if (this.mSpnOverride.containsCarrier(string2)) {
            this.spn = this.mSpnOverride.getSpn(string2);
        }
    }

    private void setVoiceMailByCountry(String string2) {
        if (this.mVmConfig.containsCarrier(string2)) {
            this.isVoiceMailFixed = true;
            this.voiceMailNum = this.mVmConfig.getVoiceMailNumber(string2);
            this.voiceMailTag = this.mVmConfig.getVoiceMailTag(string2);
        }
    }

    public void dispose() {
        this.phone.mCM.unregisterForSIMReady(this);
        this.phone.mCM.unregisterForOffOrNotAvailable(this);
        this.phone.mCM.unSetOnIccRefresh(this);
    }

    protected void finalize() {
        Log.d(LOG_TAG, "SIMRecords finalized");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int getDisplayRule(String string2) {
        int n;
        if (this.spn == null) return 2;
        if (this.spnDisplayCondition == -1) {
            return 2;
        }
        if (this.isOnMatchingPlmn(string2)) {
            n = 1;
            if ((1 & this.spnDisplayCondition) != 1) return n;
            return n | 2;
        }
        n = 2;
        if ((2 & this.spnDisplayCondition) != 0) return n;
        return n | 1;
    }

    public String getIMSI() {
        return this.imsi;
    }

    @Override
    public String getMsisdnAlphaTag() {
        return this.msisdnTag;
    }

    @Override
    public String getMsisdnNumber() {
        return this.msisdn;
    }

    String getSIMOperatorNumeric() {
        if (this.imsi == null || this.mncLength == -1 || this.mncLength == 0) {
            return null;
        }
        return this.imsi.substring(0, 3 + this.mncLength);
    }

    public boolean getVoiceCallForwardingFlag() {
        return this.callForwardingEnabled;
    }

    @Override
    public String getVoiceMailAlphaTag() {
        return this.voiceMailTag;
    }

    @Override
    public String getVoiceMailNumber() {
        return this.voiceMailNum;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void handleMessage(Message var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [5, 6 : 194->198)] java.lang.RuntimeException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected void log(String string2) {
        Log.d(LOG_TAG, "[SIMRecords] " + string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onAllRecordsLoaded() {
        Log.d(LOG_TAG, "SIMRecords: record load complete");
        String string2 = this.getSIMOperatorNumeric();
        this.phone.setSystemProperty("gsm.sim.operator.numeric", string2);
        if (this.imsi != null) {
            this.phone.setSystemProperty("gsm.sim.operator.iso-country", MccTable.countryCodeForMcc(Integer.parseInt(this.imsi.substring(0, 3))));
        } else {
            Log.e("SIM", "[SIMRecords] onAllRecordsLoaded: imsi is NULL!");
        }
        this.setVoiceMailByCountry(string2);
        this.setSpnFromConfig(string2);
        this.recordsLoadedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        ((GSMPhone)this.phone).mSimCard.broadcastIccStateChangedIntent("LOADED", null);
    }

    @Override
    protected void onRadioOffOrNotAvailable() {
        this.imsi = null;
        this.msisdn = null;
        this.voiceMailNum = null;
        this.countVoiceMessages = 0;
        this.mncLength = -1;
        this.iccid = null;
        this.spnDisplayCondition = -1;
        this.efMWIS = null;
        this.efCPHS_MWI = null;
        this.spdiNetworks = null;
        this.pnnHomeName = null;
        this.adnCache.reset();
        this.phone.setSystemProperty("gsm.sim.operator.numeric", null);
        this.phone.setSystemProperty("gsm.sim.operator.alpha", null);
        this.phone.setSystemProperty("gsm.sim.operator.iso-country", null);
        this.recordsRequested = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onRecordLoaded() {
        --this.recordsToLoad;
        if (this.recordsToLoad == 0 && this.recordsRequested) {
            this.onAllRecordsLoaded();
            return;
        } else {
            if (this.recordsToLoad >= 0) return;
            Log.e(LOG_TAG, "SIMRecords: recordsToLoad <0, programmer error suspected");
            this.recordsToLoad = 0;
            return;
        }
    }

    @Override
    public void onRefresh(boolean bl, int[] nArray) {
        if (bl) {
            this.fetchSimRecords();
        }
    }

    @Override
    public void setMsisdnNumber(String string2, String string3, Message message) {
        this.msisdn = string3;
        this.msisdnTag = string2;
        this.log("Set MSISDN: " + this.msisdnTag + " " + "xxxxxxx");
        AdnRecord adnRecord = new AdnRecord(this.msisdnTag, this.msisdn);
        new AdnRecordLoader(this.phone).updateEF(adnRecord, 28480, 28490, 1, null, this.obtainMessage(30, message));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void setVoiceCallForwardingFlag(int n, boolean bl) {
        if (n != 1) {
            return;
        }
        this.callForwardingEnabled = bl;
        ((GSMPhone)this.phone).notifyCallForwardingIndicator();
        try {
            if (this.mEfCfis != null) {
                if (bl) {
                    byte[] byArray = this.mEfCfis;
                    byArray[1] = (byte)(1 | byArray[1]);
                } else {
                    byte[] byArray = this.mEfCfis;
                    byArray[1] = (byte)(0xFE & byArray[1]);
                }
                this.phone.getIccFileHandler().updateEFLinearFixed(28619, 1, this.mEfCfis, null, this.obtainMessage(14, 28619));
            }
            if (this.mEfCff == null) return;
            this.mEfCff[0] = bl ? (byte)(0xA | 0xF0 & this.mEfCff[0]) : (byte)(5 | 0xF0 & this.mEfCff[0]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Log.w(LOG_TAG, "Error saving call fowarding flag to SIM. Probably malformed SIM record", arrayIndexOutOfBoundsException);
            return;
        }
        this.phone.getIccFileHandler().updateEFTransparent(28435, this.mEfCff, this.obtainMessage(14, 28435));
    }

    @Override
    public void setVoiceMailNumber(String string2, String string3, Message message) {
        if (this.isVoiceMailFixed) {
            AsyncResult.forMessage((Message)message).exception = new IccVmFixedException("Voicemail number is fixed by operator");
            message.sendToTarget();
            return;
        }
        this.newVoiceMailNum = string3;
        this.newVoiceMailTag = string2;
        AdnRecord adnRecord = new AdnRecord(this.newVoiceMailTag, this.newVoiceMailNum);
        if (this.mailboxIndex != 0 && this.mailboxIndex != 255) {
            new AdnRecordLoader(this.phone).updateEF(adnRecord, 28615, 28616, this.mailboxIndex, null, this.obtainMessage(20, message));
            return;
        }
        if (this.isCphsMailboxEnabled()) {
            new AdnRecordLoader(this.phone).updateEF(adnRecord, 28439, 28490, 1, null, this.obtainMessage(25, message));
            return;
        }
        AsyncResult.forMessage((Message)message).exception = new IccVmNotSupportedException("Update SIM voice mailbox error");
        message.sendToTarget();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    @Override
    public void setVoiceMessageWaiting(int n, int n2) {
        if (n != 1) {
            return;
        }
        if (n2 < 0) {
            n2 = -1;
        } else if (n2 > 255) {
            n2 = 255;
        }
        this.countVoiceMessages = n2;
        ((GSMPhone)this.phone).notifyMessageWaitingIndicator();
        try {
            if (this.efMWIS != null) {
                byte[] byArray = this.efMWIS;
                int n3 = 0xFE & this.efMWIS[0];
                int n4 = this.countVoiceMessages == 0 ? 0 : 1;
                byArray[0] = (byte)(n3 | n4);
                this.efMWIS[1] = n2 < 0 ? (byte)0 : (byte)n2;
                this.phone.getIccFileHandler().updateEFLinearFixed(28618, 1, this.efMWIS, null, this.obtainMessage(14, 28618));
            }
            if (this.efCPHS_MWI == null) return;
            byte[] byArray = this.efCPHS_MWI;
            int n5 = 0xF0 & this.efCPHS_MWI[0];
            int n6 = this.countVoiceMessages == 0 ? 5 : 10;
            byArray[0] = (byte)(n5 | n6);
            this.phone.getIccFileHandler().updateEFTransparent(28433, this.efCPHS_MWI, this.obtainMessage(14, 28433));
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Log.w(LOG_TAG, "Error saving voice mail state to SIM. Probably malformed SIM record", arrayIndexOutOfBoundsException);
            return;
        }
    }

    private static final class Get_Spn_Fsm_State
    extends Enum<Get_Spn_Fsm_State> {
        private static final /* synthetic */ Get_Spn_Fsm_State[] $VALUES;
        public static final /* enum */ Get_Spn_Fsm_State IDLE = new Get_Spn_Fsm_State();
        public static final /* enum */ Get_Spn_Fsm_State INIT = new Get_Spn_Fsm_State();
        public static final /* enum */ Get_Spn_Fsm_State READ_SPN_3GPP = new Get_Spn_Fsm_State();
        public static final /* enum */ Get_Spn_Fsm_State READ_SPN_CPHS = new Get_Spn_Fsm_State();
        public static final /* enum */ Get_Spn_Fsm_State READ_SPN_SHORT_CPHS = new Get_Spn_Fsm_State();

        static {
            Get_Spn_Fsm_State[] get_Spn_Fsm_StateArray = new Get_Spn_Fsm_State[]{IDLE, INIT, READ_SPN_3GPP, READ_SPN_CPHS, READ_SPN_SHORT_CPHS};
            $VALUES = get_Spn_Fsm_StateArray;
        }

        public static Get_Spn_Fsm_State valueOf(String string2) {
            return Enum.valueOf(Get_Spn_Fsm_State.class, string2);
        }

        public static Get_Spn_Fsm_State[] values() {
            return (Get_Spn_Fsm_State[])$VALUES.clone();
        }
    }
}

