/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

public class SimTlv {
    int curDataLength;
    int curDataOffset;
    int curOffset;
    boolean hasValidTlvObject;
    byte[] record;
    int tlvLength;
    int tlvOffset;

    public SimTlv(byte[] byArray, int n, int n2) {
        this.record = byArray;
        this.tlvOffset = n;
        this.tlvLength = n2;
        this.curOffset = n;
        this.hasValidTlvObject = this.parseCurrentTlvObject();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseCurrentTlvObject() {
        block4: {
            try {
                if (this.record[this.curOffset] == 0 || (0xFF & this.record[this.curOffset]) == 255) return false;
                if ((0xFF & this.record[1 + this.curOffset]) >= 128) break block4;
                this.curDataLength = 0xFF & this.record[1 + this.curOffset];
                this.curDataOffset = 2 + this.curOffset;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return false;
            }
            return this.curDataLength + this.curDataOffset <= this.tlvOffset + this.tlvLength;
        }
        if ((0xFF & this.record[1 + this.curOffset]) != 129) return false;
        this.curDataLength = 0xFF & this.record[2 + this.curOffset];
        this.curDataOffset = 3 + this.curOffset;
        return this.curDataLength + this.curDataOffset <= this.tlvOffset + this.tlvLength;
    }

    public byte[] getData() {
        if (!this.hasValidTlvObject) {
            return null;
        }
        byte[] byArray = new byte[this.curDataLength];
        System.arraycopy(this.record, this.curDataOffset, byArray, 0, this.curDataLength);
        return byArray;
    }

    public int getTag() {
        if (!this.hasValidTlvObject) {
            return 0;
        }
        return 0xFF & this.record[this.curOffset];
    }

    public boolean isValidObject() {
        return this.hasValidTlvObject;
    }

    public boolean nextObject() {
        if (!this.hasValidTlvObject) {
            return false;
        }
        this.curOffset = this.curDataOffset + this.curDataLength;
        this.hasValidTlvObject = this.parseCurrentTlvObject();
        return this.hasValidTlvObject;
    }
}

