/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.os.Parcel;
import android.telephony.PhoneNumberUtils;
import android.telephony.SmsMessage;
import android.text.format.Time;
import android.util.Log;
import com.android.internal.telephony.EncodeException;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.gsm.GsmSmsAddress;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

public class SmsMessage
extends SmsMessageBase {
    static final String LOG_TAG = "GSM";
    private boolean automaticDeletion;
    private int dataCodingScheme;
    private long dischargeTimeMillis;
    private boolean forSubmit;
    private boolean isStatusReportMessage = false;
    private SmsMessage.MessageClass messageClass;
    private int mti;
    private int protocolIdentifier;
    private GsmSmsAddress recipientAddress;
    private boolean replyPathPresent = false;
    private int status;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SmsMessageBase.TextEncodingDetails calculateLength(CharSequence charSequence, boolean bl) {
        SmsMessageBase.TextEncodingDetails textEncodingDetails = new SmsMessageBase.TextEncodingDetails();
        boolean bl2 = !bl;
        try {
            int n;
            textEncodingDetails.codeUnitCount = n = GsmAlphabet.countGsmSeptets(charSequence, bl2);
            if (n > 160) {
                textEncodingDetails.msgCount = (n + 152) / 153;
                textEncodingDetails.codeUnitsRemaining = 153 * textEncodingDetails.msgCount - n;
            } else {
                textEncodingDetails.msgCount = 1;
                textEncodingDetails.codeUnitsRemaining = 160 - n;
            }
            textEncodingDetails.codeUnitSize = 1;
            return textEncodingDetails;
        }
        catch (EncodeException encodeException) {
            int n = 2 * charSequence.length();
            textEncodingDetails.codeUnitCount = charSequence.length();
            if (n > 140) {
                textEncodingDetails.msgCount = (n + 133) / 134;
                textEncodingDetails.codeUnitsRemaining = (134 * textEncodingDetails.msgCount - n) / 2;
            } else {
                textEncodingDetails.msgCount = 1;
                textEncodingDetails.codeUnitsRemaining = (140 - n) / 2;
            }
            textEncodingDetails.codeUnitSize = 3;
            return textEncodingDetails;
        }
    }

    public static SmsMessage createFromEfRecord(int n, byte[] byArray) {
        SmsMessage smsMessage;
        block3: {
            try {
                smsMessage = new SmsMessage();
                smsMessage.indexOnIcc = n;
                if ((1 & byArray[0]) != 0) break block3;
                Log.w(LOG_TAG, "SMS parsing failed: Trying to parse a free record");
                return null;
            }
            catch (RuntimeException runtimeException) {
                Log.e(LOG_TAG, "SMS PDU parsing failed: ", runtimeException);
                return null;
            }
        }
        smsMessage.statusOnIcc = 7 & byArray[0];
        int n2 = byArray.length - 1;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 1, byArray2, 0, n2);
        smsMessage.parsePdu(byArray2);
        return smsMessage;
    }

    public static SmsMessage createFromPdu(byte[] byArray) {
        try {
            SmsMessage smsMessage = new SmsMessage();
            smsMessage.parsePdu(byArray);
            return smsMessage;
        }
        catch (RuntimeException runtimeException) {
            Log.e(LOG_TAG, "SMS PDU parsing failed: ", runtimeException);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static byte[] encodeUCS2(String string2, byte[] byArray) throws UnsupportedEncodingException {
        byte[] byArray2;
        byte[] byArray3 = string2.getBytes("utf-16be");
        if (byArray != null) {
            byArray2 = new byte[1 + (byArray.length + byArray3.length)];
            byArray2[0] = (byte)byArray.length;
            System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
            System.arraycopy(byArray3, 0, byArray2, 1 + byArray.length, byArray3.length);
        } else {
            byArray2 = byArray3;
        }
        byte[] byArray4 = new byte[1 + byArray2.length];
        byArray4[0] = (byte)(0xFF & byArray2.length);
        System.arraycopy(byArray2, 0, byArray4, 1, byArray2.length);
        return byArray4;
    }

    public static SubmitPdu getSubmitPdu(String string2, String string3, int n, byte[] byArray, boolean bl) {
        SmsHeader.PortAddrs portAddrs = new SmsHeader.PortAddrs();
        portAddrs.destPort = n;
        portAddrs.origPort = 0;
        portAddrs.areEightBits = false;
        SmsHeader smsHeader = new SmsHeader();
        smsHeader.portAddrs = portAddrs;
        byte[] byArray2 = SmsHeader.toByteArray(smsHeader);
        if (1 + (byArray.length + byArray2.length) > 140) {
            Log.e(LOG_TAG, "SMS data message may only contain " + (140 - byArray2.length - 1) + " bytes");
            return null;
        }
        SubmitPdu submitPdu = new SubmitPdu();
        ByteArrayOutputStream byteArrayOutputStream = SmsMessage.getSubmitPduHead(string2, string3, (byte)65, bl, submitPdu);
        byteArrayOutputStream.write(4);
        byteArrayOutputStream.write(1 + (byArray.length + byArray2.length));
        byteArrayOutputStream.write(byArray2.length);
        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        byteArrayOutputStream.write(byArray, 0, byArray.length);
        submitPdu.encodedMessage = byteArrayOutputStream.toByteArray();
        return submitPdu;
    }

    public static SubmitPdu getSubmitPdu(String string2, String string3, String string4, boolean bl) {
        return SmsMessage.getSubmitPdu(string2, string3, string4, bl, null);
    }

    public static SubmitPdu getSubmitPdu(String string2, String string3, String string4, boolean bl, byte[] byArray) {
        return SmsMessage.getSubmitPdu(string2, string3, string4, bl, byArray, 0);
    }

    /*
     * Unable to fully structure code
     */
    public static SubmitPdu getSubmitPdu(String var0, String var1_1, String var2_2, boolean var3_3, byte[] var4_4, int var5_5) {
        block17: {
            block16: {
                block15: {
                    if (var2_2 == null || var1_1 == null) {
                        return null;
                    }
                    var6_6 = new SubmitPdu();
                    if (var4_4 != null) {
                        var7_7 = 64;
lbl6:
                        // 2 sources

                        while (true) {
                            var8_8 = SmsMessage.getSubmitPduHead(var0, var1_1, (byte)(var7_7 | 1), var3_3, var6_6);
                            if (var5_5 == 0) {
                                var5_5 = 1;
                            }
                            if (var5_5 != 1) break block15;
                            var13_10 = var17_9 = GsmAlphabet.stringToGsm7BitPackedWithHeader(var2_2, var4_4);
lbl13:
                            // 3 sources

                            while (var5_5 == 1) {
                                if ((255 & var13_10[0]) > 160) {
                                    return null;
                                }
                                break block16;
                            }
                            break block17;
                            break;
                        }
                    }
                    var7_7 = 0;
                    ** while (true)
                }
                try {
                    var16_11 = SmsMessage.encodeUCS2(var2_2, var4_4);
                    var13_10 = var16_11;
                    ** GOTO lbl13
                }
                catch (UnsupportedEncodingException var14_12) {
                    try {
                        Log.e("GSM", "Implausible UnsupportedEncodingException ", var14_12);
                        return null;
                    }
                    catch (EncodeException var9_13) {
                        try {
                            var12_14 = SmsMessage.encodeUCS2(var2_2, var4_4);
                            var13_10 = var12_14;
                            var5_5 = 3;
                            ** GOTO lbl13
                        }
                        catch (UnsupportedEncodingException var10_15) {
                            Log.e("GSM", "Implausible UnsupportedEncodingException ", var10_15);
                            return null;
                        }
                    }
                }
            }
            var8_8.write(0);
lbl42:
            // 2 sources

            while (true) {
                var8_8.write(var13_10, 0, var13_10.length);
                var6_6.encodedMessage = var8_8.toByteArray();
                return var6_6;
            }
        }
        if ((255 & var13_10[0]) > 140) {
            return null;
        }
        var8_8.write(11);
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    private static ByteArrayOutputStream getSubmitPduHead(String string2, String string3, byte by, boolean bl, SubmitPdu submitPdu) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(180);
        submitPdu.encodedScAddress = (byte[])(string2 == null ? null : PhoneNumberUtils.networkPortionToCalledPartyBCDWithLength(string2));
        if (bl) {
            by = (byte)(by | 0x20);
            Log.d(LOG_TAG, "SMS status report requested");
        }
        byteArrayOutputStream.write(by);
        byteArrayOutputStream.write(0);
        byte[] byArray = PhoneNumberUtils.networkPortionToCalledPartyBCD(string3);
        int n = 2 * (byArray.length - 1);
        int n2 = (0xF0 & byArray[byArray.length - 1]) == 240 ? 1 : 0;
        byteArrayOutputStream.write(n - n2);
        byteArrayOutputStream.write(byArray, 0, byArray.length);
        byteArrayOutputStream.write(0);
        return byteArrayOutputStream;
    }

    public static int getTPLayerLengthForPDU(String string2) {
        return string2.length() / 2 - Integer.parseInt(string2.substring(0, 2), 16) - 1;
    }

    public static SmsMessage newFromCDS(String string2) {
        try {
            SmsMessage smsMessage = new SmsMessage();
            smsMessage.parsePdu(IccUtils.hexStringToBytes(string2));
            return smsMessage;
        }
        catch (RuntimeException runtimeException) {
            Log.e(LOG_TAG, "CDS SMS PDU parsing failed: ", runtimeException);
            return null;
        }
    }

    public static SmsMessage newFromCMT(String[] stringArray) {
        try {
            SmsMessage smsMessage = new SmsMessage();
            smsMessage.parsePdu(IccUtils.hexStringToBytes(stringArray[1]));
            return smsMessage;
        }
        catch (RuntimeException runtimeException) {
            Log.e(LOG_TAG, "SMS PDU parsing failed: ", runtimeException);
            return null;
        }
    }

    public static SmsMessage newFromCMTI(String string2) {
        Log.e(LOG_TAG, "newFromCMTI: not yet supported");
        return null;
    }

    public static SmsMessageBase newFromParcel(Parcel parcel) {
        Log.w(LOG_TAG, "newFromParcel: is not supported in GSM mode.");
        return null;
    }

    private void parsePdu(byte[] byArray) {
        this.mPdu = byArray;
        PduParser pduParser = new PduParser(byArray);
        this.scAddress = pduParser.getSCAddress();
        if (this.scAddress != null) {
            Log.d(LOG_TAG, "SMS SC address: " + this.scAddress);
        }
        int n = pduParser.getByte();
        this.mti = n & 3;
        switch (this.mti) {
            default: {
                throw new RuntimeException("Unsupported message type");
            }
            case 0: {
                this.parseSmsDeliver(pduParser, n);
                return;
            }
            case 2: 
        }
        this.parseSmsStatusReport(pduParser, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseSmsDeliver(PduParser pduParser, int n) {
        boolean bl = (n & 0x80) == 128;
        this.replyPathPresent = bl;
        this.originatingAddress = pduParser.getAddress();
        if (this.originatingAddress != null) {
            // empty if block
        }
        this.protocolIdentifier = pduParser.getByte();
        this.dataCodingScheme = pduParser.getByte();
        this.scTimeMillis = pduParser.getSCTimestampMillis();
        Log.d(LOG_TAG, "SMS SC timestamp: " + this.scTimeMillis);
        boolean bl2 = (n & 0x40) == 64;
        this.parseUserData(pduParser, bl2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseSmsStatusReport(PduParser pduParser, int n) {
        this.isStatusReportMessage = true;
        boolean bl = (n & 0x20) == 0;
        this.forSubmit = bl;
        this.messageRef = pduParser.getByte();
        this.recipientAddress = pduParser.getAddress();
        this.scTimeMillis = pduParser.getSCTimestampMillis();
        this.dischargeTimeMillis = pduParser.getSCTimestampMillis();
        this.status = pduParser.getByte();
        if (pduParser.moreDataPresent()) {
            int n2;
            int n3 = n2 = pduParser.getByte();
            while ((n3 & 0x80) != 0) {
                n3 = pduParser.getByte();
            }
            if ((n2 & 1) != 0) {
                this.protocolIdentifier = pduParser.getByte();
            }
            if ((n2 & 2) != 0) {
                this.dataCodingScheme = pduParser.getByte();
            }
            if ((n2 & 4) != 0) {
                boolean bl2 = (n & 0x40) == 64;
                this.parseUserData(pduParser, bl2);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseUserData(PduParser pduParser, boolean bl) {
        boolean bl2;
        int n = 0;
        if ((0x80 & this.dataCodingScheme) == 0) {
            boolean bl3 = (0x40 & this.dataCodingScheme) != 0;
            this.automaticDeletion = bl3;
            boolean bl4 = (0x20 & this.dataCodingScheme) != 0;
            bl2 = (0x10 & this.dataCodingScheme) != 0;
            if (bl4) {
                Log.w(LOG_TAG, "4 - Unsupported SMS data coding scheme (compression) " + (0xFF & this.dataCodingScheme));
            } else {
                switch (3 & this.dataCodingScheme >> 2) {
                    default: {
                        n = 0;
                        break;
                    }
                    case 0: {
                        n = 1;
                        break;
                    }
                    case 2: {
                        n = 3;
                        break;
                    }
                    case 1: 
                    case 3: {
                        Log.w(LOG_TAG, "1 - Unsupported SMS data coding scheme " + (0xFF & this.dataCodingScheme));
                        n = 2;
                        break;
                    }
                }
            }
        } else if ((0xF0 & this.dataCodingScheme) == 240) {
            this.automaticDeletion = false;
            bl2 = true;
            n = (4 & this.dataCodingScheme) == 0 ? 1 : 2;
        } else if ((0xF0 & this.dataCodingScheme) == 192 || (0xF0 & this.dataCodingScheme) == 208 || (0xF0 & this.dataCodingScheme) == 224) {
            n = (0xF0 & this.dataCodingScheme) == 224 ? 3 : 1;
            boolean bl5 = (8 & this.dataCodingScheme) == 8;
            if ((3 & this.dataCodingScheme) == 0) {
                this.isMwi = true;
                this.mwiSense = bl5;
                boolean bl6 = (0xF0 & this.dataCodingScheme) == 192;
                this.mwiDontStore = bl6;
                bl2 = false;
            } else {
                this.isMwi = false;
                Log.w(LOG_TAG, "MWI for fax, email, or other " + (0xFF & this.dataCodingScheme));
                bl2 = false;
            }
        } else {
            Log.w(LOG_TAG, "3 - Unsupported SMS data coding scheme " + (0xFF & this.dataCodingScheme));
            n = 0;
            bl2 = false;
        }
        boolean bl7 = n == 1;
        int n2 = pduParser.constructUserData(bl, bl7);
        this.userData = pduParser.getUserData();
        this.userDataHeader = pduParser.getUserDataHeader();
        switch (n) {
            case 0: 
            case 2: {
                this.messageBody = null;
                break;
            }
            case 1: {
                this.messageBody = pduParser.getUserDataGSM7Bit(n2);
                break;
            }
            case 3: {
                this.messageBody = pduParser.getUserDataUCS2(n2);
            }
        }
        if (this.messageBody != null) {
            this.parseMessageBody();
        }
        if (!bl2) {
            this.messageClass = SmsMessage.MessageClass.UNKNOWN;
            return;
        }
        switch (3 & this.dataCodingScheme) {
            default: {
                return;
            }
            case 0: {
                this.messageClass = SmsMessage.MessageClass.CLASS_0;
                return;
            }
            case 1: {
                this.messageClass = SmsMessage.MessageClass.CLASS_1;
                return;
            }
            case 2: {
                this.messageClass = SmsMessage.MessageClass.CLASS_2;
                return;
            }
            case 3: 
        }
        this.messageClass = SmsMessage.MessageClass.CLASS_3;
    }

    @Override
    public SmsMessage.MessageClass getMessageClass() {
        return this.messageClass;
    }

    @Override
    public int getProtocolIdentifier() {
        return this.protocolIdentifier;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public boolean isCphsMwiMessage() {
        return ((GsmSmsAddress)this.originatingAddress).isCphsVoiceMessageClear() || ((GsmSmsAddress)this.originatingAddress).isCphsVoiceMessageSet();
    }

    @Override
    public boolean isMWIClearMessage() {
        if (this.isMwi && !this.mwiSense) {
            return true;
        }
        return this.originatingAddress != null && ((GsmSmsAddress)this.originatingAddress).isCphsVoiceMessageClear();
    }

    @Override
    public boolean isMWISetMessage() {
        if (this.isMwi && this.mwiSense) {
            return true;
        }
        return this.originatingAddress != null && ((GsmSmsAddress)this.originatingAddress).isCphsVoiceMessageSet();
    }

    @Override
    public boolean isMwiDontStore() {
        if (this.isMwi && this.mwiDontStore) {
            return true;
        }
        if (this.isCphsMwiMessage()) {
            if (" ".equals(this.getMessageBody())) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isReplace() {
        return (0xC0 & this.protocolIdentifier) == 64 && (0x3F & this.protocolIdentifier) > 0 && (0x3F & this.protocolIdentifier) < 8;
    }

    @Override
    public boolean isReplyPathPresent() {
        return this.replyPathPresent;
    }

    @Override
    public boolean isStatusReportMessage() {
        return this.isStatusReportMessage;
    }

    public boolean isTypeZero() {
        return this.protocolIdentifier == 64;
    }

    static class PduParser {
        int cur;
        int mUserDataSeptetPadding;
        int mUserDataSize;
        byte[] pdu;
        byte[] userData;
        SmsHeader userDataHeader;

        PduParser(String string2) {
            this(IccUtils.hexStringToBytes(string2));
        }

        PduParser(byte[] byArray) {
            this.pdu = byArray;
            this.cur = 0;
            this.mUserDataSeptetPadding = 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        int constructUserData(boolean bl, boolean bl2) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5 = this.cur;
            byte[] byArray = this.pdu;
            int n6 = n5 + 1;
            int n7 = 0xFF & byArray[n5];
            if (bl) {
                byte[] byArray2 = this.pdu;
                int n8 = n6 + 1;
                n4 = 0xFF & byArray2[n6];
                byte[] byArray3 = new byte[n4];
                System.arraycopy(this.pdu, n8, byArray3, 0, n4);
                this.userDataHeader = SmsHeader.fromByteArray(byArray3);
                n3 = n8 + n4;
                int n9 = 8 * (n4 + 1);
                int n10 = n9 / 7;
                int n11 = n9 % 7 > 0 ? 1 : 0;
                n2 = n10 + n11;
                this.mUserDataSeptetPadding = n2 * 7 - n9;
            } else {
                n3 = n6;
                n2 = 0;
                n4 = 0;
            }
            if (bl2) {
                n = this.pdu.length - n3;
            } else {
                int n12 = bl ? n4 + 1 : 0;
                n = n7 - n12;
                if (n < 0) {
                    n = 0;
                }
            }
            this.userData = new byte[n];
            System.arraycopy(this.pdu, n3, this.userData, 0, this.userData.length);
            this.cur = n3;
            if (!bl2) {
                return this.userData.length;
            }
            int n13 = n7 - n2;
            if (n13 < 0) {
                return 0;
            }
            return n13;
        }

        GsmSmsAddress getAddress() {
            int n = 2 + (1 + (0xFF & this.pdu[this.cur])) / 2;
            GsmSmsAddress gsmSmsAddress = new GsmSmsAddress(this.pdu, this.cur, n);
            this.cur = n + this.cur;
            return gsmSmsAddress;
        }

        int getByte() {
            byte[] byArray = this.pdu;
            int n = this.cur;
            this.cur = n + 1;
            return 0xFF & byArray[n];
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        String getSCAddress() {
            String string2;
            int n = this.getByte();
            if (n == 0) {
                string2 = null;
            } else {
                try {
                    String string3;
                    string2 = string3 = PhoneNumberUtils.calledPartyBCDToString(this.pdu, this.cur, n);
                }
                catch (RuntimeException runtimeException) {
                    Log.d(SmsMessage.LOG_TAG, "invalid SC address: ", runtimeException);
                    string2 = null;
                }
            }
            this.cur = n + this.cur;
            return string2;
        }

        /*
         * Enabled aggressive block sorting
         */
        long getSCTimestampMillis() {
            byte[] byArray = this.pdu;
            int n = this.cur;
            this.cur = n + 1;
            int n2 = IccUtils.gsmBcdByteToInt(byArray[n]);
            byte[] byArray2 = this.pdu;
            int n3 = this.cur;
            this.cur = n3 + 1;
            int n4 = IccUtils.gsmBcdByteToInt(byArray2[n3]);
            byte[] byArray3 = this.pdu;
            int n5 = this.cur;
            this.cur = n5 + 1;
            int n6 = IccUtils.gsmBcdByteToInt(byArray3[n5]);
            byte[] byArray4 = this.pdu;
            int n7 = this.cur;
            this.cur = n7 + 1;
            int n8 = IccUtils.gsmBcdByteToInt(byArray4[n7]);
            byte[] byArray5 = this.pdu;
            int n9 = this.cur;
            this.cur = n9 + 1;
            int n10 = IccUtils.gsmBcdByteToInt(byArray5[n9]);
            byte[] byArray6 = this.pdu;
            int n11 = this.cur;
            this.cur = n11 + 1;
            int n12 = IccUtils.gsmBcdByteToInt(byArray6[n11]);
            byte[] byArray7 = this.pdu;
            int n13 = this.cur;
            this.cur = n13 + 1;
            byte by = byArray7[n13];
            int n14 = IccUtils.gsmBcdByteToInt((byte)(by & 0xFFFFFFF7));
            if ((by & 8) != 0) {
                n14 = -n14;
            }
            Time time = new Time("UTC");
            int n15 = n2 >= 90 ? n2 + 1900 : n2 + 2000;
            time.year = n15;
            time.month = n4 - 1;
            time.monthDay = n6;
            time.hour = n8;
            time.minute = n10;
            time.second = n12;
            return time.toMillis(true) - (long)(1000 * (60 * (n14 * 15)));
        }

        byte[] getUserData() {
            return this.userData;
        }

        String getUserDataGSM7Bit(int n) {
            String string2 = GsmAlphabet.gsm7BitPackedToString(this.pdu, this.cur, n, this.mUserDataSeptetPadding);
            this.cur += n * 7 / 8;
            return string2;
        }

        SmsHeader getUserDataHeader() {
            return this.userDataHeader;
        }

        int getUserDataSeptetPadding() {
            return this.mUserDataSeptetPadding;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        String getUserDataUCS2(int n) {
            String string2;
            try {
                string2 = new String(this.pdu, this.cur, n, "utf-16");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string2 = "";
                Log.e(SmsMessage.LOG_TAG, "implausible UnsupportedEncodingException", unsupportedEncodingException);
            }
            this.cur = n + this.cur;
            return string2;
        }

        boolean moreDataPresent() {
            return this.pdu.length > this.cur;
        }
    }

    public static class SubmitPdu
    extends SmsMessageBase.SubmitPduBase {
    }
}

