/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.android.internal.telephony.AdnRecord;
import com.android.internal.telephony.AdnRecordCache;
import com.android.internal.telephony.IccConstants;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.gsm.SimTlv;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class UsimPhoneBookManager
extends Handler
implements IccConstants {
    private static final boolean DBG = true;
    private static final int EVENT_EMAIL_LOAD_DONE = 4;
    private static final int EVENT_IAP_LOAD_DONE = 3;
    private static final int EVENT_PBR_LOAD_DONE = 1;
    private static final int EVENT_USIM_ADN_LOAD_DONE = 2;
    private static final String LOG_TAG = "GSM";
    private static final int USIM_EFAAS_TAG = 199;
    private static final int USIM_EFADN_TAG = 192;
    private static final int USIM_EFANR_TAG = 196;
    private static final int USIM_EFCCP1_TAG = 203;
    private static final int USIM_EFEMAIL_TAG = 202;
    private static final int USIM_EFEXT1_TAG = 194;
    private static final int USIM_EFGRP_TAG = 198;
    private static final int USIM_EFGSD_TAG = 200;
    private static final int USIM_EFIAP_TAG = 193;
    private static final int USIM_EFPBC_TAG = 197;
    private static final int USIM_EFSNE_TAG = 195;
    private static final int USIM_EFUID_TAG = 201;
    private static final int USIM_TYPE1_TAG = 168;
    private static final int USIM_TYPE2_TAG = 169;
    private static final int USIM_TYPE3_TAG = 170;
    private AdnRecordCache mAdnCache;
    private ArrayList<byte[]> mEmailFileRecord;
    private boolean mEmailPresentInIap = false;
    private int mEmailTagNumberInIap = 0;
    private Map<Integer, ArrayList<String>> mEmailsForAdnRec;
    private ArrayList<byte[]> mIapFileRecord;
    private Boolean mIsPbrPresent;
    private Object mLock = new Object();
    private PbrFile mPbrFile;
    private PhoneBase mPhone;
    private ArrayList<AdnRecord> mPhoneBookRecords;

    public UsimPhoneBookManager(PhoneBase phoneBase, AdnRecordCache adnRecordCache) {
        this.mPhone = phoneBase;
        this.mPhoneBookRecords = new ArrayList();
        this.mPbrFile = null;
        this.mIsPbrPresent = true;
        this.mAdnCache = adnRecordCache;
    }

    static /* synthetic */ boolean access$002(UsimPhoneBookManager usimPhoneBookManager, boolean bl) {
        usimPhoneBookManager.mEmailPresentInIap = bl;
        return bl;
    }

    static /* synthetic */ int access$102(UsimPhoneBookManager usimPhoneBookManager, int n) {
        usimPhoneBookManager.mEmailTagNumberInIap = n;
        return n;
    }

    private void createPbrFile(ArrayList<byte[]> arrayList) {
        if (arrayList == null) {
            this.mPbrFile = null;
            this.mIsPbrPresent = false;
            return;
        }
        this.mPbrFile = new PbrFile(arrayList);
    }

    private void log(String string2) {
        Log.d(LOG_TAG, string2);
    }

    private void readAdnFileAndWait(int n) {
        Map<Integer, Integer> map = this.mPbrFile.mFileIds.get(n);
        if (map == null || map.isEmpty()) {
            return;
        }
        this.mAdnCache.requestLoadAllAdnLike(map.get(192), map.get(194), this.obtainMessage(2));
        try {
            this.mLock.wait();
            return;
        }
        catch (InterruptedException interruptedException) {
            Log.e(LOG_TAG, "Interrupted Exception in readAdnFileAndWait");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readEmailFileAndWait(int n) {
        Map<Integer, Integer> map = this.mPbrFile.mFileIds.get(n);
        if (map == null || !map.containsKey(202)) {
            return;
        }
        map.get(202).intValue();
        if (this.mEmailPresentInIap) {
            this.readIapFileAndWait(map.get(193));
            if (this.mIapFileRecord == null) {
                Log.e(LOG_TAG, "Error: IAP file is empty");
                return;
            }
        }
        this.mPhone.getIccFileHandler().loadEFLinearFixedAll(map.get(202), this.obtainMessage(4));
        try {
            this.mLock.wait();
        }
        catch (InterruptedException interruptedException) {
            Log.e(LOG_TAG, "Interrupted Exception in readEmailFileAndWait");
        }
        if (this.mEmailFileRecord == null) {
            Log.e(LOG_TAG, "Error: Email file is empty");
            return;
        }
        this.updatePhoneAdnRecord();
    }

    private String readEmailRecord(int n) {
        byte[] byArray;
        try {
            byArray = this.mEmailFileRecord.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
        return IccUtils.adnStringFieldToString(byArray, 0, byArray.length - 2);
    }

    private void readIapFileAndWait(int n) {
        this.mPhone.getIccFileHandler().loadEFLinearFixedAll(n, this.obtainMessage(3));
        try {
            this.mLock.wait();
            return;
        }
        catch (InterruptedException interruptedException) {
            Log.e(LOG_TAG, "Interrupted Exception in readIapFileAndWait");
            return;
        }
    }

    private void readPbrFileAndWait() {
        this.mPhone.getIccFileHandler().loadEFLinearFixedAll(20272, this.obtainMessage(1));
        try {
            this.mLock.wait();
            return;
        }
        catch (InterruptedException interruptedException) {
            Log.e(LOG_TAG, "Interrupted Exception in readAdnFileAndWait");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updatePhoneAdnRecord() {
        if (this.mEmailFileRecord != null) {
            int n = this.mPhoneBookRecords.size();
            if (this.mIapFileRecord != null) {
                for (int i = 0; i < n; ++i) {
                    byte[] byArray;
                    try {
                        byArray = this.mIapFileRecord.get(i);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        Log.e(LOG_TAG, "Error: Improper ICC card: No IAP record for ADN, continuing");
                        break;
                    }
                    byte by = byArray[this.mEmailTagNumberInIap];
                    if (by == -1) continue;
                    String[] stringArray = new String[]{this.readEmailRecord(by - 1)};
                    AdnRecord adnRecord = this.mPhoneBookRecords.get(i);
                    if (adnRecord != null) {
                        adnRecord.setEmails(stringArray);
                    } else {
                        adnRecord = new AdnRecord("", "", stringArray);
                    }
                    this.mPhoneBookRecords.set(i, adnRecord);
                }
            }
            int n2 = this.mPhoneBookRecords.size();
            if (this.mEmailsForAdnRec == null) {
                this.parseType1EmailFile(n2);
            }
            for (int i = 0; i < n; ++i) {
                ArrayList<String> arrayList;
                try {
                    arrayList = this.mEmailsForAdnRec.get(i);
                    if (arrayList == null) {
                        continue;
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    return;
                }
                AdnRecord adnRecord = this.mPhoneBookRecords.get(i);
                String[] stringArray = new String[arrayList.size()];
                System.arraycopy(arrayList.toArray(), 0, stringArray, 0, arrayList.size());
                adnRecord.setEmails(stringArray);
                this.mPhoneBookRecords.set(i, adnRecord);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleMessage(Message message) {
        switch (message.what) {
            default: {
                return;
            }
            case 1: {
                AsyncResult asyncResult = (AsyncResult)message.obj;
                if (asyncResult.exception == null) {
                    this.createPbrFile((ArrayList)asyncResult.result);
                }
                Object object = this.mLock;
                synchronized (object) {
                    this.mLock.notify();
                    return;
                }
            }
            case 2: {
                this.log("Loading USIM ADN records done");
                AsyncResult asyncResult = (AsyncResult)message.obj;
                if (asyncResult.exception == null) {
                    this.mPhoneBookRecords.addAll((ArrayList)asyncResult.result);
                }
                Object object = this.mLock;
                synchronized (object) {
                    this.mLock.notify();
                    return;
                }
            }
            case 3: {
                this.log("Loading USIM IAP records done");
                AsyncResult asyncResult = (AsyncResult)message.obj;
                if (asyncResult.exception == null) {
                    this.mIapFileRecord = (ArrayList)asyncResult.result;
                }
                Object object = this.mLock;
                synchronized (object) {
                    this.mLock.notify();
                    return;
                }
            }
            case 4: 
        }
        this.log("Loading USIM Email records done");
        AsyncResult asyncResult = (AsyncResult)message.obj;
        if (asyncResult.exception == null) {
            this.mEmailFileRecord = (ArrayList)asyncResult.result;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mLock.notify();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList<AdnRecord> loadEfFilesFromUsim() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mPhoneBookRecords.isEmpty()) {
                return this.mPhoneBookRecords;
            }
            if (!this.mIsPbrPresent.booleanValue()) {
                return null;
            }
            if (this.mPbrFile == null) {
                this.readPbrFileAndWait();
            }
            if (this.mPbrFile == null) {
                return null;
            }
            int n = this.mPbrFile.mFileIds.size();
            int n2 = 0;
            while (n2 < n) {
                this.readAdnFileAndWait(n2);
                this.readEmailFileAndWait(n2);
                ++n2;
            }
            return this.mPhoneBookRecords;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void parseType1EmailFile(int n) {
        this.mEmailsForAdnRec = new HashMap<Integer, ArrayList<String>>();
        for (int i = 0; i < n; ++i) {
            void var8_6;
            String string2;
            byte[] byArray;
            try {
                byArray = this.mEmailFileRecord.get(i);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                Log.e(LOG_TAG, "Error: Improper ICC card: No email record for ADN, continuing");
                return;
            }
            byte by = byArray[byArray.length - 1];
            if (by == -1 || (string2 = this.readEmailRecord(i)) == null || string2.equals("")) continue;
            ArrayList<String> arrayList = this.mEmailsForAdnRec.get(by - 1);
            if (arrayList == null) {
                ArrayList arrayList2 = new ArrayList();
            }
            var8_6.add(string2);
            this.mEmailsForAdnRec.put(by - 1, (ArrayList<String>)var8_6);
        }
    }

    public void reset() {
        this.mPhoneBookRecords.clear();
        this.mIapFileRecord = null;
        this.mEmailFileRecord = null;
        this.mPbrFile = null;
        this.mIsPbrPresent = true;
    }

    private class PbrFile {
        HashMap<Integer, Map<Integer, Integer>> mFileIds = new HashMap();

        PbrFile(ArrayList<byte[]> arrayList) {
            int n = 0;
            for (byte[] byArray : arrayList) {
                this.parseTag(new SimTlv(byArray, 0, byArray.length), n);
                ++n;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        void parseEf(SimTlv simTlv, Map<Integer, Integer> map, int n) {
            int n2 = 0;
            do {
                int n3 = simTlv.getTag();
                if (n == 169 && n3 == 202) {
                    UsimPhoneBookManager.access$002(UsimPhoneBookManager.this, true);
                    UsimPhoneBookManager.access$102(UsimPhoneBookManager.this, n2);
                }
                switch (n3) {
                    default: {
                        break;
                    }
                    case 192: 
                    case 193: 
                    case 194: 
                    case 195: 
                    case 196: 
                    case 197: 
                    case 198: 
                    case 199: 
                    case 200: 
                    case 201: 
                    case 202: 
                    case 203: {
                        byte[] byArray = simTlv.getData();
                        int n4 = (0xFF & byArray[0]) << 8 | 0xFF & byArray[1];
                        map.put(n3, n4);
                    }
                }
                ++n2;
            } while (simTlv.nextObject());
        }

        /*
         * Enabled aggressive block sorting
         */
        void parseTag(SimTlv simTlv, int n) {
            HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
            do {
                int n2 = simTlv.getTag();
                switch (n2) {
                    default: {
                        break;
                    }
                    case 168: 
                    case 169: 
                    case 170: {
                        byte[] byArray = simTlv.getData();
                        this.parseEf(new SimTlv(byArray, 0, byArray.length), hashMap, n2);
                    }
                }
            } while (simTlv.nextObject());
            this.mFileIds.put(n, hashMap);
        }
    }
}

