/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm.stk;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Message;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.gsm.SIMFileHandler;
import com.android.internal.telephony.gsm.stk.BerTlv;
import com.android.internal.telephony.gsm.stk.CallSetupParams;
import com.android.internal.telephony.gsm.stk.CommandDetails;
import com.android.internal.telephony.gsm.stk.CommandParams;
import com.android.internal.telephony.gsm.stk.ComprehensionTlv;
import com.android.internal.telephony.gsm.stk.ComprehensionTlvTag;
import com.android.internal.telephony.gsm.stk.DisplayTextParams;
import com.android.internal.telephony.gsm.stk.Duration;
import com.android.internal.telephony.gsm.stk.GetInputParams;
import com.android.internal.telephony.gsm.stk.IconId;
import com.android.internal.telephony.gsm.stk.IconLoader;
import com.android.internal.telephony.gsm.stk.Input;
import com.android.internal.telephony.gsm.stk.ItemsIconId;
import com.android.internal.telephony.gsm.stk.LaunchBrowserMode;
import com.android.internal.telephony.gsm.stk.LaunchBrowserParams;
import com.android.internal.telephony.gsm.stk.Menu;
import com.android.internal.telephony.gsm.stk.PlayToneParams;
import com.android.internal.telephony.gsm.stk.PresentationType;
import com.android.internal.telephony.gsm.stk.ResultCode;
import com.android.internal.telephony.gsm.stk.ResultException;
import com.android.internal.telephony.gsm.stk.RilMessageDecoder;
import com.android.internal.telephony.gsm.stk.SelectItemParams;
import com.android.internal.telephony.gsm.stk.StkLog;
import com.android.internal.telephony.gsm.stk.TextMessage;
import com.android.internal.telephony.gsm.stk.Tone;
import com.android.internal.telephony.gsm.stk.ValueParser;
import java.util.Iterator;
import java.util.List;

class CommandParamsFactory
extends Handler {
    static final int LOAD_MULTI_ICONS = 2;
    static final int LOAD_NO_ICON = 0;
    static final int LOAD_SINGLE_ICON = 1;
    static final int MSG_ID_LOAD_ICON_DONE = 1;
    static final int REFRESH_NAA_INIT = 3;
    static final int REFRESH_NAA_INIT_AND_FILE_CHANGE = 2;
    static final int REFRESH_NAA_INIT_AND_FULL_FILE_CHANGE = 0;
    static final int REFRESH_UICC_RESET = 4;
    private static CommandParamsFactory sInstance = null;
    private RilMessageDecoder mCaller = null;
    private CommandParams mCmdParams = null;
    private int mIconLoadState = 0;
    private IconLoader mIconLoader;

    private CommandParamsFactory(RilMessageDecoder rilMessageDecoder, SIMFileHandler sIMFileHandler) {
        this.mCaller = rilMessageDecoder;
        this.mIconLoader = IconLoader.getInstance(this, sIMFileHandler);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static CommandParamsFactory getInstance(RilMessageDecoder rilMessageDecoder, SIMFileHandler sIMFileHandler) {
        synchronized (CommandParamsFactory.class) {
            block6: {
                if (sInstance == null) break block6;
                return sInstance;
            }
            if (sIMFileHandler == null) return null;
            CommandParamsFactory commandParamsFactory = new CommandParamsFactory(rilMessageDecoder, sIMFileHandler);
            return commandParamsFactory;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CommandDetails processCommandDetails(List<ComprehensionTlv> list) {
        CommandDetails commandDetails = null;
        if (list == null) return commandDetails;
        ComprehensionTlv comprehensionTlv = this.searchForTag(ComprehensionTlvTag.COMMAND_DETAILS, list);
        commandDetails = null;
        if (comprehensionTlv == null) return commandDetails;
        try {
            CommandDetails commandDetails2 = ValueParser.retrieveCommandDetails(comprehensionTlv);
            return commandDetails2;
        }
        catch (ResultException resultException) {
            StkLog.d(this, "Failed to procees command details");
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean processDisplayText(CommandDetails commandDetails, List<ComprehensionTlv> list) throws ResultException {
        ComprehensionTlv comprehensionTlv;
        StkLog.d(this, "process DisplayText");
        TextMessage textMessage = new TextMessage();
        ComprehensionTlv comprehensionTlv2 = this.searchForTag(ComprehensionTlvTag.TEXT_STRING, list);
        if (comprehensionTlv2 != null) {
            textMessage.text = ValueParser.retrieveTextString(comprehensionTlv2);
        }
        if (textMessage.text == null) {
            throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
        }
        if (this.searchForTag(ComprehensionTlvTag.IMMEDIATE_RESPONSE, list) != null) {
            textMessage.responseNeeded = false;
        }
        ComprehensionTlv comprehensionTlv3 = this.searchForTag(ComprehensionTlvTag.ICON_ID, list);
        IconId iconId = null;
        if (comprehensionTlv3 != null) {
            iconId = ValueParser.retrieveIconId(comprehensionTlv3);
            textMessage.iconSelfExplanatory = iconId.selfExplanatory;
        }
        if ((comprehensionTlv = this.searchForTag(ComprehensionTlvTag.DURATION, list)) != null) {
            textMessage.duration = ValueParser.retrieveDuration(comprehensionTlv);
        }
        boolean bl = (1 & commandDetails.commandQualifier) != 0;
        textMessage.isHighPriority = bl;
        boolean bl2 = (0x80 & commandDetails.commandQualifier) != 0;
        textMessage.userClear = bl2;
        this.mCmdParams = new DisplayTextParams(commandDetails, textMessage);
        if (iconId != null) {
            this.mIconLoadState = 1;
            this.mIconLoader.loadIcon(iconId.recordNumber, this.obtainMessage(1));
            return true;
        }
        return false;
    }

    private boolean processEventNotify(CommandDetails commandDetails, List<ComprehensionTlv> list) throws ResultException {
        StkLog.d(this, "process EventNotify");
        TextMessage textMessage = new TextMessage();
        ComprehensionTlv comprehensionTlv = this.searchForTag(ComprehensionTlvTag.ALPHA_ID, list);
        if (comprehensionTlv != null) {
            textMessage.text = ValueParser.retrieveAlphaId(comprehensionTlv);
            ComprehensionTlv comprehensionTlv2 = this.searchForTag(ComprehensionTlvTag.ICON_ID, list);
            IconId iconId = null;
            if (comprehensionTlv2 != null) {
                iconId = ValueParser.retrieveIconId(comprehensionTlv2);
                textMessage.iconSelfExplanatory = iconId.selfExplanatory;
            }
            textMessage.responseNeeded = false;
            this.mCmdParams = new DisplayTextParams(commandDetails, textMessage);
            if (iconId != null) {
                this.mIconLoadState = 1;
                this.mIconLoader.loadIcon(iconId.recordNumber, this.obtainMessage(1));
                return true;
            }
        } else {
            throw new ResultException(ResultCode.REQUIRED_VALUES_MISSING);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean processGetInkey(CommandDetails commandDetails, List<ComprehensionTlv> list) throws ResultException {
        StkLog.d(this, "process GetInkey");
        Input input = new Input();
        ComprehensionTlv comprehensionTlv = this.searchForTag(ComprehensionTlvTag.TEXT_STRING, list);
        if (comprehensionTlv == null) {
            throw new ResultException(ResultCode.REQUIRED_VALUES_MISSING);
        }
        input.text = ValueParser.retrieveTextString(comprehensionTlv);
        ComprehensionTlv comprehensionTlv2 = this.searchForTag(ComprehensionTlvTag.ICON_ID, list);
        IconId iconId = null;
        if (comprehensionTlv2 != null) {
            iconId = ValueParser.retrieveIconId(comprehensionTlv2);
        }
        input.minLen = 1;
        input.maxLen = 1;
        boolean bl = (1 & commandDetails.commandQualifier) == 0;
        input.digitOnly = bl;
        boolean bl2 = (2 & commandDetails.commandQualifier) != 0;
        input.ucs2 = bl2;
        boolean bl3 = (4 & commandDetails.commandQualifier) != 0;
        input.yesNo = bl3;
        boolean bl4 = (0x80 & commandDetails.commandQualifier) != 0;
        input.helpAvailable = bl4;
        this.mCmdParams = new GetInputParams(commandDetails, input);
        if (iconId != null) {
            this.mIconLoadState = 1;
            this.mIconLoader.loadIcon(iconId.recordNumber, this.obtainMessage(1));
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processGetInput(CommandDetails commandDetails, List<ComprehensionTlv> list) throws ResultException {
        StkLog.d(this, "process GetInput");
        Input input = new Input();
        ComprehensionTlv comprehensionTlv = this.searchForTag(ComprehensionTlvTag.TEXT_STRING, list);
        if (comprehensionTlv == null) {
            throw new ResultException(ResultCode.REQUIRED_VALUES_MISSING);
        }
        input.text = ValueParser.retrieveTextString(comprehensionTlv);
        ComprehensionTlv comprehensionTlv2 = this.searchForTag(ComprehensionTlvTag.RESPONSE_LENGTH, list);
        if (comprehensionTlv2 == null) {
            throw new ResultException(ResultCode.REQUIRED_VALUES_MISSING);
        }
        try {
            byte[] byArray = comprehensionTlv2.getRawValue();
            int n = comprehensionTlv2.getValueIndex();
            input.minLen = 0xFF & byArray[n];
            input.maxLen = 0xFF & byArray[n + 1];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
        }
        ComprehensionTlv comprehensionTlv3 = this.searchForTag(ComprehensionTlvTag.DEFAULT_TEXT, list);
        if (comprehensionTlv3 != null) {
            input.defaultText = ValueParser.retrieveTextString(comprehensionTlv3);
        }
        ComprehensionTlv comprehensionTlv4 = this.searchForTag(ComprehensionTlvTag.ICON_ID, list);
        IconId iconId = null;
        if (comprehensionTlv4 != null) {
            iconId = ValueParser.retrieveIconId(comprehensionTlv4);
        }
        boolean bl = (1 & commandDetails.commandQualifier) == 0;
        input.digitOnly = bl;
        boolean bl2 = (2 & commandDetails.commandQualifier) != 0;
        input.ucs2 = bl2;
        boolean bl3 = (4 & commandDetails.commandQualifier) == 0;
        input.echo = bl3;
        boolean bl4 = (8 & commandDetails.commandQualifier) != 0;
        input.packed = bl4;
        boolean bl5 = (0x80 & commandDetails.commandQualifier) != 0;
        input.helpAvailable = bl5;
        this.mCmdParams = new GetInputParams(commandDetails, input);
        if (iconId != null) {
            this.mIconLoadState = 1;
            this.mIconLoader.loadIcon(iconId.recordNumber, this.obtainMessage(1));
            return true;
        }
        return false;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processLaunchBrowser(CommandDetails commandDetails, List<ComprehensionTlv> list) throws ResultException {
        LaunchBrowserMode launchBrowserMode;
        ComprehensionTlv comprehensionTlv;
        StkLog.d(this, "process LaunchBrowser");
        TextMessage textMessage = new TextMessage();
        ComprehensionTlv comprehensionTlv2 = this.searchForTag(ComprehensionTlvTag.URL, list);
        String string2 = null;
        if (comprehensionTlv2 != null) {
            String string3;
            byte[] byArray = comprehensionTlv2.getRawValue();
            int n = comprehensionTlv2.getValueIndex();
            int n2 = comprehensionTlv2.getLength();
            string2 = n2 > 0 ? (string3 = GsmAlphabet.gsm8BitUnpackedToString(byArray, n, n2)) : null;
        }
        if ((comprehensionTlv = this.searchForTag(ComprehensionTlvTag.ALPHA_ID, list)) != null) {
            textMessage.text = ValueParser.retrieveAlphaId(comprehensionTlv);
        }
        ComprehensionTlv comprehensionTlv3 = this.searchForTag(ComprehensionTlvTag.ICON_ID, list);
        IconId iconId = null;
        if (comprehensionTlv3 != null) {
            iconId = ValueParser.retrieveIconId(comprehensionTlv3);
            textMessage.iconSelfExplanatory = iconId.selfExplanatory;
        }
        switch (commandDetails.commandQualifier) {
            default: {
                launchBrowserMode = LaunchBrowserMode.LAUNCH_IF_NOT_ALREADY_LAUNCHED;
                break;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
            }
            case 2: {
                launchBrowserMode = LaunchBrowserMode.USE_EXISTING_BROWSER;
                break;
            }
            case 3: {
                launchBrowserMode = LaunchBrowserMode.LAUNCH_NEW_BROWSER;
            }
        }
        this.mCmdParams = new LaunchBrowserParams(commandDetails, textMessage, string2, launchBrowserMode);
        if (iconId != null) {
            this.mIconLoadState = 1;
            this.mIconLoader.loadIcon(iconId.recordNumber, this.obtainMessage(1));
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processPlayTone(CommandDetails commandDetails, List<ComprehensionTlv> list) throws ResultException {
        ComprehensionTlv comprehensionTlv;
        StkLog.d(this, "process PlayTone");
        TextMessage textMessage = new TextMessage();
        ComprehensionTlv comprehensionTlv2 = this.searchForTag(ComprehensionTlvTag.TONE, list);
        Tone tone = null;
        if (comprehensionTlv2 != null) {
            int n = comprehensionTlv2.getLength();
            tone = null;
            if (n > 0) {
                try {
                    Tone tone2;
                    tone = tone2 = Tone.fromInt(comprehensionTlv2.getRawValue()[comprehensionTlv2.getValueIndex()]);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
                }
            }
        }
        if ((comprehensionTlv = this.searchForTag(ComprehensionTlvTag.ALPHA_ID, list)) != null) {
            textMessage.text = ValueParser.retrieveAlphaId(comprehensionTlv);
        }
        ComprehensionTlv comprehensionTlv3 = this.searchForTag(ComprehensionTlvTag.DURATION, list);
        Duration duration = null;
        if (comprehensionTlv3 != null) {
            duration = ValueParser.retrieveDuration(comprehensionTlv3);
        }
        ComprehensionTlv comprehensionTlv4 = this.searchForTag(ComprehensionTlvTag.ICON_ID, list);
        IconId iconId = null;
        if (comprehensionTlv4 != null) {
            iconId = ValueParser.retrieveIconId(comprehensionTlv4);
            textMessage.iconSelfExplanatory = iconId.selfExplanatory;
        }
        boolean bl = (1 & commandDetails.commandQualifier) != 0;
        textMessage.responseNeeded = false;
        this.mCmdParams = new PlayToneParams(commandDetails, textMessage, tone, duration, bl);
        if (iconId != null) {
            this.mIconLoadState = 1;
            this.mIconLoader.loadIcon(iconId.recordNumber, this.obtainMessage(1));
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean processRefresh(CommandDetails commandDetails, List<ComprehensionTlv> list) {
        StkLog.d(this, "process Refresh");
        switch (commandDetails.commandQualifier) {
            default: {
                return false;
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
        }
        this.mCmdParams = new DisplayTextParams(commandDetails, null);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean processSelectItem(CommandDetails commandDetails, List<ComprehensionTlv> list) throws ResultException {
        boolean bl;
        ComprehensionTlv comprehensionTlv;
        StkLog.d(this, "process SelectItem");
        Menu menu = new Menu();
        Iterator<ComprehensionTlv> iterator = list.iterator();
        ComprehensionTlv comprehensionTlv2 = this.searchForTag(ComprehensionTlvTag.ALPHA_ID, list);
        if (comprehensionTlv2 != null) {
            menu.title = ValueParser.retrieveAlphaId(comprehensionTlv2);
        }
        while ((comprehensionTlv = this.searchForNextTag(ComprehensionTlvTag.ITEM, iterator)) != null) {
            menu.items.add(ValueParser.retrieveItem(comprehensionTlv));
        }
        if (menu.items.size() == 0) {
            throw new ResultException(ResultCode.REQUIRED_VALUES_MISSING);
        }
        ComprehensionTlv comprehensionTlv3 = this.searchForTag(ComprehensionTlvTag.ITEM_ID, list);
        if (comprehensionTlv3 != null) {
            menu.defaultItem = ValueParser.retrieveItemId(comprehensionTlv3) - 1;
        }
        ComprehensionTlv comprehensionTlv4 = this.searchForTag(ComprehensionTlvTag.ICON_ID, list);
        IconId iconId = null;
        if (comprehensionTlv4 != null) {
            this.mIconLoadState = 1;
            iconId = ValueParser.retrieveIconId(comprehensionTlv4);
            menu.titleIconSelfExplanatory = iconId.selfExplanatory;
        }
        ComprehensionTlv comprehensionTlv5 = this.searchForTag(ComprehensionTlvTag.ITEM_ICON_ID_LIST, list);
        ItemsIconId itemsIconId = null;
        if (comprehensionTlv5 != null) {
            this.mIconLoadState = 2;
            itemsIconId = ValueParser.retrieveItemsIconId(comprehensionTlv5);
            menu.itemsIconSelfExplanatory = itemsIconId.selfExplanatory;
        }
        if (bl = (1 & commandDetails.commandQualifier) != 0) {
            menu.presentationType = (2 & commandDetails.commandQualifier) == 0 ? PresentationType.DATA_VALUES : PresentationType.NAVIGATION_OPTIONS;
        }
        boolean bl2 = (4 & commandDetails.commandQualifier) != 0;
        menu.softKeyPreferred = bl2;
        boolean bl3 = (0x80 & commandDetails.commandQualifier) != 0;
        menu.helpAvailable = bl3;
        boolean bl4 = iconId != null;
        this.mCmdParams = new SelectItemParams(commandDetails, menu, bl4);
        switch (this.mIconLoadState) {
            case 0: {
                return false;
            }
            case 1: {
                this.mIconLoader.loadIcon(iconId.recordNumber, this.obtainMessage(1));
            }
            default: {
                return true;
            }
            case 2: 
        }
        int[] nArray = itemsIconId.recordNumbers;
        if (iconId != null) {
            nArray = new int[1 + itemsIconId.recordNumbers.length];
            nArray[0] = iconId.recordNumber;
            System.arraycopy(itemsIconId.recordNumbers, 0, nArray, 1, itemsIconId.recordNumbers.length);
        }
        this.mIconLoader.loadIcons(nArray, this.obtainMessage(1));
        return true;
    }

    private boolean processSetUpEventList(CommandDetails commandDetails, List<ComprehensionTlv> list) {
        StkLog.d(this, "process SetUpEventList");
        return true;
    }

    private boolean processSetUpIdleModeText(CommandDetails commandDetails, List<ComprehensionTlv> list) throws ResultException {
        StkLog.d(this, "process SetUpIdleModeText");
        TextMessage textMessage = new TextMessage();
        ComprehensionTlv comprehensionTlv = this.searchForTag(ComprehensionTlvTag.TEXT_STRING, list);
        if (comprehensionTlv != null) {
            textMessage.text = ValueParser.retrieveTextString(comprehensionTlv);
        }
        String string2 = textMessage.text;
        IconId iconId = null;
        if (string2 != null) {
            ComprehensionTlv comprehensionTlv2 = this.searchForTag(ComprehensionTlvTag.ICON_ID, list);
            iconId = null;
            if (comprehensionTlv2 != null) {
                iconId = ValueParser.retrieveIconId(comprehensionTlv2);
                textMessage.iconSelfExplanatory = iconId.selfExplanatory;
            }
        }
        this.mCmdParams = new DisplayTextParams(commandDetails, textMessage);
        if (iconId != null) {
            this.mIconLoadState = 1;
            this.mIconLoader.loadIcon(iconId.recordNumber, this.obtainMessage(1));
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean processSetupCall(CommandDetails commandDetails, List<ComprehensionTlv> list) throws ResultException {
        ComprehensionTlv comprehensionTlv;
        StkLog.d(this, "process SetupCall");
        Iterator<ComprehensionTlv> iterator = list.iterator();
        TextMessage textMessage = new TextMessage();
        TextMessage textMessage2 = new TextMessage();
        ComprehensionTlv comprehensionTlv2 = this.searchForNextTag(ComprehensionTlvTag.ALPHA_ID, iterator);
        if (comprehensionTlv2 != null) {
            textMessage.text = ValueParser.retrieveAlphaId(comprehensionTlv2);
        }
        ComprehensionTlv comprehensionTlv3 = this.searchForTag(ComprehensionTlvTag.ICON_ID, list);
        IconId iconId = null;
        if (comprehensionTlv3 != null) {
            iconId = ValueParser.retrieveIconId(comprehensionTlv3);
            textMessage.iconSelfExplanatory = iconId.selfExplanatory;
        }
        if ((comprehensionTlv = this.searchForNextTag(ComprehensionTlvTag.ALPHA_ID, iterator)) != null) {
            textMessage2.text = ValueParser.retrieveAlphaId(comprehensionTlv);
        }
        ComprehensionTlv comprehensionTlv4 = this.searchForTag(ComprehensionTlvTag.ICON_ID, list);
        IconId iconId2 = null;
        if (comprehensionTlv4 != null) {
            iconId2 = ValueParser.retrieveIconId(comprehensionTlv4);
            textMessage2.iconSelfExplanatory = iconId2.selfExplanatory;
        }
        this.mCmdParams = new CallSetupParams(commandDetails, textMessage, textMessage2);
        if (iconId == null && iconId2 == null) {
            return false;
        }
        this.mIconLoadState = 2;
        int[] nArray = new int[2];
        int n = iconId != null ? iconId.recordNumber : -1;
        nArray[0] = n;
        int n2 = iconId2 != null ? iconId2.recordNumber : -1;
        nArray[1] = n2;
        this.mIconLoader.loadIcons(nArray, this.obtainMessage(1));
        return true;
    }

    private ComprehensionTlv searchForNextTag(ComprehensionTlvTag comprehensionTlvTag, Iterator<ComprehensionTlv> iterator) {
        int n = comprehensionTlvTag.value();
        while (iterator.hasNext()) {
            ComprehensionTlv comprehensionTlv = iterator.next();
            if (comprehensionTlv.getTag() != n) continue;
            return comprehensionTlv;
        }
        return null;
    }

    private ComprehensionTlv searchForTag(ComprehensionTlvTag comprehensionTlvTag, List<ComprehensionTlv> list) {
        return this.searchForNextTag(comprehensionTlvTag, list.iterator());
    }

    private void sendCmdParams(ResultCode resultCode) {
        this.mCaller.sendMsgParamsDecoded(resultCode, this.mCmdParams);
    }

    /*
     * Enabled aggressive block sorting
     */
    private ResultCode setIcons(Object object) {
        if (object == null) {
            return ResultCode.PRFRMD_ICON_NOT_DISPLAYED;
        }
        switch (this.mIconLoadState) {
            case 1: {
                this.mCmdParams.setIcon((Bitmap)object);
            }
            default: {
                return ResultCode.OK;
            }
            case 2: {
                for (Bitmap bitmap : (Bitmap[])object) {
                    this.mCmdParams.setIcon(bitmap);
                }
            }
        }
        return ResultCode.OK;
    }

    @Override
    public void handleMessage(Message message) {
        switch (message.what) {
            default: {
                return;
            }
            case 1: 
        }
        this.sendCmdParams(this.setIcons(message.obj));
    }

    /*
     * Exception decompiling
     */
    void make(BerTlv var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [2 : 200->208)] com.android.internal.telephony.gsm.stk.ResultException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

