/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm.stk;

import com.android.internal.telephony.EncodeException;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.gsm.stk.ComprehensionTlvTag;
import com.android.internal.telephony.gsm.stk.ResponseData;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

class GetInkeyInputResponseData
extends ResponseData {
    protected static final byte GET_INKEY_NO = 0;
    protected static final byte GET_INKEY_YES = 1;
    public String mInData;
    private boolean mIsPacked;
    private boolean mIsUcs2;
    private boolean mIsYesNo;
    private boolean mYesNoResponse;

    public GetInkeyInputResponseData(String string2, boolean bl, boolean bl2) {
        this.mIsUcs2 = bl;
        this.mIsPacked = bl2;
        this.mInData = string2;
        this.mIsYesNo = false;
    }

    public GetInkeyInputResponseData(boolean bl) {
        this.mIsUcs2 = false;
        this.mIsPacked = false;
        this.mInData = "";
        this.mIsYesNo = true;
        this.mYesNoResponse = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void format(ByteArrayOutputStream byteArrayOutputStream) {
        if (byteArrayOutputStream != null) {
            byte[] byArray;
            byteArrayOutputStream.write(0x80 | ComprehensionTlvTag.TEXT_STRING.value());
            if (this.mIsYesNo) {
                byArray = new byte[1];
                byte by = this.mYesNoResponse ? (byte)1 : 0;
                byArray[0] = by;
            } else if (this.mInData != null && this.mInData.length() > 0) {
                try {
                    if (this.mIsUcs2) {
                        byArray = this.mInData.getBytes("UTF-16");
                    } else {
                        if (this.mIsPacked) {
                            int n = this.mInData.length();
                            byte[] byArray2 = GsmAlphabet.stringToGsm7BitPacked(this.mInData);
                            byArray = new byte[n];
                            System.arraycopy(byArray2, 1, byArray, 0, n);
                        }
                        byte[] byArray3 = GsmAlphabet.stringToGsm8BitPacked(this.mInData);
                        byArray = byArray3;
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    byArray = new byte[]{};
                }
                catch (EncodeException encodeException) {
                    byArray = new byte[]{};
                }
            } else {
                byArray = new byte[]{};
            }
            byteArrayOutputStream.write(1 + byArray.length);
            if (this.mIsUcs2) {
                byteArrayOutputStream.write(8);
            } else if (this.mIsPacked) {
                byteArrayOutputStream.write(0);
            } else {
                byteArrayOutputStream.write(4);
            }
            byte[] byArray4 = byArray;
            int n = byArray4.length;
            for (int i = 0; i < n; ++i) {
                byteArrayOutputStream.write(byArray4[i]);
            }
        }
    }
}

