/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm.stk;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.android.internal.telephony.gsm.SIMFileHandler;
import com.android.internal.telephony.gsm.stk.ImageDescriptor;
import com.android.internal.telephony.gsm.stk.StkLog;
import java.util.HashMap;

class IconLoader
extends Handler {
    private static final int CLUT_ENTRY_SIZE = 3;
    private static final int CLUT_LOCATION_OFFSET = 4;
    private static final int EVENT_READ_CLUT_DONE = 3;
    private static final int EVENT_READ_EF_IMG_RECOED_DONE = 1;
    private static final int EVENT_READ_ICON_DONE = 2;
    private static final int STATE_MULTI_ICONS = 2;
    private static final int STATE_SINGLE_ICON = 1;
    private static IconLoader sLoader = null;
    private Bitmap mCurrentIcon = null;
    private int mCurrentRecordIndex = 0;
    private Message mEndMsg = null;
    private byte[] mIconData = null;
    private Bitmap[] mIcons = null;
    private HashMap<Integer, Bitmap> mIconsCache = null;
    private ImageDescriptor mId = null;
    private int mRecordNumber;
    private int[] mRecordNumbers = null;
    private SIMFileHandler mSimFH = null;
    private int mState = 1;

    private IconLoader(Looper looper, SIMFileHandler sIMFileHandler) {
        super(looper);
        this.mSimFH = sIMFileHandler;
        this.mIconsCache = new HashMap(50);
    }

    private static int bitToBnW(int n) {
        if (n == 1) {
            return -1;
        }
        return -16777216;
    }

    static IconLoader getInstance(Handler handler, SIMFileHandler sIMFileHandler) {
        if (sLoader != null) {
            return sLoader;
        }
        if (sIMFileHandler != null) {
            HandlerThread handlerThread = new HandlerThread("Stk Icon Loader");
            handlerThread.start();
            return new IconLoader(handlerThread.getLooper(), sIMFileHandler);
        }
        return null;
    }

    private static int getMask(int n) {
        switch (n) {
            default: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 7;
            }
            case 4: {
                return 15;
            }
            case 5: {
                return 31;
            }
            case 6: {
                return 63;
            }
            case 7: {
                return 127;
            }
            case 8: 
        }
        return 255;
    }

    private boolean handleImageDescriptor(byte[] byArray) {
        this.mId = ImageDescriptor.parse(byArray, 1);
        return this.mId != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Bitmap parseToBnW(byte[] byArray, int n) {
        int n2 = 0 + 1;
        int n3 = 0xFF & byArray[0];
        int n4 = n2 + 1;
        int n5 = 0xFF & byArray[n2];
        int n6 = n3 * n5;
        int[] nArray = new int[n6];
        int n7 = 7;
        byte by = 0;
        int n8 = 0;
        int n9 = n4;
        while (n8 < n6) {
            int n10;
            if (n8 % 8 == 0) {
                n10 = n9 + 1;
                by = byArray[n9];
                n7 = 7;
            } else {
                n10 = n9;
            }
            int n11 = n8 + 1;
            int n12 = n7 - 1;
            nArray[n8] = IconLoader.bitToBnW(1 & by >> n7);
            n7 = n12;
            n8 = n11;
            n9 = n10;
        }
        if (n8 != n6) {
            StkLog.d("IconLoader", "parseToBnW; size error");
        }
        return Bitmap.createBitmap(nArray, n3, n5, Bitmap.Config.ARGB_8888);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Bitmap parseToRGB(byte[] byArray, int n, boolean bl, byte[] byArray2) {
        int n2;
        int n3 = 0 + 1;
        int n4 = 0xFF & byArray[0];
        int n5 = n3 + 1;
        int n6 = 0xFF & byArray[n3];
        int n7 = n5 + 1;
        int n8 = 0xFF & byArray[n5];
        int cfr_ignored_0 = n7 + 1;
        int n9 = 0xFF & byArray[n7];
        if (bl) {
            byArray2[n9 - 1] = 0;
        }
        int n10 = n4 * n6;
        int[] nArray = new int[n10];
        int n11 = n2 = 8 - n8;
        int n12 = 6 + 1;
        byte by = byArray[6];
        int n13 = IconLoader.getMask(n8);
        boolean bl2 = 8 % n8 == 0;
        int n14 = 0;
        while (n14 < n10) {
            byte by2;
            int n15;
            if (n11 < 0) {
                int n16 = n12 + 1;
                byte by3 = byArray[n12];
                n11 = bl2 ? n2 : (n11 *= -1);
                n15 = n16;
                by2 = by3;
            } else {
                by2 = by;
                n15 = n12;
            }
            int n17 = 3 * (n13 & by2 >> n11);
            int n18 = n14 + 1;
            nArray[n14] = Color.rgb(byArray2[n17], byArray2[n17 + 1], byArray2[n17 + 2]);
            n11 -= n8;
            by = by2;
            n14 = n18;
            n12 = n15;
        }
        return Bitmap.createBitmap(nArray, n4, n6, Bitmap.Config.ARGB_8888);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void postIcon() {
        if (this.mState == 1) {
            this.mEndMsg.obj = this.mCurrentIcon;
            this.mEndMsg.sendToTarget();
            return;
        }
        if (this.mState != 2) return;
        Bitmap[] bitmapArray = this.mIcons;
        int n = this.mCurrentRecordIndex;
        this.mCurrentRecordIndex = n + 1;
        bitmapArray[n] = this.mCurrentIcon;
        if (this.mCurrentRecordIndex < this.mRecordNumbers.length) {
            this.startLoadingIcon(this.mRecordNumbers[this.mCurrentRecordIndex]);
            return;
        }
        this.mEndMsg.obj = this.mIcons;
        this.mEndMsg.sendToTarget();
    }

    private void readClut() {
        int n = 3 * this.mIconData[3];
        Message message = this.obtainMessage(3);
        this.mSimFH.loadEFImgTransparent(this.mId.imageId, this.mIconData[4], this.mIconData[5], n, message);
    }

    private void readIconData() {
        Message message = this.obtainMessage(2);
        this.mSimFH.loadEFImgTransparent(this.mId.imageId, 0, 0, this.mId.length, message);
    }

    private void readId() {
        if (this.mRecordNumber < 0) {
            this.mCurrentIcon = null;
            this.postIcon();
            return;
        }
        Message message = this.obtainMessage(1);
        this.mSimFH.loadEFImgLinearFixed(this.mRecordNumber, message);
    }

    private void startLoadingIcon(int n) {
        this.mId = null;
        this.mIconData = null;
        this.mCurrentIcon = null;
        this.mRecordNumber = n;
        if (this.mIconsCache.containsKey(n)) {
            this.mCurrentIcon = this.mIconsCache.get(n);
            this.postIcon();
            return;
        }
        this.readId();
    }

    /*
     * Exception decompiling
     */
    @Override
    public void handleMessage(Message var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [2 : 72->230)] java.lang.Exception
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void loadIcon(int n, Message message) {
        if (message == null) {
            return;
        }
        this.mEndMsg = message;
        this.mState = 1;
        this.startLoadingIcon(n);
    }

    void loadIcons(int[] nArray, Message message) {
        if (nArray == null || nArray.length == 0 || message == null) {
            return;
        }
        this.mEndMsg = message;
        this.mIcons = new Bitmap[nArray.length];
        this.mRecordNumbers = nArray;
        this.mCurrentRecordIndex = 0;
        this.mState = 2;
        this.startLoadingIcon(nArray[0]);
    }
}

