/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm.stk;

import android.graphics.Bitmap;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.telephony.gsm.stk.Item;
import com.android.internal.telephony.gsm.stk.PresentationType;
import com.android.internal.telephony.gsm.stk.TextAttribute;
import java.util.ArrayList;
import java.util.List;

public class Menu
implements Parcelable {
    public static final Parcelable.Creator<Menu> CREATOR = new Parcelable.Creator<Menu>(){

        @Override
        public Menu createFromParcel(Parcel parcel) {
            return new Menu(parcel);
        }

        public Menu[] newArray(int n) {
            return new Menu[n];
        }
    };
    public int defaultItem;
    public boolean helpAvailable;
    public List<Item> items;
    public boolean itemsIconSelfExplanatory;
    public PresentationType presentationType;
    public boolean softKeyPreferred;
    public String title;
    public List<TextAttribute> titleAttrs;
    public Bitmap titleIcon;
    public boolean titleIconSelfExplanatory;

    public Menu() {
        this.items = new ArrayList<Item>();
        this.title = null;
        this.titleAttrs = null;
        this.defaultItem = 0;
        this.softKeyPreferred = false;
        this.helpAvailable = false;
        this.titleIconSelfExplanatory = false;
        this.itemsIconSelfExplanatory = false;
        this.titleIcon = null;
        this.presentationType = PresentationType.NAVIGATION_OPTIONS;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Menu(Parcel parcel) {
        this.title = parcel.readString();
        this.titleIcon = (Bitmap)parcel.readParcelable(null);
        this.items = new ArrayList<Item>();
        int n = parcel.readInt();
        for (int i = 0; i < n; ++i) {
            Item item = (Item)parcel.readParcelable(null);
            this.items.add(item);
        }
        this.defaultItem = parcel.readInt();
        boolean bl = parcel.readInt() == 1;
        this.softKeyPreferred = bl;
        boolean bl2 = parcel.readInt() == 1;
        this.helpAvailable = bl2;
        boolean bl3 = parcel.readInt() == 1;
        this.titleIconSelfExplanatory = bl3;
        boolean bl4 = parcel.readInt() == 1;
        this.itemsIconSelfExplanatory = bl4;
        this.presentationType = PresentationType.values()[parcel.readInt()];
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.title);
        parcel.writeParcelable(this.titleIcon, n);
        int n2 = this.items.size();
        parcel.writeInt(n2);
        for (int i = 0; i < n2; ++i) {
            parcel.writeParcelable(this.items.get(i), n);
        }
        parcel.writeInt(this.defaultItem);
        int n3 = this.softKeyPreferred ? 1 : 0;
        parcel.writeInt(n3);
        int n4 = this.helpAvailable ? 1 : 0;
        parcel.writeInt(n4);
        int n5 = this.titleIconSelfExplanatory ? 1 : 0;
        parcel.writeInt(n5);
        int n6 = this.itemsIconSelfExplanatory ? 1 : 0;
        parcel.writeInt(n6);
        parcel.writeInt(this.presentationType.ordinal());
    }
}

