/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm.stk;

import android.os.Handler;
import android.os.Message;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.gsm.SIMFileHandler;
import com.android.internal.telephony.gsm.stk.BerTlv;
import com.android.internal.telephony.gsm.stk.CommandParams;
import com.android.internal.telephony.gsm.stk.CommandParamsFactory;
import com.android.internal.telephony.gsm.stk.ResultCode;
import com.android.internal.telephony.gsm.stk.ResultException;
import com.android.internal.telephony.gsm.stk.RilMessage;
import com.android.internal.telephony.gsm.stk.StkLog;
import com.android.internal.util.HierarchicalState;
import com.android.internal.util.HierarchicalStateMachine;

class RilMessageDecoder
extends HierarchicalStateMachine {
    private static final int CMD_PARAMS_READY = 2;
    private static final int CMD_START = 1;
    private static RilMessageDecoder sInstance = null;
    private Handler mCaller = null;
    private CommandParamsFactory mCmdParamsFactory = null;
    private RilMessage mCurrentRilMessage = null;
    private StateCmdParamsReady mStateCmdParamsReady;
    private StateStart mStateStart = new StateStart();

    private RilMessageDecoder(Handler handler, SIMFileHandler sIMFileHandler) {
        super("RilMessageDecoder");
        this.mStateCmdParamsReady = new StateCmdParamsReady();
        this.addState(this.mStateStart);
        this.addState(this.mStateCmdParamsReady);
        this.setInitialState(this.mStateStart);
        this.mCaller = handler;
        this.mCmdParamsFactory = CommandParamsFactory.getInstance(this, sIMFileHandler);
    }

    private boolean decodeMessageParams(RilMessage rilMessage) {
        byte[] byArray;
        this.mCurrentRilMessage = rilMessage;
        switch (rilMessage.mId) {
            default: {
                return false;
            }
            case 1: 
            case 4: {
                this.mCurrentRilMessage.mResCode = ResultCode.OK;
                this.sendCmdForExecution(this.mCurrentRilMessage);
                return false;
            }
            case 2: 
            case 3: 
            case 5: 
        }
        try {
            byArray = IccUtils.hexStringToBytes((String)rilMessage.mData);
        }
        catch (Exception exception) {
            StkLog.d(this, "decodeMessageParams dropping zombie messages");
            return false;
        }
        try {
            this.mCmdParamsFactory.make(BerTlv.decode(byArray));
            return true;
        }
        catch (ResultException resultException) {
            this.mCurrentRilMessage.mResCode = resultException.result();
            this.sendCmdForExecution(this.mCurrentRilMessage);
            return false;
        }
    }

    public static RilMessageDecoder getInstance(Handler handler, SIMFileHandler sIMFileHandler) {
        synchronized (RilMessageDecoder.class) {
            if (sInstance == null) {
                sInstance = new RilMessageDecoder(handler, sIMFileHandler);
                sInstance.start();
            }
            RilMessageDecoder rilMessageDecoder = sInstance;
            return rilMessageDecoder;
        }
    }

    private void sendCmdForExecution(RilMessage rilMessage) {
        this.mCaller.obtainMessage(10, new RilMessage(rilMessage)).sendToTarget();
    }

    public void sendMsgParamsDecoded(ResultCode resultCode, CommandParams commandParams) {
        Message message = this.obtainMessage(2);
        message.arg1 = resultCode.value();
        message.obj = commandParams;
        this.sendMessage(message);
    }

    public void sendStartDecodingMessageParams(RilMessage rilMessage) {
        Message message = this.obtainMessage(1);
        message.obj = rilMessage;
        this.sendMessage(message);
    }

    private class StateCmdParamsReady
    extends HierarchicalState {
        private StateCmdParamsReady() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected boolean processMessage(Message message) {
            if (message.what == 2) {
                ((RilMessageDecoder)RilMessageDecoder.this).mCurrentRilMessage.mResCode = ResultCode.fromInt(message.arg1);
                ((RilMessageDecoder)RilMessageDecoder.this).mCurrentRilMessage.mData = message.obj;
                RilMessageDecoder.this.sendCmdForExecution(RilMessageDecoder.this.mCurrentRilMessage);
                RilMessageDecoder.this.transitionTo(RilMessageDecoder.this.mStateStart);
                return true;
            }
            StkLog.d(this, "StateCmdParamsReady expecting CMD_PARAMS_READY=2 got " + message.what);
            RilMessageDecoder.this.deferMessage(message);
            return true;
        }
    }

    private class StateStart
    extends HierarchicalState {
        private StateStart() {
        }

        @Override
        protected boolean processMessage(Message message) {
            if (message.what == 1) {
                if (RilMessageDecoder.this.decodeMessageParams((RilMessage)message.obj)) {
                    RilMessageDecoder.this.transitionTo(RilMessageDecoder.this.mStateCmdParamsReady);
                }
                return true;
            }
            StkLog.d(this, "StateStart unexpected expecting START=1 got " + message.what);
            return true;
        }
    }
}

