/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm.stk;

import android.content.Context;
import android.content.Intent;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.gsm.SIMFileHandler;
import com.android.internal.telephony.gsm.SIMRecords;
import com.android.internal.telephony.gsm.SimCard;
import com.android.internal.telephony.gsm.stk.AppInterface;
import com.android.internal.telephony.gsm.stk.CommandDetails;
import com.android.internal.telephony.gsm.stk.CommandParams;
import com.android.internal.telephony.gsm.stk.ComprehensionTlvTag;
import com.android.internal.telephony.gsm.stk.GetInkeyInputResponseData;
import com.android.internal.telephony.gsm.stk.Input;
import com.android.internal.telephony.gsm.stk.Item;
import com.android.internal.telephony.gsm.stk.Menu;
import com.android.internal.telephony.gsm.stk.ResponseData;
import com.android.internal.telephony.gsm.stk.ResultCode;
import com.android.internal.telephony.gsm.stk.RilMessage;
import com.android.internal.telephony.gsm.stk.RilMessageDecoder;
import com.android.internal.telephony.gsm.stk.SelectItemResponseData;
import com.android.internal.telephony.gsm.stk.StkCmdMessage;
import com.android.internal.telephony.gsm.stk.StkLog;
import com.android.internal.telephony.gsm.stk.StkResponseMessage;
import java.io.ByteArrayOutputStream;

public class StkService
extends Handler
implements AppInterface {
    private static final int DEV_ID_DISPLAY = 2;
    private static final int DEV_ID_EARPIECE = 3;
    private static final int DEV_ID_KEYPAD = 1;
    private static final int DEV_ID_NETWORK = 131;
    private static final int DEV_ID_TERMINAL = 130;
    private static final int DEV_ID_UICC = 129;
    static final int MSG_ID_CALL_SETUP = 4;
    static final int MSG_ID_EVENT_NOTIFY = 3;
    static final int MSG_ID_PROACTIVE_COMMAND = 2;
    static final int MSG_ID_REFRESH = 5;
    static final int MSG_ID_RESPONSE = 6;
    static final int MSG_ID_RIL_MSG_DECODED = 10;
    static final int MSG_ID_SESSION_END = 1;
    private static final int MSG_ID_SIM_LOADED = 20;
    private static SIMRecords mSimRecords;
    private static StkService sInstance;
    private CommandsInterface mCmdIf;
    private Context mContext;
    private StkCmdMessage mCurrntCmd = null;
    private StkCmdMessage mMenuCmd = null;
    private RilMessageDecoder mMsgDecoder = null;

    private StkService(CommandsInterface commandsInterface, SIMRecords sIMRecords, Context context, SIMFileHandler sIMFileHandler, SimCard simCard) {
        if (commandsInterface == null || sIMRecords == null || context == null || sIMFileHandler == null || simCard == null) {
            throw new NullPointerException("Service: Input parameters must not be null");
        }
        this.mCmdIf = commandsInterface;
        this.mContext = context;
        this.mMsgDecoder = RilMessageDecoder.getInstance(this, sIMFileHandler);
        this.mCmdIf.setOnStkSessionEnd(this, 1, null);
        this.mCmdIf.setOnStkProactiveCmd(this, 2, null);
        this.mCmdIf.setOnStkEvent(this, 3, null);
        this.mCmdIf.setOnStkCallSetUp(this, 4, null);
        mSimRecords = sIMRecords;
        mSimRecords.registerForRecordsLoaded(this, 20, null);
        this.mCmdIf.reportStkServiceIsRunning(null);
        StkLog.d(this, "StkService: is running");
    }

    private void eventDownload(int n, int n2, int n3, byte[] byArray, boolean bl) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(214);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0x80 | ComprehensionTlvTag.EVENT_LIST.value());
        byteArrayOutputStream.write(1);
        byteArrayOutputStream.write(n);
        byteArrayOutputStream.write(0x80 | ComprehensionTlvTag.DEVICE_IDENTITIES.value());
        byteArrayOutputStream.write(2);
        byteArrayOutputStream.write(n2);
        byteArrayOutputStream.write(n3);
        if (byArray != null) {
            int n4 = byArray.length;
            for (int i = 0; i < n4; ++i) {
                byteArrayOutputStream.write(byArray[i]);
            }
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        byArray2[1] = (byte)(byArray2.length - 2);
        String string2 = IccUtils.bytesToHexString(byArray2);
        this.mCmdIf.sendEnvelope(string2, null);
    }

    public static AppInterface getInstance() {
        return StkService.getInstance(null, null, null, null, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StkService getInstance(CommandsInterface commandsInterface, SIMRecords sIMRecords, Context context, SIMFileHandler sIMFileHandler, SimCard simCard) {
        if (sInstance == null) {
            if (commandsInterface == null || sIMRecords == null || context == null || sIMFileHandler == null || simCard == null) {
                return null;
            }
            new HandlerThread("Stk Telephony service").start();
            sInstance = new StkService(commandsInterface, sIMRecords, context, sIMFileHandler, simCard);
            StkLog.d(sInstance, "NEW sInstance");
            return sInstance;
        }
        if (sIMRecords != null && mSimRecords != sIMRecords) {
            StkLog.d(sInstance, "Reinitialize the Service with SIMRecords");
            mSimRecords = sIMRecords;
            mSimRecords.registerForRecordsLoaded(sInstance, 20, null);
            StkLog.d(sInstance, "sr changed reinitialize and return current sInstance");
            return sInstance;
        }
        StkLog.d(sInstance, "Return current sInstance");
        return sInstance;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void handleCmdResponse(StkResponseMessage stkResponseMessage) {
        void var5_7;
        if (!this.validateResponse(stkResponseMessage)) {
            return;
        }
        CommandDetails commandDetails = stkResponseMessage.getCmdDetails();
        int n = 1.$SwitchMap$com$android$internal$telephony$gsm$stk$ResultCode[stkResponseMessage.resCode.ordinal()];
        boolean bl = false;
        block0 : switch (n) {
            default: {
                return;
            }
            case 1: {
                bl = true;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                int n2 = 1.$SwitchMap$com$android$internal$telephony$gsm$stk$AppInterface$CommandType[AppInterface.CommandType.fromInt(commandDetails.typeOfCommand).ordinal()];
                Object var5_6 = null;
                switch (n2) {
                    case 1: {
                        boolean bl2 = stkResponseMessage.resCode == ResultCode.HELP_INFO_REQUIRED;
                        this.sendMenuSelection(stkResponseMessage.usersMenuSelection, bl2);
                        return;
                    }
                    case 6: {
                        SelectItemResponseData selectItemResponseData = new SelectItemResponseData(stkResponseMessage.usersMenuSelection);
                        break block0;
                    }
                    case 7: 
                    case 8: {
                        Input input = this.mCurrntCmd.geInput();
                        if (!input.yesNo) {
                            Object var5_9 = null;
                            if (!bl) {
                                GetInkeyInputResponseData getInkeyInputResponseData = new GetInkeyInputResponseData(stkResponseMessage.usersInput, input.ucs2, input.packed);
                                break block0;
                            }
                        } else {
                            GetInkeyInputResponseData getInkeyInputResponseData = new GetInkeyInputResponseData(stkResponseMessage.usersYesNoSelection);
                        }
                    }
                    default: {
                        break block0;
                    }
                    case 14: 
                }
                this.mCmdIf.handleCallSetupRequestFromSim(stkResponseMessage.usersConfirm, null);
                this.mCurrntCmd = null;
                return;
            }
            case 12: 
            case 13: 
            case 14: {
                Object var5_12 = null;
            }
        }
        this.sendTerminalResponse(commandDetails, stkResponseMessage.resCode, false, 0, (ResponseData)var5_7);
        this.mCurrntCmd = null;
    }

    /*
     * Handled duff style switch with additional control
     * Enabled aggressive block sorting
     */
    private void handleProactiveCommand(CommandParams commandParams) {
        StkLog.d(this, commandParams.getCommandType().name());
        StkCmdMessage stkCmdMessage = new StkCmdMessage(commandParams);
        int n = 0;
        block7: do {
            switch (n == 0 ? 1.$SwitchMap$com$android$internal$telephony$gsm$stk$AppInterface$CommandType[commandParams.getCommandType().ordinal()] : n) {
                default: {
                    StkLog.d(this, "Unsupported command");
                    return;
                }
                case 1: {
                    this.mMenuCmd = this.removeMenu(stkCmdMessage.getMenu()) ? null : stkCmdMessage;
                    this.sendTerminalResponse(commandParams.cmdDet, ResultCode.OK, false, 0, null);
                    break;
                }
                case 2: {
                    n = 5;
                    if (stkCmdMessage.geTextMessage().responseNeeded) continue block7;
                    this.sendTerminalResponse(commandParams.cmdDet, ResultCode.OK, false, 0, null);
                    break;
                }
                case 3: {
                    commandParams.cmdDet.typeOfCommand = AppInterface.CommandType.SET_UP_IDLE_MODE_TEXT.value();
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    break;
                }
                case 4: {
                    this.sendTerminalResponse(commandParams.cmdDet, ResultCode.OK, false, 0, null);
                }
            }
            break;
        } while (true);
        this.mCurrntCmd = stkCmdMessage;
        Intent intent = new Intent("android.intent.action.stk.command");
        intent.putExtra("STK CMD", stkCmdMessage);
        this.mContext.sendBroadcast(intent);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleRilMsg(RilMessage rilMessage) {
        CommandParams commandParams;
        block8: {
            block7: {
                if (rilMessage == null) break block7;
                switch (rilMessage.mId) {
                    default: {
                        return;
                    }
                    case 1: {
                        this.handleSessionEnd();
                        return;
                    }
                    case 3: {
                        CommandParams commandParams2;
                        if (rilMessage.mResCode != ResultCode.OK || (commandParams2 = (CommandParams)rilMessage.mData) == null) break;
                        this.handleProactiveCommand(commandParams2);
                        return;
                    }
                    case 2: {
                        CommandParams commandParams3 = (CommandParams)rilMessage.mData;
                        if (commandParams3 == null) break;
                        if (rilMessage.mResCode == ResultCode.OK) {
                            this.handleProactiveCommand(commandParams3);
                            return;
                        }
                        this.sendTerminalResponse(commandParams3.cmdDet, rilMessage.mResCode, false, 0, null);
                        return;
                    }
                    case 5: {
                        commandParams = (CommandParams)rilMessage.mData;
                        if (commandParams != null) break block8;
                    }
                }
            }
            return;
        }
        this.handleProactiveCommand(commandParams);
    }

    private void handleSessionEnd() {
        StkLog.d(this, "SESSION END");
        this.mCurrntCmd = this.mMenuCmd;
        Intent intent = new Intent("android.intent.action.stk.session_end");
        this.mContext.sendBroadcast(intent);
    }

    private boolean removeMenu(Menu menu) {
        try {
            Item item;
            return menu.items.size() == 1 && (item = menu.items.get(0)) == null;
        }
        catch (NullPointerException nullPointerException) {
            StkLog.d(this, "Unable to get Menu's items size");
            return true;
        }
    }

    private void sendMenuSelection(int n, boolean bl) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(211);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0x80 | ComprehensionTlvTag.DEVICE_IDENTITIES.value());
        byteArrayOutputStream.write(2);
        byteArrayOutputStream.write(1);
        byteArrayOutputStream.write(129);
        byteArrayOutputStream.write(0x80 | ComprehensionTlvTag.ITEM_ID.value());
        byteArrayOutputStream.write(1);
        byteArrayOutputStream.write(n);
        if (bl) {
            byteArrayOutputStream.write(ComprehensionTlvTag.HELP_REQUEST.value());
            byteArrayOutputStream.write(0);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byArray[1] = (byte)(byArray.length - 2);
        String string2 = IccUtils.bytesToHexString(byArray);
        this.mCmdIf.sendEnvelope(string2, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void sendTerminalResponse(CommandDetails commandDetails, ResultCode resultCode, boolean bl, int n, ResponseData responseData) {
        if (commandDetails == null) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = ComprehensionTlvTag.COMMAND_DETAILS.value();
        if (commandDetails.compRequired) {
            n2 |= 0x80;
        }
        byteArrayOutputStream.write(n2);
        byteArrayOutputStream.write(3);
        byteArrayOutputStream.write(commandDetails.commandNumber);
        byteArrayOutputStream.write(commandDetails.typeOfCommand);
        byteArrayOutputStream.write(commandDetails.commandQualifier);
        byteArrayOutputStream.write(0x80 | ComprehensionTlvTag.DEVICE_IDENTITIES.value());
        byteArrayOutputStream.write(2);
        byteArrayOutputStream.write(130);
        byteArrayOutputStream.write(129);
        byteArrayOutputStream.write(0x80 | ComprehensionTlvTag.RESULT.value());
        int n3 = bl ? 2 : 1;
        byteArrayOutputStream.write(n3);
        byteArrayOutputStream.write(resultCode.value());
        if (bl) {
            byteArrayOutputStream.write(n);
        }
        if (responseData != null) {
            responseData.format(byteArrayOutputStream);
        }
        String string2 = IccUtils.bytesToHexString(byteArrayOutputStream.toByteArray());
        StkLog.d(this, "TERMINAL RESPONSE: " + string2);
        this.mCmdIf.sendTerminalResponse(string2, null);
    }

    private boolean validateResponse(StkResponseMessage stkResponseMessage) {
        if (this.mCurrntCmd != null) {
            return stkResponseMessage.cmdDet.compareTo(this.mCurrntCmd.mCmdDet);
        }
        return false;
    }

    public void dispose() {
        mSimRecords.unregisterForRecordsLoaded(this);
        this.mCmdIf.unSetOnStkSessionEnd(this);
        this.mCmdIf.unSetOnStkProactiveCmd(this);
        this.mCmdIf.unSetOnStkEvent(this);
        this.mCmdIf.unSetOnStkCallSetUp(this);
        this.removeCallbacksAndMessages(null);
    }

    protected void finalize() {
        StkLog.d(this, "Service finalized");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleMessage(Message message) {
        switch (message.what) {
            default: {
                throw new AssertionError((Object)("Unrecognized STK command: " + message.what));
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                StkLog.d(this, "ril message arrived");
                Object object = message.obj;
                String string2 = null;
                if (object != null) {
                    AsyncResult asyncResult = (AsyncResult)message.obj;
                    string2 = null;
                    if (asyncResult != null) {
                        Object object2 = asyncResult.result;
                        string2 = null;
                        if (object2 != null) {
                            try {
                                string2 = (String)asyncResult.result;
                            }
                            catch (ClassCastException classCastException) {
                                return;
                            }
                        }
                    }
                }
                this.mMsgDecoder.sendStartDecodingMessageParams(new RilMessage(message.what, string2));
            }
            case 20: {
                return;
            }
            case 4: {
                this.mMsgDecoder.sendStartDecodingMessageParams(new RilMessage(message.what, null));
                return;
            }
            case 10: {
                this.handleRilMsg((RilMessage)message.obj);
                return;
            }
            case 6: 
        }
        this.handleCmdResponse((StkResponseMessage)message.obj);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onCmdResponse(StkResponseMessage stkResponseMessage) {
        synchronized (this) {
            if (stkResponseMessage == null) {
                return;
            }
            this.obtainMessage(6, stkResponseMessage).sendToTarget();
            return;
        }
    }
}

