/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm.stk;

import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.gsm.stk.CommandDetails;
import com.android.internal.telephony.gsm.stk.ComprehensionTlv;
import com.android.internal.telephony.gsm.stk.DeviceIdentities;
import com.android.internal.telephony.gsm.stk.Duration;
import com.android.internal.telephony.gsm.stk.FontSize;
import com.android.internal.telephony.gsm.stk.IconId;
import com.android.internal.telephony.gsm.stk.Item;
import com.android.internal.telephony.gsm.stk.ItemsIconId;
import com.android.internal.telephony.gsm.stk.ResultCode;
import com.android.internal.telephony.gsm.stk.ResultException;
import com.android.internal.telephony.gsm.stk.StkLog;
import com.android.internal.telephony.gsm.stk.TextAlignment;
import com.android.internal.telephony.gsm.stk.TextAttribute;
import com.android.internal.telephony.gsm.stk.TextColor;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

abstract class ValueParser {
    ValueParser() {
    }

    static String retrieveAlphaId(ComprehensionTlv comprehensionTlv) throws ResultException {
        byte[] byArray = comprehensionTlv.getRawValue();
        int n = comprehensionTlv.getValueIndex();
        int n2 = comprehensionTlv.getLength();
        if (n2 != 0) {
            try {
                String string2 = IccUtils.adnStringFieldToString(byArray, n, n2);
                return string2;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
            }
        }
        return null;
    }

    static CommandDetails retrieveCommandDetails(ComprehensionTlv comprehensionTlv) throws ResultException {
        CommandDetails commandDetails = new CommandDetails();
        byte[] byArray = comprehensionTlv.getRawValue();
        int n = comprehensionTlv.getValueIndex();
        try {
            commandDetails.compRequired = comprehensionTlv.isComprehensionRequired();
            commandDetails.commandNumber = 0xFF & byArray[n];
            commandDetails.typeOfCommand = 0xFF & byArray[n + 1];
            commandDetails.commandQualifier = 0xFF & byArray[n + 2];
            return commandDetails;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
        }
    }

    static DeviceIdentities retrieveDeviceIdentities(ComprehensionTlv comprehensionTlv) throws ResultException {
        DeviceIdentities deviceIdentities = new DeviceIdentities();
        byte[] byArray = comprehensionTlv.getRawValue();
        int n = comprehensionTlv.getValueIndex();
        try {
            deviceIdentities.sourceId = 0xFF & byArray[n];
            deviceIdentities.destinationId = 0xFF & byArray[n + 1];
            return deviceIdentities;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ResultException(ResultCode.REQUIRED_VALUES_MISSING);
        }
    }

    static Duration retrieveDuration(ComprehensionTlv comprehensionTlv) throws ResultException {
        byte by;
        Duration.TimeUnit timeUnit;
        byte[] byArray = comprehensionTlv.getRawValue();
        int n = comprehensionTlv.getValueIndex();
        try {
            timeUnit = Duration.TimeUnit.values()[0xFF & byArray[n]];
            by = byArray[n + 1];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
        }
        return new Duration(by & 0xFF, timeUnit);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static IconId retrieveIconId(ComprehensionTlv comprehensionTlv) throws ResultException {
        IconId iconId = new IconId();
        byte[] byArray = comprehensionTlv.getRawValue();
        int n = comprehensionTlv.getValueIndex();
        int n2 = n + 1;
        try {
            boolean bl = (0xFF & byArray[n]) == 0;
            iconId.selfExplanatory = bl;
            iconId.recordNumber = 0xFF & byArray[n2];
            return iconId;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Item retrieveItem(ComprehensionTlv comprehensionTlv) throws ResultException {
        byte[] byArray = comprehensionTlv.getRawValue();
        int n = comprehensionTlv.getValueIndex();
        int n2 = comprehensionTlv.getLength();
        Item item = null;
        if (n2 == 0) return item;
        int n3 = n2 - 1;
        try {
            return new Item(0xFF & byArray[n], IccUtils.adnStringFieldToString(byArray, n + 1, n3));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
        }
    }

    static int retrieveItemId(ComprehensionTlv comprehensionTlv) throws ResultException {
        byte[] byArray = comprehensionTlv.getRawValue();
        int n = comprehensionTlv.getValueIndex();
        try {
            byte by = byArray[n];
            return by & 0xFF;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static ItemsIconId retrieveItemsIconId(ComprehensionTlv comprehensionTlv) throws ResultException {
        int n;
        StkLog.d("ValueParser", "retrieveItemsIconId:");
        ItemsIconId itemsIconId = new ItemsIconId();
        byte[] byArray = comprehensionTlv.getRawValue();
        int n2 = comprehensionTlv.getValueIndex();
        int n3 = comprehensionTlv.getLength() - 1;
        itemsIconId.recordNumbers = new int[n3];
        int n4 = n2 + 1;
        try {
            boolean bl = (0xFF & byArray[n2]) == 0;
            itemsIconId.selfExplanatory = bl;
            n = 0;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
        }
        while (n < n3) {
            int[] nArray = itemsIconId.recordNumbers;
            int n5 = n + 1;
            int n6 = n4 + 1;
            try {
                nArray[n] = byArray[n4];
                n = n5;
                n4 = n6;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
            }
        }
        return itemsIconId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static List<TextAttribute> retrieveTextAttribute(ComprehensionTlv comprehensionTlv) throws ResultException {
        ArrayList<TextAttribute> arrayList = new ArrayList<TextAttribute>();
        byte[] byArray = comprehensionTlv.getRawValue();
        int n = comprehensionTlv.getValueIndex();
        int n2 = comprehensionTlv.getLength();
        if (n2 == 0) {
            return null;
        }
        int n3 = n2 / 4;
        int n4 = 0;
        int n5 = n;
        while (true) {
            FontSize fontSize;
            TextAlignment textAlignment;
            int n6;
            int n7;
            int n8;
            int n9;
            if (n4 >= n3) {
                return arrayList;
            }
            try {
                n9 = 0xFF & byArray[n5];
                n8 = 0xFF & byArray[n5 + 1];
                n7 = 0xFF & byArray[n5 + 2];
                n6 = 0xFF & byArray[n5 + 3];
                textAlignment = TextAlignment.fromInt(n7 & 3);
                fontSize = FontSize.fromInt(3 & n7 >> 2);
                if (fontSize == null) {
                    fontSize = FontSize.NORMAL;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                ResultException resultException = new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
                throw resultException;
            }
            boolean bl = (n7 & 0x10) != 0;
            boolean bl2 = (n7 & 0x20) != 0;
            boolean bl3 = (n7 & 0x40) != 0;
            boolean bl4 = (n7 & 0x80) != 0;
            arrayList.add(new TextAttribute(n9, n8, textAlignment, fontSize, bl, bl2, bl3, bl4, TextColor.fromInt(n6)));
            int n10 = n4 + 1;
            int n11 = n5 + 4;
            n4 = n10;
            n5 = n11;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String retrieveTextString(ComprehensionTlv comprehensionTlv) throws ResultException {
        byte by;
        int n;
        int n2;
        byte[] byArray;
        block8: {
            byArray = comprehensionTlv.getRawValue();
            n2 = comprehensionTlv.getValueIndex();
            int n3 = comprehensionTlv.getLength();
            if (n3 == 0) {
                return null;
            }
            n = n3 - 1;
            by = (byte)(0xC & byArray[n2]);
            if (by != 0) break block8;
            return GsmAlphabet.gsm7BitPackedToString(byArray, n2 + 1, n * 8 / 7);
        }
        if (by == 4) {
            return GsmAlphabet.gsm8BitUnpackedToString(byArray, n2 + 1, n);
        }
        if (by != 8) throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
        try {
            return new String(byArray, n2 + 1, n, "UTF-16");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
        }
    }
}

