/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.sip;

import android.net.sip.SipAudioCall;
import android.os.SystemClock;
import android.telephony.PhoneNumberUtils;
import android.util.Log;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.Phone;

abstract class SipConnectionBase
extends Connection {
    private static final String LOG_TAG = "SIP_CONN";
    private long connectTime;
    private long connectTimeReal;
    private long createTime;
    private String dialString;
    private long disconnectTime;
    private long duration = -1L;
    private long holdingStartTime;
    private boolean isIncoming;
    private Connection.DisconnectCause mCause = Connection.DisconnectCause.NOT_DISCONNECTED;
    private SipAudioCall mSipAudioCall;
    private int nextPostDialChar;
    private Connection.PostDialState postDialState = Connection.PostDialState.NOT_STARTED;
    private String postDialString;

    SipConnectionBase(String string2) {
        this.dialString = string2;
        this.postDialString = PhoneNumberUtils.extractPostDialPortion(string2);
        this.isIncoming = false;
        this.createTime = System.currentTimeMillis();
    }

    private void log(String string2) {
        Log.d(LOG_TAG, "[SipConn] " + string2);
    }

    @Override
    public void cancelPostDial() {
    }

    @Override
    public long getConnectTime() {
        return this.connectTime;
    }

    @Override
    public long getCreateTime() {
        return this.createTime;
    }

    @Override
    public Connection.DisconnectCause getDisconnectCause() {
        return this.mCause;
    }

    @Override
    public long getDisconnectTime() {
        return this.disconnectTime;
    }

    @Override
    public long getDurationMillis() {
        if (this.connectTimeReal == 0L) {
            return 0L;
        }
        if (this.duration < 0L) {
            return SystemClock.elapsedRealtime() - this.connectTimeReal;
        }
        return this.duration;
    }

    @Override
    public long getHoldDurationMillis() {
        if (this.getState() != Call.State.HOLDING) {
            return 0L;
        }
        return SystemClock.elapsedRealtime() - this.holdingStartTime;
    }

    @Override
    public int getNumberPresentation() {
        return Connection.PRESENTATION_ALLOWED;
    }

    protected abstract Phone getPhone();

    @Override
    public Connection.PostDialState getPostDialState() {
        return this.postDialState;
    }

    @Override
    public String getRemainingPostDialString() {
        if (this.postDialState == Connection.PostDialState.CANCELLED || this.postDialState == Connection.PostDialState.COMPLETE || this.postDialString == null || this.postDialString.length() <= this.nextPostDialChar) {
            return "";
        }
        return this.postDialString.substring(this.nextPostDialChar);
    }

    @Override
    public void proceedAfterWaitChar() {
    }

    @Override
    public void proceedAfterWildChar(String string2) {
    }

    void setDisconnectCause(Connection.DisconnectCause disconnectCause) {
        this.mCause = disconnectCause;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void setState(Call.State state) {
        switch (1.$SwitchMap$com$android$internal$telephony$Call$State[state.ordinal()]) {
            case 1: {
                if (this.connectTime == 0L) {
                    this.connectTimeReal = SystemClock.elapsedRealtime();
                    this.connectTime = System.currentTimeMillis();
                    return;
                }
            }
            default: {
                return;
            }
            case 2: {
                this.duration = this.getDurationMillis();
                this.disconnectTime = System.currentTimeMillis();
                return;
            }
            case 3: 
        }
        this.holdingStartTime = SystemClock.elapsedRealtime();
    }
}

