/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.sip;

import android.content.Context;
import android.media.AudioManager;
import android.net.rtp.AudioGroup;
import android.net.sip.SipAudioCall;
import android.net.sip.SipErrorCode;
import android.net.sip.SipException;
import android.net.sip.SipManager;
import android.net.sip.SipProfile;
import android.os.AsyncResult;
import android.os.Message;
import android.telephony.PhoneNumberUtils;
import android.telephony.ServiceState;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneNotifier;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.sip.SipCallBase;
import com.android.internal.telephony.sip.SipConnectionBase;
import com.android.internal.telephony.sip.SipPhoneBase;
import java.text.ParseException;
import java.util.Iterator;
import java.util.List;

public class SipPhone
extends SipPhoneBase {
    private static final boolean DEBUG = true;
    private static final String LOG_TAG = "SipPhone";
    private static final int TIMEOUT_ANSWER_CALL = 8;
    private static final int TIMEOUT_HOLD_CALL = 15;
    private static final int TIMEOUT_MAKE_CALL = 15;
    private SipCall backgroundCall;
    private SipCall foregroundCall;
    private SipProfile mProfile;
    private SipManager mSipManager;
    private SipCall ringingCall = new SipCall();

    SipPhone(Context context, PhoneNotifier phoneNotifier, SipProfile sipProfile) {
        super(context, phoneNotifier);
        this.foregroundCall = new SipCall();
        this.backgroundCall = new SipCall();
        Log.d(LOG_TAG, "new SipPhone: " + sipProfile.getUriString());
        this.ringingCall = new SipCall();
        this.foregroundCall = new SipCall();
        this.backgroundCall = new SipCall();
        this.mProfile = sipProfile;
        this.mSipManager = SipManager.newInstance(context);
    }

    private Connection dialInternal(String string2) throws CallStateException {
        this.clearDisconnected();
        if (!this.canDial()) {
            throw new CallStateException("cannot dial in current state");
        }
        if (this.foregroundCall.getState() == Call.State.ACTIVE) {
            this.switchHoldingAndActive();
        }
        if (this.foregroundCall.getState() != Call.State.IDLE) {
            throw new CallStateException("cannot dial in current state");
        }
        this.foregroundCall.setMute(false);
        try {
            Connection connection = this.foregroundCall.dial(string2);
            return connection;
        }
        catch (SipException sipException) {
            Log.e(LOG_TAG, "dial()", sipException);
            throw new CallStateException("dial error: " + sipException);
        }
    }

    private static Call.State getCallStateFrom(SipAudioCall sipAudioCall) {
        if (sipAudioCall.isOnHold()) {
            return Call.State.HOLDING;
        }
        int n = sipAudioCall.getState();
        switch (n) {
            default: {
                Log.w(LOG_TAG, "illegal connection state: " + n);
                return Call.State.DISCONNECTED;
            }
            case 0: {
                return Call.State.IDLE;
            }
            case 3: 
            case 4: {
                return Call.State.INCOMING;
            }
            case 5: {
                return Call.State.DIALING;
            }
            case 6: {
                return Call.State.ALERTING;
            }
            case 7: {
                return Call.State.DISCONNECTING;
            }
            case 8: 
        }
        return Call.State.ACTIVE;
    }

    private String getSipDomain(SipProfile sipProfile) {
        String string2 = sipProfile.getSipDomain();
        if (string2.endsWith(":5060")) {
            return string2.substring(0, string2.length() - 5);
        }
        return string2;
    }

    private String getUriString(SipProfile sipProfile) {
        return sipProfile.getUserName() + "@" + this.getSipDomain(sipProfile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void acceptCall() throws CallStateException {
        synchronized (SipPhone.class) {
            if (this.ringingCall.getState() != Call.State.INCOMING && this.ringingCall.getState() != Call.State.WAITING) {
                throw new CallStateException("phone not ringing");
            }
            Log.d(LOG_TAG, "acceptCall");
            this.ringingCall.setMute(false);
            this.ringingCall.acceptCall();
            return;
        }
    }

    @Override
    public boolean canConference() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canTake(Object object) {
        synchronized (SipPhone.class) {
            block7: {
                block8: {
                    if (!(object instanceof SipAudioCall)) {
                        return false;
                    }
                    if (this.ringingCall.getState().isAlive()) {
                        return false;
                    }
                    if (this.foregroundCall.getState().isAlive() && this.backgroundCall.getState().isAlive()) {
                        return false;
                    }
                    try {
                        SipAudioCall sipAudioCall = (SipAudioCall)object;
                        Log.d(LOG_TAG, "+++ taking call from: " + sipAudioCall.getPeerProfile().getUriString());
                        if (!sipAudioCall.getLocalProfile().getUriString().equals(this.mProfile.getUriString())) break block7;
                        boolean bl = this.foregroundCall.getState().isAlive();
                        this.ringingCall.initIncomingCall(sipAudioCall, bl);
                        if (sipAudioCall.getState() == 3) break block8;
                        Log.d(LOG_TAG, "    call cancelled !!");
                        this.ringingCall.reset();
                    }
                    catch (Exception exception) {
                        this.ringingCall.reset();
                        break block7;
                    }
                }
                return true;
            }
            return false;
        }
    }

    @Override
    public boolean canTransfer() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void clearDisconnected() {
        synchronized (SipPhone.class) {
            this.ringingCall.clearDisconnected();
            this.foregroundCall.clearDisconnected();
            this.backgroundCall.clearDisconnected();
            this.updatePhoneState();
            this.notifyPreciseCallStateChanged();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void conference() throws CallStateException {
        synchronized (SipPhone.class) {
            if (this.foregroundCall.getState() == Call.State.ACTIVE && this.foregroundCall.getState() == Call.State.ACTIVE) {
                this.foregroundCall.merge(this.backgroundCall);
                return;
            }
            throw new CallStateException("wrong state to merge calls: fg=" + (Object)((Object)this.foregroundCall.getState()) + ", bg=" + (Object)((Object)this.backgroundCall.getState()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void conference(Call call) throws CallStateException {
        synchronized (SipPhone.class) {
            if (!(call instanceof SipCall)) {
                throw new CallStateException("expect " + SipCall.class + ", cannot merge with " + call.getClass());
            }
            this.foregroundCall.merge((SipCall)call);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Connection dial(String string2) throws CallStateException {
        synchronized (SipPhone.class) {
            return this.dialInternal(string2);
        }
    }

    @Override
    public Connection dial(String string2, UUSInfo uUSInfo) throws CallStateException {
        return this.dial(string2);
    }

    public boolean equals(SipPhone sipPhone) {
        return this.getSipUri().equals(sipPhone.getSipUri());
    }

    @Override
    public void explicitCallTransfer() throws CallStateException {
    }

    @Override
    public Call getBackgroundCall() {
        return this.backgroundCall;
    }

    @Override
    public void getCallWaiting(Message message) {
        AsyncResult.forMessage(message, null, null);
        message.sendToTarget();
    }

    @Override
    public Call getForegroundCall() {
        return this.foregroundCall;
    }

    @Override
    public boolean getMute() {
        if (this.foregroundCall.getState().isAlive()) {
            return this.foregroundCall.getMute();
        }
        return this.backgroundCall.getMute();
    }

    @Override
    public void getOutgoingCallerIdDisplay(Message message) {
        AsyncResult.forMessage(message, null, null);
        message.sendToTarget();
    }

    @Override
    public String getPhoneName() {
        return "SIP:" + this.getUriString(this.mProfile);
    }

    @Override
    public Call getRingingCall() {
        return this.ringingCall;
    }

    @Override
    public ServiceState getServiceState() {
        return super.getServiceState();
    }

    public String getSipUri() {
        return this.mProfile.getUriString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void rejectCall() throws CallStateException {
        synchronized (SipPhone.class) {
            if (this.ringingCall.getState().isRinging()) {
                Log.d(LOG_TAG, "rejectCall");
                this.ringingCall.rejectCall();
                return;
            }
            throw new CallStateException("phone not ringing");
        }
    }

    public void sendBurstDtmf(String string2) {
        Log.e(LOG_TAG, "[SipPhone] sendBurstDtmf() is a CDMA method");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void sendDtmf(char c) {
        if (!PhoneNumberUtils.is12Key(c)) {
            Log.e(LOG_TAG, "sendDtmf called with invalid character '" + c + "'");
            return;
        } else {
            if (!this.foregroundCall.getState().isAlive()) return;
            synchronized (SipPhone.class) {
                this.foregroundCall.sendDtmf(c);
                return;
            }
        }
    }

    @Override
    public void setCallWaiting(boolean bl, Message message) {
        Log.e(LOG_TAG, "call waiting not supported");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setEchoSuppressionEnabled(boolean bl) {
        synchronized (SipPhone.class) {
            this.foregroundCall.setAudioGroupMode();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setMute(boolean bl) {
        synchronized (SipPhone.class) {
            this.foregroundCall.setMute(bl);
            return;
        }
    }

    @Override
    public void setOutgoingCallerIdDisplay(int n, Message message) {
        AsyncResult.forMessage(message, null, null);
        message.sendToTarget();
    }

    @Override
    public void startDtmf(char c) {
        if (!PhoneNumberUtils.is12Key(c)) {
            Log.e(LOG_TAG, "startDtmf called with invalid character '" + c + "'");
            return;
        }
        this.sendDtmf(c);
    }

    @Override
    public void stopDtmf() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void switchHoldingAndActive() throws CallStateException {
        Log.d(LOG_TAG, " ~~~~~~  switch fg and bg");
        synchronized (SipPhone.class) {
            this.foregroundCall.switchWith(this.backgroundCall);
            if (this.backgroundCall.getState().isAlive()) {
                this.backgroundCall.hold();
            }
            if (this.foregroundCall.getState().isAlive()) {
                this.foregroundCall.unhold();
            }
            return;
        }
    }

    private abstract class SipAudioCallAdapter
    extends SipAudioCall.Listener {
        private SipAudioCallAdapter() {
        }

        @Override
        public void onCallBusy(SipAudioCall sipAudioCall) {
            this.onCallEnded(Connection.DisconnectCause.BUSY);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onCallEnded(SipAudioCall sipAudioCall) {
            Connection.DisconnectCause disconnectCause = sipAudioCall.isInCall() ? Connection.DisconnectCause.NORMAL : Connection.DisconnectCause.INCOMING_MISSED;
            this.onCallEnded(disconnectCause);
        }

        protected abstract void onCallEnded(Connection.DisconnectCause var1);

        @Override
        public void onError(SipAudioCall sipAudioCall, int n, String string2) {
            switch (n) {
                default: {
                    Log.w(SipPhone.LOG_TAG, "error: " + SipErrorCode.toString(n) + ": " + string2);
                    this.onError(Connection.DisconnectCause.ERROR_UNSPECIFIED);
                    return;
                }
                case -12: {
                    this.onError(Connection.DisconnectCause.SERVER_UNREACHABLE);
                    return;
                }
                case -7: {
                    this.onError(Connection.DisconnectCause.NUMBER_UNREACHABLE);
                    return;
                }
                case -6: {
                    this.onError(Connection.DisconnectCause.INVALID_NUMBER);
                    return;
                }
                case -5: 
                case -3: {
                    this.onError(Connection.DisconnectCause.TIMED_OUT);
                    return;
                }
                case -10: {
                    this.onError(Connection.DisconnectCause.LOST_SIGNAL);
                    return;
                }
                case -8: {
                    this.onError(Connection.DisconnectCause.INVALID_CREDENTIALS);
                    return;
                }
                case -11: {
                    this.onError(Connection.DisconnectCause.OUT_OF_NETWORK);
                    return;
                }
                case -2: 
            }
            this.onError(Connection.DisconnectCause.SERVER_ERROR);
        }

        protected abstract void onError(Connection.DisconnectCause var1);
    }

    private class SipCall
    extends SipCallBase {
        private SipCall() {
        }

        private void add(SipConnection sipConnection) {
            Call call = sipConnection.getCall();
            if (call == this) {
                return;
            }
            if (call != null) {
                ((SipCall)call).connections.remove(sipConnection);
            }
            this.connections.add(sipConnection);
            sipConnection.changeOwner(this);
        }

        private int convertDtmf(char c) {
            int n = c - 48;
            if (n < 0 || n > 9) {
                switch (c) {
                    default: {
                        throw new IllegalArgumentException("invalid DTMF char: " + c);
                    }
                    case '*': {
                        return 10;
                    }
                    case '#': {
                        return 11;
                    }
                    case 'A': {
                        return 12;
                    }
                    case 'B': {
                        return 13;
                    }
                    case 'C': {
                        return 14;
                    }
                    case 'D': 
                }
                return 15;
            }
            return n;
        }

        private AudioGroup getAudioGroup() {
            if (this.connections.isEmpty()) {
                return null;
            }
            return ((SipConnection)this.connections.get(0)).getAudioGroup();
        }

        private boolean isSpeakerOn() {
            return ((AudioManager)SipPhone.this.mContext.getSystemService("audio")).isSpeakerphoneOn();
        }

        private void takeOver(SipCall sipCall) {
            this.connections = sipCall.connections;
            this.state = sipCall.state;
            Iterator iterator = this.connections.iterator();
            while (iterator.hasNext()) {
                ((SipConnection)((Connection)iterator.next())).changeOwner(this);
            }
        }

        void acceptCall() throws CallStateException {
            if (this != SipPhone.this.ringingCall) {
                throw new CallStateException("acceptCall() in a non-ringing call");
            }
            if (this.connections.size() != 1) {
                throw new CallStateException("acceptCall() in a conf call");
            }
            ((SipConnection)this.connections.get(0)).acceptCall();
        }

        Connection dial(String string2) throws SipException {
            String string3 = string2;
            if (!string3.contains("@")) {
                string3 = SipPhone.this.mProfile.getUriString().replaceFirst(SipPhone.this.mProfile.getUserName() + "@", string3 + "@");
            }
            try {
                SipProfile sipProfile = new SipProfile.Builder(string3).build();
                SipConnection sipConnection = new SipConnection(this, sipProfile, string2);
                sipConnection.dial();
                this.connections.add(sipConnection);
                this.setState(Call.State.DIALING);
                return sipConnection;
            }
            catch (ParseException parseException) {
                throw new SipException("dial", parseException);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public List<Connection> getConnections() {
            synchronized (SipPhone.class) {
                return this.connections;
            }
        }

        boolean getMute() {
            if (this.connections.isEmpty()) {
                return false;
            }
            return ((SipConnection)this.connections.get(0)).getMute();
        }

        @Override
        public Phone getPhone() {
            return SipPhone.this;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void hangup() throws CallStateException {
            synchronized (SipPhone.class) {
                if (!this.state.isAlive()) {
                    Log.d("Call", "hang up dead call: " + (Object)((Object)this.getState()) + ": " + this + " on phone " + this.getPhone());
                } else {
                    Log.d("Call", "hang up call: " + (Object)((Object)this.getState()) + ": " + this + " on phone " + this.getPhone());
                    this.setState(Call.State.DISCONNECTING);
                    CallStateException callStateException = null;
                    for (Connection connection : this.connections) {
                        try {
                            connection.hangup();
                        }
                        catch (CallStateException callStateException2) {
                            callStateException = callStateException2;
                        }
                    }
                    if (callStateException != null) {
                        throw callStateException;
                    }
                }
                return;
            }
        }

        void hold() throws CallStateException {
            this.setState(Call.State.HOLDING);
            Iterator iterator = this.connections.iterator();
            while (iterator.hasNext()) {
                ((SipConnection)((Connection)iterator.next())).hold();
            }
            this.setAudioGroupMode();
        }

        /*
         * Enabled aggressive block sorting
         */
        void initIncomingCall(SipAudioCall sipAudioCall, boolean bl) {
            SipProfile sipProfile = sipAudioCall.getPeerProfile();
            SipConnection sipConnection = new SipConnection(this, sipProfile);
            this.connections.add(sipConnection);
            Call.State state = bl ? Call.State.WAITING : Call.State.INCOMING;
            sipConnection.initIncomingCall(sipAudioCall, state);
            this.setState(state);
            SipPhone.this.notifyNewRingingConnectionP(sipConnection);
        }

        void merge(SipCall sipCall) throws CallStateException {
            AudioGroup audioGroup = this.getAudioGroup();
            Connection[] connectionArray = sipCall.connections.toArray(new Connection[sipCall.connections.size()]);
            int n = connectionArray.length;
            for (int i = 0; i < n; ++i) {
                SipConnection sipConnection = (SipConnection)connectionArray[i];
                this.add(sipConnection);
                if (sipConnection.getState() != Call.State.HOLDING) continue;
                sipConnection.unhold(audioGroup);
            }
            sipCall.setState(Call.State.IDLE);
        }

        void onConnectionEnded(SipConnection sipConnection) {
            if (this.state != Call.State.DISCONNECTED) {
                boolean bl = true;
                Log.d("Call", "---check connections: " + this.connections.size());
                for (Connection connection : this.connections) {
                    Log.d("Call", "   state=" + (Object)((Object)connection.getState()) + ": " + connection);
                    if (connection.getState() == Call.State.DISCONNECTED) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    this.setState(Call.State.DISCONNECTED);
                }
            }
            SipPhone.this.notifyDisconnectP(sipConnection);
        }

        void onConnectionStateChanged(SipConnection sipConnection) {
            if (this.state != Call.State.ACTIVE) {
                this.setState(sipConnection.getState());
            }
        }

        void rejectCall() throws CallStateException {
            this.hangup();
        }

        void reset() {
            this.connections.clear();
            this.setState(Call.State.IDLE);
        }

        void sendDtmf(char c) {
            AudioGroup audioGroup = this.getAudioGroup();
            if (audioGroup == null) {
                return;
            }
            audioGroup.sendDtmf(this.convertDtmf(c));
        }

        /*
         * Enabled aggressive block sorting
         */
        void setAudioGroupMode() {
            AudioGroup audioGroup = this.getAudioGroup();
            if (audioGroup == null) {
                return;
            }
            int n = audioGroup.getMode();
            if (this.state == Call.State.HOLDING) {
                audioGroup.setMode(0);
            } else if (this.getMute()) {
                audioGroup.setMode(1);
            } else if (this.isSpeakerOn()) {
                audioGroup.setMode(3);
            } else {
                audioGroup.setMode(2);
            }
            Object[] objectArray = new Object[]{n, audioGroup.getMode()};
            Log.d("Call", String.format("audioGroup mode change: %d --> %d", objectArray));
        }

        void setMute(boolean bl) {
            Iterator iterator = this.connections.iterator();
            while (iterator.hasNext()) {
                ((SipConnection)((Connection)iterator.next())).setMute(bl);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected void setState(Call.State state) {
            if (this.state != state) {
                Log.v("Call", "+***+ call state changed: " + (Object)((Object)this.state) + " --> " + (Object)((Object)state) + ": " + this + ": on phone " + this.getPhone() + " " + this.connections.size());
                if (state == Call.State.ALERTING) {
                    this.state = state;
                    SipPhone.this.startRingbackTone();
                } else if (this.state == Call.State.ALERTING) {
                    SipPhone.this.stopRingbackTone();
                }
                this.state = state;
                SipPhone.this.updatePhoneState();
                SipPhone.this.notifyPreciseCallStateChanged();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void switchWith(SipCall sipCall) {
            synchronized (SipPhone.class) {
                SipCall sipCall2 = new SipCall();
                sipCall2.takeOver(this);
                this.takeOver(sipCall);
                sipCall.takeOver(sipCall2);
                return;
            }
        }

        void unhold() throws CallStateException {
            this.setState(Call.State.ACTIVE);
            AudioGroup audioGroup = new AudioGroup();
            Iterator iterator = this.connections.iterator();
            while (iterator.hasNext()) {
                ((SipConnection)((Connection)iterator.next())).unhold(audioGroup);
            }
            this.setAudioGroupMode();
        }
    }

    private class SipConnection
    extends SipConnectionBase {
        private SipAudioCallAdapter mAdapter;
        private boolean mIncoming;
        private String mOriginalNumber;
        private SipCall mOwner;
        private SipProfile mPeer;
        private SipAudioCall mSipAudioCall;
        private Call.State mState;

        public SipConnection(SipCall sipCall, SipProfile sipProfile) {
            this(sipCall, sipProfile, sipPhone.getUriString(sipProfile));
        }

        public SipConnection(SipCall sipCall, SipProfile sipProfile, String string2) {
            super(string2);
            this.mState = Call.State.IDLE;
            this.mIncoming = false;
            this.mAdapter = new SipAudioCallAdapter(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                protected void onCallEnded(Connection.DisconnectCause disconnectCause) {
                    if (SipConnection.this.getDisconnectCause() != Connection.DisconnectCause.LOCAL) {
                        SipConnection.this.setDisconnectCause(disconnectCause);
                    }
                    synchronized (SipPhone.class) {
                        SipConnection.this.setState(Call.State.DISCONNECTED);
                        SipAudioCall sipAudioCall = SipConnection.this.mSipAudioCall;
                        SipConnection.access$702(SipConnection.this, null);
                        String string2 = sipAudioCall == null ? "" : sipAudioCall.getState() + ", ";
                        Log.d(SipPhone.LOG_TAG, "--- connection ended: " + SipConnection.this.mPeer.getUriString() + ": " + string2 + "cause: " + (Object)((Object)SipConnection.this.getDisconnectCause()) + ", on phone " + SipConnection.this.getPhone());
                        if (sipAudioCall != null) {
                            sipAudioCall.setListener(null);
                            sipAudioCall.close();
                        }
                        SipConnection.this.mOwner.onConnectionEnded(SipConnection.this);
                        return;
                    }
                }

                @Override
                public void onCallEstablished(SipAudioCall sipAudioCall) {
                    this.onChanged(sipAudioCall);
                    if (SipConnection.this.mState == Call.State.ACTIVE) {
                        sipAudioCall.startAudio();
                    }
                }

                @Override
                public void onCallHeld(SipAudioCall sipAudioCall) {
                    this.onChanged(sipAudioCall);
                    if (SipConnection.this.mState == Call.State.HOLDING) {
                        sipAudioCall.startAudio();
                    }
                }

                /*
                 * Loose catch block
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void onChanged(SipAudioCall sipAudioCall) {
                    synchronized (SipPhone.class) {
                        Call.State state = SipPhone.getCallStateFrom(sipAudioCall);
                        if (SipConnection.this.mState == state) {
                            return;
                        }
                        if (state == Call.State.INCOMING) {
                            SipConnection.this.setState(SipConnection.this.mOwner.getState());
                        } else {
                            if (SipConnection.this.mOwner == SipPhone.this.ringingCall) {
                                Call.State state2;
                                Call.State state3 = SipPhone.this.ringingCall.getState();
                                if (state3 == (state2 = Call.State.WAITING)) {
                                    SipPhone.this.switchHoldingAndActive();
                                }
                                SipPhone.this.foregroundCall.switchWith(SipPhone.this.ringingCall);
                            }
                            SipConnection.this.setState(state);
                        }
                        SipConnection.this.mOwner.onConnectionStateChanged(SipConnection.this);
                        Log.v(SipPhone.LOG_TAG, "+***+ connection state changed: " + SipConnection.this.mPeer.getUriString() + ": " + (Object)((Object)SipConnection.this.mState) + " on phone " + SipConnection.this.getPhone());
                        return;
                        catch (CallStateException callStateException) {
                            this.onCallEnded(Connection.DisconnectCause.LOCAL);
                            return;
                        }
                    }
                }

                @Override
                protected void onError(Connection.DisconnectCause disconnectCause) {
                    Log.d(SipPhone.LOG_TAG, "SIP error: " + (Object)((Object)disconnectCause));
                    this.onCallEnded(disconnectCause);
                }
            };
            this.mOwner = sipCall;
            this.mPeer = sipProfile;
            this.mOriginalNumber = string2;
        }

        static /* synthetic */ SipAudioCall access$702(SipConnection sipConnection, SipAudioCall sipAudioCall) {
            sipConnection.mSipAudioCall = sipAudioCall;
            return sipAudioCall;
        }

        void acceptCall() throws CallStateException {
            try {
                this.mSipAudioCall.answerCall(8);
                return;
            }
            catch (SipException sipException) {
                throw new CallStateException("acceptCall(): " + sipException);
            }
        }

        void changeOwner(SipCall sipCall) {
            this.mOwner = sipCall;
        }

        void dial() throws SipException {
            this.setState(Call.State.DIALING);
            this.mSipAudioCall = SipPhone.this.mSipManager.makeAudioCall(SipPhone.this.mProfile, this.mPeer, null, 15);
            this.mSipAudioCall.setListener(this.mAdapter);
        }

        @Override
        public String getAddress() {
            return this.mOriginalNumber;
        }

        AudioGroup getAudioGroup() {
            if (this.mSipAudioCall == null) {
                return null;
            }
            return this.mSipAudioCall.getAudioGroup();
        }

        @Override
        public SipCall getCall() {
            return this.mOwner;
        }

        @Override
        public String getCnapName() {
            String string2 = this.mPeer.getDisplayName();
            if (TextUtils.isEmpty(string2)) {
                return null;
            }
            return string2;
        }

        boolean getMute() {
            if (this.mSipAudioCall == null) {
                return false;
            }
            return this.mSipAudioCall.isMuted();
        }

        @Override
        public int getNumberPresentation() {
            return Connection.PRESENTATION_ALLOWED;
        }

        @Override
        protected Phone getPhone() {
            return this.mOwner.getPhone();
        }

        @Override
        public Call.State getState() {
            return this.mState;
        }

        @Override
        public UUSInfo getUUSInfo() {
            return null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void hangup() throws CallStateException {
            synchronized (SipPhone.class) {
                Connection.DisconnectCause disconnectCause;
                SipAudioCallAdapter sipAudioCallAdapter;
                Log.d(SipPhone.LOG_TAG, "hangup conn: " + this.mPeer.getUriString() + ": " + (Object)((Object)this.mState) + ": on phone " + this.getPhone().getPhoneName());
                if (!this.mState.isAlive()) {
                    return;
                }
                try {
                    SipAudioCall sipAudioCall = this.mSipAudioCall;
                    if (sipAudioCall != null) {
                        sipAudioCall.setListener(null);
                        sipAudioCall.endCall();
                    }
                    sipAudioCallAdapter = this.mAdapter;
                    disconnectCause = this.mState == Call.State.INCOMING || this.mState == Call.State.WAITING ? Connection.DisconnectCause.INCOMING_REJECTED : Connection.DisconnectCause.LOCAL;
                }
                catch (SipException sipException) {
                    try {
                        throw new CallStateException("hangup(): " + sipException);
                    }
                    catch (Throwable throwable) {
                        SipAudioCallAdapter sipAudioCallAdapter2 = this.mAdapter;
                        Connection.DisconnectCause disconnectCause2 = this.mState == Call.State.INCOMING || this.mState == Call.State.WAITING ? Connection.DisconnectCause.INCOMING_REJECTED : Connection.DisconnectCause.LOCAL;
                        sipAudioCallAdapter2.onCallEnded(disconnectCause2);
                        throw throwable;
                    }
                }
                sipAudioCallAdapter.onCallEnded(disconnectCause);
                return;
            }
        }

        void hold() throws CallStateException {
            this.setState(Call.State.HOLDING);
            try {
                this.mSipAudioCall.holdCall(15);
                return;
            }
            catch (SipException sipException) {
                throw new CallStateException("hold(): " + sipException);
            }
        }

        void initIncomingCall(SipAudioCall sipAudioCall, Call.State state) {
            this.setState(state);
            this.mSipAudioCall = sipAudioCall;
            sipAudioCall.setListener(this.mAdapter);
            this.mIncoming = true;
        }

        @Override
        public boolean isIncoming() {
            return this.mIncoming;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void separate() throws CallStateException {
            synchronized (SipPhone.class) {
                SipCall sipCall = this.getPhone() == SipPhone.this ? (SipCall)SipPhone.this.getBackgroundCall() : (SipCall)SipPhone.this.getForegroundCall();
                if (sipCall.getState() != Call.State.IDLE) {
                    throw new CallStateException("cannot put conn back to a call in non-idle state: " + (Object)((Object)sipCall.getState()));
                }
                Log.d(SipPhone.LOG_TAG, "separate conn: " + this.mPeer.getUriString() + " from " + this.mOwner + " back to " + sipCall);
                Phone phone = this.getPhone();
                AudioGroup audioGroup = sipCall.getAudioGroup();
                sipCall.add(this);
                this.mSipAudioCall.setAudioGroup(audioGroup);
                phone.switchHoldingAndActive();
                SipCall sipCall2 = (SipCall)SipPhone.this.getForegroundCall();
                this.mSipAudioCall.startAudio();
                sipCall2.onConnectionStateChanged(this);
                return;
            }
        }

        void setMute(boolean bl) {
            if (this.mSipAudioCall != null && bl != this.mSipAudioCall.isMuted()) {
                this.mSipAudioCall.toggleMute();
            }
        }

        @Override
        protected void setState(Call.State state) {
            if (state == this.mState) {
                return;
            }
            super.setState(state);
            this.mState = state;
        }

        void unhold(AudioGroup audioGroup) throws CallStateException {
            this.mSipAudioCall.setAudioGroup(audioGroup);
            this.setState(Call.State.ACTIVE);
            try {
                this.mSipAudioCall.continueCall(15);
                return;
            }
            catch (SipException sipException) {
                throw new CallStateException("unhold(): " + sipException);
            }
        }
    }
}

