/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.sip;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemProperties;
import android.telephony.CellLocation;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.util.Log;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DataConnection;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.IccFileHandler;
import com.android.internal.telephony.IccPhoneBookInterfaceManager;
import com.android.internal.telephony.IccSmsInterfaceManager;
import com.android.internal.telephony.MmiCode;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.PhoneNotifier;
import com.android.internal.telephony.PhoneSubInfo;
import com.android.internal.telephony.gsm.NetworkInfo;
import com.android.internal.telephony.sip.SipCommandInterface;
import java.util.ArrayList;
import java.util.List;

abstract class SipPhoneBase
extends PhoneBase {
    private static final String LOG_TAG = "SipPhone";
    private RegistrantList mRingbackRegistrants = new RegistrantList();
    private Phone.State state = Phone.State.IDLE;

    public SipPhoneBase(Context context, PhoneNotifier phoneNotifier) {
        super(phoneNotifier, context, new SipCommandInterface(context), false);
    }

    static void migrate(RegistrantList registrantList, RegistrantList registrantList2) {
        registrantList2.removeCleared();
        int n = registrantList2.size();
        for (int i = 0; i < n; ++i) {
            registrantList.add((Registrant)registrantList2.get(i));
        }
    }

    @Override
    public void activateCellBroadcastSms(int n, Message message) {
        Log.e(LOG_TAG, "Error! This functionality is not implemented for SIP.");
    }

    public boolean canDial() {
        int n = this.getServiceState().getState();
        Log.v(LOG_TAG, "canDial(): serviceState = " + n);
        if (n == 3) {
            return false;
        }
        String string2 = SystemProperties.get("ro.telephony.disable-call", "false");
        Log.v(LOG_TAG, "canDial(): disableCall = " + string2);
        if (string2.equals("true")) {
            return false;
        }
        Log.v(LOG_TAG, "canDial(): ringingCall: " + (Object)((Object)this.getRingingCall().getState()));
        Log.v(LOG_TAG, "canDial(): foregndCall: " + (Object)((Object)this.getForegroundCall().getState()));
        Log.v(LOG_TAG, "canDial(): backgndCall: " + (Object)((Object)this.getBackgroundCall().getState()));
        return !this.getRingingCall().isRinging() && (!this.getForegroundCall().getState().isAlive() || !this.getBackgroundCall().getState().isAlive());
    }

    @Override
    public boolean disableDataConnectivity() {
        return false;
    }

    @Override
    public void disableLocationUpdates() {
    }

    @Override
    public boolean enableDataConnectivity() {
        return false;
    }

    @Override
    public void enableLocationUpdates() {
    }

    @Override
    public void getAvailableNetworks(Message message) {
    }

    @Override
    public abstract Call getBackgroundCall();

    @Override
    public boolean getCallForwardingIndicator() {
        return false;
    }

    @Override
    public void getCallForwardingOption(int n, Message message) {
    }

    @Override
    public void getCallWaiting(Message message) {
        AsyncResult.forMessage(message, null, null);
        message.sendToTarget();
    }

    @Override
    public void getCellBroadcastSmsConfig(Message message) {
        Log.e(LOG_TAG, "Error! This functionality is not implemented for SIP.");
    }

    @Override
    public CellLocation getCellLocation() {
        return null;
    }

    @Override
    public List<DataConnection> getCurrentDataConnectionList() {
        return null;
    }

    @Override
    public Phone.DataActivityState getDataActivityState() {
        return Phone.DataActivityState.NONE;
    }

    @Override
    public void getDataCallList(Message message) {
    }

    @Override
    public Phone.DataState getDataConnectionState() {
        return Phone.DataState.DISCONNECTED;
    }

    public Phone.DataState getDataConnectionState(String string2) {
        return Phone.DataState.DISCONNECTED;
    }

    @Override
    public boolean getDataRoamingEnabled() {
        return false;
    }

    @Override
    public String getDeviceId() {
        return null;
    }

    @Override
    public String getDeviceSvn() {
        return null;
    }

    @Override
    public String getEsn() {
        Log.e(LOG_TAG, "[SipPhone] getEsn() is a CDMA method");
        return "0";
    }

    @Override
    public abstract Call getForegroundCall();

    @Override
    public IccCard getIccCard() {
        return null;
    }

    @Override
    public IccFileHandler getIccFileHandler() {
        return null;
    }

    @Override
    public IccPhoneBookInterfaceManager getIccPhoneBookInterfaceManager() {
        return null;
    }

    @Override
    public boolean getIccRecordsLoaded() {
        return false;
    }

    @Override
    public String getIccSerialNumber() {
        return null;
    }

    @Override
    public IccSmsInterfaceManager getIccSmsInterfaceManager() {
        return null;
    }

    @Override
    public String getLine1AlphaTag() {
        return null;
    }

    @Override
    public String getLine1Number() {
        return null;
    }

    @Override
    public String getMeid() {
        Log.e(LOG_TAG, "[SipPhone] getMeid() is a CDMA method");
        return "0";
    }

    @Override
    public boolean getMessageWaitingIndicator() {
        return false;
    }

    @Override
    public void getNeighboringCids(Message message) {
    }

    @Override
    public void getOutgoingCallerIdDisplay(Message message) {
        AsyncResult.forMessage(message, null, null);
        message.sendToTarget();
    }

    @Override
    public List<? extends MmiCode> getPendingMmiCodes() {
        return new ArrayList(0);
    }

    @Override
    public PhoneSubInfo getPhoneSubInfo() {
        return null;
    }

    @Override
    public int getPhoneType() {
        return 3;
    }

    @Override
    public abstract Call getRingingCall();

    @Override
    public ServiceState getServiceState() {
        ServiceState serviceState = new ServiceState();
        serviceState.setState(0);
        return serviceState;
    }

    @Override
    public SignalStrength getSignalStrength() {
        return new SignalStrength();
    }

    @Override
    public Phone.State getState() {
        return this.state;
    }

    @Override
    public String getSubscriberId() {
        return null;
    }

    @Override
    public String getVoiceMailAlphaTag() {
        return null;
    }

    @Override
    public String getVoiceMailNumber() {
        return null;
    }

    @Override
    public boolean handleInCallMmiCommands(String string2) throws CallStateException {
        return false;
    }

    @Override
    public boolean handlePinMmi(String string2) {
        return false;
    }

    @Override
    public boolean isDataConnectivityPossible() {
        return false;
    }

    boolean isInCall() {
        Call.State state = this.getForegroundCall().getState();
        Call.State state2 = this.getBackgroundCall().getState();
        Call.State state3 = this.getRingingCall().getState();
        return state.isAlive() || state2.isAlive() || state3.isAlive();
    }

    void migrateFrom(SipPhoneBase sipPhoneBase) {
        SipPhoneBase.migrate(this.mRingbackRegistrants, sipPhoneBase.mRingbackRegistrants);
        SipPhoneBase.migrate(this.mPreciseCallStateRegistrants, sipPhoneBase.mPreciseCallStateRegistrants);
        SipPhoneBase.migrate(this.mNewRingingConnectionRegistrants, sipPhoneBase.mNewRingingConnectionRegistrants);
        SipPhoneBase.migrate(this.mIncomingRingRegistrants, sipPhoneBase.mIncomingRingRegistrants);
        SipPhoneBase.migrate(this.mDisconnectRegistrants, sipPhoneBase.mDisconnectRegistrants);
        SipPhoneBase.migrate(this.mServiceStateRegistrants, sipPhoneBase.mServiceStateRegistrants);
        SipPhoneBase.migrate(this.mMmiCompleteRegistrants, sipPhoneBase.mMmiCompleteRegistrants);
        SipPhoneBase.migrate(this.mMmiRegistrants, sipPhoneBase.mMmiRegistrants);
        SipPhoneBase.migrate(this.mUnknownConnectionRegistrants, sipPhoneBase.mUnknownConnectionRegistrants);
        SipPhoneBase.migrate(this.mSuppServiceFailedRegistrants, sipPhoneBase.mSuppServiceFailedRegistrants);
    }

    public void notifyCallForwardingIndicator() {
        this.mNotifier.notifyCallForwardingChanged(this);
    }

    void notifyDisconnect(Connection connection) {
        this.mDisconnectRegistrants.notifyResult(connection);
    }

    void notifyNewRingingConnection(Connection connection) {
        super.notifyNewRingingConnectionP(connection);
    }

    void notifyPhoneStateChanged() {
        this.mNotifier.notifyPhoneState(this);
    }

    void notifyPreciseCallStateChanged() {
        super.notifyPreciseCallStateChangedP();
    }

    void notifyServiceStateChanged(ServiceState serviceState) {
        super.notifyServiceStateChangedP(serviceState);
    }

    void notifySuppServiceFailed(Phone.SuppService suppService) {
        this.mSuppServiceFailedRegistrants.notifyResult((Object)suppService);
    }

    void notifyUnknownConnection() {
        this.mUnknownConnectionRegistrants.notifyResult(this);
    }

    @Override
    public void registerForRingbackTone(Handler handler, int n, Object object) {
        this.mRingbackRegistrants.addUnique(handler, n, object);
    }

    @Override
    public void registerForSuppServiceNotification(Handler handler, int n, Object object) {
    }

    public void saveClirSetting(int n) {
    }

    @Override
    public void selectNetworkManually(NetworkInfo networkInfo, Message message) {
    }

    @Override
    public void sendUssdResponse(String string2) {
    }

    @Override
    public void setCallForwardingOption(int n, int n2, String string2, int n3, Message message) {
    }

    @Override
    public void setCallWaiting(boolean bl, Message message) {
        Log.e(LOG_TAG, "call waiting not supported");
    }

    @Override
    public void setCellBroadcastSmsConfig(int[] nArray, Message message) {
        Log.e(LOG_TAG, "Error! This functionality is not implemented for SIP.");
    }

    @Override
    public void setDataRoamingEnabled(boolean bl) {
    }

    @Override
    public void setLine1Number(String string2, String string3, Message message) {
        AsyncResult.forMessage(message, null, null);
        message.sendToTarget();
    }

    @Override
    public void setNetworkSelectionModeAutomatic(Message message) {
    }

    @Override
    public void setOnPostDialCharacter(Handler handler, int n, Object object) {
    }

    @Override
    public void setOutgoingCallerIdDisplay(int n, Message message) {
        AsyncResult.forMessage(message, null, null);
        message.sendToTarget();
    }

    @Override
    public void setRadioPower(boolean bl) {
    }

    @Override
    public void setVoiceMailNumber(String string2, String string3, Message message) {
        AsyncResult.forMessage(message, null, null);
        message.sendToTarget();
    }

    protected void startRingbackTone() {
        AsyncResult asyncResult = new AsyncResult(null, new Boolean(true), null);
        this.mRingbackRegistrants.notifyRegistrants(asyncResult);
    }

    protected void stopRingbackTone() {
        AsyncResult asyncResult = new AsyncResult(null, new Boolean(false), null);
        this.mRingbackRegistrants.notifyRegistrants(asyncResult);
    }

    @Override
    public void unregisterForRingbackTone(Handler handler) {
        this.mRingbackRegistrants.remove(handler);
    }

    @Override
    public void unregisterForSuppServiceNotification(Handler handler) {
    }

    boolean updateCurrentCarrierInProvider() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    void updatePhoneState() {
        Phone.State state = this.state;
        this.state = this.getRingingCall().isRinging() ? Phone.State.RINGING : (this.getForegroundCall().isIdle() && this.getBackgroundCall().isIdle() ? Phone.State.IDLE : Phone.State.OFFHOOK);
        if (this.state != state) {
            Log.d(LOG_TAG, " ^^^ new phone state: " + (Object)((Object)this.state));
            this.notifyPhoneStateChanged();
        }
    }

    @Override
    public void updateServiceLocation() {
    }
}

