/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.test;

import com.android.internal.telephony.ATParseEx;
import com.android.internal.telephony.DriverCall;

class CallInfo {
    int TOA;
    boolean isMT;
    boolean isMpty;
    String number;
    State state;

    CallInfo(boolean bl, State state, boolean bl2, String string2) {
        this.isMT = bl;
        this.state = state;
        this.isMpty = bl2;
        this.number = string2;
        if (string2.length() > 0 && string2.charAt(0) == '+') {
            this.TOA = 145;
            return;
        }
        this.TOA = 129;
    }

    static CallInfo createIncomingCall(String string2) {
        return new CallInfo(true, State.INCOMING, false, string2);
    }

    static CallInfo createOutgoingCall(String string2) {
        return new CallInfo(false, State.DIALING, false, string2);
    }

    boolean isActiveOrHeld() {
        return this.state == State.ACTIVE || this.state == State.HOLDING;
    }

    boolean isConnecting() {
        return this.state == State.DIALING || this.state == State.ALERTING;
    }

    boolean isRinging() {
        return this.state == State.INCOMING || this.state == State.WAITING;
    }

    /*
     * Enabled aggressive block sorting
     */
    String toCLCCLine(int n) {
        String string2;
        StringBuilder stringBuilder = new StringBuilder().append("+CLCC: ").append(n).append(",");
        String string3 = this.isMT ? "1" : "0";
        StringBuilder stringBuilder2 = stringBuilder.append(string3).append(",").append(this.state.value()).append(",0,");
        if (this.isMpty) {
            string2 = "1";
            return stringBuilder2.append(string2).append(",\"").append(this.number).append("\",").append(this.TOA).toString();
        }
        string2 = "0";
        return stringBuilder2.append(string2).append(",\"").append(this.number).append("\",").append(this.TOA).toString();
    }

    DriverCall toDriverCall(int n) {
        DriverCall driverCall = new DriverCall();
        driverCall.index = n;
        driverCall.isMT = this.isMT;
        try {
            driverCall.state = DriverCall.stateFromCLCC(this.state.value());
        }
        catch (ATParseEx aTParseEx) {
            throw new RuntimeException("should never happen", aTParseEx);
        }
        driverCall.isMpty = this.isMpty;
        driverCall.number = this.number;
        driverCall.TOA = this.TOA;
        driverCall.isVoice = true;
        driverCall.als = 0;
        return driverCall;
    }

    static final class State
    extends Enum<State> {
        private static final /* synthetic */ State[] $VALUES;
        public static final /* enum */ State ACTIVE = new State(0);
        public static final /* enum */ State ALERTING;
        public static final /* enum */ State DIALING;
        public static final /* enum */ State HOLDING;
        public static final /* enum */ State INCOMING;
        public static final /* enum */ State WAITING;
        private final int value;

        static {
            HOLDING = new State(1);
            DIALING = new State(2);
            ALERTING = new State(3);
            INCOMING = new State(4);
            WAITING = new State(5);
            State[] stateArray = new State[]{ACTIVE, HOLDING, DIALING, ALERTING, INCOMING, WAITING};
            $VALUES = stateArray;
        }

        private State(int n2) {
            this.value = n2;
        }

        public static State valueOf(String string2) {
            return Enum.valueOf(State.class, string2);
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public int value() {
            return this.value;
        }
    }
}

