/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.test;

import android.os.HandlerThread;
import android.os.Looper;
import android.util.Log;
import com.android.internal.telephony.test.InterpreterEx;
import com.android.internal.telephony.test.LineReader;
import com.android.internal.telephony.test.SimulatedGsmCallState;
import com.android.internal.telephony.test.SimulatedRadioControl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;

public class ModelInterpreter
implements Runnable,
SimulatedRadioControl {
    static final int CONNECTING_PAUSE_MSEC = 500;
    static final String LOG_TAG = "ModelInterpreter";
    static final int MAX_CALLS = 6;
    static final int PROGRESS_CALL_STATE = 1;
    static final String[][] sDefaultResponses = new String[][]{{"E0Q0V1", null}, {"+CMEE=2", null}, {"+CREG=2", null}, {"+CGREG=2", null}, {"+CCWA=1", null}, {"+COPS=0", null}, {"+CFUN=1", null}, {"+CGMI", "+CGMI: Android Model AT Interpreter\r"}, {"+CGMM", "+CGMM: Android Model AT Interpreter\r"}, {"+CGMR", "+CGMR: 1.0\r"}, {"+CGSN", "000000000000000\r"}, {"+CIMI", "320720000000000\r"}, {"+CSCS=?", "+CSCS: (\"HEX\",\"UCS2\")\r"}, {"+CFUN?", "+CFUN: 1\r"}, {"+COPS=3,0;+COPS?;+COPS=3,1;+COPS?;+COPS=3,2;+COPS?", "+COPS: 0,0,\"Android\"\r+COPS: 0,1,\"Android\"\r+COPS: 0,2,\"310995\"\r"}, {"+CREG?", "+CREG: 2,5, \"0113\", \"6614\"\r"}, {"+CGREG?", "+CGREG: 2,0\r"}, {"+CSQ", "+CSQ: 16,99\r"}, {"+CNMI?", "+CNMI: 1,2,2,1,1\r"}, {"+CLIR?", "+CLIR: 1,3\r"}, {"%CPVWI=2", "%CPVWI: 0\r"}, {"+CUSD=1,\"#646#\"", "+CUSD=0,\"You have used 23 minutes\"\r"}, {"+CRSM=176,12258,0,0,10", "+CRSM: 144,0,981062200050259429F6\r"}, {"+CRSM=192,12258,0,0,15", "+CRSM: 144,0,0000000A2FE204000FF55501020000\r"}, {"+CRSM=192,28474,0,0,15", "+CRSM: 144,0,0000005a6f3a040011f5220102011e\r"}, {"+CRSM=178,28474,1,4,30", "+CRSM: 144,0,437573746f6d65722043617265ffffff07818100398799f7ffffffffffff\r"}, {"+CRSM=178,28474,2,4,30", "+CRSM: 144,0,566f696365204d61696cffffffffffff07918150367742f3ffffffffffff\r"}, {"+CRSM=178,28474,3,4,30", "+CRSM: 144,0,4164676a6dffffffffffffffffffffff0b918188551512c221436587ff01\r"}, {"+CRSM=178,28474,4,4,30", "+CRSM: 144,0,810101c1ffffffffffffffffffffffff068114455245f8ffffffffffffff\r"}, {"+CRSM=192,28490,0,0,15", "+CRSM: 144,0,000000416f4a040011f5550102010d\r"}, {"+CRSM=178,28490,1,4,13", "+CRSM: 144,0,0206092143658709ffffffffff\r"}};
    private String finalResponse;
    InputStream in;
    LineReader lineReader;
    HandlerThread mHandlerThread;
    OutputStream out;
    int pausedResponseCount;
    Object pausedResponseMonitor = new Object();
    SimulatedGsmCallState simulatedCallState;
    ServerSocket ss;

    public ModelInterpreter(InputStream inputStream, OutputStream outputStream) {
        this.in = inputStream;
        this.out = outputStream;
        this.init();
    }

    public ModelInterpreter(InetSocketAddress inetSocketAddress) throws IOException {
        this.ss = new ServerSocket();
        this.ss.setReuseAddress(true);
        this.ss.bind(inetSocketAddress);
        this.init();
    }

    private void conference() throws InterpreterEx {
        if (!this.simulatedCallState.conference()) {
            throw new InterpreterEx("ERROR");
        }
    }

    private void init() {
        new Thread(this, LOG_TAG).start();
        this.mHandlerThread = new HandlerThread(LOG_TAG);
        this.mHandlerThread.start();
        this.simulatedCallState = new SimulatedGsmCallState(this.mHandlerThread.getLooper());
    }

    private void onAnswer() throws InterpreterEx {
        if (!this.simulatedCallState.onAnswer()) {
            throw new InterpreterEx("ERROR");
        }
    }

    private void onCHLD(String string2) throws InterpreterEx {
        char c = string2.charAt(6);
        int n = string2.length();
        char c2 = '\u0000';
        if (n >= 8) {
            c2 = string2.charAt(7);
        }
        if (!this.simulatedCallState.onChld(c, c2)) {
            throw new InterpreterEx("ERROR");
        }
    }

    private void onCLCC() throws InterpreterEx {
        List<String> list = this.simulatedCallState.getClccLines();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            this.println(list.get(i));
        }
    }

    private void onDial(String string2) throws InterpreterEx {
        if (!this.simulatedCallState.onDial(string2.substring(1))) {
            throw new InterpreterEx("ERROR");
        }
    }

    private void onHangup() throws InterpreterEx {
        if (!this.simulatedCallState.onAnswer()) {
            throw new InterpreterEx("ERROR");
        }
        this.finalResponse = "NO CARRIER";
    }

    private void onSMSSend(String string2) throws InterpreterEx {
        this.print("> ");
        this.lineReader.getNextLineCtrlZ();
        this.println("+CMGS: 1");
    }

    private void releaseActiveAcceptHeldOrWaiting() throws InterpreterEx {
        if (!this.simulatedCallState.releaseActiveAcceptHeldOrWaiting()) {
            throw new InterpreterEx("ERROR");
        }
    }

    private void releaseHeldOrUDUB() throws InterpreterEx {
        if (!this.simulatedCallState.releaseHeldOrUDUB()) {
            throw new InterpreterEx("ERROR");
        }
    }

    private void separateCall(int n) throws InterpreterEx {
        if (!this.simulatedCallState.separateCall(n)) {
            throw new InterpreterEx("ERROR");
        }
    }

    private void switchActiveAndHeldOrWaiting() throws InterpreterEx {
        if (!this.simulatedCallState.switchActiveAndHeldOrWaiting()) {
            throw new InterpreterEx("ERROR");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void pauseResponses() {
        Object object = this.pausedResponseMonitor;
        synchronized (object) {
            this.pausedResponseCount = 1 + this.pausedResponseCount;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void print(String string2) {
        synchronized (this) {
            try {
                byte[] byArray = string2.getBytes("US-ASCII");
                this.out.write(byArray);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void println(String string2) {
        synchronized (this) {
            try {
                byte[] byArray = string2.getBytes("US-ASCII");
                this.out.write(byArray);
                this.out.write(13);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    void processLine(String var1_1) throws InterpreterEx {
        var2_2 = this.splitCommands(var1_1);
        block0: for (var3_3 = 0; var3_3 < var2_2.length; ++var3_3) {
            block12: {
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                var4_4 = var2_2[var3_3];
                                if (var4_4.equals("A")) {
                                    this.onAnswer();
lbl6:
                                    // 7 sources

                                    continue block0;
                                }
                                if (!var4_4.equals("H")) break block8;
                                this.onHangup();
                                ** GOTO lbl6
                            }
                            if (!var4_4.startsWith("+CHLD=")) break block9;
                            this.onCHLD(var4_4);
                            ** GOTO lbl6
                        }
                        if (!var4_4.equals("+CLCC")) break block10;
                        this.onCLCC();
                        ** GOTO lbl6
                    }
                    if (!var4_4.startsWith("D")) break block11;
                    this.onDial(var4_4);
                    ** GOTO lbl6
                }
                if (!var4_4.startsWith("+CMGS=")) break block12;
                this.onSMSSend(var4_4);
                ** GOTO lbl6
            }
            var5_5 = 0;
            while (true) {
                block14: {
                    block13: {
                        var6_6 = ModelInterpreter.sDefaultResponses.length;
                        var7_7 = false;
                        if (var5_5 >= var6_6) break block13;
                        if (!var4_4.equals(ModelInterpreter.sDefaultResponses[var5_5][0])) break block14;
                        var8_8 = ModelInterpreter.sDefaultResponses[var5_5][1];
                        if (var8_8 != null) {
                            this.println(var8_8);
                        }
                        var7_7 = true;
                    }
                    if (!var7_7) ** break;
                    ** continue;
                    throw new InterpreterEx("ERROR");
                }
                ++var5_5;
            }
        }
    }

    @Override
    public void progressConnectingCallState() {
        this.simulatedCallState.progressConnectingCallState();
    }

    @Override
    public void progressConnectingToActive() {
        this.simulatedCallState.progressConnectingToActive();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void resumeResponses() {
        Object object = this.pausedResponseMonitor;
        synchronized (object) {
            --this.pausedResponseCount;
            if (this.pausedResponseCount == 0) {
                this.pausedResponseMonitor.notifyAll();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        block15: while (true) {
            block19: {
                Socket socket;
                if (this.ss == null) break block19;
                try {
                    socket = this.ss.accept();
                }
                catch (IOException iOException) {
                    Log.w(LOG_TAG, "IOException on socket.accept(); stopping", iOException);
                    return;
                }
                try {
                    this.in = socket.getInputStream();
                    this.out = socket.getOutputStream();
                }
                catch (IOException iOException) {
                    Log.w(LOG_TAG, "IOException on accepted socket(); re-listening", iOException);
                }
                Log.i(LOG_TAG, "New connection accepted");
                break block19;
                continue;
            }
            this.lineReader = new LineReader(this.in);
            this.println("Welcome");
            while (true) {
                int n;
                String string2;
                if ((string2 = this.lineReader.getNextLine()) == null) {
                    Log.i(LOG_TAG, "Disconnected");
                    if (this.ss == null) return;
                    continue block15;
                }
                Object object = this.pausedResponseMonitor;
                // MONITORENTER : object
                while ((n = this.pausedResponseCount) > 0) {
                    try {
                        this.pausedResponseMonitor.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                // MONITOREXIT : object
                // MONITORENTER : this
                try {
                    this.finalResponse = "OK";
                    this.processLine(string2);
                    this.println(this.finalResponse);
                }
                catch (InterpreterEx interpreterEx) {
                    this.println(interpreterEx.result);
                }
                catch (RuntimeException runtimeException) {
                    runtimeException.printStackTrace();
                    this.println("ERROR");
                }
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendUnsolicited(String string2) {
        synchronized (this) {
            this.println(string2);
            return;
        }
    }

    @Override
    public void setAutoProgressConnectingCall(boolean bl) {
        this.simulatedCallState.setAutoProgressConnectingCall(bl);
    }

    @Override
    public void setNextCallFailCause(int n) {
    }

    @Override
    public void setNextDialFailImmediately(boolean bl) {
        this.simulatedCallState.setNextDialFailImmediately(bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void shutdown() {
        Looper looper = this.mHandlerThread.getLooper();
        if (looper != null) {
            looper.quit();
        }
        try {
            this.in.close();
        }
        catch (IOException iOException) {}
        try {
            this.out.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    String[] splitCommands(String string2) throws InterpreterEx {
        if (!string2.startsWith("AT")) {
            throw new InterpreterEx("ERROR");
        }
        if (string2.length() == 2) {
            return new String[0];
        }
        String[] stringArray = new String[]{string2.substring(2)};
        return stringArray;
    }

    @Override
    public void triggerHangupAll() {
        if (this.simulatedCallState.triggerHangupAll()) {
            this.println("NO CARRIER");
        }
    }

    @Override
    public void triggerHangupBackground() {
        if (this.simulatedCallState.triggerHangupBackground()) {
            this.println("NO CARRIER");
        }
    }

    @Override
    public void triggerHangupForeground() {
        if (this.simulatedCallState.triggerHangupForeground()) {
            this.println("NO CARRIER");
        }
    }

    @Override
    public void triggerIncomingSMS(String string2) {
    }

    @Override
    public void triggerIncomingUssd(String string2, String string3) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void triggerRing(String string2) {
        synchronized (this) {
            if (this.simulatedCallState.triggerRing(string2)) {
                this.println("RING");
            }
            return;
        }
    }

    @Override
    public void triggerSsn(int n, int n2) {
    }
}

