/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.test;

import android.os.AsyncResult;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.android.internal.telephony.BaseCommands;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.gsm.SmsBroadcastConfigInfo;
import com.android.internal.telephony.gsm.SuppServiceNotification;
import com.android.internal.telephony.test.SimulatedGsmCallState;
import com.android.internal.telephony.test.SimulatedRadioControl;
import java.util.ArrayList;

public final class SimulatedCommands
extends BaseCommands
implements CommandsInterface,
SimulatedRadioControl {
    private static final String DEFAULT_SIM_PIN2_CODE = "5678";
    private static final String DEFAULT_SIM_PIN_CODE = "1234";
    private static final SimFdnState INITIAL_FDN_STATE;
    private static final SimLockState INITIAL_LOCK_STATE;
    private static final String LOG_TAG = "SIM";
    private static final String SIM_PUK2_CODE = "87654321";
    private static final String SIM_PUK_CODE = "12345678";
    HandlerThread mHandlerThread;
    int mNetworkType;
    String mPin2Code;
    int mPin2UnlockAttempts;
    String mPinCode;
    int mPinUnlockAttempts;
    int mPuk2UnlockAttempts;
    int mPukUnlockAttempts;
    boolean mSimFdnEnabled;
    SimFdnState mSimFdnEnabledState;
    boolean mSimLockEnabled;
    SimLockState mSimLockedState;
    boolean mSsnNotifyOn = false;
    int nextCallFailCause = 16;
    int pausedResponseCount;
    ArrayList<Message> pausedResponses = new ArrayList();
    SimulatedGsmCallState simulatedCallState;

    static {
        INITIAL_LOCK_STATE = SimLockState.NONE;
        INITIAL_FDN_STATE = SimFdnState.NONE;
    }

    /*
     * Enabled aggressive block sorting
     */
    public SimulatedCommands() {
        super(null);
        this.mHandlerThread = new HandlerThread("SimulatedCommands");
        this.mHandlerThread.start();
        this.simulatedCallState = new SimulatedGsmCallState(this.mHandlerThread.getLooper());
        this.setRadioState(CommandsInterface.RadioState.RADIO_OFF);
        this.mSimLockedState = INITIAL_LOCK_STATE;
        boolean bl = this.mSimLockedState != SimLockState.NONE;
        this.mSimLockEnabled = bl;
        this.mPinCode = DEFAULT_SIM_PIN_CODE;
        this.mSimFdnEnabledState = INITIAL_FDN_STATE;
        boolean bl2 = this.mSimFdnEnabledState != SimFdnState.NONE;
        this.mSimFdnEnabled = bl2;
        this.mPin2Code = DEFAULT_SIM_PIN2_CODE;
    }

    private boolean isSimLocked() {
        return this.mSimLockedState != SimLockState.NONE;
    }

    private void resultFail(Message message, Throwable throwable) {
        block3: {
            block2: {
                if (message == null) break block2;
                AsyncResult.forMessage((Message)message).exception = throwable;
                if (this.pausedResponseCount <= 0) break block3;
                this.pausedResponses.add(message);
            }
            return;
        }
        message.sendToTarget();
    }

    private void resultSuccess(Message message, Object object) {
        block3: {
            block2: {
                if (message == null) break block2;
                AsyncResult.forMessage((Message)message).result = object;
                if (this.pausedResponseCount <= 0) break block3;
                this.pausedResponses.add(message);
            }
            return;
        }
        message.sendToTarget();
    }

    private void unimplemented(Message message) {
        block3: {
            block2: {
                if (message == null) break block2;
                AsyncResult.forMessage((Message)message).exception = new RuntimeException("Unimplemented");
                if (this.pausedResponseCount <= 0) break block3;
                this.pausedResponses.add(message);
            }
            return;
        }
        message.sendToTarget();
    }

    @Override
    public void acceptCall(Message message) {
        if (!this.simulatedCallState.onAnswer()) {
            this.resultFail(message, new RuntimeException("Hangup Error"));
            return;
        }
        this.resultSuccess(message, null);
    }

    @Override
    public void acknowledgeLastIncomingCdmaSms(boolean bl, int n, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void acknowledgeLastIncomingGsmSms(boolean bl, int n, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void cancelPendingUssd(Message message) {
        this.resultSuccess(message, null);
    }

    @Override
    public void changeBarringPassword(String string2, String string3, String string4, Message message) {
        this.unimplemented(message);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void changeIccPin(String string2, String string3, Message message) {
        if (string2 != null && string2.equals(this.mPinCode)) {
            this.mPinCode = string3;
            if (message == null) return;
            AsyncResult.forMessage(message, null, null);
            message.sendToTarget();
            return;
        }
        if (message == null) return;
        Log.i(LOG_TAG, "[SimCmd] changeIccPin: pin failed!");
        AsyncResult.forMessage(message, null, new CommandException(CommandException.Error.PASSWORD_INCORRECT));
        message.sendToTarget();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void changeIccPin2(String string2, String string3, Message message) {
        if (string2 != null && string2.equals(this.mPin2Code)) {
            this.mPin2Code = string3;
            if (message == null) return;
            AsyncResult.forMessage(message, null, null);
            message.sendToTarget();
            return;
        }
        if (message == null) return;
        Log.i(LOG_TAG, "[SimCmd] changeIccPin2: pin2 failed!");
        AsyncResult.forMessage(message, null, new CommandException(CommandException.Error.PASSWORD_INCORRECT));
        message.sendToTarget();
    }

    @Override
    public void conference(Message message) {
        if (!this.simulatedCallState.onChld('3', '\u0000')) {
            this.resultFail(message, new RuntimeException("Hangup Error"));
            return;
        }
        this.resultSuccess(message, null);
    }

    @Override
    public void deactivateDataCall(int n, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void deactivateDefaultPDP(int n, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void deleteSmsOnRuim(int n, Message message) {
        Log.d(LOG_TAG, "Delete RUIM message at index " + n);
        this.unimplemented(message);
    }

    @Override
    public void deleteSmsOnSim(int n, Message message) {
        Log.d(LOG_TAG, "Delete message at index " + n);
        this.unimplemented(message);
    }

    @Override
    public void dial(String string2, int n, Message message) {
        this.simulatedCallState.onDial(string2);
        this.resultSuccess(message, null);
    }

    @Override
    public void dial(String string2, int n, UUSInfo uUSInfo, Message message) {
        this.simulatedCallState.onDial(string2);
        this.resultSuccess(message, null);
    }

    @Override
    public void exitEmergencyCallbackMode(Message message) {
        this.unimplemented(message);
    }

    @Override
    public void explicitCallTransfer(Message message) {
        if (!this.simulatedCallState.onChld('4', '\u0000')) {
            this.resultFail(message, new RuntimeException("Hangup Error"));
            return;
        }
        this.resultSuccess(message, null);
    }

    public void forceDataDormancy(Message message) {
        this.unimplemented(message);
    }

    @Override
    public void getAvailableNetworks(Message message) {
        this.unimplemented(message);
    }

    @Override
    public void getBasebandVersion(Message message) {
        this.resultSuccess(message, "SimulatedCommands");
    }

    @Override
    public void getCDMASubscription(Message message) {
        Log.w(LOG_TAG, "CDMA not implemented in SimulatedCommands");
        this.unimplemented(message);
    }

    @Override
    public void getCLIR(Message message) {
        this.unimplemented(message);
    }

    @Override
    public void getCdmaBroadcastConfig(Message message) {
        this.unimplemented(message);
    }

    @Override
    public void getCurrentCalls(Message message) {
        if (this.mState == CommandsInterface.RadioState.SIM_READY) {
            this.resultSuccess(message, this.simulatedCallState.getDriverCalls());
            return;
        }
        this.resultFail(message, new CommandException(CommandException.Error.RADIO_NOT_AVAILABLE));
    }

    @Override
    public void getDataCallList(Message message) {
        this.resultSuccess(message, new ArrayList(0));
    }

    @Override
    public void getDeviceIdentity(Message message) {
        Log.w(LOG_TAG, "CDMA not implemented in SimulatedCommands");
        this.unimplemented(message);
    }

    @Override
    public void getGPRSRegistrationState(Message message) {
        this.resultSuccess(message, new String[]{"5", null, null, "2"});
    }

    @Override
    public void getGsmBroadcastConfig(Message message) {
        this.unimplemented(message);
    }

    @Override
    public void getIMEI(Message message) {
        this.resultSuccess(message, "012345678901234");
    }

    @Override
    public void getIMEISV(Message message) {
        this.resultSuccess(message, "99");
    }

    @Override
    public void getIMSI(Message message) {
        this.resultSuccess(message, "012345678901234");
    }

    @Override
    public void getIccCardStatus(Message message) {
        this.unimplemented(message);
    }

    @Override
    public void getLastCallFailCause(Message message) {
        int[] nArray = new int[]{this.nextCallFailCause};
        this.resultSuccess(message, nArray);
    }

    @Override
    public void getLastDataCallFailCause(Message message) {
        this.unimplemented(message);
    }

    @Override
    public void getLastPdpFailCause(Message message) {
        this.unimplemented(message);
    }

    @Override
    public void getMute(Message message) {
        this.unimplemented(message);
    }

    @Override
    public void getNeighboringCids(Message message) {
        int[] nArray = new int[7];
        nArray[0] = 6;
        for (int i = 1; i < 7; ++i) {
            nArray[i] = i;
        }
        this.resultSuccess(message, nArray);
    }

    @Override
    public void getNetworkSelectionMode(Message message) {
        this.resultSuccess(message, new int[]{0});
    }

    @Override
    public void getOperator(Message message) {
        this.resultSuccess(message, new String[]{"El Telco Loco", "Telco Loco", "001001"});
    }

    @Override
    public void getPDPContextList(Message message) {
        this.getDataCallList(message);
    }

    @Override
    public void getPreferredNetworkType(Message message) {
        int[] nArray = new int[]{this.mNetworkType};
        this.resultSuccess(message, nArray);
    }

    @Override
    public void getPreferredVoicePrivacy(Message message) {
        Log.w(LOG_TAG, "CDMA not implemented in SimulatedCommands");
        this.unimplemented(message);
    }

    @Override
    public void getRegistrationState(Message message) {
        this.resultSuccess(message, new String[]{"5", null, null, null, null, null, null, null, null, null, null, null, null, null});
    }

    @Override
    public void getSignalStrength(Message message) {
        this.resultSuccess(message, new int[]{23, 0});
    }

    @Override
    public void getSmscAddress(Message message) {
        this.unimplemented(message);
    }

    @Override
    public void handleCallSetupRequestFromSim(boolean bl, Message message) {
        this.resultSuccess(message, null);
    }

    @Override
    public void hangupConnection(int n, Message message) {
        if (!this.simulatedCallState.onChld('1', (char)(n + 48))) {
            Log.i("GSM", "[SimCmd] hangupConnection: resultFail");
            this.resultFail(message, new RuntimeException("Hangup Error"));
            return;
        }
        Log.i("GSM", "[SimCmd] hangupConnection: resultSuccess");
        this.resultSuccess(message, null);
    }

    @Override
    public void hangupForegroundResumeBackground(Message message) {
        if (!this.simulatedCallState.onChld('1', '\u0000')) {
            this.resultFail(message, new RuntimeException("Hangup Error"));
            return;
        }
        this.resultSuccess(message, null);
    }

    @Override
    public void hangupWaitingOrBackground(Message message) {
        if (!this.simulatedCallState.onChld('0', '\u0000')) {
            this.resultFail(message, new RuntimeException("Hangup Error"));
            return;
        }
        this.resultSuccess(message, null);
    }

    @Override
    public void iccIO(int n, int n2, String string2, int n3, int n4, int n5, String string3, String string4, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void invokeOemRilRequestRaw(byte[] byArray, Message message) {
        if (message != null) {
            AsyncResult.forMessage((Message)message).result = byArray;
            message.sendToTarget();
        }
    }

    @Override
    public void invokeOemRilRequestStrings(String[] stringArray, Message message) {
        if (message != null) {
            AsyncResult.forMessage((Message)message).result = stringArray;
            message.sendToTarget();
        }
    }

    @Override
    public void pauseResponses() {
        this.pausedResponseCount = 1 + this.pausedResponseCount;
    }

    @Override
    public void progressConnectingCallState() {
        this.simulatedCallState.progressConnectingCallState();
        this.mCallStateRegistrants.notifyRegistrants();
    }

    @Override
    public void progressConnectingToActive() {
        this.simulatedCallState.progressConnectingToActive();
        this.mCallStateRegistrants.notifyRegistrants();
    }

    @Override
    public void queryAvailableBandMode(Message message) {
        this.resultSuccess(message, new int[]{4, 2, 3, 4});
    }

    @Override
    public void queryCLIP(Message message) {
        this.unimplemented(message);
    }

    @Override
    public void queryCallForwardStatus(int n, int n2, String string2, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void queryCallWaiting(int n, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void queryCdmaRoamingPreference(Message message) {
        Log.w(LOG_TAG, "CDMA not implemented in SimulatedCommands");
        this.unimplemented(message);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void queryFacilityLock(String string2, String string3, int n, Message message) {
        block4: {
            int n2;
            int[] nArray;
            if (string2 != null && string2.equals("SC")) {
                if (message == null) return;
                int[] nArray2 = new int[1];
                int n3 = this.mSimLockEnabled ? 1 : 0;
                nArray2[0] = n3;
                StringBuilder stringBuilder = new StringBuilder().append("[SimCmd] queryFacilityLock: SIM is ");
                String string4 = nArray2[0] == 0 ? "unlocked" : "locked";
                Log.i(LOG_TAG, stringBuilder.append(string4).toString());
                AsyncResult.forMessage(message, nArray2, null);
                message.sendToTarget();
                return;
            }
            if (string2 != null && string2.equals("FD")) {
                if (message == null) return;
                nArray = new int[1];
                n2 = this.mSimFdnEnabled ? 1 : 0;
            }
            break block4;
            nArray[0] = n2;
            StringBuilder stringBuilder = new StringBuilder().append("[SimCmd] queryFacilityLock: FDN is ");
            String string5 = nArray[0] == 0 ? "disabled" : "enabled";
            Log.i(LOG_TAG, stringBuilder.append(string5).toString());
            AsyncResult.forMessage(message, nArray, null);
            message.sendToTarget();
            return;
        }
        this.unimplemented(message);
    }

    @Override
    public void queryTTYMode(Message message) {
        Log.w(LOG_TAG, "CDMA not implemented in SimulatedCommands");
        this.unimplemented(message);
    }

    @Override
    public void rejectCall(Message message) {
        if (!this.simulatedCallState.onChld('0', '\u0000')) {
            this.resultFail(message, new RuntimeException("Hangup Error"));
            return;
        }
        this.resultSuccess(message, null);
    }

    @Override
    public void reportSmsMemoryStatus(boolean bl, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void reportStkServiceIsRunning(Message message) {
        this.resultSuccess(message, null);
    }

    @Override
    public void resetRadio(Message message) {
        this.unimplemented(message);
    }

    @Override
    public void resumeResponses() {
        --this.pausedResponseCount;
        if (this.pausedResponseCount == 0) {
            int n = this.pausedResponses.size();
            for (int i = 0; i < n; ++i) {
                this.pausedResponses.get(i).sendToTarget();
            }
            this.pausedResponses.clear();
            return;
        }
        Log.e("GSM", "SimulatedCommands.resumeResponses < 0");
    }

    @Override
    public void sendBurstDtmf(String string2, int n, int n2, Message message) {
        this.resultSuccess(message, null);
    }

    @Override
    public void sendCDMAFeatureCode(String string2, Message message) {
        Log.w(LOG_TAG, "CDMA not implemented in SimulatedCommands");
        this.unimplemented(message);
    }

    @Override
    public void sendCdmaSms(byte[] byArray, Message message) {
        Log.w(LOG_TAG, "CDMA not implemented in SimulatedCommands");
    }

    @Override
    public void sendDtmf(char c, Message message) {
        this.resultSuccess(message, null);
    }

    @Override
    public void sendEnvelope(String string2, Message message) {
        this.resultSuccess(message, null);
    }

    @Override
    public void sendSMS(String string2, String string3, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void sendTerminalResponse(String string2, Message message) {
        this.resultSuccess(message, null);
    }

    @Override
    public void sendUSSD(String string2, Message message) {
        if (string2.equals("#646#")) {
            this.resultSuccess(message, null);
            this.triggerIncomingUssd("0", "You have NNN minutes remaining.");
            return;
        }
        this.resultSuccess(message, null);
        this.triggerIncomingUssd("0", "All Done");
    }

    @Override
    public void separateConnection(int n, Message message) {
        char c = (char)(n + 48);
        if (!this.simulatedCallState.onChld('2', c)) {
            this.resultFail(message, new RuntimeException("Hangup Error"));
            return;
        }
        this.resultSuccess(message, null);
    }

    @Override
    public void setAutoProgressConnectingCall(boolean bl) {
        this.simulatedCallState.setAutoProgressConnectingCall(bl);
    }

    @Override
    public void setBandMode(int n, Message message) {
        this.resultSuccess(message, null);
    }

    @Override
    public void setCLIR(int n, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void setCallForward(int n, int n2, int n3, String string2, int n4, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void setCallWaiting(boolean bl, int n, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void setCdmaBroadcastActivation(boolean bl, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void setCdmaBroadcastConfig(int[] nArray, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void setCdmaRoamingPreference(int n, Message message) {
        Log.w(LOG_TAG, "CDMA not implemented in SimulatedCommands");
        this.unimplemented(message);
    }

    @Override
    public void setCdmaSubscription(int n, Message message) {
        Log.w(LOG_TAG, "CDMA not implemented in SimulatedCommands");
        this.unimplemented(message);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setFacilityLock(String string2, boolean bl, String string3, int n, Message message) {
        if (string2 != null && string2.equals("SC")) {
            if (string3 != null && string3.equals(this.mPinCode)) {
                Log.i(LOG_TAG, "[SimCmd] setFacilityLock: pin is valid");
                this.mSimLockEnabled = bl;
                if (message == null) return;
                AsyncResult.forMessage(message, null, null);
                message.sendToTarget();
                return;
            }
            if (message == null) return;
            Log.i(LOG_TAG, "[SimCmd] setFacilityLock: pin failed!");
            AsyncResult.forMessage(message, null, new CommandException(CommandException.Error.GENERIC_FAILURE));
            message.sendToTarget();
            return;
        }
        if (string2 != null && string2.equals("FD")) {
            if (string3 != null && string3.equals(this.mPin2Code)) {
                Log.i(LOG_TAG, "[SimCmd] setFacilityLock: pin2 is valid");
                this.mSimFdnEnabled = bl;
                if (message == null) return;
                AsyncResult.forMessage(message, null, null);
                message.sendToTarget();
                return;
            } else {
                if (message == null) return;
                Log.i(LOG_TAG, "[SimCmd] setFacilityLock: pin2 failed!");
                AsyncResult.forMessage(message, null, new CommandException(CommandException.Error.GENERIC_FAILURE));
                message.sendToTarget();
                return;
            }
        }
        this.unimplemented(message);
    }

    @Override
    public void setGsmBroadcastActivation(boolean bl, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void setGsmBroadcastConfig(SmsBroadcastConfigInfo[] smsBroadcastConfigInfoArray, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void setLocationUpdates(boolean bl, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void setMute(boolean bl, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void setNetworkSelectionModeAutomatic(Message message) {
        this.unimplemented(message);
    }

    @Override
    public void setNetworkSelectionModeManual(String string2, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void setNextCallFailCause(int n) {
        this.nextCallFailCause = n;
    }

    @Override
    public void setNextDialFailImmediately(boolean bl) {
        this.simulatedCallState.setNextDialFailImmediately(bl);
    }

    @Override
    public void setPhoneType(int n) {
        Log.w(LOG_TAG, "CDMA not implemented in SimulatedCommands");
    }

    @Override
    public void setPreferredNetworkType(int n, Message message) {
        this.mNetworkType = n;
        this.resultSuccess(message, null);
    }

    @Override
    public void setPreferredVoicePrivacy(boolean bl, Message message) {
        Log.w(LOG_TAG, "CDMA not implemented in SimulatedCommands");
        this.unimplemented(message);
    }

    @Override
    public void setRadioPower(boolean bl, Message message) {
        if (bl) {
            if (this.isSimLocked()) {
                Log.i(LOG_TAG, "[SimCmd] setRadioPower: SIM locked! state=" + (Object)((Object)this.mSimLockedState));
                this.setRadioState(CommandsInterface.RadioState.SIM_LOCKED_OR_ABSENT);
                return;
            }
            this.setRadioState(CommandsInterface.RadioState.SIM_READY);
            return;
        }
        this.setRadioState(CommandsInterface.RadioState.RADIO_OFF);
    }

    @Override
    public void setSmscAddress(String string2, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void setSuppServiceNotifications(boolean bl, Message message) {
        this.resultSuccess(message, null);
        if (bl && this.mSsnNotifyOn) {
            Log.w(LOG_TAG, "Supp Service Notifications already enabled!");
        }
        this.mSsnNotifyOn = bl;
    }

    @Override
    public void setTTYMode(int n, Message message) {
        Log.w(LOG_TAG, "Not implemented in SimulatedCommands");
        this.unimplemented(message);
    }

    @Override
    public void setupDataCall(String string2, String string3, String string4, String string5, String string6, String string7, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void setupDefaultPDP(String string2, String string3, String string4, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void shutdown() {
        this.setRadioState(CommandsInterface.RadioState.RADIO_UNAVAILABLE);
        Looper looper = this.mHandlerThread.getLooper();
        if (looper != null) {
            looper.quit();
        }
    }

    @Override
    public void startDtmf(char c, Message message) {
        this.resultSuccess(message, null);
    }

    @Override
    public void stopDtmf(Message message) {
        this.resultSuccess(message, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void supplyIccPin(String string2, Message message) {
        if (this.mSimLockedState != SimLockState.REQUIRE_PIN) {
            Log.i(LOG_TAG, "[SimCmd] supplyIccPin: wrong state, state=" + (Object)((Object)this.mSimLockedState));
            AsyncResult.forMessage(message, null, new CommandException(CommandException.Error.PASSWORD_INCORRECT));
            message.sendToTarget();
            return;
        } else if (string2 != null && string2.equals(this.mPinCode)) {
            Log.i(LOG_TAG, "[SimCmd] supplyIccPin: success!");
            this.setRadioState(CommandsInterface.RadioState.SIM_READY);
            this.mPinUnlockAttempts = 0;
            this.mSimLockedState = SimLockState.NONE;
            if (message == null) return;
            AsyncResult.forMessage(message, null, null);
            message.sendToTarget();
            return;
        } else {
            if (message == null) return;
            this.mPinUnlockAttempts = 1 + this.mPinUnlockAttempts;
            Log.i(LOG_TAG, "[SimCmd] supplyIccPin: failed! attempt=" + this.mPinUnlockAttempts);
            if (this.mPinUnlockAttempts >= 3) {
                Log.i(LOG_TAG, "[SimCmd] supplyIccPin: set state to REQUIRE_PUK");
                this.mSimLockedState = SimLockState.REQUIRE_PUK;
            }
            AsyncResult.forMessage(message, null, new CommandException(CommandException.Error.PASSWORD_INCORRECT));
            message.sendToTarget();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void supplyIccPin2(String string2, Message message) {
        if (this.mSimFdnEnabledState != SimFdnState.REQUIRE_PIN2) {
            Log.i(LOG_TAG, "[SimCmd] supplyIccPin2: wrong state, state=" + (Object)((Object)this.mSimFdnEnabledState));
            AsyncResult.forMessage(message, null, new CommandException(CommandException.Error.PASSWORD_INCORRECT));
            message.sendToTarget();
            return;
        } else if (string2 != null && string2.equals(this.mPin2Code)) {
            Log.i(LOG_TAG, "[SimCmd] supplyIccPin2: success!");
            this.mPin2UnlockAttempts = 0;
            this.mSimFdnEnabledState = SimFdnState.NONE;
            if (message == null) return;
            AsyncResult.forMessage(message, null, null);
            message.sendToTarget();
            return;
        } else {
            if (message == null) return;
            this.mPin2UnlockAttempts = 1 + this.mPin2UnlockAttempts;
            Log.i(LOG_TAG, "[SimCmd] supplyIccPin2: failed! attempt=" + this.mPin2UnlockAttempts);
            if (this.mPin2UnlockAttempts >= 3) {
                Log.i(LOG_TAG, "[SimCmd] supplyIccPin2: set state to REQUIRE_PUK2");
                this.mSimFdnEnabledState = SimFdnState.REQUIRE_PUK2;
            }
            AsyncResult.forMessage(message, null, new CommandException(CommandException.Error.PASSWORD_INCORRECT));
            message.sendToTarget();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void supplyIccPuk(String string2, String string3, Message message) {
        if (this.mSimLockedState != SimLockState.REQUIRE_PUK) {
            Log.i(LOG_TAG, "[SimCmd] supplyIccPuk: wrong state, state=" + (Object)((Object)this.mSimLockedState));
            AsyncResult.forMessage(message, null, new CommandException(CommandException.Error.PASSWORD_INCORRECT));
            message.sendToTarget();
            return;
        } else if (string2 != null && string2.equals(SIM_PUK_CODE)) {
            Log.i(LOG_TAG, "[SimCmd] supplyIccPuk: success!");
            this.setRadioState(CommandsInterface.RadioState.SIM_READY);
            this.mSimLockedState = SimLockState.NONE;
            this.mPukUnlockAttempts = 0;
            if (message == null) return;
            AsyncResult.forMessage(message, null, null);
            message.sendToTarget();
            return;
        } else {
            if (message == null) return;
            this.mPukUnlockAttempts = 1 + this.mPukUnlockAttempts;
            Log.i(LOG_TAG, "[SimCmd] supplyIccPuk: failed! attempt=" + this.mPukUnlockAttempts);
            if (this.mPukUnlockAttempts >= 10) {
                Log.i(LOG_TAG, "[SimCmd] supplyIccPuk: set state to SIM_PERM_LOCKED");
                this.mSimLockedState = SimLockState.SIM_PERM_LOCKED;
            }
            AsyncResult.forMessage(message, null, new CommandException(CommandException.Error.PASSWORD_INCORRECT));
            message.sendToTarget();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void supplyIccPuk2(String string2, String string3, Message message) {
        if (this.mSimFdnEnabledState != SimFdnState.REQUIRE_PUK2) {
            Log.i(LOG_TAG, "[SimCmd] supplyIccPuk2: wrong state, state=" + (Object)((Object)this.mSimLockedState));
            AsyncResult.forMessage(message, null, new CommandException(CommandException.Error.PASSWORD_INCORRECT));
            message.sendToTarget();
            return;
        } else if (string2 != null && string2.equals(SIM_PUK2_CODE)) {
            Log.i(LOG_TAG, "[SimCmd] supplyIccPuk2: success!");
            this.mSimFdnEnabledState = SimFdnState.NONE;
            this.mPuk2UnlockAttempts = 0;
            if (message == null) return;
            AsyncResult.forMessage(message, null, null);
            message.sendToTarget();
            return;
        } else {
            if (message == null) return;
            this.mPuk2UnlockAttempts = 1 + this.mPuk2UnlockAttempts;
            Log.i(LOG_TAG, "[SimCmd] supplyIccPuk2: failed! attempt=" + this.mPuk2UnlockAttempts);
            if (this.mPuk2UnlockAttempts >= 10) {
                Log.i(LOG_TAG, "[SimCmd] supplyIccPuk2: set state to SIM_PERM_LOCKED");
                this.mSimFdnEnabledState = SimFdnState.SIM_PERM_LOCKED;
            }
            AsyncResult.forMessage(message, null, new CommandException(CommandException.Error.PASSWORD_INCORRECT));
            message.sendToTarget();
            return;
        }
    }

    @Override
    public void supplyNetworkDepersonalization(String string2, Message message) {
        this.unimplemented(message);
    }

    @Override
    public void switchWaitingOrHoldingAndActive(Message message) {
        if (!this.simulatedCallState.onChld('2', '\u0000')) {
            this.resultFail(message, new RuntimeException("Hangup Error"));
            return;
        }
        this.resultSuccess(message, null);
    }

    @Override
    public void triggerHangupAll() {
        this.simulatedCallState.triggerHangupAll();
        this.mCallStateRegistrants.notifyRegistrants();
    }

    @Override
    public void triggerHangupBackground() {
        this.simulatedCallState.triggerHangupBackground();
        this.mCallStateRegistrants.notifyRegistrants();
    }

    @Override
    public void triggerHangupForeground() {
        this.simulatedCallState.triggerHangupForeground();
        this.mCallStateRegistrants.notifyRegistrants();
    }

    @Override
    public void triggerIncomingSMS(String string2) {
    }

    @Override
    public void triggerIncomingUssd(String string2, String string3) {
        if (this.mUSSDRegistrant != null) {
            String[] stringArray = new String[]{string2, string3};
            this.mUSSDRegistrant.notifyResult(stringArray);
        }
    }

    @Override
    public void triggerRing(String string2) {
        this.simulatedCallState.triggerRing(string2);
        this.mCallStateRegistrants.notifyRegistrants();
    }

    @Override
    public void triggerSsn(int n, int n2) {
        SuppServiceNotification suppServiceNotification = new SuppServiceNotification();
        suppServiceNotification.notificationType = n;
        suppServiceNotification.code = n2;
        this.mSsnRegistrant.notifyRegistrant(new AsyncResult(null, suppServiceNotification, null));
    }

    @Override
    public void writeSmsToRuim(int n, String string2, Message message) {
        Log.d(LOG_TAG, "Write SMS to RUIM with status " + n);
        this.unimplemented(message);
    }

    @Override
    public void writeSmsToSim(int n, String string2, String string3, Message message) {
        Log.d(LOG_TAG, "Write SMS to SIM with status " + n);
        this.unimplemented(message);
    }

    private static final class SimFdnState
    extends Enum<SimFdnState> {
        private static final /* synthetic */ SimFdnState[] $VALUES;
        public static final /* enum */ SimFdnState NONE = new SimFdnState();
        public static final /* enum */ SimFdnState REQUIRE_PIN2 = new SimFdnState();
        public static final /* enum */ SimFdnState REQUIRE_PUK2 = new SimFdnState();
        public static final /* enum */ SimFdnState SIM_PERM_LOCKED = new SimFdnState();

        static {
            SimFdnState[] simFdnStateArray = new SimFdnState[]{NONE, REQUIRE_PIN2, REQUIRE_PUK2, SIM_PERM_LOCKED};
            $VALUES = simFdnStateArray;
        }

        public static SimFdnState valueOf(String string2) {
            return Enum.valueOf(SimFdnState.class, string2);
        }

        public static SimFdnState[] values() {
            return (SimFdnState[])$VALUES.clone();
        }
    }

    private static final class SimLockState
    extends Enum<SimLockState> {
        private static final /* synthetic */ SimLockState[] $VALUES;
        public static final /* enum */ SimLockState NONE = new SimLockState();
        public static final /* enum */ SimLockState REQUIRE_PIN = new SimLockState();
        public static final /* enum */ SimLockState REQUIRE_PUK = new SimLockState();
        public static final /* enum */ SimLockState SIM_PERM_LOCKED = new SimLockState();

        static {
            SimLockState[] simLockStateArray = new SimLockState[]{NONE, REQUIRE_PIN, REQUIRE_PUK, SIM_PERM_LOCKED};
            $VALUES = simLockStateArray;
        }

        public static SimLockState valueOf(String string2) {
            return Enum.valueOf(SimLockState.class, string2);
        }

        public static SimLockState[] values() {
            return (SimLockState[])$VALUES.clone();
        }
    }
}

