/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.test;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.telephony.PhoneNumberUtils;
import android.util.Log;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.test.CallInfo;
import com.android.internal.telephony.test.InvalidStateEx;
import java.util.ArrayList;
import java.util.List;

class SimulatedGsmCallState
extends Handler {
    static final int CONNECTING_PAUSE_MSEC = 500;
    static final int EVENT_PROGRESS_CALL_STATE = 1;
    static final int MAX_CALLS = 7;
    private boolean autoProgressConnecting = true;
    CallInfo[] calls = new CallInfo[7];
    private boolean nextDialFailImmediately;

    public SimulatedGsmCallState(Looper looper) {
        super(looper);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int countActiveLines() throws InvalidStateEx {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        for (int i = 0; i < this.calls.length; ++i) {
            CallInfo callInfo = this.calls[i];
            if (callInfo == null) continue;
            if (!bl && callInfo.isMpty) {
                bl6 = callInfo.state == CallInfo.State.HOLDING;
            } else {
                if (callInfo.isMpty && bl6 && callInfo.state == CallInfo.State.ACTIVE) {
                    Log.e("ModelInterpreter", "Invalid state");
                    throw new InvalidStateEx();
                }
                if (!callInfo.isMpty && bl && bl6 && callInfo.state == CallInfo.State.HOLDING) {
                    Log.e("ModelInterpreter", "Invalid state");
                    throw new InvalidStateEx();
                }
            }
            bl |= callInfo.isMpty;
            boolean bl7 = callInfo.state == CallInfo.State.HOLDING;
            bl2 |= bl7;
            boolean bl8 = callInfo.state == CallInfo.State.ACTIVE;
            bl3 |= bl8;
            bl4 |= callInfo.isConnecting();
            bl5 |= callInfo.isRinging();
        }
        int n = 0;
        if (bl2) {
            n = 0 + 1;
        }
        if (bl3) {
            ++n;
        }
        if (bl4) {
            ++n;
        }
        if (bl5) {
            ++n;
        }
        return n;
    }

    public boolean conference() {
        int n = 0;
        for (int i = 0; i < this.calls.length; ++i) {
            CallInfo callInfo = this.calls[i];
            if (callInfo == null) continue;
            ++n;
            if (!callInfo.isConnecting()) continue;
            return false;
        }
        for (int i = 0; i < this.calls.length; ++i) {
            CallInfo callInfo = this.calls[i];
            if (callInfo == null) continue;
            callInfo.state = CallInfo.State.ACTIVE;
            if (n <= 0) continue;
            callInfo.isMpty = true;
        }
        return true;
    }

    public boolean explicitCallTransfer() {
        int n = 0;
        for (int i = 0; i < this.calls.length; ++i) {
            CallInfo callInfo = this.calls[i];
            if (callInfo == null) continue;
            ++n;
            if (!callInfo.isConnecting()) continue;
            return false;
        }
        return this.triggerHangupAll();
    }

    public List<String> getClccLines() {
        ArrayList<String> arrayList = new ArrayList<String>(this.calls.length);
        for (int i = 0; i < this.calls.length; ++i) {
            CallInfo callInfo = this.calls[i];
            if (callInfo == null) continue;
            arrayList.add(callInfo.toCLCCLine(i + 1));
        }
        return arrayList;
    }

    public List<DriverCall> getDriverCalls() {
        ArrayList<DriverCall> arrayList = new ArrayList<DriverCall>(this.calls.length);
        for (int i = 0; i < this.calls.length; ++i) {
            CallInfo callInfo = this.calls[i];
            if (callInfo == null) continue;
            arrayList.add(callInfo.toDriverCall(i + 1));
        }
        Log.d("GSM", "SC< getDriverCalls " + arrayList);
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleMessage(Message message) {
        synchronized (this) {
            switch (message.what) {
                default: {
                    break;
                }
                case 1: {
                    this.progressConnectingCallState();
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onAnswer() {
        synchronized (this) {
            int n = 0;
            while (n < this.calls.length) {
                CallInfo callInfo = this.calls[n];
                if (callInfo != null) {
                    if (callInfo.state == CallInfo.State.INCOMING) return this.switchActiveAndHeldOrWaiting();
                    if (callInfo.state == CallInfo.State.WAITING) {
                        return this.switchActiveAndHeldOrWaiting();
                    }
                }
                ++n;
            }
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onChld(char c, char c2) {
        int n = 0;
        if (c2 != '\u0000') {
            n = c2 - 49;
            if (n < 0) return false;
            if (n >= this.calls.length) {
                return false;
            }
        }
        switch (c) {
            default: {
                return false;
            }
            case '0': {
                return this.releaseHeldOrUDUB();
            }
            case '1': {
                if (c2 <= '\u0000') {
                    return this.releaseActiveAcceptHeldOrWaiting();
                }
                if (this.calls[n] == null) {
                    return false;
                }
                this.calls[n] = null;
                return true;
            }
            case '2': {
                if (c2 > '\u0000') return this.separateCall(n);
                return this.switchActiveAndHeldOrWaiting();
            }
            case '3': {
                return this.conference();
            }
            case '4': {
                return this.explicitCallTransfer();
            }
            case '5': 
        }
        return false;
    }

    public boolean onDial(String string2) {
        int n = -1;
        Log.d("GSM", "SC> dial '" + string2 + "'");
        if (this.nextDialFailImmediately) {
            this.nextDialFailImmediately = false;
            Log.d("GSM", "SC< dial fail (per request)");
            return false;
        }
        String string3 = PhoneNumberUtils.extractNetworkPortion(string2);
        if (string3.length() == 0) {
            Log.d("GSM", "SC< dial fail (invalid ph num)");
            return false;
        }
        if (string3.startsWith("*99") && string3.endsWith("#")) {
            Log.d("GSM", "SC< dial ignored (gprs)");
            return true;
        }
        try {
            if (this.countActiveLines() > 1) {
                Log.d("GSM", "SC< dial fail (invalid call state)");
                return false;
            }
        }
        catch (InvalidStateEx invalidStateEx) {
            Log.d("GSM", "SC< dial fail (invalid call state)");
            return false;
        }
        for (int i = 0; i < this.calls.length; ++i) {
            if (n < 0 && this.calls[i] == null) {
                n = i;
            }
            if (this.calls[i] != null && !this.calls[i].isActiveOrHeld()) {
                Log.d("GSM", "SC< dial fail (invalid call state)");
                return false;
            }
            if (this.calls[i] == null || this.calls[i].state != CallInfo.State.ACTIVE) continue;
            this.calls[i].state = CallInfo.State.HOLDING;
        }
        if (n < 0) {
            Log.d("GSM", "SC< dial fail (invalid call state)");
            return false;
        }
        this.calls[n] = CallInfo.createOutgoingCall(string3);
        if (this.autoProgressConnecting) {
            this.sendMessageDelayed(this.obtainMessage(1, this.calls[n]), 500L);
        }
        Log.d("GSM", "SC< dial (slot = " + n + ")");
        return true;
    }

    public boolean onHangup() {
        boolean bl = false;
        for (int i = 0; i < this.calls.length; ++i) {
            CallInfo callInfo = this.calls[i];
            if (callInfo == null || callInfo.state == CallInfo.State.WAITING) continue;
            this.calls[i] = null;
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void progressConnectingCallState() {
        synchronized (this) {
            int n = 0;
            while (true) {
                block10: {
                    block8: {
                        CallInfo callInfo;
                        block9: {
                            if (n >= this.calls.length) break block8;
                            callInfo = this.calls[n];
                            if (callInfo == null || callInfo.state != CallInfo.State.DIALING) break block9;
                            callInfo.state = CallInfo.State.ALERTING;
                            if (this.autoProgressConnecting) {
                                this.sendMessageDelayed(this.obtainMessage(1, callInfo), 500L);
                            }
                            break block8;
                        }
                        if (callInfo == null || callInfo.state != CallInfo.State.ALERTING) break block10;
                        callInfo.state = CallInfo.State.ACTIVE;
                    }
                    return;
                }
                ++n;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void progressConnectingToActive() {
        synchronized (this) {
            int n = 0;
            while (true) {
                block6: {
                    block5: {
                        if (n >= this.calls.length) break block5;
                        CallInfo callInfo = this.calls[n];
                        if (callInfo == null || callInfo.state != CallInfo.State.DIALING && callInfo.state != CallInfo.State.ALERTING) break block6;
                        callInfo.state = CallInfo.State.ACTIVE;
                    }
                    return;
                }
                ++n;
            }
        }
    }

    public boolean releaseActiveAcceptHeldOrWaiting() {
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < this.calls.length; ++i) {
            CallInfo callInfo = this.calls[i];
            if (callInfo == null || callInfo.state != CallInfo.State.ACTIVE) continue;
            this.calls[i] = null;
            bl2 = true;
        }
        if (!bl2) {
            for (int i = 0; i < this.calls.length; ++i) {
                CallInfo callInfo = this.calls[i];
                if (callInfo == null || callInfo.state != CallInfo.State.DIALING && callInfo.state != CallInfo.State.ALERTING) continue;
                this.calls[i] = null;
            }
        }
        for (int i = 0; i < this.calls.length; ++i) {
            CallInfo callInfo = this.calls[i];
            if (callInfo == null || callInfo.state != CallInfo.State.HOLDING) continue;
            callInfo.state = CallInfo.State.ACTIVE;
            bl = true;
        }
        if (bl) {
            return true;
        }
        for (int i = 0; i < this.calls.length; ++i) {
            CallInfo callInfo = this.calls[i];
            if (callInfo == null || !callInfo.isRinging()) continue;
            callInfo.state = CallInfo.State.ACTIVE;
            return true;
        }
        return true;
    }

    public boolean releaseHeldOrUDUB() {
        int n = 0;
        while (true) {
            block4: {
                boolean bl;
                block3: {
                    int n2 = this.calls.length;
                    bl = false;
                    if (n >= n2) break block3;
                    CallInfo callInfo = this.calls[n];
                    if (callInfo == null || !callInfo.isRinging()) break block4;
                    bl = true;
                    this.calls[n] = null;
                }
                if (bl) break;
                for (int i = 0; i < this.calls.length; ++i) {
                    CallInfo callInfo = this.calls[i];
                    if (callInfo == null || callInfo.state != CallInfo.State.HOLDING) continue;
                    this.calls[i] = null;
                }
                break;
            }
            ++n;
        }
        return true;
    }

    public boolean separateCall(int n) {
        block10: {
            int n2;
            CallInfo callInfo = this.calls[n];
            if (callInfo == null) break block10;
            try {
                if (callInfo.isConnecting() || this.countActiveLines() != 1) break block10;
                callInfo.state = CallInfo.State.ACTIVE;
                callInfo.isMpty = false;
                n2 = 0;
            }
            catch (InvalidStateEx invalidStateEx) {
                return false;
            }
            while (true) {
                int n3;
                block11: {
                    if (n2 >= this.calls.length) break;
                    n3 = 0;
                    int n4 = 0;
                    if (n2 == n) break block11;
                    CallInfo callInfo2 = this.calls[n2];
                    n3 = 0;
                    n4 = 0;
                    if (callInfo2 == null) break block11;
                    CallInfo.State state = callInfo2.state;
                    CallInfo.State state2 = CallInfo.State.ACTIVE;
                    n3 = 0;
                    n4 = 0;
                    if (state != state2) break block11;
                    callInfo2.state = CallInfo.State.HOLDING;
                    n3 = 0 + 1;
                    n4 = n2;
                }
                if (n3 == 1) {
                    this.calls[n4].isMpty = false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public void setAutoProgressConnectingCall(boolean bl) {
        this.autoProgressConnecting = bl;
    }

    public void setNextDialFailImmediately(boolean bl) {
        this.nextDialFailImmediately = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean switchActiveAndHeldOrWaiting() {
        boolean bl;
        int n = 0;
        while (true) {
            int n2 = this.calls.length;
            bl = false;
            if (n >= n2) break;
            CallInfo callInfo = this.calls[n];
            if (callInfo != null && callInfo.state == CallInfo.State.HOLDING) {
                bl = true;
                break;
            }
            ++n;
        }
        int n3 = 0;
        while (n3 < this.calls.length) {
            CallInfo callInfo = this.calls[n3];
            if (callInfo != null) {
                if (callInfo.state == CallInfo.State.ACTIVE) {
                    callInfo.state = CallInfo.State.HOLDING;
                } else if (callInfo.state == CallInfo.State.HOLDING) {
                    callInfo.state = CallInfo.State.ACTIVE;
                } else if (!bl && callInfo.isRinging()) {
                    callInfo.state = CallInfo.State.ACTIVE;
                }
            }
            ++n3;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean triggerHangupAll() {
        synchronized (this) {
            boolean bl = false;
            int n = 0;
            while (n < this.calls.length) {
                CallInfo cfr_ignored_0 = this.calls[n];
                if (this.calls[n] != null) {
                    bl = true;
                }
                this.calls[n] = null;
                ++n;
            }
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean triggerHangupBackground() {
        synchronized (this) {
            boolean bl = false;
            int n = 0;
            while (n < this.calls.length) {
                CallInfo callInfo = this.calls[n];
                if (callInfo != null && callInfo.state == CallInfo.State.HOLDING) {
                    this.calls[n] = null;
                    bl = true;
                }
                ++n;
            }
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean triggerHangupForeground() {
        synchronized (this) {
            boolean bl = false;
            for (int i = 0; i < this.calls.length; ++i) {
                CallInfo callInfo = this.calls[i];
                if (callInfo == null || callInfo.state != CallInfo.State.INCOMING && callInfo.state != CallInfo.State.WAITING) continue;
                this.calls[i] = null;
                bl = true;
            }
            int n = 0;
            while (n < this.calls.length) {
                CallInfo callInfo = this.calls[n];
                if (callInfo != null && (callInfo.state == CallInfo.State.DIALING || callInfo.state == CallInfo.State.ACTIVE || callInfo.state == CallInfo.State.ALERTING)) {
                    this.calls[n] = null;
                    bl = true;
                }
                ++n;
            }
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean triggerRing(String string2) {
        synchronized (this) {
            int n = -1;
            boolean bl = false;
            int n2 = 0;
            while (true) {
                block9: {
                    CallInfo callInfo;
                    block10: {
                        block7: {
                            block8: {
                                if (n2 >= this.calls.length) break block7;
                                callInfo = this.calls[n2];
                                if (callInfo != null || n >= 0) break block8;
                                n = n2;
                                break block9;
                            }
                            if (callInfo != null && (callInfo.state == CallInfo.State.INCOMING || callInfo.state == CallInfo.State.WAITING)) {
                                Log.w("ModelInterpreter", "triggerRing failed; phone already ringing");
                                return false;
                            }
                            break block10;
                        }
                        if (n < 0) {
                            Log.w("ModelInterpreter", "triggerRing failed; all full");
                            return false;
                        }
                        this.calls[n] = CallInfo.createIncomingCall(PhoneNumberUtils.extractNetworkPortion(string2));
                        if (bl) {
                            this.calls[n].state = CallInfo.State.WAITING;
                        }
                        return true;
                    }
                    if (callInfo != null) {
                        bl = true;
                    }
                }
                ++n2;
            }
        }
    }
}

