/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import java.lang.reflect.Array;

public class ArrayUtils {
    private static final int CACHE_SIZE = 73;
    private static Object[] EMPTY = new Object[0];
    private static Object[] sCache = new Object[73];

    private ArrayUtils() {
    }

    public static <T> boolean contains(T[] TArray, T t) {
        for (T t2 : TArray) {
            if (!(t2 == null ? t == null : t != null && t2.equals(t))) continue;
            return true;
        }
        return false;
    }

    public static <T> T[] emptyArray(Class<T> clazz) {
        if (clazz == Object.class) {
            return EMPTY;
        }
        int n = (Integer.MAX_VALUE & System.identityHashCode(clazz) / 8) % 73;
        Object object = sCache[n];
        if (object == null || object.getClass().getComponentType() != clazz) {
            ArrayUtils.sCache[n] = object = Array.newInstance(clazz, 0);
        }
        return (Object[])object;
    }

    public static boolean equals(byte[] byArray, byte[] byArray2, int n) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null || byArray2 == null || byArray.length < n || byArray2.length < n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static int idealBooleanArraySize(int n) {
        return ArrayUtils.idealByteArraySize(n);
    }

    public static int idealByteArraySize(int n) {
        for (int i = 4; i < 32; ++i) {
            if (n > (1 << i) - 12) continue;
            return (1 << i) - 12;
        }
        return n;
    }

    public static int idealCharArraySize(int n) {
        return ArrayUtils.idealByteArraySize(n * 2) / 2;
    }

    public static int idealFloatArraySize(int n) {
        return ArrayUtils.idealByteArraySize(n * 4) / 4;
    }

    public static int idealIntArraySize(int n) {
        return ArrayUtils.idealByteArraySize(n * 4) / 4;
    }

    public static int idealLongArraySize(int n) {
        return ArrayUtils.idealByteArraySize(n * 8) / 8;
    }

    public static int idealObjectArraySize(int n) {
        return ArrayUtils.idealByteArraySize(n * 4) / 4;
    }

    public static int idealShortArraySize(int n) {
        return ArrayUtils.idealByteArraySize(n * 2) / 2;
    }
}

