/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

public class BitwiseOutputStream {
    private byte[] mBuf;
    private int mEnd;
    private int mPos;

    public BitwiseOutputStream(int n) {
        this.mBuf = new byte[n];
        this.mEnd = n << 3;
        this.mPos = 0;
    }

    private void possExpand(int n) {
        if (n + this.mPos < this.mEnd) {
            return;
        }
        byte[] byArray = new byte[n + this.mPos >>> 2];
        System.arraycopy(this.mBuf, 0, byArray, 0, this.mEnd >>> 3);
        this.mBuf = byArray;
    }

    public void skip(int n) {
        this.possExpand(n);
        this.mPos = n + this.mPos;
    }

    /*
     * Enabled aggressive block sorting
     */
    public byte[] toByteArray() {
        int n = this.mPos >>> 3;
        int n2 = (7 & this.mPos) > 0 ? 1 : 0;
        int n3 = n + n2;
        byte[] byArray = new byte[n3];
        System.arraycopy(this.mBuf, 0, byArray, 0, n3);
        return byArray;
    }

    public void write(int n, int n2) throws AccessException {
        if (n < 0 || n > 8) {
            throw new AccessException("illegal write (" + n + " bits)");
        }
        this.possExpand(n);
        int n3 = n2 & -1 >>> 32 - n;
        int n4 = this.mPos >>> 3;
        int n5 = 16 - (7 & this.mPos) - n;
        int n6 = n3 << n5;
        this.mPos = n + this.mPos;
        byte[] byArray = this.mBuf;
        byArray[n4] = (byte)(byArray[n4] | n6 >>> 8);
        if (n5 < 8) {
            byte[] byArray2 = this.mBuf;
            int n7 = n4 + 1;
            byArray2[n7] = (byte)(byArray2[n7] | n6 & 0xFF);
        }
    }

    public void writeByteArray(int n, byte[] byArray) throws AccessException {
        for (int i = 0; i < byArray.length; ++i) {
            int n2 = Math.min(8, n - (i << 3));
            if (n2 <= 0) continue;
            this.write(n2, (byte)(byArray[i] >>> 8 - n2));
        }
    }

    public static class AccessException
    extends Exception {
        public AccessException(String string2) {
            super("BitwiseOutputStream access failed: " + string2);
        }
    }
}

