/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.android.internal.util.HierarchicalState;
import com.android.internal.util.ProcessedMessages;
import java.util.ArrayList;
import java.util.HashMap;

public class HierarchicalStateMachine {
    public static final boolean HANDLED = true;
    public static final int HSM_INIT_CMD = -1;
    public static final int HSM_QUIT_CMD = -1;
    public static final boolean NOT_HANDLED = false;
    private static final String TAG = "HierarchicalStateMachine";
    private HsmHandler mHsmHandler;
    private HandlerThread mHsmThread;
    private String mName;

    protected HierarchicalStateMachine(String string2) {
        this.mHsmThread = new HandlerThread(string2);
        this.mHsmThread.start();
        this.initStateMachine(string2, this.mHsmThread.getLooper());
    }

    protected HierarchicalStateMachine(String string2, Looper looper) {
        this.initStateMachine(string2, looper);
    }

    private void initStateMachine(String string2, Looper looper) {
        this.mName = string2;
        this.mHsmHandler = new HsmHandler(looper, this);
    }

    protected final void addState(HierarchicalState hierarchicalState) {
        this.mHsmHandler.addState(hierarchicalState, null);
    }

    protected final void addState(HierarchicalState hierarchicalState, HierarchicalState hierarchicalState2) {
        this.mHsmHandler.addState(hierarchicalState, hierarchicalState2);
    }

    protected final void deferMessage(Message message) {
        this.mHsmHandler.deferMessage(message);
    }

    protected final Message getCurrentMessage() {
        return this.mHsmHandler.getCurrentMessage();
    }

    protected final HierarchicalState getCurrentState() {
        return this.mHsmHandler.getCurrentState();
    }

    public final Handler getHandler() {
        return this.mHsmHandler;
    }

    public final String getName() {
        return this.mName;
    }

    public final ProcessedMessages.Info getProcessedMessage(int n) {
        return this.mHsmHandler.getProcessedMessage(n);
    }

    public final int getProcessedMessagesCount() {
        return this.mHsmHandler.getProcessedMessagesCount();
    }

    public final int getProcessedMessagesSize() {
        return this.mHsmHandler.getProcessedMessagesSize();
    }

    protected void haltedProcessMessage(Message message) {
    }

    protected void halting() {
    }

    public boolean isDbg() {
        return this.mHsmHandler.isDbg();
    }

    protected final boolean isQuit(Message message) {
        return this.mHsmHandler.isQuit(message);
    }

    public final Message obtainMessage() {
        return Message.obtain(this.mHsmHandler);
    }

    public final Message obtainMessage(int n) {
        return Message.obtain((Handler)this.mHsmHandler, n);
    }

    public final Message obtainMessage(int n, Object object) {
        return Message.obtain(this.mHsmHandler, n, object);
    }

    public final void quit() {
        this.mHsmHandler.quit();
    }

    protected void quitting() {
    }

    public final void sendMessage(int n) {
        this.mHsmHandler.sendMessage(this.obtainMessage(n));
    }

    public final void sendMessage(int n, Object object) {
        this.mHsmHandler.sendMessage(this.obtainMessage(n, object));
    }

    public final void sendMessage(Message message) {
        this.mHsmHandler.sendMessage(message);
    }

    protected final void sendMessageAtFrontOfQueue(int n) {
        this.mHsmHandler.sendMessageAtFrontOfQueue(this.obtainMessage(n));
    }

    protected final void sendMessageAtFrontOfQueue(int n, Object object) {
        this.mHsmHandler.sendMessageAtFrontOfQueue(this.obtainMessage(n, object));
    }

    protected final void sendMessageAtFrontOfQueue(Message message) {
        this.mHsmHandler.sendMessageAtFrontOfQueue(message);
    }

    public final void sendMessageDelayed(int n, long l) {
        this.mHsmHandler.sendMessageDelayed(this.obtainMessage(n), l);
    }

    public final void sendMessageDelayed(int n, Object object, long l) {
        this.mHsmHandler.sendMessageDelayed(this.obtainMessage(n, object), l);
    }

    public final void sendMessageDelayed(Message message, long l) {
        this.mHsmHandler.sendMessageDelayed(message, l);
    }

    public void setDbg(boolean bl) {
        this.mHsmHandler.setDbg(bl);
    }

    protected final void setInitialState(HierarchicalState hierarchicalState) {
        this.mHsmHandler.setInitialState(hierarchicalState);
    }

    public final void setProcessedMessagesSize(int n) {
        this.mHsmHandler.setProcessedMessagesSize(n);
    }

    public void start() {
        this.mHsmHandler.completeConstruction();
    }

    protected final void transitionTo(HierarchicalState hierarchicalState) {
        this.mHsmHandler.transitionTo(hierarchicalState);
    }

    protected final void transitionToHaltingState() {
        this.mHsmHandler.transitionTo(this.mHsmHandler.mHaltingState);
    }

    protected void unhandledMessage(Message message) {
    }

    private static class HsmHandler
    extends Handler {
        private static final Message mInitMsg;
        private static final Object mQuitObj;
        private boolean mDbg = false;
        private ArrayList<Message> mDeferredMessages;
        private HierarchicalState mDestState;
        private HaltingState mHaltingState;
        private HierarchicalStateMachine mHsm;
        private HierarchicalState mInitialState;
        private boolean mIsConstructionCompleted;
        private Message mMsg;
        private ProcessedMessages mProcessedMessages = new ProcessedMessages();
        private QuittingState mQuittingState;
        private HashMap<HierarchicalState, StateInfo> mStateInfo;
        private StateInfo[] mStateStack;
        private int mStateStackTopIndex = -1;
        private StateInfo[] mTempStateStack;
        private int mTempStateStackCount;

        static {
            mQuitObj = new Object();
            mInitMsg = null;
        }

        private HsmHandler(Looper looper, HierarchicalStateMachine hierarchicalStateMachine) {
            super(looper);
            this.mHaltingState = new HaltingState();
            this.mQuittingState = new QuittingState();
            this.mStateInfo = new HashMap();
            this.mDeferredMessages = new ArrayList();
            this.mHsm = hierarchicalStateMachine;
            this.addState(this.mHaltingState, null);
            this.addState(this.mQuittingState, null);
        }

        /*
         * Enabled aggressive block sorting
         */
        private final StateInfo addState(HierarchicalState hierarchicalState, HierarchicalState hierarchicalState2) {
            StateInfo stateInfo;
            if (this.mDbg) {
                StringBuilder stringBuilder = new StringBuilder().append("addStateInternal: E state=").append(hierarchicalState.getName()).append(",parent=");
                String string2 = hierarchicalState2 == null ? "" : hierarchicalState2.getName();
                Log.d(HierarchicalStateMachine.TAG, stringBuilder.append(string2).toString());
            }
            StateInfo stateInfo2 = null;
            if (hierarchicalState2 != null && (stateInfo2 = this.mStateInfo.get(hierarchicalState2)) == null) {
                stateInfo2 = this.addState(hierarchicalState2, null);
            }
            if ((stateInfo = this.mStateInfo.get(hierarchicalState)) == null) {
                stateInfo = new StateInfo();
                this.mStateInfo.put(hierarchicalState, stateInfo);
            }
            if (stateInfo.parentStateInfo != null && stateInfo.parentStateInfo != stateInfo2) {
                throw new RuntimeException("state already added");
            }
            stateInfo.state = hierarchicalState;
            stateInfo.parentStateInfo = stateInfo2;
            stateInfo.active = false;
            if (this.mDbg) {
                Log.d(HierarchicalStateMachine.TAG, "addStateInternal: X stateInfo: " + stateInfo);
            }
            return stateInfo;
        }

        private final void completeConstruction() {
            if (this.mDbg) {
                Log.d(HierarchicalStateMachine.TAG, "completeConstruction: E");
            }
            int n = 0;
            for (StateInfo stateInfo : this.mStateInfo.values()) {
                int n2 = 0;
                StateInfo stateInfo2 = stateInfo;
                while (stateInfo2 != null) {
                    stateInfo2 = stateInfo2.parentStateInfo;
                    ++n2;
                }
                if (n >= n2) continue;
                n = n2;
            }
            if (this.mDbg) {
                Log.d(HierarchicalStateMachine.TAG, "completeConstruction: maxDepth=" + n);
            }
            this.mStateStack = new StateInfo[n];
            this.mTempStateStack = new StateInfo[n];
            this.setupInitialStateStack();
            this.mIsConstructionCompleted = true;
            this.mMsg = this.obtainMessage(-1);
            this.invokeEnterMethods(0);
            this.performTransitions();
            if (this.mDbg) {
                Log.d(HierarchicalStateMachine.TAG, "completeConstruction: X");
            }
        }

        private final void deferMessage(Message message) {
            if (this.mDbg) {
                Log.d(HierarchicalStateMachine.TAG, "deferMessage: msg=" + message.what);
            }
            Message message2 = this.obtainMessage();
            message2.copyFrom(message);
            this.mDeferredMessages.add(message2);
        }

        private final Message getCurrentMessage() {
            return this.mMsg;
        }

        private final HierarchicalState getCurrentState() {
            return this.mStateStack[this.mStateStackTopIndex].state;
        }

        private final ProcessedMessages.Info getProcessedMessage(int n) {
            return this.mProcessedMessages.get(n);
        }

        private final int getProcessedMessagesCount() {
            return this.mProcessedMessages.count();
        }

        private final int getProcessedMessagesSize() {
            return this.mProcessedMessages.size();
        }

        private final void invokeEnterMethods(int n) {
            for (int i = n; i <= this.mStateStackTopIndex; ++i) {
                if (this.mDbg) {
                    Log.d(HierarchicalStateMachine.TAG, "invokeEnterMethods: " + this.mStateStack[i].state.getName());
                }
                this.mStateStack[i].state.enter();
                this.mStateStack[i].active = true;
            }
        }

        private final void invokeExitMethods(StateInfo stateInfo) {
            while (this.mStateStackTopIndex >= 0 && this.mStateStack[this.mStateStackTopIndex] != stateInfo) {
                HierarchicalState hierarchicalState = this.mStateStack[this.mStateStackTopIndex].state;
                if (this.mDbg) {
                    Log.d(HierarchicalStateMachine.TAG, "invokeExitMethods: " + hierarchicalState.getName());
                }
                hierarchicalState.exit();
                this.mStateStack[this.mStateStackTopIndex].active = false;
                --this.mStateStackTopIndex;
            }
        }

        private final boolean isDbg() {
            return this.mDbg;
        }

        private final boolean isQuit(Message message) {
            return message.what == -1 && message.obj == mQuitObj;
        }

        private final void moveDeferredMessageAtFrontOfQueue() {
            for (int i = this.mDeferredMessages.size() - 1; i >= 0; --i) {
                Message message = this.mDeferredMessages.get(i);
                if (this.mDbg) {
                    Log.d(HierarchicalStateMachine.TAG, "moveDeferredMessageAtFrontOfQueue; what=" + message.what);
                }
                this.sendMessageAtFrontOfQueue(message);
            }
            this.mDeferredMessages.clear();
        }

        private final int moveTempStateStackToStateStack() {
            int n = 1 + this.mStateStackTopIndex;
            int n2 = n;
            for (int i = this.mTempStateStackCount - 1; i >= 0; --i) {
                if (this.mDbg) {
                    Log.d(HierarchicalStateMachine.TAG, "moveTempStackToStateStack: i=" + i + ",j=" + n2);
                }
                this.mStateStack[n2] = this.mTempStateStack[i];
                ++n2;
            }
            this.mStateStackTopIndex = n2 - 1;
            if (this.mDbg) {
                Log.d(HierarchicalStateMachine.TAG, "moveTempStackToStateStack: X mStateStackTop=" + this.mStateStackTopIndex + ",startingIndex=" + n + ",Top=" + this.mStateStack[this.mStateStackTopIndex].state.getName());
            }
            return n;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void performTransitions() {
            HierarchicalState hierarchicalState = null;
            while (this.mDestState != null) {
                if (this.mDbg) {
                    Log.d(HierarchicalStateMachine.TAG, "handleMessage: new destination call exit");
                }
                hierarchicalState = this.mDestState;
                this.mDestState = null;
                this.invokeExitMethods(this.setupTempStateStackWithStatesToEnter(hierarchicalState));
                this.invokeEnterMethods(this.moveTempStateStackToStateStack());
                this.moveDeferredMessageAtFrontOfQueue();
            }
            if (hierarchicalState == null) return;
            if (hierarchicalState == this.mQuittingState) {
                this.mHsm.quitting();
                if (this.mHsm.mHsmThread == null) return;
                this.getLooper().quit();
                return;
            }
            if (hierarchicalState != this.mHaltingState) return;
            this.mHsm.halting();
        }

        private final void processMsg(Message message) {
            StateInfo stateInfo = this.mStateStack[this.mStateStackTopIndex];
            if (this.mDbg) {
                Log.d(HierarchicalStateMachine.TAG, "processMsg: " + stateInfo.state.getName());
            }
            while (true) {
                block7: {
                    block6: {
                        if (stateInfo.state.processMessage(message)) break block6;
                        stateInfo = stateInfo.parentStateInfo;
                        if (stateInfo != null) break block7;
                        this.mHsm.unhandledMessage(message);
                        if (this.isQuit(message)) {
                            this.transitionTo(this.mQuittingState);
                        }
                    }
                    if (stateInfo == null) break;
                    HierarchicalState hierarchicalState = this.mStateStack[this.mStateStackTopIndex].state;
                    this.mProcessedMessages.add(message, stateInfo.state, hierarchicalState);
                    return;
                }
                if (!this.mDbg) continue;
                Log.d(HierarchicalStateMachine.TAG, "processMsg: " + stateInfo.state.getName());
            }
            this.mProcessedMessages.add(message, null, null);
        }

        private final void quit() {
            if (this.mDbg) {
                Log.d(HierarchicalStateMachine.TAG, "quit:");
            }
            this.sendMessage(this.obtainMessage(-1, mQuitObj));
        }

        private final void setDbg(boolean bl) {
            this.mDbg = bl;
        }

        private final void setInitialState(HierarchicalState hierarchicalState) {
            if (this.mDbg) {
                Log.d(HierarchicalStateMachine.TAG, "setInitialState: initialState" + hierarchicalState.getName());
            }
            this.mInitialState = hierarchicalState;
        }

        private final void setProcessedMessagesSize(int n) {
            this.mProcessedMessages.setSize(n);
        }

        private final void setupInitialStateStack() {
            if (this.mDbg) {
                Log.d(HierarchicalStateMachine.TAG, "setupInitialStateStack: E mInitialState=" + this.mInitialState.getName());
            }
            StateInfo stateInfo = this.mStateInfo.get(this.mInitialState);
            this.mTempStateStackCount = 0;
            while (stateInfo != null) {
                this.mTempStateStack[this.mTempStateStackCount] = stateInfo;
                stateInfo = stateInfo.parentStateInfo;
                this.mTempStateStackCount = 1 + this.mTempStateStackCount;
            }
            this.mStateStackTopIndex = -1;
            this.moveTempStateStackToStateStack();
        }

        private final StateInfo setupTempStateStackWithStatesToEnter(HierarchicalState hierarchicalState) {
            this.mTempStateStackCount = 0;
            StateInfo stateInfo = this.mStateInfo.get(hierarchicalState);
            do {
                StateInfo[] stateInfoArray = this.mTempStateStack;
                int n = this.mTempStateStackCount;
                this.mTempStateStackCount = n + 1;
                stateInfoArray[n] = stateInfo;
            } while ((stateInfo = stateInfo.parentStateInfo) != null && !stateInfo.active);
            if (this.mDbg) {
                Log.d(HierarchicalStateMachine.TAG, "setupTempStateStackWithStatesToEnter: X mTempStateStackCount=" + this.mTempStateStackCount + ",curStateInfo: " + stateInfo);
            }
            return stateInfo;
        }

        private final void transitionTo(HierarchicalState hierarchicalState) {
            if (this.mDbg) {
                Log.d(HierarchicalStateMachine.TAG, "StateMachine.transitionTo EX destState" + hierarchicalState.getName());
            }
            this.mDestState = hierarchicalState;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public final void handleMessage(Message message) {
            if (this.mDbg) {
                Log.d(HierarchicalStateMachine.TAG, "handleMessage: E msg.what=" + message.what);
            }
            this.mMsg = message;
            if (!this.mIsConstructionCompleted) {
                Log.e(HierarchicalStateMachine.TAG, "The start method not called, ignore msg: " + message);
                return;
            } else {
                this.processMsg(message);
                this.performTransitions();
                if (!this.mDbg) return;
                Log.d(HierarchicalStateMachine.TAG, "handleMessage: X");
                return;
            }
        }

        private class HaltingState
        extends HierarchicalState {
            private HaltingState() {
            }

            @Override
            public boolean processMessage(Message message) {
                HsmHandler.this.mHsm.haltedProcessMessage(message);
                return true;
            }
        }

        private class QuittingState
        extends HierarchicalState {
            private QuittingState() {
            }

            @Override
            public boolean processMessage(Message message) {
                return false;
            }
        }

        private class StateInfo {
            boolean active;
            StateInfo parentStateInfo;
            HierarchicalState state;

            private StateInfo() {
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public String toString() {
                String string2;
                StringBuilder stringBuilder = new StringBuilder().append("state=").append(this.state.getName()).append(",active=").append(this.active).append(",parent=");
                if (this.parentStateInfo == null) {
                    string2 = "null";
                    return stringBuilder.append(string2).toString();
                }
                string2 = this.parentStateInfo.state.getName();
                return stringBuilder.append(string2).toString();
            }
        }
    }
}

