/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import java.io.File;
import java.io.IOException;

public class JournaledFile {
    File mReal;
    File mTemp;
    boolean mWriting;

    public JournaledFile(File file, File file2) {
        this.mReal = file;
        this.mTemp = file2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public File chooseForRead() {
        File file;
        if (this.mReal.exists()) {
            file = this.mReal;
            if (this.mTemp.exists()) {
                this.mTemp.delete();
            }
            return file;
        }
        if (!this.mTemp.exists()) return this.mReal;
        file = this.mTemp;
        this.mTemp.renameTo(this.mReal);
        return file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File chooseForWrite() {
        if (this.mWriting) {
            throw new IllegalStateException("uncommitted write already in progress");
        }
        if (!this.mReal.exists()) {
            try {
                this.mReal.createNewFile();
            }
            catch (IOException iOException) {}
        }
        if (this.mTemp.exists()) {
            this.mTemp.delete();
        }
        this.mWriting = true;
        return this.mTemp;
    }

    public void commit() {
        if (!this.mWriting) {
            throw new IllegalStateException("no file to commit");
        }
        this.mWriting = false;
        this.mTemp.renameTo(this.mReal);
    }

    public void rollback() {
        if (!this.mWriting) {
            throw new IllegalStateException("no file to roll back");
        }
        this.mWriting = false;
        this.mTemp.delete();
    }
}

