/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.os.Message;
import com.android.internal.util.HierarchicalState;
import java.util.Vector;

public class ProcessedMessages {
    public static final int DEFAULT_SIZE = 20;
    private int mCount = 0;
    private int mMaxSize = 20;
    private Vector<Info> mMessages = new Vector();
    private int mOldestIndex = 0;

    ProcessedMessages() {
    }

    ProcessedMessages(int n) {
        this.setSize(n);
    }

    void add(Message message, HierarchicalState hierarchicalState, HierarchicalState hierarchicalState2) {
        this.mCount = 1 + this.mCount;
        if (this.mMessages.size() < this.mMaxSize) {
            this.mMessages.add(new Info(message, hierarchicalState, hierarchicalState2));
            return;
        }
        Info info = this.mMessages.get(this.mOldestIndex);
        this.mOldestIndex = 1 + this.mOldestIndex;
        if (this.mOldestIndex >= this.mMaxSize) {
            this.mOldestIndex = 0;
        }
        info.update(message, hierarchicalState, hierarchicalState2);
    }

    int count() {
        return this.mCount;
    }

    Info get(int n) {
        int n2 = n + this.mOldestIndex;
        if (n2 >= this.mMaxSize) {
            n2 -= this.mMaxSize;
        }
        if (n2 >= this.size()) {
            return null;
        }
        return this.mMessages.get(n2);
    }

    void setSize(int n) {
        this.mMaxSize = n;
        this.mCount = 0;
        this.mMessages.clear();
    }

    int size() {
        return this.mMessages.size();
    }

    public class Info {
        private HierarchicalState orgState;
        private HierarchicalState state;
        private int what;

        Info(Message message, HierarchicalState hierarchicalState, HierarchicalState hierarchicalState2) {
            this.update(message, hierarchicalState, hierarchicalState2);
        }

        private String cn(Object object) {
            if (object == null) {
                return "null";
            }
            String string2 = object.getClass().getName();
            return string2.substring(1 + string2.lastIndexOf(36));
        }

        public HierarchicalState getOriginalState() {
            return this.orgState;
        }

        public HierarchicalState getState() {
            return this.state;
        }

        public int getWhat() {
            return this.what;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("what=");
            stringBuilder.append(this.what);
            stringBuilder.append(" state=");
            stringBuilder.append(this.cn(this.state));
            stringBuilder.append(" orgState=");
            stringBuilder.append(this.cn(this.orgState));
            return stringBuilder.toString();
        }

        public void update(Message message, HierarchicalState hierarchicalState, HierarchicalState hierarchicalState2) {
            this.what = message.what;
            this.state = hierarchicalState;
            this.orgState = hierarchicalState2;
        }
    }
}

