/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class TypedProperties
extends HashMap<String, Object> {
    static final String NULL_STRING = new String("<TypedProperties:NULL_STRING>");
    public static final int STRING_NOT_SET = -1;
    public static final int STRING_NULL = 0;
    public static final int STRING_SET = 1;
    public static final int STRING_TYPE_MISMATCH = -2;
    static final int TYPE_BOOLEAN = 90;
    static final int TYPE_BYTE = 329;
    static final int TYPE_DOUBLE = 2118;
    static final int TYPE_ERROR = -1;
    static final int TYPE_FLOAT = 1094;
    static final int TYPE_INT = 1097;
    static final int TYPE_LONG = 2121;
    static final int TYPE_SHORT = 585;
    static final int TYPE_STRING = 29516;
    static final int TYPE_UNSET = 120;

    static StreamTokenizer initTokenizer(Reader reader) {
        StreamTokenizer streamTokenizer = new StreamTokenizer(reader);
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(48, 57);
        streamTokenizer.wordChars(65, 90);
        streamTokenizer.wordChars(97, 122);
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.wordChars(36, 36);
        streamTokenizer.wordChars(46, 46);
        streamTokenizer.wordChars(45, 45);
        streamTokenizer.wordChars(43, 43);
        streamTokenizer.ordinaryChar(61);
        streamTokenizer.whitespaceChars(32, 32);
        streamTokenizer.whitespaceChars(9, 9);
        streamTokenizer.whitespaceChars(10, 10);
        streamTokenizer.whitespaceChars(13, 13);
        streamTokenizer.quoteChar(34);
        streamTokenizer.slashStarComments(true);
        streamTokenizer.slashSlashComments(true);
        return streamTokenizer;
    }

    static int interpretType(String string2) {
        if ("unset".equals(string2)) {
            return 120;
        }
        if ("boolean".equals(string2)) {
            return 90;
        }
        if ("byte".equals(string2)) {
            return 329;
        }
        if ("short".equals(string2)) {
            return 585;
        }
        if ("int".equals(string2)) {
            return 1097;
        }
        if ("long".equals(string2)) {
            return 2121;
        }
        if ("float".equals(string2)) {
            return 1094;
        }
        if ("double".equals(string2)) {
            return 2118;
        }
        if ("String".equals(string2)) {
            return 29516;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    static void parse(Reader reader, Map<String, Object> map) throws ParseException, IOException {
        StreamTokenizer streamTokenizer = TypedProperties.initTokenizer(reader);
        Pattern pattern = Pattern.compile("([a-zA-Z_$][0-9a-zA-Z_$]*\\.)*[a-zA-Z_$][0-9a-zA-Z_$]*");
        do {
            int n;
            if ((n = streamTokenizer.nextToken()) == -1) {
                return;
            }
            if (n != -3) {
                throw new ParseException(streamTokenizer, "type name");
            }
            int n2 = TypedProperties.interpretType(streamTokenizer.sval);
            if (n2 == -1) {
                throw new ParseException(streamTokenizer, "valid type name");
            }
            streamTokenizer.sval = null;
            if (n2 == 120 && streamTokenizer.nextToken() != 40) {
                throw new ParseException(streamTokenizer, "'('");
            }
            if (streamTokenizer.nextToken() != -3) {
                throw new ParseException(streamTokenizer, "property name");
            }
            String string2 = streamTokenizer.sval;
            if (!pattern.matcher(string2).matches()) {
                throw new ParseException(streamTokenizer, "valid property name");
            }
            streamTokenizer.sval = null;
            if (n2 == 120) {
                if (streamTokenizer.nextToken() != 41) {
                    throw new ParseException(streamTokenizer, "')'");
                }
                map.remove(string2);
                continue;
            }
            if (streamTokenizer.nextToken() != 61) {
                throw new ParseException(streamTokenizer, "'='");
            }
            Object object = TypedProperties.parseValue(streamTokenizer, n2);
            Object object2 = map.remove(string2);
            if (object2 != null && object.getClass() != object2.getClass()) {
                throw new ParseException(streamTokenizer, "(property previously declared as a different type)");
            }
            map.put(string2, object);
        } while (streamTokenizer.nextToken() == 59);
        throw new ParseException(streamTokenizer, "';'");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Object parseValue(StreamTokenizer streamTokenizer, int n) throws IOException {
        int n2 = streamTokenizer.nextToken();
        if (n == 90) {
            if (n2 != -3) {
                throw new ParseException(streamTokenizer, "boolean constant");
            }
            if ("true".equals(streamTokenizer.sval)) {
                return Boolean.TRUE;
            }
            if ("false".equals(streamTokenizer.sval)) {
                return Boolean.FALSE;
            }
            throw new ParseException(streamTokenizer, "boolean constant");
        }
        if ((n & 0xFF) == 73) {
            int n3;
            long l;
            if (n2 != -3) {
                throw new ParseException(streamTokenizer, "integer constant");
            }
            try {
                l = Long.decode(streamTokenizer.sval);
                n3 = 0xFF & n >> 8;
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException(streamTokenizer, "integer constant");
            }
            switch (n3) {
                default: {
                    throw new IllegalStateException("Internal error; unexpected integer type width " + n3);
                }
                case 1: {
                    if (l >= -128L && l <= 127L) {
                        return new Byte((byte)l);
                    }
                    throw new ParseException(streamTokenizer, "8-bit integer constant");
                }
                case 2: {
                    if (l >= -32768L && l <= 32767L) {
                        return new Short((short)l);
                    }
                    throw new ParseException(streamTokenizer, "16-bit integer constant");
                }
                case 4: {
                    if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                        return new Integer((int)l);
                    }
                    throw new ParseException(streamTokenizer, "32-bit integer constant");
                }
                case 8: 
            }
            if (l >= Long.MIN_VALUE && l <= Long.MAX_VALUE) {
                return new Long(l);
            }
            throw new ParseException(streamTokenizer, "64-bit integer constant");
        }
        if ((n & 0xFF) == 70) {
            double d;
            block26: {
                if (n2 != -3) {
                    throw new ParseException(streamTokenizer, "float constant");
                }
                try {
                    d = Double.parseDouble(streamTokenizer.sval);
                    if ((0xFF & n >> 8) != 4) break block26;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParseException(streamTokenizer, "float constant");
                }
                double d2 = Math.abs(d);
                if (d2 != 0.0 && !Double.isInfinite(d) && !Double.isNaN(d) && (d2 < (double)1.4E-45f || d2 > 3.4028234663852886E38)) {
                    throw new ParseException(streamTokenizer, "32-bit float constant");
                }
                return new Float((float)d);
            }
            return new Double(d);
        }
        if (n != 29516) {
            throw new IllegalStateException("Internal error; unknown type " + n);
        }
        if (n2 == 34) {
            return streamTokenizer.sval;
        }
        if (n2 == -3 && "null".equals(streamTokenizer.sval)) {
            return NULL_STRING;
        }
        throw new ParseException(streamTokenizer, "double-quoted string or 'null'");
    }

    @Override
    public Object get(Object object) {
        Object v = super.get(object);
        if (v == NULL_STRING) {
            return null;
        }
        return v;
    }

    public boolean getBoolean(String string2) {
        return this.getBoolean(string2, false);
    }

    public boolean getBoolean(String string2, boolean bl) {
        Object v = super.get(string2);
        if (v == null) {
            return bl;
        }
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        throw new TypeException(string2, v, "boolean");
    }

    public byte getByte(String string2) {
        return this.getByte(string2, (byte)0);
    }

    public byte getByte(String string2, byte by) {
        Object v = super.get(string2);
        if (v == null) {
            return by;
        }
        if (v instanceof Byte) {
            return (Byte)v;
        }
        throw new TypeException(string2, v, "byte");
    }

    public double getDouble(String string2) {
        return this.getDouble(string2, 0.0);
    }

    public double getDouble(String string2, double d) {
        Object v = super.get(string2);
        if (v == null) {
            return d;
        }
        if (v instanceof Double) {
            return (Double)v;
        }
        throw new TypeException(string2, v, "double");
    }

    public float getFloat(String string2) {
        return this.getFloat(string2, 0.0f);
    }

    public float getFloat(String string2, float f) {
        Object v = super.get(string2);
        if (v == null) {
            return f;
        }
        if (v instanceof Float) {
            return ((Float)v).floatValue();
        }
        throw new TypeException(string2, v, "float");
    }

    public int getInt(String string2) {
        return this.getInt(string2, 0);
    }

    public int getInt(String string2, int n) {
        Object v = super.get(string2);
        if (v == null) {
            return n;
        }
        if (v instanceof Integer) {
            return (Integer)v;
        }
        throw new TypeException(string2, v, "int");
    }

    public long getLong(String string2) {
        return this.getLong(string2, 0L);
    }

    public long getLong(String string2, long l) {
        Object v = super.get(string2);
        if (v == null) {
            return l;
        }
        if (v instanceof Long) {
            return (Long)v;
        }
        throw new TypeException(string2, v, "long");
    }

    public short getShort(String string2) {
        return this.getShort(string2, (short)0);
    }

    public short getShort(String string2, short s) {
        Object v = super.get(string2);
        if (v == null) {
            return s;
        }
        if (v instanceof Short) {
            return (Short)v;
        }
        throw new TypeException(string2, v, "short");
    }

    public String getString(String string2) {
        return this.getString(string2, "");
    }

    public String getString(String string2, String string3) {
        Object v = super.get(string2);
        if (v == null) {
            return string3;
        }
        if (v == NULL_STRING) {
            return null;
        }
        if (v instanceof String) {
            return (String)v;
        }
        throw new TypeException(string2, v, "string");
    }

    public int getStringInfo(String string2) {
        Object v = super.get(string2);
        if (v == null) {
            return -1;
        }
        if (v == NULL_STRING) {
            return 0;
        }
        if (v instanceof String) {
            return 1;
        }
        return -2;
    }

    public void load(Reader reader) throws IOException {
        TypedProperties.parse(reader, this);
    }

    public static class ParseException
    extends IllegalArgumentException {
        ParseException(StreamTokenizer streamTokenizer, String string2) {
            super("expected " + string2 + ", saw " + streamTokenizer.toString());
        }
    }

    public static class TypeException
    extends IllegalArgumentException {
        TypeException(String string2, Object object, String string3) {
            super(string2 + " has type " + object.getClass().getName() + ", not " + string3);
        }
    }
}

