/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputMethodInfo;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputMethodClient;
import com.android.internal.view.InputBindResult;
import java.util.ArrayList;
import java.util.List;

public interface IInputMethodManager
extends IInterface {
    public void addClient(IInputMethodClient var1, IInputContext var2, int var3, int var4) throws RemoteException;

    public void finishInput(IInputMethodClient var1) throws RemoteException;

    public List<InputMethodInfo> getEnabledInputMethodList() throws RemoteException;

    public List<InputMethodInfo> getInputMethodList() throws RemoteException;

    public void hideMySoftInput(IBinder var1, int var2) throws RemoteException;

    public boolean hideSoftInput(IInputMethodClient var1, int var2, ResultReceiver var3) throws RemoteException;

    public void removeClient(IInputMethodClient var1) throws RemoteException;

    public void setInputMethod(IBinder var1, String var2) throws RemoteException;

    public boolean setInputMethodEnabled(String var1, boolean var2) throws RemoteException;

    public void showInputMethodPickerFromClient(IInputMethodClient var1) throws RemoteException;

    public void showMySoftInput(IBinder var1, int var2) throws RemoteException;

    public boolean showSoftInput(IInputMethodClient var1, int var2, ResultReceiver var3) throws RemoteException;

    public InputBindResult startInput(IInputMethodClient var1, IInputContext var2, EditorInfo var3, boolean var4, boolean var5) throws RemoteException;

    public void updateStatusIcon(IBinder var1, String var2, int var3) throws RemoteException;

    public void windowGainedFocus(IInputMethodClient var1, IBinder var2, boolean var3, boolean var4, int var5, boolean var6, int var7) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IInputMethodManager {
        private static final String DESCRIPTOR = "com.android.internal.view.IInputMethodManager";
        static final int TRANSACTION_addClient = 3;
        static final int TRANSACTION_finishInput = 6;
        static final int TRANSACTION_getEnabledInputMethodList = 2;
        static final int TRANSACTION_getInputMethodList = 1;
        static final int TRANSACTION_hideMySoftInput = 12;
        static final int TRANSACTION_hideSoftInput = 8;
        static final int TRANSACTION_removeClient = 4;
        static final int TRANSACTION_setInputMethod = 11;
        static final int TRANSACTION_setInputMethodEnabled = 15;
        static final int TRANSACTION_showInputMethodPickerFromClient = 10;
        static final int TRANSACTION_showMySoftInput = 13;
        static final int TRANSACTION_showSoftInput = 7;
        static final int TRANSACTION_startInput = 5;
        static final int TRANSACTION_updateStatusIcon = 14;
        static final int TRANSACTION_windowGainedFocus = 9;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IInputMethodManager asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IInputMethodManager) {
                return (IInputMethodManager)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    List<InputMethodInfo> list = this.getInputMethodList();
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    List<InputMethodInfo> list = this.getEnabledInputMethodList();
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.addClient(IInputMethodClient.Stub.asInterface(parcel.readStrongBinder()), IInputContext.Stub.asInterface(parcel.readStrongBinder()), parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.removeClient(IInputMethodClient.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IInputMethodClient iInputMethodClient = IInputMethodClient.Stub.asInterface(parcel.readStrongBinder());
                    IInputContext iInputContext = IInputContext.Stub.asInterface(parcel.readStrongBinder());
                    EditorInfo editorInfo = parcel.readInt() != 0 ? EditorInfo.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = parcel.readInt() != 0;
                    boolean bl2 = parcel.readInt() != 0;
                    InputBindResult inputBindResult = this.startInput(iInputMethodClient, iInputContext, editorInfo, bl, bl2);
                    parcel2.writeNoException();
                    if (inputBindResult != null) {
                        parcel2.writeInt(1);
                        inputBindResult.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.finishInput(IInputMethodClient.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IInputMethodClient iInputMethodClient = IInputMethodClient.Stub.asInterface(parcel.readStrongBinder());
                    int n3 = parcel.readInt();
                    ResultReceiver resultReceiver = parcel.readInt() != 0 ? ResultReceiver.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.showSoftInput(iInputMethodClient, n3, resultReceiver);
                    parcel2.writeNoException();
                    int n4 = bl ? 1 : 0;
                    parcel2.writeInt(n4);
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IInputMethodClient iInputMethodClient = IInputMethodClient.Stub.asInterface(parcel.readStrongBinder());
                    int n5 = parcel.readInt();
                    ResultReceiver resultReceiver = parcel.readInt() != 0 ? ResultReceiver.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.hideSoftInput(iInputMethodClient, n5, resultReceiver);
                    parcel2.writeNoException();
                    int n6 = bl ? 1 : 0;
                    parcel2.writeInt(n6);
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IInputMethodClient iInputMethodClient = IInputMethodClient.Stub.asInterface(parcel.readStrongBinder());
                    IBinder iBinder = parcel.readStrongBinder();
                    boolean bl = parcel.readInt() != 0;
                    boolean bl3 = parcel.readInt() != 0;
                    int n7 = parcel.readInt();
                    boolean bl4 = parcel.readInt() != 0;
                    this.windowGainedFocus(iInputMethodClient, iBinder, bl, bl3, n7, bl4, parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.showInputMethodPickerFromClient(IInputMethodClient.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 11: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setInputMethod(parcel.readStrongBinder(), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 12: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.hideMySoftInput(parcel.readStrongBinder(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 13: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.showMySoftInput(parcel.readStrongBinder(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 14: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.updateStatusIcon(parcel.readStrongBinder(), parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 15: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            String string2 = parcel.readString();
            boolean bl = parcel.readInt() != 0;
            boolean bl5 = this.setInputMethodEnabled(string2, bl);
            parcel2.writeNoException();
            int n8 = bl5 ? 1 : 0;
            parcel2.writeInt(n8);
            return true;
        }

        private static class Proxy
        implements IInputMethodManager {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void addClient(IInputMethodClient iInputMethodClient, IInputContext iInputContext, int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iInputMethodClient != null ? iInputMethodClient.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    IBinder iBinder2 = iInputContext != null ? iInputContext.asBinder() : null;
                    parcel.writeStrongBinder(iBinder2);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void finishInput(IInputMethodClient iInputMethodClient) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iInputMethodClient != null ? iInputMethodClient.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public List<InputMethodInfo> getEnabledInputMethodList() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<InputMethodInfo> arrayList = parcel2.createTypedArrayList(InputMethodInfo.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public List<InputMethodInfo> getInputMethodList() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<InputMethodInfo> arrayList = parcel2.createTypedArrayList(InputMethodInfo.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public void hideMySoftInput(IBinder iBinder, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    this.mRemote.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean hideSoftInput(IInputMethodClient iInputMethodClient, int n, ResultReceiver resultReceiver) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iInputMethodClient != null ? iInputMethodClient.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    if (resultReceiver != null) {
                        parcel.writeInt(1);
                        resultReceiver.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    boolean bl = n2 != 0;
                    return bl;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void removeClient(IInputMethodClient iInputMethodClient) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iInputMethodClient != null ? iInputMethodClient.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void setInputMethod(IBinder iBinder, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeString(string2);
                    this.mRemote.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean setInputMethodEnabled(String string2, boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    int n = bl ? 1 : 0;
                    parcel.writeInt(n);
                    this.mRemote.transact(15, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    boolean bl2 = n2 != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void showInputMethodPickerFromClient(IInputMethodClient iInputMethodClient) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iInputMethodClient != null ? iInputMethodClient.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void showMySoftInput(IBinder iBinder, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    this.mRemote.transact(13, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean showSoftInput(IInputMethodClient iInputMethodClient, int n, ResultReceiver resultReceiver) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iInputMethodClient != null ? iInputMethodClient.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    if (resultReceiver != null) {
                        parcel.writeInt(1);
                        resultReceiver.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    boolean bl = n2 != 0;
                    return bl;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public InputBindResult startInput(IInputMethodClient iInputMethodClient, IInputContext iInputContext, EditorInfo editorInfo, boolean bl, boolean bl2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iInputMethodClient != null ? iInputMethodClient.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    IBinder iBinder2 = iInputContext != null ? iInputContext.asBinder() : null;
                    parcel.writeStrongBinder(iBinder2);
                    if (editorInfo != null) {
                        parcel.writeInt(1);
                        editorInfo.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
                int n = bl ? 1 : 0;
                parcel.writeInt(n);
                int n2 = bl2 ? 1 : 0;
                parcel.writeInt(n2);
                this.mRemote.transact(5, parcel, parcel2, 0);
                parcel2.readException();
                InputBindResult inputBindResult = parcel2.readInt() != 0 ? InputBindResult.CREATOR.createFromParcel(parcel2) : null;
                parcel2.recycle();
                parcel.recycle();
                return inputBindResult;
            }

            @Override
            public void updateStatusIcon(IBinder iBinder, String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(14, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void windowGainedFocus(IInputMethodClient iInputMethodClient, IBinder iBinder, boolean bl, boolean bl2, int n, boolean bl3, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder2 = iInputMethodClient != null ? iInputMethodClient.asBinder() : null;
                    parcel.writeStrongBinder(iBinder2);
                    parcel.writeStrongBinder(iBinder);
                    int n3 = bl ? 1 : 0;
                    parcel.writeInt(n3);
                    int n4 = bl2 ? 1 : 0;
                    parcel.writeInt(n4);
                    parcel.writeInt(n);
                    int n5 = bl3 ? 1 : 0;
                    parcel.writeInt(n5);
                    parcel.writeInt(n2);
                    this.mRemote.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }
        }
    }
}

