/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.os.Bundle;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Log;
import android.view.KeyEvent;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputConnection;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputContextCallback;

public class InputConnectionWrapper
implements InputConnection {
    private static final int MAX_WAIT_TIME_MILLIS = 2000;
    private final IInputContext mIInputContext;

    public InputConnectionWrapper(IInputContext iInputContext) {
        this.mIInputContext = iInputContext;
    }

    @Override
    public boolean beginBatchEdit() {
        try {
            this.mIInputContext.beginBatchEdit();
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    @Override
    public boolean clearMetaKeyStates(int n) {
        try {
            this.mIInputContext.clearMetaKeyStates(n);
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    @Override
    public boolean commitCompletion(CompletionInfo completionInfo) {
        try {
            this.mIInputContext.commitCompletion(completionInfo);
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    @Override
    public boolean commitText(CharSequence charSequence, int n) {
        try {
            this.mIInputContext.commitText(charSequence, n);
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    @Override
    public boolean deleteSurroundingText(int n, int n2) {
        try {
            this.mIInputContext.deleteSurroundingText(n, n2);
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    @Override
    public boolean endBatchEdit() {
        try {
            this.mIInputContext.endBatchEdit();
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    @Override
    public boolean finishComposingText() {
        try {
            this.mIInputContext.finishComposingText();
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getCursorCapsMode(int n) {
        int n2;
        InputContextCallback inputContextCallback;
        try {
            inputContextCallback = InputContextCallback.getInstance();
            this.mIInputContext.getCursorCapsMode(n, inputContextCallback.mSeq, inputContextCallback);
            synchronized (inputContextCallback) {
                inputContextCallback.waitForResultLocked();
                boolean bl = inputContextCallback.mHaveValue;
                n2 = 0;
                if (bl) {
                    n2 = inputContextCallback.mCursorCapsMode;
                }
            }
        }
        catch (RemoteException remoteException) {
            return 0;
        }
        {
            inputContextCallback.dispose();
            return n2;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ExtractedText getExtractedText(ExtractedTextRequest extractedTextRequest, int n) {
        ExtractedText extractedText;
        InputContextCallback inputContextCallback;
        try {
            inputContextCallback = InputContextCallback.getInstance();
            this.mIInputContext.getExtractedText(extractedTextRequest, n, inputContextCallback.mSeq, inputContextCallback);
            synchronized (inputContextCallback) {
                inputContextCallback.waitForResultLocked();
                boolean bl = inputContextCallback.mHaveValue;
                extractedText = null;
                if (bl) {
                    extractedText = inputContextCallback.mExtractedText;
                }
            }
        }
        catch (RemoteException remoteException) {
            return null;
        }
        {
            inputContextCallback.dispose();
            return extractedText;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CharSequence getSelectedText(int n) {
        CharSequence charSequence;
        InputContextCallback inputContextCallback;
        try {
            inputContextCallback = InputContextCallback.getInstance();
            this.mIInputContext.getSelectedText(n, inputContextCallback.mSeq, inputContextCallback);
            synchronized (inputContextCallback) {
                inputContextCallback.waitForResultLocked();
                boolean bl = inputContextCallback.mHaveValue;
                charSequence = null;
                if (bl) {
                    charSequence = inputContextCallback.mSelectedText;
                }
            }
        }
        catch (RemoteException remoteException) {
            return null;
        }
        {
            inputContextCallback.dispose();
            return charSequence;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CharSequence getTextAfterCursor(int n, int n2) {
        CharSequence charSequence;
        InputContextCallback inputContextCallback;
        try {
            inputContextCallback = InputContextCallback.getInstance();
            this.mIInputContext.getTextAfterCursor(n, n2, inputContextCallback.mSeq, inputContextCallback);
            synchronized (inputContextCallback) {
                inputContextCallback.waitForResultLocked();
                boolean bl = inputContextCallback.mHaveValue;
                charSequence = null;
                if (bl) {
                    charSequence = inputContextCallback.mTextAfterCursor;
                }
            }
        }
        catch (RemoteException remoteException) {
            return null;
        }
        {
            inputContextCallback.dispose();
            return charSequence;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CharSequence getTextBeforeCursor(int n, int n2) {
        CharSequence charSequence;
        InputContextCallback inputContextCallback;
        try {
            inputContextCallback = InputContextCallback.getInstance();
            this.mIInputContext.getTextBeforeCursor(n, n2, inputContextCallback.mSeq, inputContextCallback);
            synchronized (inputContextCallback) {
                inputContextCallback.waitForResultLocked();
                boolean bl = inputContextCallback.mHaveValue;
                charSequence = null;
                if (bl) {
                    charSequence = inputContextCallback.mTextBeforeCursor;
                }
            }
        }
        catch (RemoteException remoteException) {
            return null;
        }
        {
            inputContextCallback.dispose();
            return charSequence;
        }
    }

    @Override
    public boolean performContextMenuAction(int n) {
        try {
            this.mIInputContext.performContextMenuAction(n);
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    @Override
    public boolean performEditorAction(int n) {
        try {
            this.mIInputContext.performEditorAction(n);
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    @Override
    public boolean performPrivateCommand(String string2, Bundle bundle) {
        try {
            this.mIInputContext.performPrivateCommand(string2, bundle);
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    @Override
    public boolean reportFullscreenMode(boolean bl) {
        try {
            this.mIInputContext.reportFullscreenMode(bl);
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    @Override
    public boolean sendKeyEvent(KeyEvent keyEvent) {
        try {
            this.mIInputContext.sendKeyEvent(keyEvent);
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    @Override
    public boolean setComposingRegion(int n, int n2) {
        try {
            this.mIInputContext.setComposingRegion(n, n2);
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    @Override
    public boolean setComposingText(CharSequence charSequence, int n) {
        try {
            this.mIInputContext.setComposingText(charSequence, n);
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    @Override
    public boolean setSelection(int n, int n2) {
        try {
            this.mIInputContext.setSelection(n, n2);
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    static class InputContextCallback
    extends IInputContextCallback.Stub {
        private static final String TAG = "InputConnectionWrapper.ICC";
        private static InputContextCallback sInstance = new InputContextCallback();
        private static int sSequenceNumber = 1;
        public int mCursorCapsMode;
        public ExtractedText mExtractedText;
        public boolean mHaveValue;
        public CharSequence mSelectedText;
        public int mSeq;
        public CharSequence mTextAfterCursor;
        public CharSequence mTextBeforeCursor;

        InputContextCallback() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void dispose() {
            synchronized (InputContextCallback.class) {
                if (sInstance == null) {
                    this.mTextAfterCursor = null;
                    this.mTextBeforeCursor = null;
                    this.mExtractedText = null;
                    sInstance = this;
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static InputContextCallback getInstance() {
            synchronized (InputContextCallback.class) {
                InputContextCallback inputContextCallback;
                if (sInstance != null) {
                    inputContextCallback = sInstance;
                    sInstance = null;
                    inputContextCallback.mHaveValue = false;
                } else {
                    inputContextCallback = new InputContextCallback();
                }
                int n = sSequenceNumber;
                sSequenceNumber = n + 1;
                inputContextCallback.mSeq = n;
                return inputContextCallback;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void setCursorCapsMode(int n, int n2) {
            synchronized (this) {
                if (n2 == this.mSeq) {
                    this.mCursorCapsMode = n;
                    this.mHaveValue = true;
                    this.notifyAll();
                } else {
                    Log.i(TAG, "Got out-of-sequence callback " + n2 + " (expected " + this.mSeq + ") in setCursorCapsMode, ignoring.");
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void setExtractedText(ExtractedText extractedText, int n) {
            synchronized (this) {
                if (n == this.mSeq) {
                    this.mExtractedText = extractedText;
                    this.mHaveValue = true;
                    this.notifyAll();
                } else {
                    Log.i(TAG, "Got out-of-sequence callback " + n + " (expected " + this.mSeq + ") in setExtractedText, ignoring.");
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void setSelectedText(CharSequence charSequence, int n) {
            synchronized (this) {
                if (n == this.mSeq) {
                    this.mSelectedText = charSequence;
                    this.mHaveValue = true;
                    this.notifyAll();
                } else {
                    Log.i(TAG, "Got out-of-sequence callback " + n + " (expected " + this.mSeq + ") in setSelectedText, ignoring.");
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void setTextAfterCursor(CharSequence charSequence, int n) {
            synchronized (this) {
                if (n == this.mSeq) {
                    this.mTextAfterCursor = charSequence;
                    this.mHaveValue = true;
                    this.notifyAll();
                } else {
                    Log.i(TAG, "Got out-of-sequence callback " + n + " (expected " + this.mSeq + ") in setTextAfterCursor, ignoring.");
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void setTextBeforeCursor(CharSequence charSequence, int n) {
            synchronized (this) {
                if (n == this.mSeq) {
                    this.mTextBeforeCursor = charSequence;
                    this.mHaveValue = true;
                    this.notifyAll();
                } else {
                    Log.i(TAG, "Got out-of-sequence callback " + n + " (expected " + this.mSeq + ") in setTextBeforeCursor, ignoring.");
                }
                return;
            }
        }

        void waitForResultLocked() {
            long l = 2000L + SystemClock.uptimeMillis();
            while (true) {
                long l2;
                block6: {
                    block5: {
                        if (this.mHaveValue) break block5;
                        l2 = l - SystemClock.uptimeMillis();
                        if (l2 > 0L) break block6;
                        Log.w(TAG, "Timed out waiting on IInputContextCallback");
                    }
                    return;
                }
                try {
                    this.wait(l2);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

