/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.android.internal.R;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuView;

public final class ExpandedMenuView
extends ListView
implements MenuBuilder.ItemInvoker,
MenuView,
AdapterView.OnItemClickListener {
    private int mAnimations;
    private MenuBuilder mMenu;

    public ExpandedMenuView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.MenuView, 0, 0);
        this.mAnimations = typedArray.getResourceId(0, 0);
        typedArray.recycle();
        this.setOnItemClickListener(this);
    }

    @Override
    public int getWindowAnimations() {
        return this.mAnimations;
    }

    @Override
    public void initialize(MenuBuilder menuBuilder, int n) {
        this.mMenu = menuBuilder;
        menuBuilder.getClass();
        this.setAdapter(new MenuBuilder.MenuAdapter(menuBuilder, n));
    }

    @Override
    public boolean invokeItem(MenuItemImpl menuItemImpl) {
        return this.mMenu.performItemAction(menuItemImpl, 0);
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.setChildrenDrawingCacheEnabled(false);
    }

    public void onItemClick(AdapterView adapterView, View view, int n, long l) {
        this.invokeItem((MenuItemImpl)this.getAdapter().getItem(n));
    }

    protected boolean recycleOnMeasure() {
        return false;
    }

    @Override
    public void updateChildren(boolean bl) {
        ListAdapter listAdapter;
        block3: {
            block2: {
                listAdapter = this.getAdapter();
                if (listAdapter == null) break block2;
                if (!bl) break block3;
                ((BaseAdapter)listAdapter).notifyDataSetInvalidated();
            }
            return;
        }
        ((BaseAdapter)listAdapter).notifyDataSetChanged();
    }
}

