/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import com.android.internal.R;
import com.android.internal.view.menu.IconMenuItemView;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuView;
import java.util.ArrayList;

public final class IconMenuView
extends ViewGroup
implements MenuBuilder.ItemInvoker,
MenuView,
Runnable {
    private static final int ITEM_CAPTION_CYCLE_DELAY = 1000;
    private int mAnimations;
    private boolean mHasStaleChildren;
    private Drawable mHorizontalDivider;
    private int mHorizontalDividerHeight;
    private ArrayList<Rect> mHorizontalDividerRects;
    private Drawable mItemBackground;
    private boolean mLastChildrenCaptionMode;
    private int[] mLayout;
    private int mLayoutNumRows;
    private int mMaxItems;
    private int mMaxItemsPerRow;
    private int mMaxRows;
    private MenuBuilder mMenu;
    private boolean mMenuBeingLongpressed = false;
    private Drawable mMoreIcon;
    private IconMenuItemView mMoreItemView;
    private int mNumActualItemsShown;
    private int mRowHeight;
    private Drawable mVerticalDivider;
    private ArrayList<Rect> mVerticalDividerRects;
    private int mVerticalDividerWidth;

    public IconMenuView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.IconMenuView, 0, 0);
        this.mRowHeight = typedArray.getDimensionPixelSize(0, 64);
        this.mMaxRows = typedArray.getInt(1, 2);
        this.mMaxItems = typedArray.getInt(4, 6);
        this.mMaxItemsPerRow = typedArray.getInt(2, 3);
        this.mMoreIcon = typedArray.getDrawable(3);
        typedArray.recycle();
        TypedArray typedArray2 = context.obtainStyledAttributes(attributeSet, R.styleable.MenuView, 0, 0);
        this.mItemBackground = typedArray2.getDrawable(5);
        this.mHorizontalDivider = typedArray2.getDrawable(2);
        this.mHorizontalDividerRects = new ArrayList();
        this.mVerticalDivider = typedArray2.getDrawable(3);
        this.mVerticalDividerRects = new ArrayList();
        this.mAnimations = typedArray2.getResourceId(0, 0);
        typedArray2.recycle();
        if (this.mHorizontalDivider != null) {
            this.mHorizontalDividerHeight = this.mHorizontalDivider.getIntrinsicHeight();
            if (this.mHorizontalDividerHeight == -1) {
                this.mHorizontalDividerHeight = 1;
            }
        }
        if (this.mVerticalDivider != null) {
            this.mVerticalDividerWidth = this.mVerticalDivider.getIntrinsicWidth();
            if (this.mVerticalDividerWidth == -1) {
                this.mVerticalDividerWidth = 1;
            }
        }
        this.mLayout = new int[this.mMaxRows];
        this.setWillNotDraw(false);
        this.setFocusableInTouchMode(true);
        this.setDescendantFocusability(262144);
    }

    private void addItemView(IconMenuItemView iconMenuItemView) {
        iconMenuItemView.setIconMenuView(this);
        iconMenuItemView.setBackgroundDrawable(this.mItemBackground.getConstantState().newDrawable(this.getContext().getResources()));
        iconMenuItemView.setItemInvoker(this);
        this.addView((View)iconMenuItemView, iconMenuItemView.getTextAppropriateLayoutParams());
    }

    private void calculateItemFittingMetadata(int n) {
        int n2 = this.mMaxItemsPerRow;
        int n3 = this.getChildCount();
        block0: for (int i = 0; i < n3; ++i) {
            LayoutParams layoutParams = (LayoutParams)this.getChildAt(i).getLayoutParams();
            layoutParams.maxNumItemsOnRow = 1;
            int n4 = n2;
            while (true) {
                if (n4 <= 0) continue block0;
                if (layoutParams.desiredWidth < n / n4) {
                    layoutParams.maxNumItemsOnRow = n4;
                    continue block0;
                }
                --n4;
            }
        }
    }

    private IconMenuItemView createMoreItemView() {
        IconMenuItemView iconMenuItemView = (IconMenuItemView)this.mMenu.getMenuType(0).getInflater().inflate(17367080, null);
        iconMenuItemView.initialize(this.getContext().getResources().getText(17040066), this.mMoreIcon);
        iconMenuItemView.setOnClickListener(new View.OnClickListener(){

            @Override
            public void onClick(View view) {
                MenuBuilder.Callback callback = IconMenuView.this.mMenu.getCallback();
                if (callback != null) {
                    callback.onMenuModeChange(IconMenuView.this.mMenu);
                }
            }
        });
        return iconMenuItemView;
    }

    /*
     * Unable to fully structure code
     */
    private boolean doItemsFit() {
        block5: {
            var1_1 = 0;
            var2_2 = this.mLayout;
            var3_3 = this.mLayoutNumRows;
            block0: for (var4_4 = 0; var4_4 < var3_3; ++var4_4) {
                var5_5 = var2_2[var4_4];
                if (var5_5 == 1) {
                    ++var1_1;
lbl8:
                    // 2 sources

                    continue block0;
                }
                var7_7 = var1_1;
                for (var6_6 = var5_5; var6_6 > 0; --var6_6) {
                    var8_8 = var7_7 + 1;
                    if (((LayoutParams)this.getChildAt((int)var7_7).getLayoutParams()).maxNumItemsOnRow < var5_5) {
                        return false;
                    }
                    var7_7 = var8_8;
                }
                break block5;
            }
            return true;
        }
        var1_1 = var7_7;
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    private void layoutItems(int n) {
        int n2 = this.getChildCount();
        if (n2 == 0) {
            this.mLayoutNumRows = 0;
            return;
        } else {
            for (int i = Math.min((int)Math.ceil((float)n2 / (float)this.mMaxItemsPerRow), this.mMaxRows); i <= this.mMaxRows; ++i) {
                this.layoutItemsUsingGravity(i, n2);
                if (i >= n2 || this.doItemsFit()) return;
            }
        }
    }

    private void layoutItemsUsingGravity(int n, int n2) {
        int n3 = n2 / n;
        int n4 = n - n2 % n;
        int[] nArray = this.mLayout;
        for (int i = 0; i < n; ++i) {
            nArray[i] = n3;
            if (i < n4) continue;
            nArray[i] = 1 + nArray[i];
        }
        this.mLayoutNumRows = n;
    }

    private void positionChildren(int n, int n2) {
        if (this.mHorizontalDivider != null) {
            this.mHorizontalDividerRects.clear();
        }
        if (this.mVerticalDivider != null) {
            this.mVerticalDividerRects.clear();
        }
        int n3 = this.mLayoutNumRows;
        int n4 = n3 - 1;
        int[] nArray = this.mLayout;
        int n5 = 0;
        LayoutParams layoutParams = null;
        float f = 0.0f;
        float f2 = (float)(n2 - this.mHorizontalDividerHeight * (n3 - 1)) / (float)n3;
        for (int i = 0; i < n3; ++i) {
            int n6;
            float f3 = 0.0f;
            float f4 = (float)(n - this.mVerticalDividerWidth * (nArray[i] - 1)) / (float)nArray[i];
            for (int j = 0; j < (n6 = nArray[i]); ++j) {
                int n7;
                int n8;
                int n9;
                int n10;
                View view = this.getChildAt(n5);
                view.measure(View.MeasureSpec.makeMeasureSpec((int)f4, 0x40000000), View.MeasureSpec.makeMeasureSpec((int)f2, 0x40000000));
                layoutParams = (LayoutParams)view.getLayoutParams();
                layoutParams.left = n10 = (int)f3;
                layoutParams.right = n9 = (int)(f3 + f4);
                layoutParams.top = n8 = (int)f;
                layoutParams.bottom = n7 = (int)(f + f2);
                float f5 = f3 + f4;
                ++n5;
                if (this.mVerticalDivider != null) {
                    this.mVerticalDividerRects.add(new Rect((int)f5, (int)f, (int)(f5 + (float)this.mVerticalDividerWidth), (int)(f + f2)));
                }
                f3 = f5 + (float)this.mVerticalDividerWidth;
            }
            if (layoutParams != null) {
                layoutParams.right = n;
            }
            f += f2;
            if (this.mHorizontalDivider == null || i >= n4) continue;
            ArrayList<Rect> arrayList = this.mHorizontalDividerRects;
            Rect rect = new Rect(0, (int)f, n, (int)(f + (float)this.mHorizontalDividerHeight));
            arrayList.add(rect);
            f += (float)this.mHorizontalDividerHeight;
        }
    }

    private void setChildrenCaptionMode(boolean bl) {
        this.mLastChildrenCaptionMode = bl;
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            ((IconMenuItemView)this.getChildAt(i)).setCaptionMode(bl);
        }
    }

    private void setCycleShortcutCaptionMode(boolean bl) {
        if (!bl) {
            this.removeCallbacks(this);
            this.setChildrenCaptionMode(false);
            this.mMenuBeingLongpressed = false;
            return;
        }
        this.setChildrenCaptionMode(true);
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() != 82) return super.dispatchKeyEvent(keyEvent);
        if (keyEvent.getAction() == 0 && keyEvent.getRepeatCount() == 0) {
            this.removeCallbacks(this);
            this.postDelayed(this, ViewConfiguration.getLongPressTimeout());
            return super.dispatchKeyEvent(keyEvent);
        }
        if (keyEvent.getAction() != 1) return super.dispatchKeyEvent(keyEvent);
        if (this.mMenuBeingLongpressed) {
            this.setCycleShortcutCaptionMode(false);
            return true;
        }
        this.removeCallbacks(this);
        return super.dispatchKeyEvent(keyEvent);
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    public int[] getLayout() {
        return this.mLayout;
    }

    public int getLayoutNumRows() {
        return this.mLayoutNumRows;
    }

    int getNumActualItemsShown() {
        return this.mNumActualItemsShown;
    }

    @Override
    public int getWindowAnimations() {
        return this.mAnimations;
    }

    @Override
    public void initialize(MenuBuilder menuBuilder, int n) {
        this.mMenu = menuBuilder;
        this.updateChildren(true);
    }

    @Override
    public boolean invokeItem(MenuItemImpl menuItemImpl) {
        return this.mMenu.performItemAction(menuItemImpl, 0);
    }

    void markStaleChildren() {
        if (!this.mHasStaleChildren) {
            this.mHasStaleChildren = true;
            this.requestLayout();
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.requestFocus();
    }

    @Override
    protected void onDetachedFromWindow() {
        this.setCycleShortcutCaptionMode(false);
        super.onDetachedFromWindow();
    }

    @Override
    protected void onDraw(Canvas canvas) {
        Drawable drawable2;
        Drawable drawable3 = this.mHorizontalDivider;
        if (drawable3 != null) {
            ArrayList<Rect> arrayList = this.mHorizontalDividerRects;
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                drawable3.setBounds(arrayList.get(i));
                drawable3.draw(canvas);
            }
        }
        if ((drawable2 = this.mVerticalDivider) != null) {
            ArrayList<Rect> arrayList = this.mVerticalDividerRects;
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                drawable2.setBounds(arrayList.get(i));
                drawable2.draw(canvas);
            }
        }
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            View view = this.getChildAt(i);
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            view.layout(layoutParams.left, layoutParams.top, layoutParams.right, layoutParams.bottom);
        }
    }

    @Override
    protected void onMeasure(int n, int n2) {
        if (this.mHasStaleChildren) {
            this.mHasStaleChildren = false;
            this.updateChildren(false);
        }
        int n3 = IconMenuView.resolveSize(Integer.MAX_VALUE, n);
        this.calculateItemFittingMetadata(n3);
        this.layoutItems(n3);
        int n4 = this.mLayoutNumRows;
        this.setMeasuredDimension(n3, IconMenuView.resolveSize(n4 * (this.mRowHeight + this.mHorizontalDividerHeight) - this.mHorizontalDividerHeight, n2));
        if (n4 > 0) {
            this.positionChildren(this.mMeasuredWidth, this.mMeasuredHeight);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onRestoreInstanceState(Parcelable parcelable) {
        View view;
        SavedState savedState = (SavedState)parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        if (savedState.focusedPosition >= this.getChildCount() || (view = this.getChildAt(savedState.focusedPosition)) == null) {
            return;
        }
        view.requestFocus();
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        View view = this.getFocusedChild();
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            if (this.getChildAt(i) != view) continue;
            return new SavedState(parcelable, i);
        }
        return new SavedState(parcelable, -1);
    }

    @Override
    public void onWindowFocusChanged(boolean bl) {
        if (!bl) {
            this.setCycleShortcutCaptionMode(false);
        }
        super.onWindowFocusChanged(bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void run() {
        if (this.mMenuBeingLongpressed) {
            boolean bl = !this.mLastChildrenCaptionMode;
            this.setChildrenCaptionMode(bl);
        } else {
            this.mMenuBeingLongpressed = true;
            this.setCycleShortcutCaptionMode(true);
        }
        this.postDelayed(this, 1000L);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void updateChildren(boolean bl) {
        this.removeAllViews();
        ArrayList<MenuItemImpl> arrayList = this.mMenu.getVisibleItems();
        int n = arrayList.size();
        int n2 = this.mMaxItems;
        int n3 = Math.min(n2 - 1, n);
        for (int i = 0; i < n3; ++i) {
            this.addItemView((IconMenuItemView)arrayList.get(i).getItemView(0, this));
        }
        if (n > n2) {
            if (this.mMoreItemView == null) {
                this.mMoreItemView = this.createMoreItemView();
            }
            this.addItemView(this.mMoreItemView);
            this.mNumActualItemsShown = n2 - 1;
            return;
        } else {
            if (n != n2) return;
            this.addItemView((IconMenuItemView)arrayList.get(n2 - 1).getItemView(0, this));
            this.mNumActualItemsShown = n2;
            return;
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        int bottom;
        int desiredWidth;
        int left;
        int maxNumItemsOnRow;
        int right;
        int top;

        public LayoutParams(int n, int n2) {
            super(n, n2);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }
    }

    private static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        int focusedPosition;

        private SavedState(Parcel parcel) {
            super(parcel);
            this.focusedPosition = parcel.readInt();
        }

        public SavedState(Parcelable parcelable, int n) {
            super(parcelable);
            this.focusedPosition = n;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            parcel.writeInt(this.focusedPosition);
        }
    }
}

