/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuView;

public class ListMenuItemView
extends LinearLayout
implements MenuView.ItemView {
    private Drawable mBackground;
    private CheckBox mCheckBox;
    private ImageView mIconView;
    private MenuItemImpl mItemData;
    private int mMenuType;
    private RadioButton mRadioButton;
    private TextView mShortcutView;
    private int mTextAppearance;
    private Context mTextAppearanceContext;
    private TextView mTitleView;

    public ListMenuItemView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ListMenuItemView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.MenuView, n, 0);
        this.mBackground = typedArray.getDrawable(5);
        this.mTextAppearance = typedArray.getResourceId(1, -1);
        this.mTextAppearanceContext = context;
        typedArray.recycle();
    }

    private void insertCheckBox() {
        this.mCheckBox = (CheckBox)this.mItemData.getLayoutInflater(this.mMenuType).inflate(17367101, (ViewGroup)this, false);
        this.addView(this.mCheckBox);
    }

    private void insertIconView() {
        this.mIconView = (ImageView)this.mItemData.getLayoutInflater(this.mMenuType).inflate(17367102, (ViewGroup)this, false);
        this.addView((View)this.mIconView, 0);
    }

    private void insertRadioButton() {
        this.mRadioButton = (RadioButton)this.mItemData.getLayoutInflater(this.mMenuType).inflate(17367104, (ViewGroup)this, false);
        this.addView(this.mRadioButton);
    }

    @Override
    public MenuItemImpl getItemData() {
        return this.mItemData;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void initialize(MenuItemImpl menuItemImpl, int n) {
        this.mItemData = menuItemImpl;
        this.mMenuType = n;
        int n2 = menuItemImpl.isVisible() ? 0 : 8;
        this.setVisibility(n2);
        this.setTitle(menuItemImpl.getTitleForItemView(this));
        this.setCheckable(menuItemImpl.isCheckable());
        this.setShortcut(menuItemImpl.shouldShowShortcut(), menuItemImpl.getShortcut());
        this.setIcon(menuItemImpl.getIcon());
        this.setEnabled(menuItemImpl.isEnabled());
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        this.setBackgroundDrawable(this.mBackground);
        this.mTitleView = (TextView)this.findViewById(16908310);
        if (this.mTextAppearance != -1) {
            this.mTitleView.setTextAppearance(this.mTextAppearanceContext, this.mTextAppearance);
        }
        this.mShortcutView = (TextView)this.findViewById(16908783);
    }

    @Override
    public boolean prefersCondensedTitle() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setCheckable(boolean bl) {
        CompoundButton compoundButton;
        block10: {
            block9: {
                CompoundButton compoundButton2;
                if (!bl && this.mRadioButton == null && this.mCheckBox == null) break block9;
                if (this.mRadioButton == null) {
                    this.insertRadioButton();
                }
                if (this.mCheckBox == null) {
                    this.insertCheckBox();
                }
                if (this.mItemData.isExclusiveCheckable()) {
                    compoundButton2 = this.mRadioButton;
                    compoundButton = this.mCheckBox;
                } else {
                    compoundButton2 = this.mCheckBox;
                    compoundButton = this.mRadioButton;
                }
                if (!bl) {
                    this.mCheckBox.setVisibility(8);
                    this.mRadioButton.setVisibility(8);
                    return;
                }
                compoundButton2.setChecked(this.mItemData.isChecked());
                int n = bl ? 0 : 8;
                if (compoundButton2.getVisibility() != n) {
                    compoundButton2.setVisibility(n);
                }
                if (compoundButton.getVisibility() != 8) break block10;
            }
            return;
        }
        compoundButton.setVisibility(8);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setChecked(boolean bl) {
        CompoundButton compoundButton;
        if (this.mItemData.isExclusiveCheckable()) {
            if (this.mRadioButton == null) {
                this.insertRadioButton();
            }
            compoundButton = this.mRadioButton;
        } else {
            if (this.mCheckBox == null) {
                this.insertCheckBox();
            }
            compoundButton = this.mCheckBox;
        }
        compoundButton.setChecked(bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setIcon(Drawable drawable2) {
        block6: {
            block5: {
                if (!this.mItemData.shouldShowIcon(this.mMenuType) || this.mIconView == null && drawable2 == null) break block5;
                if (this.mIconView == null) {
                    this.insertIconView();
                }
                if (drawable2 == null) {
                    this.mIconView.setVisibility(8);
                    return;
                }
                this.mIconView.setImageDrawable(drawable2);
                if (this.mIconView.getVisibility() != 0) break block6;
            }
            return;
        }
        this.mIconView.setVisibility(0);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setShortcut(boolean bl, char c) {
        int n = bl && this.mItemData.shouldShowShortcut() ? 0 : 8;
        if (n == 0) {
            this.mShortcutView.setText(this.mItemData.getShortcutLabel());
        }
        if (this.mShortcutView.getVisibility() != n) {
            this.mShortcutView.setVisibility(n);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setTitle(CharSequence charSequence) {
        if (charSequence != null) {
            this.mTitleView.setText(charSequence);
            if (this.mTitleView.getVisibility() == 0) return;
            this.mTitleView.setVisibility(0);
            return;
        }
        if (this.mTitleView.getVisibility() == 8) return;
        this.mTitleView.setVisibility(8);
    }

    @Override
    public boolean showsIcon() {
        return false;
    }
}

